/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.tabbox;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.form.field.TabBoxNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TabBoxNewWizardPage
extends AbstractWorkspaceWizardPage {
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private SiblingProposal m_sibling;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_createdField;

    public TabBoxNewWizardPage(IType declaringType) {
        super(TabBoxNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewTabBox"));
        this.setDescription(Texts.get((String)"CreateANewTabBox"));
        this.m_declaringType = declaringType;
        this.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox", (IJavaProject)this.m_declaringType.getJavaProject()));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"PropLabel"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    TabBoxNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = TabBoxNewWizardPage.this.getNlsName();
                    TabBoxNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (TabBoxNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(TabBoxNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((CharSequence)TabBoxNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        TabBoxNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)TabBoxNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    TabBoxNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Box");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeName = this.m_typeNameField.getText();
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabBoxNewWizardPage.this.m_typeName = TabBoxNewWizardPage.this.m_typeNameField.getText();
                TabBoxNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                TabBoxNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                TabBoxNewWizardPage.this.pingStateChanging();
            }
        });
        if (this.m_sibling == null) {
            this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        } else {
            this.m_siblingField.acceptProposal(this.m_sibling);
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        TabBoxNewOperation operation = new TabBoxNewOperation(this.getTypeName(), this.m_declaringType, true);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        if (this.getSuperType() != null) {
            operation.setSuperTypeSignature(SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END || this.getSibling() == null) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdField = operation.getCreatedField();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusNameField());
    }

    protected IStatus getStatusNameField() {
        return ScoutUtility.validateFormFieldName((String)this.getTypeName(), (String)"Box", (IType)this.m_declaringType);
    }

    public IType getCreatedField() {
        return this.m_createdField;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
        this.pingStateChanging();
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

