/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.lookupcall.LocalLookupCallNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureSubTypeProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LocalLookupCallNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType localLookupCall = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall");
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_GENERIC_TYPE = "genericType";
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private EntityTextField m_entityField;
    private ProposalTextField m_genericTypeField;
    private IScoutBundle m_clientBundle;

    public LocalLookupCallNewWizardPage(IScoutBundle client) {
        super(LocalLookupCallNewWizardPage.class.getName());
        this.m_clientBundle = client;
        this.setTitle(Texts.get((String)"NewLocalLookupCallNoPopup"));
        this.setDescription(Texts.get((String)"CreateANewLocalLookupCall"));
        this.setLookupCallSuperTypeInternal(this.localLookupCall);
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)client, (String)"client.services.lookup"));
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("LookupCall");
        this.m_typeNameField.setText(this.getTypeName());
        this.setTypeNameInternal(this.m_typeNameField.getText());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalLookupCallNewWizardPage.this.setTypeNameInternal(LocalLookupCallNewWizardPage.this.m_typeNameField.getText());
                LocalLookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        final SignatureSubTypeProposalProvider proposalProvider = new SignatureSubTypeProposalProvider(this.getGenericTypeOfSuperClass(), this.m_clientBundle.getJavaProject());
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"LookupCallSuperType"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                Set superTypes = TypeUtility.getClassesOnClasspath((IType)LocalLookupCallNewWizardPage.this.localLookupCall, (IJavaProject)ScoutUtility.getJavaProject((IScoutBundle)LocalLookupCallNewWizardPage.this.getClientBundle()), (ITypeFilter)TypeFilters.getNotInTypes((IType[])new IType[]{LocalLookupCallNewWizardPage.this.localLookupCall}));
                return new Object[][]{{LocalLookupCallNewWizardPage.this.localLookupCall}, superTypes.toArray(new IType[superTypes.size()])};
            }
        }, labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.getLookupCallSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LocalLookupCallNewWizardPage.this.setLookupCallSuperTypeInternal((IType)event.proposal);
                IType genericTypeOfSuperClass = LocalLookupCallNewWizardPage.this.getGenericTypeOfSuperClass();
                if (LocalLookupCallNewWizardPage.this.getGenericTypeSignature() == null && TypeUtility.exists((IJavaElement)genericTypeOfSuperClass)) {
                    LocalLookupCallNewWizardPage.this.m_genericTypeField.acceptProposal(SignatureCache.createTypeSignature((String)genericTypeOfSuperClass.getFullyQualifiedName()));
                }
                proposalProvider.setBaseType(genericTypeOfSuperClass);
                LocalLookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(parent, Texts.get((String)"EntityTextField"), this.m_clientBundle, labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LocalLookupCallNewWizardPage.this.setTargetPackageInternal(LocalLookupCallNewWizardPage.this.m_entityField.getText());
                    LocalLookupCallNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        this.m_genericTypeField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"KeyType"), 1, labelColWidthPercent);
        this.m_genericTypeField.setContentProvider(proposalProvider);
        this.m_genericTypeField.setLabelProvider((IBaseLabelProvider)proposalProvider.getLabelProvider());
        this.m_genericTypeField.acceptProposal(this.getGenericTypeSignature());
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LocalLookupCallNewWizardPage.this.setGenericTypeSignatureInternal((String)event.proposal);
                LocalLookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    protected IType getGenericTypeOfSuperClass() {
        if (TypeUtility.exists((IJavaElement)this.getLookupCallSuperType())) {
            try {
                String typeParamSig = SignatureUtility.resolveTypeParameter((IType)this.getLookupCallSuperType(), (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupCall", (int)0);
                if (typeParamSig != null) {
                    return TypeUtility.getTypeBySignature((String)typeParamSig);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
        return null;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusTargetPackge());
            multiStatus.add(this.getStatusGenericType());
            multiStatus.add(this.getStatusGenericTypeToSuperClass());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusGenericTypeToSuperClass() {
        IType generic;
        IType superType;
        if (this.getGenericTypeSignature() != null && TypeUtility.exists((IJavaElement)(superType = this.getGenericTypeOfSuperClass())) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)this.getGenericTypeSignature()))) && !TypeUtility.getSupertypeHierarchy((IType)generic).contains(superType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeDoesNotMatchSuperClass"));
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
        LocalLookupCallNewOperation op = new LocalLookupCallNewOperation(this.getTypeName(), this.getClientBundle().getPackageName(this.getTargetPackage()), ScoutUtility.getJavaProject((IScoutBundle)this.getClientBundle()));
        op.setFormatSource(true);
        IType superTypeProp = this.getLookupCallSuperType();
        if (superTypeProp != null) {
            StringBuilder superType = new StringBuilder(superTypeProp.getFullyQualifiedName());
            superType.append('<');
            superType.append(Signature.toString((String)this.getGenericTypeSignature()));
            superType.append('>');
            op.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superType.toString()));
        }
        op.validate();
        op.run(monitor, manager);
        return true;
    }

    protected IStatus getStatusTargetPackge() {
        return ScoutUtility.validatePackageName((String)this.getTargetPackage());
    }

    protected IStatus getStatusGenericType() {
        if (this.getGenericTypeSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"LookupCall");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.getClientBundle(), (String)this.getTargetPackage(), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getLookupCallSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getLookupCallSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setLookupCallSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setLookupCallSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupCallSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public String getTargetPackage() {
        return (String)this.getProperty(PROP_TARGET_PACKAGE);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }

    public String getGenericTypeSignature() {
        return (String)this.getProperty(PROP_GENERIC_TYPE);
    }

    public void setGenericTypeSignature(String genericType) {
        try {
            this.setStateChanging(true);
            this.setGenericTypeSignatureInternal(genericType);
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setGenericTypeSignatureInternal(String genericType) {
        this.setProperty(PROP_GENERIC_TYPE, genericType);
    }
}

