/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.MoreElementsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LookupCallNewWizard;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LookupCallNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SERVICE_SUPER_TYPE = "serviceSuperType";
    public static final String PROP_LOOKUP_SERVICE = "lookupService";
    public static final String PROP_LOOKUP_SERVICE_STRATEGY = "lookupServiceStrategy";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_GENERIC_TYPE = "genericType";
    private StyledTextField m_typeNameField;
    private Button m_createServiceButton;
    private Button m_useServiceButton;
    private Button m_noServiceButton;
    private ProposalTextField m_serviceSuperTypeField;
    private ProposalTextField m_lookupServiceTypeField;
    private ProposalTextField m_genericTypeField;
    private EntityTextField m_entityField;
    private IType m_abstractSqlLookupService;
    private final IScoutBundle m_sharedBundle;
    private final IScoutBundle m_serverBundle;

    public LookupCallNewWizardPage(IScoutBundle sharedBundle, IScoutBundle serverBundle) {
        super(LookupCallNewWizardPage.class.getName());
        this.m_sharedBundle = sharedBundle;
        this.m_serverBundle = serverBundle;
        this.setTitle(Texts.get((String)"NewLookupCall"));
        this.setDescription(Texts.get((String)"CreateANewLookupCall"));
        if (sharedBundle != null) {
            this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)sharedBundle, (String)"shared.services.lookup"));
        }
        if (serverBundle != null) {
            this.setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY.CREATE_NEW);
            this.m_abstractSqlLookupService = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService", (IJavaProject)serverBundle.getJavaProject());
            this.setServiceSuperTypeInternal(this.m_abstractSqlLookupService);
        } else {
            this.setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY.NO_SERVICE);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        int labelPercentage = 20;
        boolean isEnabled = this.getSharedBundle() != null;
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelPercentage);
        this.m_typeNameField.setReadOnlySuffix("LookupCall");
        this.m_typeNameField.setText(this.getTypeName());
        this.setTypeNameInternal(this.m_typeNameField.getText());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LookupCallNewWizardPage.this.setTypeNameInternal(LookupCallNewWizardPage.this.m_typeNameField.getText());
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_typeNameField.setEnabled(isEnabled);
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(parent, Texts.get((String)"EntityTextField"), this.getSharedBundle(), labelPercentage);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LookupCallNewWizardPage.this.setTargetPackageInternal(LookupCallNewWizardPage.this.m_entityField.getText());
                    LookupCallNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
            this.m_entityField.setEnabled(isEnabled);
        }
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, Texts.get((String)"KeyType"), this.getSharedBundle(), SignatureProposalProvider.DEFAULT_MOST_USED, labelPercentage);
        this.m_genericTypeField.acceptProposal(this.getGenericTypeSignature());
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LookupCallNewWizardPage.this.setGenericTypeSignatureInternal((String)event.proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_genericTypeField.setEnabled(isEnabled);
        Control lookupServiceGroup = this.createLookupServiceGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        lookupServiceGroup.setLayoutData((Object)new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_typeNameField.setFocus();
    }

    protected Control createLookupServiceGroup(Composite parent) {
        AbstractJavaElementContentProvider contentProvider;
        Group group = new Group(parent, 16);
        group.setText("Lookup Service");
        boolean serverAvailable = this.getServerBundle() != null;
        Composite radioButtons = new Composite((Composite)group, 1);
        this.m_createServiceButton = new Button(radioButtons, 16);
        this.m_createServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.CREATE_NEW));
        this.m_createServiceButton.setText("create new lookup service");
        this.m_createServiceButton.setSelection(serverAvailable);
        this.m_useServiceButton = new Button(radioButtons, 16);
        this.m_useServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.USE_EXISTING));
        this.m_useServiceButton.setText("use existing lookup service");
        this.m_noServiceButton = new Button(radioButtons, 16);
        this.m_noServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.NO_SERVICE));
        this.m_noServiceButton.setText("no lookup service");
        this.m_noServiceButton.setSelection(!serverAvailable);
        this.m_serviceSuperTypeField = this.getFieldToolkit().createProposalField((Composite)group, Texts.get((String)"LookupServiceSuperType"));
        if (serverAvailable) {
            contentProvider = new AbstractJavaElementContentProvider(){

                @Override
                protected Object[][] computeProposals() {
                    IType abstractLookupService = TypeUtility.getType((String)"org.eclipse.scout.rt.server.services.lookup.AbstractLookupService");
                    ArrayList<Object> proposals = new ArrayList<Object>();
                    proposals.add(abstractLookupService);
                    if (LookupCallNewWizardPage.this.m_abstractSqlLookupService != null) {
                        proposals.add(LookupCallNewWizardPage.this.m_abstractSqlLookupService);
                    }
                    proposals.add(MoreElementsProposal.INSTANCE);
                    ITypeFilter filter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getPrimaryTypeFilter(), TypeFilters.getTypeParamSubTypeFilter((String)LookupCallNewWizardPage.this.getGenericTypeSignature(), (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService", (int)0)});
                    Set abstractLookupServices = TypeUtility.getAbstractTypesOnClasspath((IType)TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService"), (IJavaProject)LookupCallNewWizardPage.this.getServerBundle().getJavaProject(), (ITypeFilter)filter);
                    for (IType t : abstractLookupServices) {
                        if (proposals.contains(t)) continue;
                        proposals.add(t);
                    }
                    return new Object[][]{proposals.toArray(new Object[proposals.size()])};
                }
            };
            this.m_serviceSuperTypeField.setContentProvider(contentProvider);
            this.m_serviceSuperTypeField.setLabelProvider((IBaseLabelProvider)contentProvider.getLabelProvider());
            this.m_serviceSuperTypeField.acceptProposal(this.getServiceSuperType());
            this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

                @Override
                public void proposalAccepted(ContentProposalEvent event) {
                    contentProvider.invalidateCache();
                    LookupCallNewWizardPage.this.pingStateChanging();
                }
            });
        } else {
            this.m_serviceSuperTypeField.setEnabled(false);
            radioButtons.setEnabled(false);
            this.m_createServiceButton.setEnabled(false);
            this.m_useServiceButton.setEnabled(false);
            this.m_serviceSuperTypeField.setVisible(false);
        }
        this.m_serviceSuperTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                IType t = (IType)event.proposal;
                LookupCallNewWizardPage.this.setServiceSuperTypeInternal(t);
                LookupCallNewWizardPage.this.updateKeyTypeFor(t);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_lookupServiceTypeField = this.getFieldToolkit().createProposalField((Composite)group, Texts.get((String)"LookupService"));
        if (this.getSharedBundle() != null) {
            contentProvider = new AbstractJavaElementContentProvider(){

                @Override
                protected Object[][] computeProposals() {
                    IType iLookupService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
                    Set lookupServiceInterfaces = TypeUtility.getInterfacesOnClasspath((IType)iLookupService, (IJavaProject)LookupCallNewWizardPage.this.getSharedBundle().getJavaProject(), (ITypeFilter)TypeFilters.getTypeParamSubTypeFilter((String)LookupCallNewWizardPage.this.getGenericTypeSignature(), (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService", (int)0));
                    return new Object[][]{lookupServiceInterfaces.toArray(new IType[lookupServiceInterfaces.size()])};
                }
            };
            this.m_lookupServiceTypeField.setContentProvider(contentProvider);
            this.m_lookupServiceTypeField.setLabelProvider((IBaseLabelProvider)contentProvider.getLabelProvider());
            this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

                @Override
                public void proposalAccepted(ContentProposalEvent event) {
                    contentProvider.invalidateCache();
                    LookupCallNewWizardPage.this.pingStateChanging();
                }
            });
        } else {
            this.m_lookupServiceTypeField.setEnabled(false);
        }
        this.m_lookupServiceTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                IType t = (IType)event.proposal;
                LookupCallNewWizardPage.this.setLookupServiceTypeInternal(t);
                LookupCallNewWizardPage.this.updateKeyTypeFor(t);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        radioButtons.setLayoutData((Object)new GridData(768));
        GridLayout radioButtonGroupLayout = new GridLayout(3, true);
        radioButtons.setLayout((Layout)radioButtonGroupLayout);
        this.m_createServiceButton.setLayoutData((Object)new GridData(768));
        this.m_useServiceButton.setLayoutData((Object)new GridData(768));
        this.m_noServiceButton.setLayoutData((Object)new GridData(768));
        this.m_serviceSuperTypeField.setLayoutData(new GridData(768));
        GridData lookupServiceData = new GridData(768);
        lookupServiceData.exclude = true;
        this.m_lookupServiceTypeField.setLayoutData(lookupServiceData);
        return group;
    }

    private void updateKeyTypeFor(IType t) {
        this.m_genericTypeField.setEnabled(t == null || TypeUtility.isGenericType((IType)t));
        if (this.getGenericTypeSignature() == null && TypeUtility.exists((IJavaElement)t)) {
            try {
                String lookupSvcKeyTypeSig = SignatureUtility.resolveTypeParameter((IType)t, (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService", (int)0);
                if (lookupSvcKeyTypeSig != null && Signature.getTypeSignatureKind((String)lookupSvcKeyTypeSig) != 3) {
                    this.setGenericTypeSignature(lookupSvcKeyTypeSig);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
    }

    public LookupCallNewWizard getWizard() {
        return (LookupCallNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusWorkspace());
        multiStatus.add(this.getStatusNameField());
        multiStatus.add(this.getStatusSuperType());
        multiStatus.add(this.getStatusLookupService());
        multiStatus.add(this.getStatusGenericType());
        multiStatus.add(this.getStatusGenericTypeToSuperClass());
        multiStatus.add(this.getStatusGenericTypeToLookupService());
    }

    protected IStatus getStatusGenericTypeToLookupService() {
        IType generic;
        IType superType;
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.USE_EXISTING && this.getLookupServiceType() != null && TypeUtility.exists((IJavaElement)(superType = this.getGenericTypeOf(this.getLookupServiceType()))) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)this.getGenericTypeSignature()))) && !TypeUtility.getSupertypeHierarchy((IType)generic).contains(superType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeDoesNotMatchSuperClass"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericTypeToSuperClass() {
        IType generic;
        IType superType;
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.CREATE_NEW && this.getGenericTypeSignature() != null && TypeUtility.exists((IJavaElement)(superType = this.getGenericTypeOf(this.getServiceSuperType()))) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)this.getGenericTypeSignature()))) && !TypeUtility.getSupertypeHierarchy((IType)generic).contains(superType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeDoesNotMatchSuperClass"));
        }
        return Status.OK_STATUS;
    }

    protected IType getGenericTypeOf(IType lookupType) {
        if (TypeUtility.exists((IJavaElement)lookupType)) {
            try {
                String typeParamSig = SignatureUtility.resolveTypeParameter((IType)lookupType, (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService", (int)0);
                if (typeParamSig != null) {
                    return TypeUtility.getTypeBySignature((String)typeParamSig);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
        return null;
    }

    protected IStatus getStatusWorkspace() {
        if (this.getSharedBundle() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoNewXWithoutScoutBundle", (String[])new String[]{Texts.get((String)"LookupCall")}));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"LookupCall");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.getSharedBundle(), (String)this.getTargetPackage(), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() {
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.CREATE_NEW && this.getServiceSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusLookupService() {
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.USE_EXISTING && this.getLookupServiceType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheLookupCallCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() {
        if (this.getGenericTypeSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"PleaseChooseAKeyType"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public LOOKUP_SERVICE_STRATEGY getLookupServiceStrategy() {
        Object strategy = this.getProperty(PROP_LOOKUP_SERVICE_STRATEGY);
        if (!(strategy instanceof LOOKUP_SERVICE_STRATEGY)) {
            strategy = LOOKUP_SERVICE_STRATEGY.NO_SERVICE;
        }
        return (LOOKUP_SERVICE_STRATEGY)((Object)strategy);
    }

    public void setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY strategy) {
        try {
            if (strategy == null) {
                strategy = LOOKUP_SERVICE_STRATEGY.NO_SERVICE;
            }
            this.setStateChanging(true);
            this.setLookupServiceStrategyInternal(strategy);
            if (this.isControlCreated()) {
                switch (strategy) {
                    case CREATE_NEW: {
                        this.m_createServiceButton.setSelection(true);
                        break;
                    }
                    case USE_EXISTING: {
                        this.m_useServiceButton.setSelection(true);
                        break;
                    }
                    case NO_SERVICE: {
                        this.m_noServiceButton.setSelection(true);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupServiceStrategyInternal(LOOKUP_SERVICE_STRATEGY strategy) {
        this.setProperty(PROP_LOOKUP_SERVICE_STRATEGY, (Object)strategy);
    }

    public IType getServiceSuperType() {
        return (IType)this.getProperty(PROP_SERVICE_SUPER_TYPE);
    }

    public void setServiceSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setServiceSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_serviceSuperTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setServiceSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SERVICE_SUPER_TYPE, superType);
    }

    public IType getLookupServiceType() {
        return (IType)this.getProperty(PROP_LOOKUP_SERVICE);
    }

    public void setLookupServiceType(IType lookupService) {
        try {
            this.setStateChanging(true);
            this.setLookupServiceTypeInternal(lookupService);
            if (this.isControlCreated()) {
                this.m_lookupServiceTypeField.acceptProposal(lookupService);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupServiceTypeInternal(IType lookupService) {
        this.setProperty(PROP_LOOKUP_SERVICE, lookupService);
    }

    public String getTargetPackage() {
        return (String)this.getProperty(PROP_TARGET_PACKAGE);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }

    public String getGenericTypeSignature() {
        return (String)this.getProperty(PROP_GENERIC_TYPE);
    }

    public void setGenericTypeSignature(String genericType) {
        try {
            this.setStateChanging(true);
            this.setGenericTypeSignatureInternal(genericType);
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setGenericTypeSignatureInternal(String genericType) {
        this.setProperty(PROP_GENERIC_TYPE, genericType);
    }

    public static enum LOOKUP_SERVICE_STRATEGY {
        CREATE_NEW,
        USE_EXISTING,
        NO_SERVICE;

    }

    private class P_LookupServiceStrategyButtonListener
    extends SelectionAdapter {
        private final LOOKUP_SERVICE_STRATEGY m_strategy;

        public P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY strategy) {
            this.m_strategy = strategy;
        }

        public void widgetSelected(SelectionEvent e) {
            LookupCallNewWizardPage.this.setLookupServiceStrategyInternal(this.m_strategy);
            switch (this.m_strategy) {
                case CREATE_NEW: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(true);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = false;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.getWizard().getLocationsPage().setExcludePage(false);
                    LookupCallNewWizardPage.this.updateKeyTypeFor(LookupCallNewWizardPage.this.getServiceSuperType());
                    break;
                }
                case USE_EXISTING: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(true);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = false;
                    LookupCallNewWizardPage.this.getWizard().getLocationsPage().setExcludePage(true);
                    LookupCallNewWizardPage.this.updateKeyTypeFor(LookupCallNewWizardPage.this.getLookupServiceType());
                    break;
                }
                case NO_SERVICE: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.getWizard().getLocationsPage().setExcludePage(true);
                    LookupCallNewWizardPage.this.updateKeyTypeFor(null);
                }
            }
            LookupCallNewWizardPage.this.m_lookupServiceTypeField.getParent().layout(true);
            LookupCallNewWizardPage.this.pingStateChanging();
        }
    }
}

