/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.outline;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.outline.OutlineNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class OutlineNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private boolean m_addToDesktop;
    private boolean m_addToDesktopEnabled;
    private String m_packageName;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private Button m_addToDesktopField;
    private EntityTextField m_entityField;
    private final IType m_abstractOutline;
    private final IScoutBundle m_clientBundle;
    private final IType m_desktopType;

    public OutlineNewWizardPage(IScoutBundle clientBundle, IType desktopType) {
        super(OutlineNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.m_desktopType = desktopType;
        this.setTitle(Texts.get((String)"NewOutline"));
        this.setDescription(Texts.get((String)"CreateANewOutline"));
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)clientBundle, (String)"client.outline"));
        this.m_superType = this.m_abstractOutline = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline", (IJavaProject)this.m_clientBundle.getJavaProject());
        this.setAddToDesktop(TypeUtility.exists((IJavaElement)this.m_desktopType));
        this.setAddToDesktopEnabled(TypeUtility.exists((IJavaElement)this.m_desktopType));
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, this.getClientBundle().getNlsProject(), Texts.get((String)"PropTitle"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    OutlineNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = OutlineNewWizardPage.this.getNlsName();
                    OutlineNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (OutlineNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(OutlineNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((CharSequence)OutlineNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        OutlineNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)OutlineNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    OutlineNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("Outline");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeName = this.m_typeNameField.getText();
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutlineNewWizardPage.this.m_typeName = OutlineNewWizardPage.this.m_typeNameField.getText();
                OutlineNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iOutline, this.getClientBundle().getJavaProject(), this.m_abstractOutline), labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                OutlineNewWizardPage.this.m_superType = (IType)event.proposal;
                OutlineNewWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(parent, Texts.get((String)"EntityTextField"), this.m_clientBundle, labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OutlineNewWizardPage.this.setTargetPackageInternal(OutlineNewWizardPage.this.m_entityField.getText());
                    OutlineNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        this.m_addToDesktopField = new Button(parent, 32);
        this.m_addToDesktopField.setSelection(this.isAddToDesktop());
        this.m_addToDesktopField.setText("Add to Desktop");
        this.m_addToDesktopField.setEnabled(this.isAddToDesktopEnabled());
        this.m_addToDesktopField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutlineNewWizardPage.this.m_addToDesktop = OutlineNewWizardPage.this.m_addToDesktopField.getSelection();
                OutlineNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_addToDesktopField.setLayoutData((Object)new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        OutlineNewOperation op = new OutlineNewOperation(this.getTypeName(), this.getClientBundle().getPackageName(this.getTargetPackage()), this.getClientBundle().getJavaProject());
        op.setFormatSource(true);
        op.setNlsEntry(this.getNlsName());
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            op.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
        }
        if (this.isAddToDesktop()) {
            op.setDesktopType(this.getDesktopType());
        }
        op.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusTargetPackge());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public IType getDesktopType() {
        return this.m_desktopType;
    }

    protected IStatus getStatusTargetPackge() {
        return ScoutUtility.validatePackageName((String)this.getTargetPackage());
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"Outline");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.getClientBundle(), (String)this.getTargetPackage(), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setAddToDesktop(boolean addToDesktop) {
        try {
            this.setStateChanging(true);
            this.m_addToDesktop = addToDesktop;
            if (this.isControlCreated()) {
                this.m_addToDesktopField.setSelection(addToDesktop);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public boolean isAddToDesktop() {
        return this.m_addToDesktop;
    }

    public void setAddToDesktopEnabled(boolean addToDesktopEnabled) {
        try {
            this.setStateChanging(true);
            this.m_addToDesktopEnabled = addToDesktopEnabled;
            if (this.isControlCreated()) {
                if (!addToDesktopEnabled) {
                    this.setAddToDesktop(false);
                }
                this.m_addToDesktopField.setEnabled(addToDesktopEnabled);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public boolean isAddToDesktopEnabled() {
        return this.m_addToDesktopEnabled;
    }

    public String getTargetPackage() {
        return this.m_packageName;
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.m_packageName = targetPackage;
    }
}

