/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.page;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.page.PageNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.page.PageNewAttributesWizardPage;
import org.eclipse.scout.sdk.ui.wizard.page.PageNewTemplatesWizardPage;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.ui.IWorkbench;

public class PageNewWizard
extends AbstractWorkspaceWizard {
    private static final String TYPE_PAGE = "page";
    private static final String TYPE_PAGE_DATA = "pageData";
    private IScoutBundle m_clientBundle;
    private ITreeNode m_locationWizardPageRoot;
    private PageNewOperation m_operation;
    private PageNewTemplatesWizardPage m_templatePage;
    private PageNewAttributesWizardPage m_pageAttributePage;
    private BundleTreeWizardPage m_locationWizardPage;

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Texts.get((String)"NewPage"));
        this.m_clientBundle = UiUtility.getScoutBundleFromSelection(selection, ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}));
        IType holderType = UiUtility.getTypeFromSelection(selection);
        this.m_templatePage = new PageNewTemplatesWizardPage(this.m_clientBundle);
        this.addPage((IWizardPage)this.m_templatePage);
        if (this.m_clientBundle != null) {
            this.m_locationWizardPageRoot = PageNewWizard.createTree(this.m_clientBundle);
            P_StatusRevalidator validator = new P_StatusRevalidator();
            this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"LookupServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new P_InitialCheckedFilter());
            this.m_pageAttributePage = new PageNewAttributesWizardPage(this.m_clientBundle);
            this.m_pageAttributePage.addPropertyChangeListener(new P_PageAttributesPropertyListener());
            this.m_pageAttributePage.addStatusProvider(validator);
            this.m_pageAttributePage.setHolderType(holderType);
            this.addPage((IWizardPage)this.m_pageAttributePage);
            this.m_locationWizardPage.addStatusProvider(validator);
            this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
            this.addPage((IWizardPage)this.m_locationWizardPage);
            this.m_locationWizardPage.setExcludePage(true);
            String pck = UiUtility.getPackageSuffix(selection);
            if (StringUtility.hasText((CharSequence)pck)) {
                this.m_pageAttributePage.setTargetPackage(pck);
            }
        }
    }

    public void setLocationWizardPageVisible(boolean visible) {
        this.m_locationWizardPage.setExcludePage(!visible);
    }

    private static ITreeNode createTree(IScoutBundle clientBundle) {
        IScoutBundle sharedBundle = clientBundle.getParentBundle(ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"})}), false);
        IScoutBundleFilter bundleFilter = ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT", "SHARED"})});
        ITreeNode rootNode = TreeUtility.createBundleTree(clientBundle, bundleFilter);
        ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
        TreeUtility.createNode(clientNode, TYPE_PAGE, Texts.get((String)"Page"), ScoutSdkUi.getImageDescriptor("class_obj.gif"));
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_PAGE_DATA, Texts.get((String)"PageData"), ScoutSdkUi.getImageDescriptor("class_obj.gif"));
        }
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle pageDataProject = this.m_locationWizardPage.getLocationBundle(TYPE_PAGE_DATA, true, true);
        String pageDataPackage = null;
        IJavaProject pageDataJavaProject = null;
        if (pageDataProject != null) {
            pageDataJavaProject = pageDataProject.getJavaProject();
            pageDataPackage = pageDataProject.getPackageName(this.m_pageAttributePage.getTargetPackage());
        }
        this.m_operation = new PageNewOperation(this.m_pageAttributePage.getTypeName(), this.m_clientBundle.getPackageName(this.m_pageAttributePage.getTargetPackage()), pageDataPackage, this.m_clientBundle.getJavaProject(), pageDataJavaProject);
        this.m_operation.setNlsEntry(this.m_pageAttributePage.getNlsName());
        IType superType = this.m_pageAttributePage.getSuperType();
        if (TypeUtility.exists((IJavaElement)superType)) {
            this.m_operation.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superType.getFullyQualifiedName()));
        }
        this.m_operation.setHolderType(this.m_pageAttributePage.getHolderType());
        this.m_operation.setFormatSource(true);
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.m_operation.validate();
        this.m_operation.run(monitor, workingCopyManager);
        return true;
    }

    private static final class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        private P_InitialCheckedFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), PageNewWizard.TYPE_PAGE, PageNewWizard.TYPE_PAGE_DATA);
        }
    }

    private final class P_PageAttributesPropertyListener
    implements PropertyChangeListener {
        private P_PageAttributesPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("typeName".equals(evt.getPropertyName())) {
                String typeName = PageNewWizard.this.m_pageAttributePage.getTypeName();
                if (StringUtility.isNullOrEmpty((CharSequence)typeName)) {
                    TreeUtility.findNode(PageNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(PageNewWizard.TYPE_PAGE)).setText(Texts.get((String)"Page"));
                    TreeUtility.findNode(PageNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(PageNewWizard.TYPE_PAGE_DATA)).setText(Texts.get((String)"PageData"));
                } else {
                    TreeUtility.findNode(PageNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(PageNewWizard.TYPE_PAGE)).setText(typeName);
                    TreeUtility.findNode(PageNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(PageNewWizard.TYPE_PAGE_DATA)).setText(String.valueOf(typeName) + "Data");
                }
                PageNewWizard.this.m_locationWizardPage.refreshTree();
            }
        }
    }

    private final class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusPageData(source));
        }

        private IStatus getStatusPageData(Object source) {
            IScoutBundle pageDataBundle = PageNewWizard.this.m_locationWizardPage.getLocationBundle(PageNewWizard.TYPE_PAGE_DATA, true, true);
            if (pageDataBundle != null) {
                ITreeNode pageDataNode = PageNewWizard.this.m_locationWizardPage.getTreeNode(PageNewWizard.TYPE_PAGE_DATA, true, true);
                if (pageDataNode != null) {
                    try {
                        String fqn = String.valueOf(pageDataBundle.getPackageName(PageNewWizard.this.m_pageAttributePage.getTargetPackage())) + "." + pageDataNode.getText();
                        if (pageDataBundle.getJavaProject().findType(fqn) != null) {
                            return new Status(4, "org.eclipse.scout.sdk.ui", "'" + pageDataNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                        }
                    }
                    catch (JavaModelException e) {
                        ScoutSdkUi.logError(e);
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                    }
                }
                if (!ScoutTypeUtility.isOnClasspath((IScoutBundle)pageDataBundle, (IScoutBundle)PageNewWizard.this.m_clientBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{PageNewWizard.this.m_locationWizardPage.getTextOfNode(PageNewWizard.TYPE_PAGE_DATA), PageNewWizard.this.m_locationWizardPage.getTextOfNode(PageNewWizard.TYPE_PAGE)}));
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static final class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return PageNewWizard.TYPE_PAGE_DATA.equals(node.getType());
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 2) {
                dndEvent.doit = PageNewWizard.TYPE_PAGE_DATA.equals(dndEvent.node.getType()) ? "SHARED".equals(dndEvent.targetParent.getType()) : false;
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
        }
    }
}

