/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class TypeHierarchy
implements org.eclipse.scout.sdk.util.typecache.ITypeHierarchy {
    private ITypeHierarchy m_hierarchy;
    private IType m_type;

    TypeHierarchy(IType type) {
        this(type, null);
    }

    TypeHierarchy(IType type, ITypeHierarchy jdtHierarchy) {
        this.m_hierarchy = jdtHierarchy;
        this.m_type = type;
    }

    protected ITypeHierarchy getJdtHierarchy() {
        return this.m_hierarchy;
    }

    protected void setJdtHierarchy(ITypeHierarchy hierarchy) {
        this.m_hierarchy = hierarchy;
    }

    @Override
    public boolean contains(IType type) {
        if (type == null) {
            return false;
        }
        return this.m_hierarchy.contains(type);
    }

    @Override
    public IType getBaseType() {
        return this.m_type;
    }

    protected void setBaseType(IType newBaseType) {
        this.m_type = newBaseType;
    }

    @Override
    public Set<IType> getAllClasses() {
        return this.getAllClasses(null);
    }

    @Override
    public Set<IType> getAllClasses(ITypeFilter filter) {
        return this.getAllClasses(filter, null);
    }

    @Override
    public Set<IType> getAllClasses(ITypeFilter filter, Comparator<IType> comparator) {
        IType[] classes = this.m_hierarchy.getAllClasses();
        return this.getTypesFilteredAndSorted(classes, filter, comparator);
    }

    @Override
    public Set<IType> getAllInterfaces() {
        return this.getAllInterfaces(null);
    }

    @Override
    public Set<IType> getAllInterfaces(ITypeFilter filter) {
        return this.getAllInterfaces(filter, null);
    }

    @Override
    public Set<IType> getAllInterfaces(ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getAllInterfaces();
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public Deque<IType> getSuperClassStack(IType startType) {
        return this.getSuperClassStack(startType, true);
    }

    @Override
    public Deque<IType> getSuperClassStack(IType startType, boolean includeStartType) {
        return this.getSuperClassStack(startType, includeStartType, null);
    }

    @Override
    public Deque<IType> getSuperClassStack(IType startType, boolean includeStartType, String stopTypeFqn) {
        LinkedList<IType> result = new LinkedList<IType>();
        if (startType == null) {
            return result;
        }
        if (stopTypeFqn == null) {
            stopTypeFqn = Object.class.getName();
        }
        IType cur = null;
        cur = includeStartType ? startType : this.getSuperclass(startType);
        while (TypeUtility.exists((IJavaElement)cur) && !stopTypeFqn.equals(cur.getFullyQualifiedName())) {
            result.add(cur);
            cur = this.getSuperclass(cur);
        }
        return result;
    }

    @Override
    public boolean isSubtype(IType type, IType potentialSubtype) {
        IType[] subtypes;
        if (type == null || potentialSubtype == null) {
            return false;
        }
        if (CompareUtility.equals((Object)type, (Object)potentialSubtype)) {
            return true;
        }
        IType[] iTypeArray = subtypes = this.m_hierarchy.getAllSubtypes(type);
        int n = subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (CompareUtility.equals((Object)t, (Object)potentialSubtype)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Set<IType> getAllSubtypes(IType type) {
        return this.getAllSubtypes(type, null);
    }

    @Override
    public Set<IType> getAllSubtypes(IType type, ITypeFilter filter) {
        return this.getAllSubtypes(type, filter, null);
    }

    @Override
    public Set<IType> getAllSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] subtypes = this.m_hierarchy.getAllSubtypes(type);
        return this.getTypesFilteredAndSorted(subtypes, filter, comparator);
    }

    @Override
    public Set<IType> getAllSuperclasses(IType type) {
        return this.getAllSuperclasses(type, null);
    }

    @Override
    public Set<IType> getAllSuperclasses(IType type, ITypeFilter filter) {
        return this.getAllSuperclasses(type, filter, null);
    }

    @Override
    public Set<IType> getAllSuperclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getAllSuperclasses(type);
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public Set<IType> getAllSuperInterfaces(IType type) {
        return this.getAllSuperInterfaces(type, null);
    }

    @Override
    public Set<IType> getAllSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getAllSuperInterfaces(type, filter, null);
    }

    @Override
    public Set<IType> getAllSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getAllSuperInterfaces(type);
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public Set<IType> getAllSupertypes(IType type) {
        return this.getAllSupertypes(type, null);
    }

    @Override
    public Set<IType> getAllSupertypes(IType type, ITypeFilter filter) {
        return this.getAllSupertypes(type, filter, null);
    }

    @Override
    public Set<IType> getAllSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getAllSupertypes(type);
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public Set<IType> getAllTypes() {
        return this.getAllTypes(null);
    }

    @Override
    public Set<IType> getAllTypes(ITypeFilter filter) {
        return this.getAllTypes(filter, null);
    }

    @Override
    public Set<IType> getAllTypes(ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getAllTypes();
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public Set<IType> getSubclasses(IType type) {
        return this.getSubclasses(type, null);
    }

    @Override
    public Set<IType> getSubclasses(IType type, ITypeFilter filter) {
        return this.getSubclasses(type, filter, null);
    }

    @Override
    public Set<IType> getSubclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getSubclasses(type);
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public Set<IType> getSubtypes(IType type) {
        return this.getSubtypes(type, null);
    }

    @Override
    public Set<IType> getSubtypes(IType type, ITypeFilter filter) {
        return this.getSubtypes(type, filter, null);
    }

    @Override
    public Set<IType> getSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getSubtypes(type);
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType getSuperclass(IType type) {
        IType superclass = this.m_hierarchy.getSuperclass(type);
        if (!TypeUtility.exists((IJavaElement)superclass)) {
            return null;
        }
        return superclass;
    }

    @Override
    public Set<IType> getSuperInterfaces(IType type) {
        return this.getSuperInterfaces(type, null);
    }

    @Override
    public Set<IType> getSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getSuperInterfaces(type, filter, null);
    }

    @Override
    public Set<IType> getSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getSuperInterfaces(type);
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public Set<IType> getSupertypes(IType type) {
        return this.getSupertypes(type, null);
    }

    @Override
    public Set<IType> getSupertypes(IType type, ITypeFilter filter) {
        return this.getSupertypes(type, filter, null);
    }

    @Override
    public Set<IType> getSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = this.m_hierarchy.getSupertypes(type);
        return this.getTypesFilteredAndSorted(types, filter, comparator);
    }

    protected Set<IType> getTypesFilteredAndSorted(IType[] types, ITypeFilter filter, Comparator<IType> comparator) {
        AbstractSet result = null;
        result = comparator == null ? new HashSet(types.length) : new TreeSet<IType>(comparator);
        if (filter == null) {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType candidate = iTypeArray[n2];
                result.add((IType)candidate);
                ++n2;
            }
        } else {
            IType[] iTypeArray = types;
            int n = types.length;
            int n3 = 0;
            while (n3 < n) {
                IType candidate = iTypeArray[n3];
                if (filter.accept(candidate)) {
                    result.add(candidate);
                }
                ++n3;
            }
        }
        return result;
    }

    @Override
    public Iterator<IType> iterator() {
        return this.getAllTypes().iterator();
    }
}

