/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class PropertyBean
implements IPropertyBean {
    private IField m_field;
    private IMethod m_readMethod;
    private IMethod m_writeMethod;
    private String m_beanName;
    private final IType m_declaringType;

    public PropertyBean(IType declaringType, String beanName) {
        this.m_declaringType = declaringType;
        this.m_beanName = beanName;
    }

    public String toString() {
        return String.valueOf(this.m_declaringType.getFullyQualifiedName()) + "#" + this.m_beanName;
    }

    @Override
    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public List<IMember> getAllMembers() {
        ArrayList<IMember> members = new ArrayList<IMember>(3);
        if (TypeUtility.exists((IJavaElement)this.m_field)) {
            members.add((IMember)this.m_field);
        }
        if (TypeUtility.exists((IJavaElement)this.m_readMethod)) {
            members.add((IMember)this.m_readMethod);
        }
        if (TypeUtility.exists((IJavaElement)this.m_writeMethod)) {
            members.add((IMember)this.m_writeMethod);
        }
        return members;
    }

    public void setBeanName(String beanName) {
        this.m_beanName = beanName;
    }

    @Override
    public String getBeanName() {
        return this.m_beanName;
    }

    @Override
    public String getBeanSignature() {
        if (TypeUtility.exists((IJavaElement)this.getReadMethod())) {
            try {
                return SignatureUtility.getResolvedSignature(this.getReadMethod().getReturnType(), this.getReadMethod().getDeclaringType());
            }
            catch (CoreException e) {
                SdkUtilActivator.logWarning("could not parse signature of '" + this.getReadMethod().getElementName() + "' in type '" + this.getReadMethod().getDeclaringType().getFullyQualifiedName() + "'.", e);
            }
        }
        if (TypeUtility.exists((IJavaElement)this.getWriteMethod())) {
            try {
                String[] parameterTypes = this.getWriteMethod().getParameterTypes();
                if (parameterTypes != null && parameterTypes.length == 1) {
                    return SignatureUtility.getResolvedSignature(parameterTypes[0], this.getWriteMethod().getDeclaringType());
                }
            }
            catch (CoreException e) {
                SdkUtilActivator.logWarning("could not parse signature of '" + this.getWriteMethod().getElementName() + "' in type '" + this.getWriteMethod().getDeclaringType().getFullyQualifiedName() + "'.", e);
            }
        }
        return null;
    }

    @Override
    public IField getField() {
        return this.m_field;
    }

    public void setField(IField field) {
        this.m_field = field;
    }

    @Override
    public IMethod getReadMethod() {
        return this.m_readMethod;
    }

    public void setReadMethod(IMethod readMethod) {
        this.m_readMethod = readMethod;
    }

    @Override
    public IMethod getWriteMethod() {
        return this.m_writeMethod;
    }

    public void setWriteMethod(IMethod writeMethod) {
        this.m_writeMethod = writeMethod;
    }
}

