/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.util.ScoutSdkUtilCore;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;

public class TypeFilters {
    private static final ITypeFilter INTERFACE_FILTER = new ITypeFilter(){

        @Override
        public boolean accept(IType candidate) {
            try {
                int flags = candidate.getFlags();
                return Flags.isInterface((int)flags) && !Flags.isDeprecated((int)flags);
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logWarning("could not evalutate flags of type '" + candidate.getFullyQualifiedName() + "'.", e);
                return false;
            }
        }
    };
    private static final ITypeFilter CLASS_FILTER = new ITypeFilter(){

        @Override
        public boolean accept(IType candidate) {
            return TypeFilters.isClass(candidate);
        }
    };
    private static final ITypeFilter TOP_LEVEL_FILTER = new ITypeFilter(){

        @Override
        public boolean accept(IType type) {
            return type != null && type.getDeclaringType() == null;
        }
    };
    private static final ITypeFilter IN_WORKSPACE_FILTER = new ITypeFilter(){

        @Override
        public boolean accept(IType type) {
            return !type.isBinary() && !type.isReadOnly();
        }
    };
    private static final ITypeFilter NO_GENERIC_FILTER = new ITypeFilter(){

        @Override
        public boolean accept(IType type) {
            return !TypeUtility.isGenericType(type);
        }
    };
    private static final ITypeFilter ENUM_TYPE_FILTER = new ITypeFilter(){

        @Override
        public boolean accept(IType type) {
            try {
                int flags = type.getFlags();
                return Flags.isEnum((int)flags) && !Flags.isDeprecated((int)flags) && !Flags.isAbstract((int)flags);
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logWarning("could not evalutate flags of type '" + type.getFullyQualifiedName() + "'.", e);
                return false;
            }
        }
    };
    private static final ITypeFilter NO_SURROUNDING_CONTEXT_TYPE_FILTER = new ITypeFilter(){

        @Override
        public boolean accept(IType type) {
            try {
                return type != null && !type.isAnonymous() && (type.getDeclaringType() == null || Flags.isStatic((int)type.getFlags()));
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logWarning("could not evalutate flags of type '" + type.getFullyQualifiedName() + "'.", e);
                return false;
            }
        }
    };

    protected TypeFilters() {
    }

    public static ITypeFilter invertFilter(final ITypeFilter filter) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return !filter.accept(type);
            }
        };
    }

    public static ITypeFilter getSubtypeFilter(String fqn) {
        IType type = TypeUtility.getType(fqn);
        if (TypeUtility.exists((IJavaElement)type)) {
            return TypeFilters.getSubtypeFilter(type);
        }
        return new ITypeFilter(){

            @Override
            public boolean accept(IType t) {
                return false;
            }
        };
    }

    public static ITypeFilter getSubtypeFilter(final IType type) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                ITypeHierarchy hierarchy = ScoutSdkUtilCore.getHierarchyCache().getSupertypeHierarchy(candidate);
                return hierarchy != null && hierarchy.contains(type);
            }
        };
    }

    public static ITypeFilter getSubtypeFilter(final IType type, final ITypeHierarchy hierarchy) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                return hierarchy.isSubtype(type, candidate);
            }
        };
    }

    public static ITypeFilter getElementNameFilter(String typeName) {
        return TypeFilters.getElementNameFilter(typeName, true);
    }

    public static ITypeFilter getElementNameFilter(final String typeName, boolean caseSensitive) {
        if (caseSensitive) {
            return new ITypeFilter(){

                @Override
                public boolean accept(IType type) {
                    return typeName.equals(type.getElementName());
                }
            };
        }
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return typeName.equalsIgnoreCase(type.getElementName());
            }
        };
    }

    public static ITypeFilter getRegexSimpleNameFilter(String regex, int regexFlags) {
        final Pattern pat = Pattern.compile(regex, regexFlags);
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return pat.matcher(type.getElementName()).matches();
            }
        };
    }

    public static ITypeFilter getRegexSimpleNameFilter(String regex) {
        return TypeFilters.getRegexSimpleNameFilter(regex, 2);
    }

    public static ITypeFilter getTypesOnClasspath(final IJavaProject project) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (!TypeUtility.exists((IJavaElement)candidate)) {
                    return false;
                }
                return TypeUtility.isOnClasspath((IJavaElement)candidate, project);
            }
        };
    }

    public static ITypeFilter getInWorkspaceFilter() {
        return IN_WORKSPACE_FILTER;
    }

    public static ITypeFilter getPrimaryTypeFilter() {
        return TOP_LEVEL_FILTER;
    }

    public static ITypeFilter getInnerClasses(final IType declaringType) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                if (!TypeUtility.exists((IJavaElement)candidate)) {
                    return false;
                }
                IType candidateDeclaringType = candidate.getDeclaringType();
                return candidateDeclaringType != null && candidateDeclaringType.equals(declaringType) && TypeFilters.isClass(candidate);
            }
        };
    }

    public static ITypeFilter getFlagsFilter(final int flags) {
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                try {
                    int typeFlags = type.getFlags();
                    return (typeFlags & flags) == flags;
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logError("could not filter type '" + type.getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
        };
    }

    public static ITypeFilter getClassFilter() {
        return CLASS_FILTER;
    }

    public static ITypeFilter getNotInTypes(IType ... excludedTypes) {
        HashSet<IType> excludedSet = null;
        if (excludedTypes != null) {
            excludedSet = new HashSet<IType>(excludedTypes.length);
            IType[] iTypeArray = excludedTypes;
            int n = excludedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                if (t != null) {
                    excludedSet.add(t);
                }
                ++n2;
            }
        }
        return TypeFilters.getNotInTypes(excludedSet);
    }

    public static ITypeFilter getNoSurroundingContextTypeFilter() {
        return NO_SURROUNDING_CONTEXT_TYPE_FILTER;
    }

    public static ITypeFilter getNotInTypes(final Set<IType> excludedTypes) {
        if (excludedTypes == null || excludedTypes.size() < 1) {
            return null;
        }
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                return !excludedTypes.contains(type);
            }
        };
    }

    public static ITypeFilter getInterfaceFilter() {
        return INTERFACE_FILTER;
    }

    protected static boolean isClass(IType type) {
        block5: {
            block4: {
                try {
                    if (TypeUtility.exists((IJavaElement)type)) break block4;
                    return false;
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logWarning("could not evalutate flags of type '" + type.getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
            if (!type.isAnonymous()) break block5;
            return false;
        }
        int flags = type.getFlags();
        return !Flags.isAbstract((int)flags) && !Flags.isInterface((int)flags) && !Flags.isDeprecated((int)flags);
    }

    public static ITypeFilter getNoGenericTypesFilter() {
        return NO_GENERIC_FILTER;
    }

    public static ITypeFilter getEnumTypesFilter() {
        return ENUM_TYPE_FILTER;
    }

    private static ITypeFilter getMultiTypeFilter(final boolean or, final ITypeFilter ... filters) {
        if (filters == null || filters.length < 1) {
            return null;
        }
        if (filters.length == 1) {
            return filters[0];
        }
        return new ITypeFilter(){

            @Override
            public boolean accept(IType candidate) {
                ITypeFilter[] iTypeFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean accepted;
                    ITypeFilter f = iTypeFilterArray[n2];
                    if (f != null && or == (accepted = f.accept(candidate))) {
                        return accepted;
                    }
                    ++n2;
                }
                return !or;
            }
        };
    }

    public static ITypeFilter getMultiTypeFilterOr(ITypeFilter ... filters) {
        return TypeFilters.getMultiTypeFilter(true, filters);
    }

    public static ITypeFilter getMultiTypeFilterAnd(ITypeFilter ... filters) {
        return TypeFilters.getMultiTypeFilter(false, filters);
    }

    public static ITypeFilter getTypeParamSuperTypeFilter(String baseSig, String paramDefiningSuperTypeFqn, int paramIndex) {
        return TypeFilters.getTypeParamFilter(baseSig, paramDefiningSuperTypeFqn, paramIndex, false);
    }

    public static ITypeFilter getTypeParamSubTypeFilter(String baseSig, String paramDefiningSuperTypeFqn, int paramIndex) {
        return TypeFilters.getTypeParamFilter(baseSig, paramDefiningSuperTypeFqn, paramIndex, true);
    }

    private static ITypeFilter getTypeParamFilter(String baseSig, final String paramDefiningSuperTypeFqn, final int paramIndex, final boolean sub) {
        if (baseSig == null) {
            return new ITypeFilter(){

                @Override
                public boolean accept(IType type) {
                    return true;
                }
            };
        }
        final IType baseType = TypeUtility.getTypeBySignature(baseSig);
        final boolean baseTypeExists = TypeUtility.exists((IJavaElement)baseType);
        return new ITypeFilter(){

            @Override
            public boolean accept(IType type) {
                String typeParamSig;
                block5: {
                    try {
                        typeParamSig = SignatureUtility.resolveTypeParameter(type, paramDefiningSuperTypeFqn, paramIndex);
                        if (typeParamSig != null && Signature.getTypeSignatureKind((String)typeParamSig) != 3 && !SignatureUtility.SIG_OBJECT.equals(typeParamSig)) break block5;
                        return true;
                    }
                    catch (CoreException e) {
                        SdkUtilActivator.logWarning("Could not evaluate generic parameters of type '" + type.getFullyQualifiedName() + "'.", e);
                        return false;
                    }
                }
                IType typeParam = TypeUtility.getTypeBySignature(typeParamSig);
                if (TypeUtility.exists((IJavaElement)typeParam) && baseTypeExists) {
                    if (sub) {
                        return TypeUtility.getSupertypeHierarchy(typeParam).contains(baseType);
                    }
                    return TypeUtility.getSupertypeHierarchy(baseType).contains(typeParam);
                }
                return false;
            }
        };
    }
}

