/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractTypeNewExecutor
extends AbstractExecutor {
    private String m_packageFragment;
    private boolean m_allowModifyPackageFragment;
    private String m_superTypeSignature;
    private boolean m_allowModifySuperType;
    private List<String> m_interfaceTypeSignatures;
    private boolean m_allowModifyInterfaces;
    private String m_typeName;
    private IScoutBundle m_bundle;

    public boolean canRun(IStructuredSelection selection) {
        this.m_bundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
        return this.isEditable(this.m_bundle);
    }

    protected abstract void init(IScoutBundle var1);

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        try {
            this.init(this.m_bundle);
            this.openNewTypeDialog();
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("Error while creating new type.", e);
        }
        return null;
    }

    protected String stripSignatureToFQN(String signature, boolean eraseGenericTypes) {
        if (signature == null) {
            return null;
        }
        String typeSignature = SignatureUtil.stripSignatureToFQN((String)signature);
        if (!eraseGenericTypes) {
            String typeArguments = null;
            String[] stringArray = Signature.getTypeArguments((String)signature);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String typeArgument = stringArray[n2];
                typeArguments = StringUtility.join((String)",", (Object[])new Object[]{typeArguments, SignatureUtil.stripSignatureToFQN((String)typeArgument)});
                ++n2;
            }
            if (typeArguments != null) {
                typeSignature = String.valueOf(typeSignature) + '<' + typeArguments + '>';
            }
        }
        return typeSignature;
    }

    protected IType openNewTypeDialog() throws JavaModelException {
        NewClassWizardPage page = new NewClassWizardPage();
        page.setEnclosingTypeSelection(false, false);
        page.setMethodStubSelection(false, true, true, true);
        IPackageFragment packageFragment = null;
        packageFragment = this.m_bundle.getPackageFragment(this.m_packageFragment);
        if (packageFragment != null) {
            page.setPackageFragmentRoot((IPackageFragmentRoot)packageFragment.getParent(), this.m_allowModifyPackageFragment);
            page.setPackageFragment(packageFragment, this.m_allowModifyPackageFragment);
        } else {
            String rootPackageName = this.m_bundle.getSymbolicName();
            page.setPackageFragmentRoot((IPackageFragmentRoot)this.m_bundle.getPackageFragment(rootPackageName).getParent(), true);
        }
        if (this.m_superTypeSignature != null) {
            page.setSuperClass(this.stripSignatureToFQN(this.m_superTypeSignature, false), this.m_allowModifySuperType);
        }
        if (this.m_interfaceTypeSignatures != null && this.m_interfaceTypeSignatures.size() > 0) {
            LinkedList<String> interfaceTypeNames = new LinkedList<String>();
            for (String signature : this.m_interfaceTypeSignatures) {
                interfaceTypeNames.add(this.stripSignatureToFQN(signature, false));
            }
            page.setSuperInterfaces(interfaceTypeNames, this.m_allowModifyInterfaces);
        }
        if (this.m_typeName != null) {
            page.setTypeName(Signature.getSimpleName((String)this.m_typeName), true);
        }
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setConfiguredWizardPage(page);
        action.run();
        IType createdType = page.getCreatedType();
        if (TypeUtility.exists((IJavaElement)createdType)) {
            IWorkingCopyManager level = ScoutSdkCore.createWorkingCopyManger();
            try {
                level.register(createdType.getCompilationUnit(), (IProgressMonitor)new NullProgressMonitor());
                TypeUtility.getType((String)createdType.getFullyQualifiedName());
                level.reconcile(createdType.getCompilationUnit(), (IProgressMonitor)new NullProgressMonitor());
                TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")).invalidate();
            }
            catch (CoreException e) {
                JaxWsSdk.logError(e);
            }
            level.unregisterAll((IProgressMonitor)new NullProgressMonitor());
            return createdType;
        }
        return null;
    }

    protected void setSuperTypeSignature(String superTypeSignature, boolean allowModify) {
        this.m_superTypeSignature = superTypeSignature;
        this.m_allowModifySuperType = allowModify;
    }

    protected void setInterfaceTypeSignatures(List<String> interfaceTypeSignatures, boolean allowModify) {
        this.m_interfaceTypeSignatures = interfaceTypeSignatures;
        this.m_allowModifyInterfaces = allowModify;
    }

    protected void setPackageFragment(String packageFragment, boolean allowModify) {
        this.m_packageFragment = packageFragment;
        this.m_allowModifyPackageFragment = allowModify;
    }

    protected void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }
}

