/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.executor.param.HandlerParams;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;

public class HandlerChainRemoveExecutor
extends AbstractExecutor {
    private HandlerParams m_params;

    public boolean canRun(IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof HandlerParams) {
            this.m_params = (HandlerParams)firstElement;
        }
        return this.m_params != null && this.isEditable(this.m_params.getBundle());
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        SunJaxWsBean sunJaxWsBean = this.m_params.getSunJaxWsBean();
        Element xmlHandlerChain = this.m_params.getXmlHandlerChain();
        MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 196);
        messageBox.setMessage(Texts.get("QuestionRemoveHandlerChain"));
        if (messageBox.open() == 64) {
            Element xmlHandlerChains = JaxWsSdkUtility.getChildElement(sunJaxWsBean.getXml().getChildNodes(), sunJaxWsBean.toQualifiedName("handler-chains"));
            xmlHandlerChains.removeChild(xmlHandlerChain);
            ResourceFactory.getSunJaxWsResource(this.m_params.getBundle()).storeXmlAsync(xmlHandlerChain.getOwnerDocument(), 512, sunJaxWsBean.getAlias());
        }
        return null;
    }
}

