/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.IMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.CommandExecutionOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.CommandExecutionDialog;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderCodeFirstNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.swt.widgets.Shell;

public class RepairExecutor
extends AbstractExecutor {
    public boolean canRun(IStructuredSelection selection) {
        return this.isEditable(UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection));
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        IScoutBundle scoutBundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
        Object selected = selection.getFirstElement();
        String markerGroupUUID = null;
        if (selected instanceof WebServiceConsumerNodePage) {
            markerGroupUUID = ((WebServiceConsumerNodePage)selected).getMarkerGroupUUID();
        } else if (selected instanceof WebServiceProviderCodeFirstNodePage) {
            markerGroupUUID = ((WebServiceProviderCodeFirstNodePage)selected).getMarkerGroupUUID();
        } else if (selected instanceof WebServiceProviderNodePage) {
            markerGroupUUID = ((WebServiceProviderNodePage)selected).getMarkerGroupUUID();
        } else {
            return null;
        }
        IMarkerCommand[] markerCommands = MarkerUtility.getMarkerCommands(markerGroupUUID, scoutBundle);
        CommandExecutionDialog dialog = new CommandExecutionDialog(Texts.get("RepairTools"));
        dialog.setHeaderMessage(Texts.get("TheFollowingProblemsWereEncountered"));
        dialog.setCommands(markerCommands);
        if (dialog.open() == 0) {
            LinkedList<IMarkerCommand> commandsToBeExecuted = new LinkedList<IMarkerCommand>();
            IMarkerCommand[] iMarkerCommandArray = markerCommands;
            int n = markerCommands.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerCommand command = iMarkerCommandArray[n2];
                if (command.isDoExecute()) {
                    try {
                        if (command.prepareForUi()) {
                            commandsToBeExecuted.add(command);
                        }
                    }
                    catch (CoreException e) {
                        JaxWsSdk.logError("Error occured while preparing command to be executed", e);
                    }
                }
                ++n2;
            }
            OperationJob job = new OperationJob(new IOperation[]{new CommandExecutionOperation(commandsToBeExecuted.toArray(new IMarkerCommand[commandsToBeExecuted.size()]))});
            job.schedule();
        }
        return null;
    }
}

