/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker;

import java.util.HashSet;
import java.util.Map;
import javax.jws.WebService;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.CorruptBindingFileCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.CorruptWsdlCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.DiscouragedWsdlFolderCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.InvalidEndpointInterfaceCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.InvalidPortTypeCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.InvalidServiceCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.JaxWsServletRegistrationCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingBuildJaxWsEntryCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingClasspathEntryForJarFileCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingEndpointPropertyCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingPortTypeCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingPortTypeInheritanceCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingScoutWebServiceAnnotationCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingServiceCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingWebServiceAnnotationCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MissingWsdlCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.MultipleGlobalBindingsCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.StubRebuildCommand;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.UrlPatternDefaultCommand;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.eclipse.scout.sdk.ws.jaxws.util.ServletRegistrationUtility;
import org.eclipse.scout.sdk.ws.jaxws.validator.IServletAliasValidation;
import org.eclipse.scout.sdk.ws.jaxws.validator.IUrlPatternValidation;
import org.eclipse.scout.sdk.ws.jaxws.validator.ServletAliasValidator;
import org.eclipse.scout.sdk.ws.jaxws.validator.UrlPatternValidator;
import org.w3c.dom.Element;

public final class MarkerRebuildUtility {
    public static final String PROPERTY_ENDPOINT_INTERFACE = "endpointInterface";

    private MarkerRebuildUtility() {
    }

    public static boolean rebuildPortTypeImplMarkers(IFile sunJaxWsFile, SunJaxWsBean sunJaxWsBean, BuildJaxWsBean buildJaxWsBean, IType portType, Definition wsdlDefinition, String markerGroupUUID, IScoutBundle bundle) {
        block21: {
            String interfacePortTypeQualifiedNameFromAnnotation;
            HashSet<IType> interfacePortTypes;
            block20: {
                IAnnotation webServiceAnnotation;
                block19: {
                    block18: {
                        IType portTypeInterfaceType;
                        block17: {
                            block16: {
                                IFile markerResource = sunJaxWsFile;
                                if (!JaxWsSdkUtility.exists((IResource)sunJaxWsFile)) {
                                    markerResource = bundle.getJavaProject().getResource();
                                }
                                portTypeInterfaceType = null;
                                PortType wsdlPortType = JaxWsSdkUtility.getPortType(wsdlDefinition, sunJaxWsBean.getServiceQNameSafe(), sunJaxWsBean.getPort());
                                if (wsdlPortType != null && wsdlPortType.getQName() != null) {
                                    IFile stubJarFile = JaxWsSdkUtility.getStubJarFile(bundle, buildJaxWsBean, sunJaxWsBean.getWsdl());
                                    portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(wsdlPortType.getQName(), stubJarFile);
                                }
                                if (TypeUtility.exists((IJavaElement)portType)) break block16;
                                String markerSourceId = MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("InvalidImplementationType"));
                                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingPortTypeCommand(bundle, markerGroupUUID, sunJaxWsBean, portTypeInterfaceType));
                                return false;
                            }
                            String recommendedPackageName = JaxWsSdkUtility.getRecommendedProviderImplPackageName(bundle);
                            if (portType.getPackageFragment().getElementName().startsWith(recommendedPackageName)) break block17;
                            MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Package, markerGroupUUID, 1, Texts.get("ByConventionXShouldStartWithY", Texts.get("Package"), recommendedPackageName));
                            return false;
                        }
                        interfacePortTypes = new HashSet<IType>();
                        ITypeHierarchy hierarchy = TypeUtility.getSupertypeHierarchy((IType)portType);
                        for (IType superInterface : hierarchy.getAllSuperInterfaces(portType)) {
                            IAnnotation annotation = JaxWsSdkUtility.getAnnotation(superInterface, WebService.class.getName(), false);
                            if (annotation == null || !annotation.exists()) continue;
                            interfacePortTypes.add(superInterface);
                        }
                        if (interfacePortTypes.size() != 0) break block18;
                        String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("WsImplXMustImplementPortTypeInterface", portType.getElementName()));
                        if (portTypeInterfaceType != null) {
                            JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingPortTypeInheritanceCommand(markerGroupUUID, portType, portTypeInterfaceType));
                        }
                        return false;
                    }
                    webServiceAnnotation = JaxWsSdkUtility.getAnnotation(portType, WebService.class.getSimpleName(), false);
                    if (TypeUtility.exists((IJavaElement)webServiceAnnotation)) break block19;
                    String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("TypeMustBeAnnotatedWithXAnnotationInOrderToBeInstalledAsWebservice", WebService.class.getSimpleName()));
                    MarkerRebuildUtility.registerMissingEndpointCommand(markerSourceId, bundle, sunJaxWsBean, buildJaxWsBean, portType, wsdlDefinition);
                    return false;
                }
                IMemberValuePair[] memberValuePairs = webServiceAnnotation.getMemberValuePairs();
                interfacePortTypeQualifiedNameFromAnnotation = null;
                IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
                int n = memberValuePairs.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemberValuePair mvPair = iMemberValuePairArray[n2];
                    if (PROPERTY_ENDPOINT_INTERFACE.equals(mvPair.getMemberName())) {
                        interfacePortTypeQualifiedNameFromAnnotation = (String)mvPair.getValue();
                        break;
                    }
                    ++n2;
                }
                if (interfacePortTypeQualifiedNameFromAnnotation != null) break block20;
                String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("MissingPropertyXOnAnnotationYToLinkThePortTypeWithTheRespectivePortTypeInterface", PROPERTY_ENDPOINT_INTERFACE, WebService.class.getSimpleName()));
                MarkerRebuildUtility.registerMissingEndpointCommand(markerSourceId, bundle, sunJaxWsBean, buildJaxWsBean, portType, wsdlDefinition);
                return false;
            }
            boolean match = false;
            for (IType interfacePortTypeCandidate : interfacePortTypes) {
                if (!interfacePortTypeCandidate.getFullyQualifiedName().equals(interfacePortTypeQualifiedNameFromAnnotation)) continue;
                match = true;
                break;
            }
            if (match) break block21;
            String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("TheEndpointInterfaceConfiguredWithinAnnotationXDoesNotExistOrIsNotImplementedByThisEndpoint", WebService.class.getSimpleName()));
            MarkerRebuildUtility.registerMissingEndpointCommand(markerSourceId, bundle, sunJaxWsBean, buildJaxWsBean, portType, wsdlDefinition);
            return false;
        }
        try {
            IAnnotation scoutWebServiceAnnotation = JaxWsSdkUtility.getAnnotation(portType, TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getElementName(), false);
            if (!TypeUtility.exists((IJavaElement)scoutWebServiceAnnotation)) {
                String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, 1, Texts.get("ToConfigureAuthenticationAndSessionHandlingForTheWebserviceAnnotateThePortTypeWithX", TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getElementName()));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingScoutWebServiceAnnotationCommand(portType));
                return false;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("failed to rebuild markers for endpoint", e);
        }
        return true;
    }

    public static boolean rebuildBuildJaxWsMarkers(IFile buildJaxWsFile, BuildJaxWsBean buildJaxWsBean, String alias, WsdlResource wsdlResource, String markerGroupUUID, IScoutBundle bundle, WebserviceEnum webserviceEnum) {
        IFile markerResource = buildJaxWsFile;
        if (!JaxWsSdkUtility.exists((IResource)buildJaxWsFile)) {
            markerResource = bundle.getJavaProject().getResource();
        }
        if (buildJaxWsBean == null) {
            String markerSourceId = MarkerUtility.createMarker(bundle.getJavaProject().getResource(), JaxWsConstants.MarkerType.MissingBuildJaxWsEntry, markerGroupUUID, Texts.get("MissingBuildEntryInFileX", JaxWsConstants.PATH_BUILD_JAXWS.toString()));
            JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingBuildJaxWsEntryCommand(bundle, alias, webserviceEnum));
            return false;
        }
        IFolder folder = JaxWsSdkUtility.getFolder(bundle, JaxWsConstants.STUB_FOLDER, false);
        if (folder == null || !folder.exists()) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.StubFolder, markerGroupUUID, Texts.get("StubFolderXDoesNotExist", JaxWsConstants.STUB_FOLDER.toString()));
            return false;
        }
        String stubPackageName = JaxWsSdkUtility.getBuildProperty(buildJaxWsBean.getPropertiers(), "p");
        if (stubPackageName != null) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Package, markerGroupUUID, 1, Texts.get("ConventionPackageNameEqualsToTargetNamespaceX"));
            if (!StringUtility.hasText((CharSequence)stubPackageName)) {
                MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Package, markerGroupUUID, Texts.get("PackageNameMustNotBeEmpty"));
                return false;
            }
            IStatus status = JavaConventionsUtil.validatePackageName((String)stubPackageName, (IJavaElement)bundle.getJavaProject());
            if (status.getSeverity() == 4) {
                MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Package, markerGroupUUID, Texts.get("PackageNameNotValidJavaPackageName", status.getMessage()));
                return false;
            }
            if (status.getSeverity() == 2) {
                MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Package, markerGroupUUID, 1, Texts.get("PackageNameNotValidJavaPackageName", status.getMessage()));
            }
        }
        return true;
    }

    public static boolean rebuildSunJaxWsMarkers(IFile sunJaxWsFile, SunJaxWsBean sunJaxWsBean, WsdlResource wsdlResource, String markerGroupUUID, IScoutBundle bundle) {
        IFile markerResource = sunJaxWsFile;
        if (!JaxWsSdkUtility.exists((IResource)sunJaxWsFile)) {
            markerResource = bundle.getJavaProject().getResource();
        }
        if (!StringUtility.hasText((CharSequence)sunJaxWsBean.getAlias())) {
            MarkerUtility.createMarker((IResource)markerResource, markerGroupUUID, Texts.get("MissingOrEmptyAttributeX", "name"));
            return false;
        }
        if (!StringUtility.hasText((CharSequence)sunJaxWsBean.getImplementation())) {
            MarkerUtility.createMarker((IResource)markerResource, markerGroupUUID, Texts.get("MissingOrEmptyAttributeX", "implementation"));
            return false;
        }
        if (!MarkerRebuildUtility.validateJaxWsServletRegistartionAndUrlPattern(sunJaxWsBean, markerGroupUUID, bundle)) {
            return false;
        }
        Definition wsdlDefinition = wsdlResource.loadWsdlDefinition();
        if (wsdlDefinition == null) {
            return true;
        }
        String wsdlProjectRelativePath = sunJaxWsBean.getWsdl();
        if (wsdlProjectRelativePath != null && !wsdlProjectRelativePath.equals(PathNormalizer.toWsdlPath(sunJaxWsBean.getWsdl()))) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.WsdlFolder, markerGroupUUID, "Path to WSDL file in 'sun-jaxws.xml' must not start with a slash.");
        }
        Map services = wsdlDefinition.getServices();
        if (sunJaxWsBean.getServiceQNameSafe() == null) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Service, markerGroupUUID, 1, Texts.get("InvalidServiceConfigurationMissingOrInvalidQNameInAttributeX", "service"));
            return false;
        }
        if (!services.keySet().contains(sunJaxWsBean.getServiceQNameSafe())) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Service, markerGroupUUID, Texts.get("ServiceCouldNotBeFoundInWSDLmodel"));
            if (!sunJaxWsBean.getServiceQNameSafe().getNamespaceURI().endsWith("/")) {
                MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Service, markerGroupUUID, Texts.get("ServiceNamespaceMustEndWithASlash"));
            }
            return false;
        }
        javax.wsdl.Service service = (javax.wsdl.Service)services.get(sunJaxWsBean.getServiceQNameSafe());
        Map ports = service.getPorts();
        if (ports == null || ports.size() == 0) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Port, markerGroupUUID, 1, Texts.get("DiscouragedPortConfigurationNoPortFoundInWSDLFileX", wsdlResource.getFile().getProjectRelativePath().toString()));
            return false;
        }
        if (sunJaxWsBean.getPortQNameSafe() == null) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Port, markerGroupUUID, 1, Texts.get("DiscouragedServiceConfigurationMissingOrIinvalidQNameInAttributeX", "port"));
            return false;
        }
        if (!ports.keySet().contains(sunJaxWsBean.getPortQNameSafe().getLocalPart())) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Port, markerGroupUUID, Texts.get("UnknownPortConfiguredInAttributeX", "port"));
            return false;
        }
        return true;
    }

    private static boolean validateJaxWsServletRegistartionAndUrlPattern(SunJaxWsBean sunJaxWsBean, final String markerGroupUUID, final IScoutBundle bundle) {
        final String servletAlias = ServletRegistrationUtility.getAlias(bundle);
        boolean validationResult = ServletAliasValidator.validate(servletAlias, new IServletAliasValidation(){

            @Override
            public void onEmpty() {
                String markerSourceId = MarkerUtility.createMarker(bundle.getJavaProject().getResource(), JaxWsConstants.MarkerType.UrlPattern, markerGroupUUID, 2, "No or wrong servlet Plug-In specified in build-jaxws.xml to host JAX-WS servlet registration.\nAdd the element 'servlet-bundle' with the attribute 'name' to build-jaxws.xml and specify the symbolic name of the plugin that contains the JAX-WS servlet registration in its plugin.xml.");
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new JaxWsServletRegistrationCommand(bundle));
            }

            @Override
            public void onIllegalCharacters() {
                String markerSourceId = MarkerUtility.createMarker(bundle.getJavaProject().getResource(), JaxWsConstants.MarkerType.UrlPattern, markerGroupUUID, 2, "Invalid JAX-WS servlet alias '" + servletAlias + "' specified.");
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new JaxWsServletRegistrationCommand(bundle));
            }

            @Override
            public void onWrongSeparators() {
                String markerSourceId = MarkerUtility.createMarker(bundle.getJavaProject().getResource(), JaxWsConstants.MarkerType.UrlPattern, markerGroupUUID, 2, "Invalid JAX-WS servlet alias '" + servletAlias + "'. Must start with a slash with no empty segments and no trailing slash.");
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new JaxWsServletRegistrationCommand(bundle));
            }
        });
        if (!validationResult) {
            return false;
        }
        IFile sunJaxWsResource = ResourceFactory.getSunJaxWsResource(bundle).getFile();
        Object markerResource = JaxWsSdkUtility.exists((IResource)sunJaxWsResource) ? sunJaxWsResource : bundle.getJavaProject().getResource();
        String urlPattern = sunJaxWsBean.getUrlPattern();
        return UrlPatternValidator.validate(urlPattern, servletAlias, new IUrlPatternValidation((IResource)markerResource, markerGroupUUID, urlPattern, bundle, sunJaxWsBean, servletAlias){
            private final /* synthetic */ IResource val$markerResource;
            private final /* synthetic */ String val$markerGroupUUID;
            private final /* synthetic */ String val$urlPattern;
            private final /* synthetic */ IScoutBundle val$bundle;
            private final /* synthetic */ SunJaxWsBean val$sunJaxWsBean;
            private final /* synthetic */ String val$servletAlias;
            {
                this.val$markerResource = iResource;
                this.val$markerGroupUUID = string;
                this.val$urlPattern = string2;
                this.val$bundle = iScoutBundle;
                this.val$sunJaxWsBean = sunJaxWsBean;
                this.val$servletAlias = string3;
            }

            @Override
            public void onWrongSeparators() {
                String markerSourceId = MarkerUtility.createMarker(this.val$markerResource, JaxWsConstants.MarkerType.UrlPattern, this.val$markerGroupUUID, 2, "Invalid URL pattern '" + this.val$urlPattern + "'. Must start with a slash with no empty segments and no trailing slash.");
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new JaxWsServletRegistrationCommand(this.val$bundle, this.val$sunJaxWsBean));
            }

            @Override
            public void onNotStartingWithServletAlias() {
                String markerSourceId = MarkerUtility.createMarker(this.val$markerResource, JaxWsConstants.MarkerType.UrlPattern, this.val$markerGroupUUID, 2, Texts.get("UrlPatternJaxWsAliasMismatch", this.val$servletAlias));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new UrlPatternDefaultCommand(this.val$bundle, this.val$sunJaxWsBean, this.val$servletAlias, "URL pattern must start with JAX-WS servlet alias."));
            }

            @Override
            public void onIllegalCharacters() {
                String markerSourceId = MarkerUtility.createMarker(this.val$markerResource, JaxWsConstants.MarkerType.UrlPattern, this.val$markerGroupUUID, 2, "Invalid URL pattern '" + this.val$urlPattern + "'.");
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new UrlPatternDefaultCommand(this.val$bundle, this.val$sunJaxWsBean, this.val$servletAlias, "Illegal characters in URL pattern."));
            }

            @Override
            public void onEmpty() {
                String markerSourceId = MarkerUtility.createMarker(this.val$markerResource, JaxWsConstants.MarkerType.UrlPattern, this.val$markerGroupUUID, Texts.get("MissingOrEmptyAttributeX", "url-pattern"));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new UrlPatternDefaultCommand(this.val$bundle, this.val$sunJaxWsBean, this.val$servletAlias, "No URL Pattern specified."));
            }
        });
    }

    public static boolean rebuildBindingFileMarkers(IFile buildJaxWsFile, XmlResource[] bindingFileResources, WsdlResource wsdlResource, String markerGroupUUID, IScoutBundle bundle) {
        IFile defaultMarkerResource = buildJaxWsFile;
        int index = 0;
        while (index < bindingFileResources.length) {
            XmlResource bindingFileResource = bindingFileResources[index];
            if (bindingFileResource.getFile() == null) {
                MarkerUtility.createMarker((IResource)defaultMarkerResource, JaxWsConstants.MarkerType.BindingFile, JaxWsSdkUtility.toMarkerGroupUUID(markerGroupUUID, index), 2, Texts.get("NonExistingBindingFileConfigured"));
                return false;
            }
            if (!bindingFileResource.getFile().exists()) {
                String markerSourceId = MarkerUtility.createMarker((IResource)defaultMarkerResource, JaxWsConstants.MarkerType.BindingFile, JaxWsSdkUtility.toMarkerGroupUUID(markerGroupUUID, index), 2, Texts.get("BindingFileXCouldNotBeFound", bindingFileResource.getFile().getProjectRelativePath().toString()));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new CorruptBindingFileCommand(bundle, bindingFileResource.getFile(), wsdlResource));
                return false;
            }
            if (bindingFileResource.loadXml() == null) {
                String markerSourceId = MarkerUtility.createMarker((IResource)bindingFileResource.getFile(), JaxWsConstants.MarkerType.BindingFile, JaxWsSdkUtility.toMarkerGroupUUID(markerGroupUUID, index), 2, Texts.get("BindingFileXIsNotAValidXMLFile", bindingFileResource.getFile().getProjectRelativePath().toString()));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new CorruptBindingFileCommand(bundle, bindingFileResource.getFile(), wsdlResource));
                return false;
            }
            ++index;
        }
        if (JaxWsSdkUtility.containsGlobalBindingSection(bindingFileResources, true)) {
            String markerSourceId = MarkerUtility.createMarker((IResource)defaultMarkerResource, JaxWsConstants.MarkerType.BindingFile, markerGroupUUID, 2, Texts.get("MultipleGlobalBindingDefinitionsFoundOnlyOneAllowed"));
            JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MultipleGlobalBindingsCommand());
            return false;
        }
        return true;
    }

    public static boolean rebuildWsdlMarkers(WsdlResource wsdlResource, BuildJaxWsBean buildJaxWsBean, SunJaxWsBean sunJaxWsBean, String markerGroupUUID, IScoutBundle bundle) {
        boolean provider;
        IFile wsdlFile;
        IFile markerResource = wsdlResource.getFile();
        if (!JaxWsSdkUtility.exists((IResource)wsdlResource.getFile())) {
            markerResource = bundle.getJavaProject().getResource();
        }
        if ((wsdlFile = wsdlResource.getFile()) == null) {
            MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Wsdl, markerGroupUUID, Texts.get("NoWSDLFileConfigured"));
            return false;
        }
        boolean bl = provider = sunJaxWsBean != null;
        if (!wsdlResource.existsFile()) {
            String markerSourceId = MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Wsdl, markerGroupUUID, Texts.get("WSDLFileXCouldNotBeFound", wsdlFile.getProjectRelativePath().toString()));
            if (provider) {
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingWsdlCommand(bundle, wsdlResource, sunJaxWsBean));
            } else {
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingWsdlCommand(bundle, wsdlResource, buildJaxWsBean));
            }
            return false;
        }
        Definition wsdlDefinition = wsdlResource.loadWsdlDefinition();
        if (wsdlDefinition == null) {
            String markerSourceId = MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Wsdl, markerGroupUUID, Texts.get("CorruptWSDLFileAtLocationX", wsdlFile.getProjectRelativePath().toString()));
            if (provider) {
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new CorruptWsdlCommand(bundle, wsdlResource, sunJaxWsBean));
            } else {
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new CorruptWsdlCommand(bundle, wsdlResource, buildJaxWsBean));
            }
            return false;
        }
        Map services = wsdlDefinition.getServices();
        if (services == null || services.size() == 0) {
            String markerSourceId = MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.Service, markerGroupUUID, 2, Texts.get("NoServiceFoundInWSDLFileX", wsdlResource.getFile().getProjectRelativePath().toString()));
            JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingServiceCommand(wsdlResource.getFile().getName()));
            return false;
        }
        IFolder rootFolder = provider ? JaxWsSdkUtility.getFolder(bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false) : JaxWsSdkUtility.getFolder(bundle, JaxWsConstants.PATH_WSDL_CONSUMER, false);
        IFolder folder = JaxWsSdkUtility.getParentFolder(bundle, wsdlFile);
        IPath wsdlRootPath = rootFolder.getProjectRelativePath();
        IPath candidatePath = folder.getProjectRelativePath();
        if ((candidatePath = candidatePath.makeRelativeTo(wsdlRootPath)).toString().startsWith("..")) {
            String markerSourceId = MarkerUtility.createMarker((IResource)markerResource, JaxWsConstants.MarkerType.WsdlFolder, markerGroupUUID, 1, Texts.get("WarningWsdlFolder", rootFolder.getProjectRelativePath().toString()));
            if (provider) {
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new DiscouragedWsdlFolderCommand(bundle, markerGroupUUID, buildJaxWsBean, sunJaxWsBean));
            } else {
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new DiscouragedWsdlFolderCommand(bundle, markerGroupUUID, buildJaxWsBean));
            }
        }
        return true;
    }

    public static boolean rebuildWebserviceClientType(IType webserviceClientType, BuildJaxWsBean buildJaxWsBean, WsdlResource wsdlResource, String markerGroupUUID, IScoutBundle bundle) {
        if (buildJaxWsBean == null) {
            return false;
        }
        if (!TypeUtility.exists((IJavaElement)webserviceClientType)) {
            return false;
        }
        IResource markerResource = webserviceClientType.getResource();
        if (!JaxWsSdkUtility.exists(markerResource)) {
            markerResource = bundle.getJavaProject().getResource();
        }
        IFile stubJarFile = JaxWsSdkUtility.getStubJarFile(bundle, buildJaxWsBean, buildJaxWsBean.getWsdl());
        QName serviceQName = JaxWsSdkUtility.extractServiceQNameFromWsClient(webserviceClientType);
        if (serviceQName == null) {
            if (stubJarFile != null && stubJarFile.exists()) {
                String markerSourceId = MarkerUtility.createMarker(markerResource, JaxWsConstants.MarkerType.Service, markerGroupUUID, Texts.get("InvalidServiceInSuperTypeGenericParameter", Service.class.getName(), WebServiceClient.class.getSimpleName()));
                InvalidServiceCommand cmd = new InvalidServiceCommand(webserviceClientType, stubJarFile);
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
            } else {
                String markerSourceId = MarkerUtility.createMarker(markerResource, JaxWsConstants.MarkerType.Service, markerGroupUUID, Texts.get("InvalidServiceInWsdl", Service.class.getName(), WebServiceClient.class.getSimpleName()));
                MarkerRebuildUtility.registerStubRebuildCommand(markerSourceId, buildJaxWsBean, wsdlResource, bundle);
            }
            return false;
        }
        QName portTypeQName = JaxWsSdkUtility.extractPortTypeQNameFromWsClient(webserviceClientType);
        if (portTypeQName == null) {
            if (stubJarFile != null && stubJarFile.exists()) {
                String markerSourceId = MarkerUtility.createMarker(markerResource, JaxWsConstants.MarkerType.PortType, markerGroupUUID, Texts.get("InvalidPortTypeInSuperGenericParameter", WebService.class.getSimpleName()));
                InvalidPortTypeCommand cmd = new InvalidPortTypeCommand(webserviceClientType, stubJarFile);
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
            } else {
                String markerSourceId = MarkerUtility.createMarker(markerResource, JaxWsConstants.MarkerType.PortType, markerGroupUUID, Texts.get("InvalidPortTypeInWsdl", WebService.class.getSimpleName()));
                MarkerRebuildUtility.registerStubRebuildCommand(markerSourceId, buildJaxWsBean, wsdlResource, bundle);
            }
            return false;
        }
        Definition wsdlDefinition = wsdlResource.loadWsdlDefinition();
        if (wsdlDefinition == null) {
            return true;
        }
        if (wsdlDefinition.getService(serviceQName) == null) {
            String markerSourceId = MarkerUtility.createMarker(markerResource, JaxWsConstants.MarkerType.Service, markerGroupUUID, Texts.get("ServiceXNotFoundInWsdl", serviceQName.toString()));
            if (stubJarFile != null && stubJarFile.exists()) {
                InvalidServiceCommand cmd = new InvalidServiceCommand(webserviceClientType, stubJarFile);
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
            }
            return false;
        }
        if (wsdlDefinition.getPortType(portTypeQName) == null) {
            String markerSourceId = MarkerUtility.createMarker(markerResource, JaxWsConstants.MarkerType.PortType, markerGroupUUID, Texts.get("PortTypeXNotFoundInWsdl", portTypeQName.toString()));
            if (stubJarFile != null && stubJarFile.exists()) {
                InvalidPortTypeCommand cmd = new InvalidPortTypeCommand(webserviceClientType, stubJarFile);
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
            }
            return false;
        }
        return true;
    }

    public static boolean rebuildStubJarFileMarkers(BuildJaxWsBean buildJaxWsBean, WsdlResource wsdlResource, QName portTypeQName, QName serviceQName, IScoutBundle bundle, String markerGroupUUID) {
        IType serviceType;
        String markerSourceId;
        IType portTypeInterfaceType;
        if (buildJaxWsBean == null || wsdlResource == null || wsdlResource.getFile() == null) {
            return false;
        }
        IResource markerResource = bundle.getJavaProject().getResource();
        IFile stubJarFile = JaxWsSdkUtility.getStubJarFile(bundle, buildJaxWsBean, wsdlResource.getFile().getName());
        if (!stubJarFile.exists()) {
            String markerSourceId2 = MarkerUtility.createMarker(markerResource, JaxWsConstants.MarkerType.StubJar, markerGroupUUID, "Could not find JAR file '" + stubJarFile.getName() + "' with generated stub classes for webservice '" + buildJaxWsBean.getAlias() + "'");
            MarkerRebuildUtility.registerStubRebuildCommand(markerSourceId2, buildJaxWsBean, wsdlResource, bundle);
            return false;
        }
        try {
            PluginModelHelper h = new PluginModelHelper(bundle.getProject());
            if (!h.Manifest.existsClasspathEntry(stubJarFile.getProjectRelativePath().toString())) {
                String markerSourceId3 = MarkerUtility.createMarker((IResource)wsdlResource.getFile(), JaxWsConstants.MarkerType.StubJar, markerGroupUUID, Texts.get("JarFileXOfWsYMustBeOnClasspath", stubJarFile.getName(), buildJaxWsBean.getAlias()));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId3, new MissingClasspathEntryForJarFileCommand(bundle, buildJaxWsBean.getAlias(), stubJarFile));
                return false;
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError(e);
        }
        if (portTypeQName != null && (portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(portTypeQName, stubJarFile)) == null) {
            markerSourceId = MarkerUtility.createMarker((IResource)wsdlResource.getFile(), JaxWsConstants.MarkerType.StubJar, markerGroupUUID, Texts.get("PortTypeXNotFoundInStubJarY", portTypeQName.toString(), stubJarFile.getName()));
            MarkerRebuildUtility.registerStubRebuildCommand(markerSourceId, buildJaxWsBean, wsdlResource, bundle);
        }
        if (serviceQName != null && (serviceType = JaxWsSdkUtility.resolveServiceType(serviceQName, stubJarFile)) == null) {
            markerSourceId = MarkerUtility.createMarker((IResource)wsdlResource.getFile(), JaxWsConstants.MarkerType.StubJar, markerGroupUUID, Texts.get("ServiceTypeXNotFoundInStubJarY", serviceQName.toString(), stubJarFile.getName()));
            MarkerRebuildUtility.registerStubRebuildCommand(markerSourceId, buildJaxWsBean, wsdlResource, bundle);
            return false;
        }
        return true;
    }

    public static void rebuildHandlerMarkers(SunJaxWsBean sunJaxWsBean, final IScoutBundle bundle, final String markerGroupUUID) {
        sunJaxWsBean.visitHandlers(new SunJaxWsBean.IHandlerVisitor(){

            @Override
            public boolean visit(Element xmlHandlerElement, String fullyQualifiedName, int handlerIndex, int handlerCount) {
                if (fullyQualifiedName == null) {
                    MarkerUtility.createMarker((IResource)ResourceFactory.getSunJaxWsResource(bundle).getFile(), JaxWsConstants.MarkerType.HandlerClass, markerGroupUUID, "Missing handler class");
                    return false;
                }
                if (!TypeUtility.existsType((String)fullyQualifiedName)) {
                    MarkerUtility.createMarker((IResource)ResourceFactory.getSunJaxWsResource(bundle).getFile(), JaxWsConstants.MarkerType.HandlerClass, markerGroupUUID, "Configured handler class '" + fullyQualifiedName + "' could not be found.");
                    return false;
                }
                return true;
            }
        });
    }

    public static void rebuildCodeFirstPortTypeMarkers(IScoutBundle bundle, IType portType, SunJaxWsBean sunJaxWsBean, String markerGroupUUID) {
        try {
            if (!TypeUtility.exists((IJavaElement)portType)) {
                String markerSourceId = MarkerUtility.createMarker((IResource)ResourceFactory.getSunJaxWsResource(bundle).getFile(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("InvalidImplementationType"));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingPortTypeCommand(bundle, markerGroupUUID, sunJaxWsBean, null));
                return;
            }
            if (!TypeUtility.exists((IJavaElement)portType)) {
                return;
            }
            IAnnotation wsAnnotation = JaxWsSdkUtility.getAnnotation(portType, WebService.class.getName(), false);
            if (wsAnnotation == null) {
                String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("MissingAnnotationOnPortType", WebService.class.getSimpleName(), portType.getElementName()));
                MissingWebServiceAnnotationCommand cmd = new MissingWebServiceAnnotationCommand(portType);
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
                return;
            }
            AnnotationProperty endpointProperty = JaxWsSdkUtility.parseAnnotationTypeValue(portType, wsAnnotation, PROPERTY_ENDPOINT_INTERFACE);
            if (endpointProperty.isDefined()) {
                IType endpointInterfaceType = TypeUtility.getType((String)endpointProperty.getFullyQualifiedName());
                if (endpointInterfaceType == null) {
                    String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("InvalidEndpointInterfaceSpecified", WebService.class.getSimpleName(), portType.getElementName()));
                    JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new InvalidEndpointInterfaceCommand(portType));
                    return;
                }
                wsAnnotation = JaxWsSdkUtility.getAnnotation(endpointInterfaceType, WebService.class.getName(), true);
                if (wsAnnotation == null) {
                    String markerSourceId = MarkerUtility.createMarker(endpointInterfaceType.getResource(), JaxWsConstants.MarkerType.EndpointInterface, markerGroupUUID, Texts.get("MissingAnnotationOnEndpointInterface", endpointInterfaceType.getElementName(), WebService.class.getSimpleName()));
                    MissingWebServiceAnnotationCommand cmd = new MissingWebServiceAnnotationCommand(endpointInterfaceType);
                    JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
                    return;
                }
                if (!JaxWsSdkUtility.isJdtSubType(endpointInterfaceType.getFullyQualifiedName(), portType)) {
                    String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, Texts.get("WsImplXMustImplementPortTypeInterface", portType.getElementName()));
                    JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingPortTypeInheritanceCommand(markerGroupUUID, portType, endpointInterfaceType));
                    return;
                }
            }
            if (!MarkerRebuildUtility.validateJaxWsServletRegistartionAndUrlPattern(sunJaxWsBean, markerGroupUUID, bundle)) {
                return;
            }
            IAnnotation scoutWebServiceAnnotation = JaxWsSdkUtility.getAnnotation(portType, TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getElementName(), false);
            if (!TypeUtility.exists((IJavaElement)scoutWebServiceAnnotation)) {
                String markerSourceId = MarkerUtility.createMarker(portType.getResource(), JaxWsConstants.MarkerType.Implementation, markerGroupUUID, 1, Texts.get("ToConfigureAuthenticationAndSessionHandlingForTheWebserviceAnnotateThePortTypeWithX", TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getElementName()));
                JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, new MissingScoutWebServiceAnnotationCommand(portType));
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError(e);
        }
    }

    private static void registerStubRebuildCommand(String markerSourceId, BuildJaxWsBean buildJaxWsBean, WsdlResource wsdlResource, IScoutBundle bundle) {
        if (wsdlResource.getFile() != null) {
            StubRebuildCommand cmd = new StubRebuildCommand(bundle);
            cmd.setAlias(buildJaxWsBean.getAlias());
            cmd.setProperties(buildJaxWsBean.getPropertiers());
            cmd.setWsdlResource(wsdlResource);
            JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
        }
    }

    private static void registerMissingEndpointCommand(String markerSourceId, IScoutBundle bundle, SunJaxWsBean sunJaxWsBean, BuildJaxWsBean buildJaxWsBean, IType implType, Definition wsdlDefinition) {
        if (sunJaxWsBean == null || wsdlDefinition == null) {
            return;
        }
        IFile stubJarFile = JaxWsSdkUtility.getStubJarFile(bundle, buildJaxWsBean, sunJaxWsBean.getWsdl());
        if (stubJarFile == null) {
            return;
        }
        MissingEndpointPropertyCommand cmd = new MissingEndpointPropertyCommand(implType);
        PortType wsdlPortType = JaxWsSdkUtility.getPortType(wsdlDefinition, sunJaxWsBean.getServiceQNameSafe(), sunJaxWsBean.getPort());
        if (wsdlPortType != null) {
            cmd.setPortTypeQName(wsdlPortType.getQName());
        }
        cmd.setStubJarFile(stubJarFile);
        JaxWsSdk.getDefault().addMarkerCommand(markerSourceId, cmd);
    }
}

