/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.UUID;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.IMarkerCommand;

public final class MarkerUtility {
    private MarkerUtility() {
    }

    public static int getQuality(IPage page, IScoutBundle bundle, String groupUUID) {
        int quality = 0;
        IMarker[] iMarkerArray = MarkerUtility.getMarkers(bundle, JaxWsConstants.MarkerType.JaxWs, groupUUID);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if ((quality = Math.max(quality, marker.getAttribute("severity", 0))) == 2) {
                return quality;
            }
            ++n2;
        }
        if (page.hasChildren()) {
            IPage[] a = page.getChildArray();
            int i = 0;
            while (i < a.length) {
                if ((quality = Math.max(quality, a[i].getQuality())) == 2) break;
                ++i;
            }
            return quality;
        }
        return quality;
    }

    public static void clearMarkers(IScoutBundle bundle, String groupUUID) {
        JaxWsSdk.getDefault().removeMarkerCommands(groupUUID);
        try {
            IMarker[] iMarkerArray = MarkerUtility.getMarkers(bundle, JaxWsConstants.MarkerType.JaxWs, groupUUID);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            JaxWsSdk.logError("Could not delete markers", e);
        }
    }

    public static void deleteMarkers(IScoutBundle bundle, JaxWsConstants.MarkerType markerType, String groupUUID) {
        try {
            IMarker[] iMarkerArray = MarkerUtility.getMarkers(bundle, markerType, groupUUID);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                String markerSourceId = marker.getAttribute("sourceId", null);
                if (markerSourceId != null) {
                    JaxWsSdk.getDefault().removeMarkerCommand(markerSourceId);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JaxWsSdk.logError("Could not delete markers", e);
        }
    }

    public static String createMarker(IResource resource, String groupUUID, String message) {
        return MarkerUtility.createMarker(resource, JaxWsConstants.MarkerType.JaxWs, groupUUID, message);
    }

    public static String createMarker(IResource resource, JaxWsConstants.MarkerType markerType, String groupUUID, String message) {
        return MarkerUtility.createMarker(resource, markerType, groupUUID, 2, message);
    }

    public static String createMarker(IResource resource, JaxWsConstants.MarkerType markerType, String groupUUID, int severity, String message) {
        if (resource != null && resource.exists()) {
            try {
                IMarker marker = resource.createMarker(markerType.getId());
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("priority", 2);
                marker.setAttribute("severity", severity);
                marker.setAttribute("transient", true);
                String sourceId = StringUtility.join((String)" ", (Object[])new Object[]{groupUUID, UUID.randomUUID().toString()});
                marker.setAttribute("sourceId", (Object)sourceId);
                return sourceId;
            }
            catch (Exception e) {
                JaxWsSdk.logError("could not create marker", e);
            }
        }
        return null;
    }

    public static boolean containsMarker(IScoutBundle bundle, JaxWsConstants.MarkerType markerType, String groupUUID, int minimumSeverity) {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = MarkerUtility.getMarkers(bundle, markerType, groupUUID);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("severity", 0) >= minimumSeverity) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IMarker[] getMarkers(IScoutBundle bundle, JaxWsConstants.MarkerType markerType, String groupUUID) {
        HashSet<IMarker> markers = new HashSet<IMarker>();
        try {
            IMarker[] candidates;
            IMarker[] iMarkerArray = candidates = bundle.getJavaProject().getResource().findMarkers(markerType.getId(), true, 2);
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker candidate = iMarkerArray[n2];
                if (groupUUID == null) {
                    markers.add(candidate);
                } else if (candidate.getAttribute("sourceId", "").startsWith(groupUUID)) {
                    markers.add(candidate);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError("Could not retrieve markers", e);
        }
        return markers.toArray(new IMarker[markers.size()]);
    }

    public static IMarkerCommand[] getMarkerCommands(String markerGroupUUID, IScoutBundle bundle) {
        IMarker[] markers;
        LinkedList<IMarkerCommand> commands = new LinkedList<IMarkerCommand>();
        IMarker[] iMarkerArray = markers = MarkerUtility.getMarkers(bundle, JaxWsConstants.MarkerType.JaxWs, markerGroupUUID);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerCommand markerCommand;
            IMarker marker = iMarkerArray[n2];
            String sourceId = marker.getAttribute("sourceId", null);
            if (sourceId != null && (markerCommand = JaxWsSdk.getDefault().getMarkerCommand(sourceId)) != null) {
                markerCommand.setMarker(marker);
                commands.add(markerCommand);
            }
            ++n2;
        }
        return commands.toArray(new IMarkerCommand[commands.size()]);
    }
}

