/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BindingFileCreateOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private IPath m_projectRelativePath;
    private IFile m_wsdlLocation;
    private String m_schemaTargetNamespace;
    private boolean m_createGlobalBindingSection;
    private IFolder m_wsdlDestinationFolder;

    public void validate() {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("no bundle set");
        }
        if (this.m_projectRelativePath == null) {
            throw new IllegalArgumentException("no projectRelativePath set");
        }
        if (this.m_wsdlDestinationFolder == null) {
            throw new IllegalArgumentException("WSDL destination path must not be null");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFile bindingFile = JaxWsSdkUtility.getFile(this.m_bundle, this.m_projectRelativePath, true);
        Document xmlDocument = JaxWsSdkUtility.createNewXmlDocument("jaxws:bindings");
        Element rootXml = xmlDocument.getDocumentElement();
        rootXml.setAttribute("xmlns:jaxws", "http://java.sun.com/xml/ns/jaxws");
        rootXml.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
        rootXml.setAttribute("xmlns:wsdl", "http://schemas.xmlsoap.org/wsdl/");
        rootXml.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        rootXml.setAttribute("xmlns:xjc", "http://java.sun.com/xml/ns/jaxb/xjc");
        rootXml.setAttribute("version", "2.0");
        if (this.m_wsdlLocation != null) {
            IPath wsdlFolderProjectRelativePath = this.m_wsdlDestinationFolder.getProjectRelativePath().makeRelativeTo(JaxWsSdkUtility.getParentFolder(this.m_bundle, bindingFile).getProjectRelativePath());
            rootXml.setAttribute("wsdlLocation", wsdlFolderProjectRelativePath.append(this.m_wsdlLocation.getName()).toString());
        }
        if (StringUtility.hasText((CharSequence)this.m_schemaTargetNamespace)) {
            rootXml.setAttribute("node", "wsdl:definitions/wsdl:types/xsd:schema[@targetNamespace='" + this.m_schemaTargetNamespace + "']");
        } else {
            rootXml.setAttribute("node", "wsdl:definitions/wsdl:types/xsd:schema");
        }
        if (this.isCreateGlobalBindingSection()) {
            Element globalBindingsXml = xmlDocument.createElement("jaxb:globalBindings");
            rootXml.appendChild(globalBindingsXml);
            Element bindingJavaTypeXml = xmlDocument.createElement("xjc:javaType");
            bindingJavaTypeXml.setAttribute("name", Date.class.getName());
            bindingJavaTypeXml.setAttribute("xmlType", "xsd:date");
            bindingJavaTypeXml.setAttribute("adapter", "org.eclipse.scout.jaxws.adapters.UtcDateAdapter");
            globalBindingsXml.appendChild(bindingJavaTypeXml);
            bindingJavaTypeXml = xmlDocument.createElement("xjc:javaType");
            bindingJavaTypeXml.setAttribute("name", Date.class.getName());
            bindingJavaTypeXml.setAttribute("xmlType", "xsd:time");
            bindingJavaTypeXml.setAttribute("adapter", "org.eclipse.scout.jaxws.adapters.UtcDateAdapter");
            globalBindingsXml.appendChild(bindingJavaTypeXml);
            bindingJavaTypeXml = xmlDocument.createElement("xjc:javaType");
            bindingJavaTypeXml.setAttribute("name", Date.class.getName());
            bindingJavaTypeXml.setAttribute("xmlType", "xsd:dateTime");
            bindingJavaTypeXml.setAttribute("adapter", "org.eclipse.scout.jaxws.adapters.UtcDateAdapter");
            globalBindingsXml.appendChild(bindingJavaTypeXml);
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(JaxWsSdkUtility.getXmlContent(xmlDocument).getBytes("UTF-8"));
            bindingFile.setContents((InputStream)is, true, false, monitor);
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new ScoutStatus(4, "could not create binding file.", (Throwable)e));
        }
    }

    public String getOperationName() {
        return BindingFileCreateOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public IPath getProjectRelativePath() {
        return this.m_projectRelativePath;
    }

    public void setProjectRelativePath(IPath projectRelativePath) {
        this.m_projectRelativePath = projectRelativePath;
    }

    public IFile getWsdlLocation() {
        return this.m_wsdlLocation;
    }

    public void setWsdlLocation(IFile wsdlLocation) {
        this.m_wsdlLocation = wsdlLocation;
    }

    public String getSchemaTargetNamespace() {
        return this.m_schemaTargetNamespace;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.m_schemaTargetNamespace = schemaTargetNamespace;
    }

    public boolean isCreateGlobalBindingSection() {
        return this.m_createGlobalBindingSection;
    }

    public void setCreateGlobalBindingSection(boolean createGlobalBindingSection) {
        this.m_createGlobalBindingSection = createGlobalBindingSection;
    }

    public IFolder getWsdlDestinationFolder() {
        return this.m_wsdlDestinationFolder;
    }

    public void setWsdlDestinationFolder(IFolder wsdlDestinationFolder) {
        this.m_wsdlDestinationFolder = wsdlDestinationFolder;
    }
}

