/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import javax.xml.ws.Service;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.operation.jdt.type.PrimaryTypeNewOperation;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;

public class WsConsumerImplNewOperation
extends ServiceNewOperation {
    private IType m_jaxWsServiceType;
    private IType m_jaxWsPortType;
    private boolean m_createScoutWebServiceAnnotation;
    private String m_authenticationHandlerQName;

    public WsConsumerImplNewOperation(String serviceInterfaceName, String serviceName) {
        super(serviceInterfaceName, serviceName);
        this.setFormatSource(true);
    }

    public void validate() {
    }

    public void run(final IProgressMonitor monitor, final IWorkingCopyManager workingCopyManager) throws CoreException {
        IType jaxWsPortType = null;
        if (TypeUtility.exists((IJavaElement)this.getJaxWsPortType())) {
            jaxWsPortType = this.getJaxWsPortType();
        } else {
            jaxWsPortType = TypeUtility.getType((String)Object.class.getName());
            JaxWsSdk.logError("Could not link webservice consumer to port type as port type could not be found");
        }
        IType jaxWsServiceType = null;
        if (TypeUtility.exists((IJavaElement)this.getJaxWsServiceType())) {
            jaxWsServiceType = this.getJaxWsServiceType();
        } else {
            jaxWsServiceType = TypeUtility.getType((String)Service.class.getName());
            JaxWsSdk.logError("Could not link webservice consumer to service as service could not be found");
        }
        String superTypeSignature = SignatureCache.createTypeSignature((String)("org.eclipse.scout.jaxws.service.AbstractWebServiceClient<" + jaxWsServiceType.getFullyQualifiedName() + ", " + jaxWsPortType.getFullyQualifiedName() + ">"));
        this.setImplementationSuperTypeSignature(superTypeSignature);
        if (this.m_createScoutWebServiceAnnotation) {
            final String defaultAuthFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient").getMethod("authenticationHandler", new String[0]).getDefaultValue().getValue();
            AnnotationSourceBuilder scoutWebServiceClientAnnot = new AnnotationSourceBuilder(SignatureCache.createTypeSignature((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient")){

                public void createSource(StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
                    if (WsConsumerImplNewOperation.this.m_authenticationHandlerQName != null && !WsConsumerImplNewOperation.this.isSameType(WsConsumerImplNewOperation.this.m_authenticationHandlerQName, defaultAuthFactory)) {
                        IType type = WsConsumerImplNewOperation.this.createType(WsConsumerImplNewOperation.this.m_authenticationHandlerQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler"), monitor, workingCopyManager);
                        this.addParameter("authenticationHandler=" + validator.getTypeName(SignatureCache.createTypeSignature((String)type.getFullyQualifiedName())) + ".class");
                    }
                    super.createSource(source, lineDelimiter, ownerProject, validator);
                }
            };
            this.getImplementationSourceBuilder().addAnnotationSourceBuilder((IAnnotationSourceBuilder)scoutWebServiceClientAnnot);
        }
        super.run(monitor, workingCopyManager);
    }

    private IType createType(String qualifiedTypeName, IType interfaceType, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IType type;
        if (TypeUtility.existsType((String)qualifiedTypeName)) {
            type = TypeUtility.getType((String)qualifiedTypeName);
        } else {
            String typeName = Signature.getSimpleName((String)qualifiedTypeName);
            String packageName = Signature.getQualifier((String)qualifiedTypeName);
            PrimaryTypeNewOperation newTypeOp = new PrimaryTypeNewOperation(typeName, packageName, this.getImplementationProject());
            newTypeOp.setIcuCommentSourceBuilder(CommentSourceBuilderFactory.createPreferencesCompilationUnitCommentBuilder());
            newTypeOp.setTypeCommentSourceBuilder(CommentSourceBuilderFactory.createPreferencesTypeCommentBuilder());
            newTypeOp.setFlags(1);
            newTypeOp.addInterfaceSignature(SignatureCache.createTypeSignature((String)interfaceType.getFullyQualifiedName()));
            newTypeOp.run(monitor, workingCopyManager);
            type = newTypeOp.getCreatedType();
            workingCopyManager.register(type.getCompilationUnit(), monitor);
        }
        return type;
    }

    public String getOperationName() {
        return WsConsumerImplNewOperation.class.getName();
    }

    public boolean isCreateScoutWebserviceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public void setCreateScoutWebServiceAnnotation(boolean createScoutWebServiceAnnotation) {
        this.m_createScoutWebServiceAnnotation = createScoutWebServiceAnnotation;
    }

    public String getAuthenticationHandlerQName() {
        return this.m_authenticationHandlerQName;
    }

    public void setAuthenticationHandlerQName(String authenticationHandlerQName) {
        this.m_authenticationHandlerQName = authenticationHandlerQName;
    }

    public boolean isCreateScoutWebServiceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public IType getJaxWsServiceType() {
        return this.m_jaxWsServiceType;
    }

    public void setJaxWsServiceType(IType jaxWsServiceType) {
        this.m_jaxWsServiceType = jaxWsServiceType;
    }

    public IType getJaxWsPortType() {
        return this.m_jaxWsPortType;
    }

    public void setJaxWsPortType(IType jaxWsPortType) {
        this.m_jaxWsPortType = jaxWsPortType;
    }

    private boolean isSameType(String fullyQualifiedName1, String fullyQualifiedName2) {
        if (fullyQualifiedName1 != null) {
            fullyQualifiedName1 = fullyQualifiedName1.replaceAll("\\$", ".");
        }
        if (fullyQualifiedName2 != null) {
            fullyQualifiedName2 = fullyQualifiedName2.replaceAll("\\$", ".");
        }
        return CompareUtility.equals((Object)fullyQualifiedName1, (Object)fullyQualifiedName2);
    }
}

