/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.delete.DeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.AbstractTypeChangedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;

public class AuthenticationHandlerNodePage
extends AbstractPage
implements ITypePage {
    private IType m_type;
    private boolean m_pageUnloaded = false;
    private Object m_pageLoadedListenerLock;
    private Set<IPageLoadedListener> m_pageLoadedListeners;
    private P_TypeChangeListener m_handlerChangedListener;

    public AuthenticationHandlerNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setName(type.getElementName());
        this.m_type = type;
        if (type.isBinary()) {
            this.setImageDescriptor(JaxWsSdk.getImageDescriptor("authentication_handler_binary.png"));
        } else {
            this.setImageDescriptor(JaxWsSdk.getImageDescriptor("authentication_handler.png"));
        }
        this.m_pageLoadedListeners = new HashSet<IPageLoadedListener>();
        this.m_pageLoadedListenerLock = new Object();
        this.m_handlerChangedListener = new P_TypeChangeListener();
        this.m_handlerChangedListener.setType(this.m_type);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.m_handlerChangedListener);
    }

    public String getPageId() {
        return IJaxWsPageConstants.AUTHENTICATION_HANDLER_NODE_PAGE;
    }

    public void unloadPage() {
        this.m_pageUnloaded = true;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_handlerChangedListener);
        super.unloadPage();
    }

    public int getQuality() {
        int quality = 0;
        if (this.getType().exists()) {
            quality = ScoutSeverityManager.getInstance().getSeverityOf((Object)this.getType());
        }
        return quality;
    }

    public boolean handleDoubleClickedDelegate() {
        if (this.getType() != null) {
            try {
                JavaUI.openInEditor((IJavaElement)this.getType());
            }
            catch (Exception e) {
                JaxWsSdk.logWarning("could not open type in editor", e);
            }
            return true;
        }
        return false;
    }

    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        if (!this.m_type.isBinary()) {
            return this.newSet(new Class[]{DeleteAction.class, TypeRenameAction.class, ShowJavaReferencesAction.class});
        }
        return this.newSet(new Class[]{ShowJavaReferencesAction.class});
    }

    public boolean isFolder() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPageLoadedListeners() {
        IPageLoadedListener[] listeners;
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            listeners = this.m_pageLoadedListeners.toArray(new IPageLoadedListener[this.m_pageLoadedListeners.size()]);
        }
        IPageLoadedListener[] iPageLoadedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPageLoadedListener listener = iPageLoadedListenerArray[n2];
            try {
                listener.pageLoaded();
            }
            catch (Exception e) {
                JaxWsSdk.logError("error while notifying pageLoaded listener", e);
            }
            ++n2;
        }
    }

    public boolean isPageUnloaded() {
        return this.m_pageUnloaded;
    }

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
    }

    private class P_TypeChangeListener
    extends AbstractTypeChangedListener {
        private P_TypeChangeListener() {
        }

        @Override
        protected boolean shouldAnalayseForChange(IResourceChangeEvent event) {
            return !AuthenticationHandlerNodePage.this.isPageUnloaded();
        }

        @Override
        protected void typeChanged() {
            AuthenticationHandlerNodePage.this.markStructureDirty();
            AuthenticationHandlerNodePage.this.notifyPageLoadedListeners();
        }
    }
}

