/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.part;

import javax.jws.WebService;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.IScoutSeverityListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.FileOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.RepairAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.TypeOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderCodeFirstNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.ActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AnnotationPropertyTypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.SeparatorPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.TypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.UrlPatternPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.ServletRegistrationUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPresenterValueChangedListener;
import org.eclipse.swt.layout.GridData;

public class WebServiceProviderCodeFirstNodePagePropertyViewPart
extends AbstractSinglePageSectionBasedViewPart {
    public static final String SECTION_ID_REPAIR = "section.jaxws.repair";
    public static final String SECTION_ID_PROPERTIES = "section.jaxws.properties";
    public static final String SECTION_ID_LINKS = "section.jaxws.links";
    public static final String SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION = "section.scoutWebServiceAnnotation";
    public static final int PRESENTER_ID_SESSION_FACTORY = 2;
    public static final int PRESENTER_ID_AUTHENTICATION_HANDLER = 4;
    public static final int PRESENTER_ID_CREDENTIAL_VALIDATION_STRATEGY = 8;
    private IPresenterValueChangedListener m_presenterListener;
    private UrlPatternPresenter m_urlPatternPresenter;
    private P_ScoutSeverityListener m_severityListener;
    private IPageLoadedListener m_pageLoadedListener;
    private AnnotationPropertyTypePresenter m_sessionFactoryPresenter;
    private AnnotationPropertyTypePresenter m_authenticationHandlerPresenter;
    private AnnotationPropertyTypePresenter m_credentialValidationStrategyPresenter;
    private IScoutBundle m_bundle;

    protected void init() {
        this.m_bundle = this.getPage().getScoutBundle();
        this.m_presenterListener = new P_PresenterListener();
        this.m_severityListener = new P_ScoutSeverityListener();
        this.m_pageLoadedListener = new P_PageLoadedListener();
        ScoutSeverityManager.getInstance().addQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.getPage().addPageLoadedListener(this.m_pageLoadedListener);
    }

    protected void cleanup() {
        ScoutSeverityManager.getInstance().removeQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.getPage().removePageLoadedListener(this.m_pageLoadedListener);
    }

    public WebServiceProviderCodeFirstNodePage getPage() {
        return (WebServiceProviderCodeFirstNodePage)super.getPage();
    }

    protected void createSections() {
        this.getForm().setRedraw(true);
        try {
            this.createSection(SECTION_ID_REPAIR, Texts.get("RepairRequired"), Texts.get("SectionRepairDescription"), false);
            this.getSection(SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(this.getPage().getMarkerGroupUUID()));
            RepairAction a = new RepairAction();
            ActionPresenter presenter = new ActionPresenter(this.getSection(SECTION_ID_REPAIR).getSectionClient(), a, this.getFormToolkit(), this.getPage());
            this.applyLayoutData(presenter);
            this.createSection(SECTION_ID_LINKS, Texts.get("ConsiderLinks"));
            this.createQuickLinkPresenters();
            this.createSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION, Texts.get("AuthenticationAndSessionContext"), null, true);
            this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).setExpanded(false);
            this.m_authenticationHandlerPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).getSectionClient(), this.getFormToolkit());
            this.m_authenticationHandlerPresenter.setPresenterId(4);
            this.m_authenticationHandlerPresenter.setLabel(Texts.get("Authentication"));
            this.m_authenticationHandlerPresenter.setAcceptNullValue(true);
            this.m_authenticationHandlerPresenter.setBundle(this.m_bundle);
            this.m_authenticationHandlerPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
            this.m_authenticationHandlerPresenter.setProperty("authenticationHandler");
            this.m_authenticationHandlerPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
            this.m_authenticationHandlerPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_authenticationHandlerPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler")));
            this.m_authenticationHandlerPresenter.setAllowChangeOfInterfaceType(true);
            this.m_authenticationHandlerPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler")});
            this.m_authenticationHandlerPresenter.addValueChangedListener(this.m_presenterListener);
            this.m_authenticationHandlerPresenter.getContainer().setLayoutData((Object)new GridData());
            this.applyLayoutData(this.m_authenticationHandlerPresenter);
            this.m_credentialValidationStrategyPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).getSectionClient(), this.getFormToolkit());
            this.m_credentialValidationStrategyPresenter.setPresenterId(8);
            this.m_credentialValidationStrategyPresenter.setLabel(Texts.get("CredentialValidation"));
            this.m_credentialValidationStrategyPresenter.setAcceptNullValue(true);
            this.m_credentialValidationStrategyPresenter.setBundle(this.m_bundle);
            this.m_credentialValidationStrategyPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
            this.m_credentialValidationStrategyPresenter.setProperty("credentialValidationStrategy");
            this.m_credentialValidationStrategyPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
            this.m_credentialValidationStrategyPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_credentialValidationStrategyPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy")));
            this.m_credentialValidationStrategyPresenter.setAllowChangeOfInterfaceType(true);
            this.m_credentialValidationStrategyPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy")});
            this.m_credentialValidationStrategyPresenter.addValueChangedListener(this.m_presenterListener);
            this.m_credentialValidationStrategyPresenter.getContainer().setLayoutData((Object)new GridData());
            this.applyLayoutData(this.m_credentialValidationStrategyPresenter);
            this.m_sessionFactoryPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).getSectionClient(), this.getFormToolkit());
            this.m_sessionFactoryPresenter.setPresenterId(2);
            this.m_sessionFactoryPresenter.setLabel(Texts.get("Session"));
            this.m_sessionFactoryPresenter.setAcceptNullValue(true);
            this.m_sessionFactoryPresenter.setBundle(this.m_bundle);
            this.m_sessionFactoryPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
            this.m_sessionFactoryPresenter.setProperty("sessionFactory");
            this.m_sessionFactoryPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
            this.m_sessionFactoryPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_sessionFactoryPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")));
            this.m_sessionFactoryPresenter.setAllowChangeOfInterfaceType(true);
            this.m_sessionFactoryPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")});
            this.m_sessionFactoryPresenter.addValueChangedListener(this.m_presenterListener);
            this.m_sessionFactoryPresenter.getContainer().setLayoutData((Object)new GridData());
            this.applyLayoutData(this.m_sessionFactoryPresenter);
            this.createSection(SECTION_ID_PROPERTIES, Texts.get("WebserviceProperties"));
            this.getSection(SECTION_ID_PROPERTIES).setExpanded(true);
            this.m_urlPatternPresenter = new UrlPatternPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_urlPatternPresenter.setLabel(Texts.get("UrlPattern"));
            this.m_urlPatternPresenter.setBundle(this.m_bundle);
            this.m_urlPatternPresenter.setMarkerType(JaxWsConstants.MarkerType.UrlPattern);
            this.m_urlPatternPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_urlPatternPresenter);
            this.updatePresenterValues();
        }
        finally {
            this.getForm().setRedraw(true);
        }
    }

    private void updatePresenterValues() {
        this.createQuickLinkPresenters();
        SunJaxWsBean sunJaxWsBean = this.getPage().getSunJaxWsBean();
        String urlPattern = null;
        if (sunJaxWsBean != null) {
            urlPattern = sunJaxWsBean.getUrlPattern();
        }
        this.m_urlPatternPresenter.setInput(urlPattern);
        this.m_urlPatternPresenter.setSunJaxWsBean(sunJaxWsBean);
        String servletRegistrationBundleName = ServletRegistrationUtility.getBuildJaxServletRegistrationBundleName(this.m_bundle);
        if (servletRegistrationBundleName != null) {
            this.m_urlPatternPresenter.setTooltip(Texts.get("JaxWsServletRegistrationInBundleX", servletRegistrationBundleName));
        } else {
            this.m_urlPatternPresenter.setTooltip(null);
        }
        IType portType = this.getPage().getPortType();
        if (portType != null) {
            IAnnotation scoutWebServiceAnnotation = JaxWsSdkUtility.getAnnotation(portType, TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getFullyQualifiedName(), false);
            this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).setVisible(TypeUtility.exists((IJavaElement)scoutWebServiceAnnotation));
            if (TypeUtility.exists((IJavaElement)scoutWebServiceAnnotation)) {
                AnnotationProperty propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue(portType, scoutWebServiceAnnotation, "sessionFactory");
                this.m_sessionFactoryPresenter.setInput(propertyValue.getFullyQualifiedName());
                this.m_sessionFactoryPresenter.setDeclaringType(portType);
                this.m_sessionFactoryPresenter.setResetLinkVisible(!propertyValue.isInherited());
                this.m_sessionFactoryPresenter.setBoldLabelText(!propertyValue.isInherited());
                propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue(portType, scoutWebServiceAnnotation, "authenticationHandler");
                this.m_authenticationHandlerPresenter.setInput(propertyValue.getFullyQualifiedName());
                this.m_authenticationHandlerPresenter.setDeclaringType(portType);
                this.m_authenticationHandlerPresenter.setResetLinkVisible(!propertyValue.isInherited());
                this.m_authenticationHandlerPresenter.setBoldLabelText(!propertyValue.isInherited());
                propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue(portType, scoutWebServiceAnnotation, "credentialValidationStrategy");
                this.m_credentialValidationStrategyPresenter.setInput(propertyValue.getFullyQualifiedName());
                this.m_credentialValidationStrategyPresenter.setDeclaringType(portType);
                this.m_credentialValidationStrategyPresenter.setResetLinkVisible(!propertyValue.isInherited());
                this.m_credentialValidationStrategyPresenter.setBoldLabelText(!propertyValue.isInherited());
            }
        }
        this.getSection(SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(this.getPage().getMarkerGroupUUID()));
    }

    private void createQuickLinkPresenters() {
        this.getForm().setRedraw(false);
        try {
            JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS).getSectionClient());
            this.createQuickLinkForTypesPresenters();
            SeparatorPresenter separatorPresenter = new SeparatorPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), this.getFormToolkit());
            this.applyLayoutData(separatorPresenter);
            FileOpenAction a = new FileOpenAction();
            a.setLinkText(ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile().getName());
            a.setToolTip(Texts.get("JaxWsDeploymentDescriptor"));
            a.setImage(JaxWsSdk.getImageDescriptor("sunJaxWs.png"));
            ActionPresenter actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit(), ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile());
            this.applyLayoutData(actionPresenter);
        }
        catch (Throwable throwable) {
            this.getForm().setRedraw(true);
            this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
            throw throwable;
        }
        this.getForm().setRedraw(true);
        this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
        JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
    }

    private void createQuickLinkForTypesPresenters() {
        SunJaxWsBean sunJaxWsBean = this.getPage().getSunJaxWsBean();
        if (sunJaxWsBean == null || sunJaxWsBean.getImplementation() == null) {
            return;
        }
        String fqn = sunJaxWsBean.getImplementation();
        if (!TypeUtility.existsType((String)fqn)) {
            return;
        }
        IType wsProviderImplType = TypeUtility.getType((String)fqn);
        TypeOpenAction a = new TypeOpenAction();
        a.setLinkText(wsProviderImplType.getElementName());
        ActionPresenter actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit(), wsProviderImplType);
        this.applyLayoutData(actionPresenter);
        this.createQuickLinkForPortTypeInterfaceType();
    }

    private void createQuickLinkForPortTypeInterfaceType() {
        IType portType = this.getPage().getPortType();
        if (!TypeUtility.exists((IJavaElement)portType)) {
            return;
        }
        IAnnotation annotation = JaxWsSdkUtility.getAnnotation(portType, WebService.class.getName(), false);
        if (annotation == null) {
            return;
        }
        AnnotationProperty property = JaxWsSdkUtility.parseAnnotationTypeValue(portType, annotation, "endpointInterface");
        IType portTypeInterfaceType = TypeUtility.getType((String)property.getFullyQualifiedName());
        if (portTypeInterfaceType == null) {
            return;
        }
        TypeOpenAction action = new TypeOpenAction();
        action.setLinkText(portTypeInterfaceType.getElementName());
        action.setToolTip(Texts.get("JaxWsPortTypeInterface"));
        ActionPresenter presenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), action, this.getFormToolkit(), portTypeInterfaceType);
        this.applyLayoutData(presenter);
    }

    private void applyLayoutData(AbstractPresenter presenter) {
        GridData layoutData = new GridData(768);
        presenter.getContainer().setLayoutData((Object)layoutData);
    }

    private TypePresenter.ISearchJavaSearchScopeFactory createSubClassesSearchScopeFactory(final IType superType) {
        return new TypePresenter.ISearchJavaSearchScopeFactory(){

            @Override
            public IJavaSearchScope create() {
                IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(WebServiceProviderCodeFirstNodePagePropertyViewPart.this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
                return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
            }
        };
    }

    private class P_PageLoadedListener
    implements IPageLoadedListener {
        private P_PageLoadedListener() {
        }

        @Override
        public void pageLoaded() {
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    WebServiceProviderCodeFirstNodePagePropertyViewPart.this.updatePresenterValues();
                }
            });
        }
    }

    private final class P_PresenterListener
    implements IPresenterValueChangedListener {
        private P_PresenterListener() {
        }

        @Override
        public void propertyChanged(int presenterId, Object value) {
            switch (presenterId) {
                case 2: 
                case 4: 
                case 8: {
                    IType portType = WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getPage().getPortType();
                    if (!TypeUtility.exists((IJavaElement)portType)) break;
                    String factoryFullyQualifiedName = (String)value;
                    if (!TypeUtility.existsType((String)factoryFullyQualifiedName)) {
                        return;
                    }
                    IType factoryType = TypeUtility.getType((String)factoryFullyQualifiedName);
                    AnnotationUpdateOperation op = new AnnotationUpdateOperation();
                    op.setDeclaringType(portType);
                    op.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
                    switch (presenterId) {
                        case 2: {
                            op.addTypeProperty("sessionFactory", factoryType);
                            break;
                        }
                        case 4: {
                            op.addTypeProperty("authenticationHandler", factoryType);
                            break;
                        }
                        case 8: {
                            op.addTypeProperty("credentialValidationStrategy", factoryType);
                        }
                    }
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        }
    }

    private class P_ScoutSeverityListener
    implements IScoutSeverityListener {
        private P_ScoutSeverityListener() {
        }

        public void severityChanged(IResource resource) {
            boolean accept = false;
            if (resource == ResourceFactory.getSunJaxWsResource(WebServiceProviderCodeFirstNodePagePropertyViewPart.this.m_bundle).getFile()) {
                accept = true;
            }
            if (!accept && WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getPage().getPortType() != null && resource == WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getPage().getPortType().getResource()) {
                accept = true;
            }
            if (!accept) {
                return;
            }
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getSection(WebServiceProviderCodeFirstNodePagePropertyViewPart.SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(WebServiceProviderCodeFirstNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID()));
                    WebServiceProviderCodeFirstNodePagePropertyViewPart.this.m_urlPatternPresenter.updateInfo();
                    WebServiceProviderCodeFirstNodePagePropertyViewPart.this.m_sessionFactoryPresenter.updateInfo();
                    WebServiceProviderCodeFirstNodePagePropertyViewPart.this.m_authenticationHandlerPresenter.updateInfo();
                    WebServiceProviderCodeFirstNodePagePropertyViewPart.this.m_credentialValidationStrategyPresenter.updateInfo();
                }
            });
        }
    }
}

