/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.part;

import java.util.LinkedList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.IScoutSeverityListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.BindingFileNewAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.BuildPropertiesEditAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.FileOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.RepairAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.StubRebuildAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.TypeOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.ActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AnnotationPropertyTypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.BindingFilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.FilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.FolderPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.SeparatorPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.StringPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.TypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.UrlPatternPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.WsdlFilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.WsdlFolderPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.ISchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.ServletRegistrationUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPresenterValueChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WebServiceProviderNodePagePropertyViewPart
extends AbstractSinglePageSectionBasedViewPart {
    public static final String SECTION_ID_REPAIR = "section.jaxws.repair";
    public static final String SECTION_ID_PROPERTIES = "section.jaxws.properties";
    public static final String SECTION_ID_STUB_PROPERTIES = "section.jaxws.build";
    public static final String SECTION_ID_LINKS = "section.jaxws.links";
    public static final String SECTION_ID_LINKS_REF_WSDLS = "section.jaxws.links.ref.wsdl";
    public static final String SECTION_ID_LINKS_INCLUDED_SCHEMAS = "section.jaxws.links.included.schema";
    public static final String SECTION_ID_LINKS_IMPORTED_SCHEMAS = "section.jaxws.links.imported.schema";
    public static final String SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION = "section.scoutWebServiceAnnotation";
    public static final int PRESENTER_ID_SESSION_FACTORY = 2;
    public static final int PRESENTER_ID_AUTHENTICATION_HANDLER = 4;
    public static final int PRESENTER_ID_CREDENTIAL_VALIDATION_STRATEGY = 8;
    private IPresenterValueChangedListener m_presenterListener;
    private StringPresenter m_targetNamespacePresenter;
    private StringPresenter m_servicePresenter;
    private StringPresenter m_portPresenter;
    private StringPresenter m_bindingPresenter;
    private StringPresenter m_portTypePresenter;
    private UrlPatternPresenter m_urlPatternPresenter;
    private FolderPresenter m_stubFolderPresenter;
    private FilePresenter m_stubJarFilePresenter;
    private WsdlFolderPresenter m_wsdlFolderPresenter;
    private WsdlFilePresenter m_wsdlFilePresenter;
    private Composite m_bindingFilesComposite;
    private P_ScoutSeverityListener m_severityListener;
    private IPageLoadedListener m_pageLoadedListener;
    private AnnotationPropertyTypePresenter m_sessionFactoryPresenter;
    private AnnotationPropertyTypePresenter m_authenticationHandlerPresenter;
    private AnnotationPropertyTypePresenter m_credentialValidationStrategyPresenter;
    private List<BindingFilePresenter> m_bindingFilePresenters;
    private ActionPresenter m_rebuildStubPresenter;
    private IScoutBundle m_bundle;

    protected void init() {
        this.m_bundle = this.getPage().getScoutBundle();
        this.m_presenterListener = new P_PresenterListener();
        this.m_severityListener = new P_ScoutSeverityListener();
        this.m_pageLoadedListener = new P_PageLoadedListener();
        ScoutSeverityManager.getInstance().addQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.getPage().addPageLoadedListener(this.m_pageLoadedListener);
        this.m_bindingFilePresenters = new LinkedList<BindingFilePresenter>();
    }

    protected void cleanup() {
        ScoutSeverityManager.getInstance().removeQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.getPage().removePageLoadedListener(this.m_pageLoadedListener);
    }

    public WebServiceProviderNodePage getPage() {
        return (WebServiceProviderNodePage)super.getPage();
    }

    protected void createSections() {
        this.getForm().setRedraw(true);
        try {
            this.createSection(SECTION_ID_REPAIR, Texts.get("RepairRequired"), Texts.get("SectionRepairDescription"), false);
            this.getSection(SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(this.getPage().getMarkerGroupUUID()));
            RepairAction a = new RepairAction();
            ActionPresenter presenter = new ActionPresenter(this.getSection(SECTION_ID_REPAIR).getSectionClient(), a, this.getFormToolkit(), this.getPage());
            this.applyLayoutData(presenter);
            this.createSection(SECTION_ID_LINKS, Texts.get("ConsiderLinks"));
            this.createQuickLinkPresenters();
            this.createSection(SECTION_ID_LINKS_REF_WSDLS, Texts.get("ReferencedWsdlDefintions"));
            this.getSection(SECTION_ID_LINKS_REF_WSDLS).setExpanded(false);
            this.createSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS, Texts.get("ImportedXsdSchemas"));
            this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setExpanded(false);
            this.createSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS, Texts.get("IncludedXsdSchemas"));
            this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setExpanded(false);
            this.createQuickLinkPresentersForReferencedFiles();
            if (this.getPage().getBuildJaxWsBean() == null) {
                return;
            }
            this.createSection(SECTION_ID_STUB_PROPERTIES, Texts.get("StubProperties"));
            StubRebuildAction b = new StubRebuildAction();
            this.m_rebuildStubPresenter = new ActionPresenter(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), b, this.getFormToolkit(), this.getPage());
            this.applyLayoutData(this.m_rebuildStubPresenter);
            BuildPropertiesEditAction c = new BuildPropertiesEditAction();
            presenter = new ActionPresenter(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), c, this.getFormToolkit(), this.getPage());
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            presenter.getContainer().setLayoutData((Object)gd);
            BindingFileNewAction d = new BindingFileNewAction();
            presenter = new ActionPresenter(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), d, this.getFormToolkit(), this.getPage());
            presenter.setEnabled(this.getPage().getBuildJaxWsBean() != null && TypeUtility.exists((IJavaElement)this.getPage().getPortType()) && !this.getPage().getPortType().isReadOnly());
            gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            presenter.getContainer().setLayoutData((Object)gd);
            this.m_bindingFilesComposite = new Composite(this.getSection(SECTION_ID_STUB_PROPERTIES).getSectionClient(), 0);
            gd = new GridData(768);
            gd.verticalIndent = 5;
            this.m_bindingFilesComposite.setLayoutData((Object)gd);
            this.createSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION, Texts.get("AuthenticationAndSessionContext"), null, true);
            this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).setExpanded(false);
            this.m_authenticationHandlerPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).getSectionClient(), this.getFormToolkit());
            this.m_authenticationHandlerPresenter.setPresenterId(4);
            this.m_authenticationHandlerPresenter.setLabel(Texts.get("Authentication"));
            this.m_authenticationHandlerPresenter.setAcceptNullValue(true);
            this.m_authenticationHandlerPresenter.setBundle(this.m_bundle);
            this.m_authenticationHandlerPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
            this.m_authenticationHandlerPresenter.setProperty("authenticationHandler");
            this.m_authenticationHandlerPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
            this.m_authenticationHandlerPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_authenticationHandlerPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler")));
            this.m_authenticationHandlerPresenter.setAllowChangeOfInterfaceType(true);
            this.m_authenticationHandlerPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler")});
            this.m_authenticationHandlerPresenter.addValueChangedListener(this.m_presenterListener);
            this.m_authenticationHandlerPresenter.getContainer().setLayoutData((Object)new GridData());
            this.applyLayoutData(this.m_authenticationHandlerPresenter);
            this.m_credentialValidationStrategyPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).getSectionClient(), this.getFormToolkit());
            this.m_credentialValidationStrategyPresenter.setPresenterId(8);
            this.m_credentialValidationStrategyPresenter.setLabel(Texts.get("CredentialValidation"));
            this.m_credentialValidationStrategyPresenter.setAcceptNullValue(true);
            this.m_credentialValidationStrategyPresenter.setBundle(this.m_bundle);
            this.m_credentialValidationStrategyPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
            this.m_credentialValidationStrategyPresenter.setProperty("credentialValidationStrategy");
            this.m_credentialValidationStrategyPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
            this.m_credentialValidationStrategyPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_credentialValidationStrategyPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy")));
            this.m_credentialValidationStrategyPresenter.setAllowChangeOfInterfaceType(true);
            this.m_credentialValidationStrategyPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy")});
            this.m_credentialValidationStrategyPresenter.addValueChangedListener(this.m_presenterListener);
            this.m_credentialValidationStrategyPresenter.getContainer().setLayoutData((Object)new GridData());
            this.applyLayoutData(this.m_credentialValidationStrategyPresenter);
            this.m_sessionFactoryPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).getSectionClient(), this.getFormToolkit());
            this.m_sessionFactoryPresenter.setPresenterId(2);
            this.m_sessionFactoryPresenter.setLabel(Texts.get("Session"));
            this.m_sessionFactoryPresenter.setAcceptNullValue(true);
            this.m_sessionFactoryPresenter.setBundle(this.m_bundle);
            this.m_sessionFactoryPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
            this.m_sessionFactoryPresenter.setProperty("sessionFactory");
            this.m_sessionFactoryPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
            this.m_sessionFactoryPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_sessionFactoryPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")));
            this.m_sessionFactoryPresenter.setAllowChangeOfInterfaceType(true);
            this.m_sessionFactoryPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")});
            this.m_sessionFactoryPresenter.addValueChangedListener(this.m_presenterListener);
            this.m_sessionFactoryPresenter.getContainer().setLayoutData((Object)new GridData());
            this.applyLayoutData(this.m_sessionFactoryPresenter);
            this.createSection(SECTION_ID_PROPERTIES, Texts.get("WebserviceProperties"));
            this.getSection(SECTION_ID_PROPERTIES).setExpanded(true);
            this.m_servicePresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_servicePresenter.setLabel(Texts.get("Service"));
            this.m_servicePresenter.setBundle(this.m_bundle);
            this.m_servicePresenter.setMarkerType(JaxWsConstants.MarkerType.Service);
            this.m_servicePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_servicePresenter.setEditable(false);
            this.applyLayoutData(this.m_servicePresenter);
            this.m_portPresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_portPresenter.setLabel(Texts.get("Port"));
            this.m_portPresenter.setBundle(this.m_bundle);
            this.m_portPresenter.setMarkerType(JaxWsConstants.MarkerType.Port);
            this.m_portPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_portPresenter.setEditable(false);
            this.applyLayoutData(this.m_portPresenter);
            this.m_portTypePresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_portTypePresenter.setLabel(Texts.get("PortType"));
            this.m_portTypePresenter.setBundle(this.m_bundle);
            this.m_portTypePresenter.setMarkerType(JaxWsConstants.MarkerType.PortType);
            this.m_portTypePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_portTypePresenter.setEditable(false);
            this.applyLayoutData(this.m_portTypePresenter);
            this.m_bindingPresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_bindingPresenter.setLabel(Texts.get("Binding"));
            this.m_bindingPresenter.setEditable(false);
            this.applyLayoutData(this.m_bindingPresenter);
            this.m_urlPatternPresenter = new UrlPatternPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_urlPatternPresenter.setLabel(Texts.get("UrlPattern"));
            this.m_urlPatternPresenter.setBundle(this.m_bundle);
            this.m_urlPatternPresenter.setMarkerType(JaxWsConstants.MarkerType.UrlPattern);
            this.m_urlPatternPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_urlPatternPresenter);
            this.m_targetNamespacePresenter = new StringPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_targetNamespacePresenter.setLabel(Texts.get("TargetNamespace"));
            this.m_targetNamespacePresenter.setBundle(this.m_bundle);
            this.m_targetNamespacePresenter.setMarkerType(JaxWsConstants.MarkerType.TargetNamespace);
            this.m_targetNamespacePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.m_targetNamespacePresenter.setEditable(false);
            this.applyLayoutData(this.m_targetNamespacePresenter);
            this.m_stubFolderPresenter = new FolderPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_stubFolderPresenter.setShowBrowseButton(false);
            this.m_stubFolderPresenter.setLabel(Texts.get("StubFolder"));
            this.m_stubFolderPresenter.setBundle(this.m_bundle);
            this.m_stubFolderPresenter.setMarkerType(JaxWsConstants.MarkerType.StubFolder);
            this.m_stubFolderPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_stubFolderPresenter);
            this.m_stubJarFilePresenter = new FilePresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_stubJarFilePresenter.setShowBrowseButton(false);
            this.m_stubJarFilePresenter.setLabel(Texts.get("StubJar"));
            this.m_stubJarFilePresenter.setBundle(this.m_bundle);
            this.m_stubJarFilePresenter.setMarkerType(JaxWsConstants.MarkerType.StubJar);
            this.m_stubJarFilePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_stubJarFilePresenter);
            this.m_wsdlFolderPresenter = new WsdlFolderPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit(), WebserviceEnum.PROVIDER);
            this.m_wsdlFolderPresenter.setLabel(Texts.get("WsdlFolder"));
            this.m_wsdlFolderPresenter.setBundle(this.m_bundle);
            this.m_wsdlFolderPresenter.setMarkerType(JaxWsConstants.MarkerType.WsdlFolder);
            this.m_wsdlFolderPresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_wsdlFolderPresenter);
            this.m_wsdlFilePresenter = new WsdlFilePresenter(this.m_bundle, this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_wsdlFilePresenter.setLabel(Texts.get("WsdlFile"));
            this.m_wsdlFilePresenter.setBundle(this.m_bundle);
            this.m_wsdlFilePresenter.setMarkerType(JaxWsConstants.MarkerType.Wsdl);
            this.m_wsdlFilePresenter.setMarkerGroupUUID(this.getPage().getMarkerGroupUUID());
            this.applyLayoutData(this.m_wsdlFilePresenter);
            this.updatePresenterValues();
        }
        finally {
            this.getForm().setRedraw(true);
        }
    }

    private void updatePresenterValues() {
        PortType portType;
        this.createQuickLinkPresenters();
        this.createQuickLinkPresentersForReferencedFiles();
        SunJaxWsBean sunJaxWsBean = this.getPage().getSunJaxWsBean();
        BuildJaxWsBean buildJaxWsBean = this.getPage().getBuildJaxWsBean();
        Definition wsdlDefinition = this.getPage().getWsdlDefinition();
        String serviceName = null;
        String serviceTooltip = null;
        String portName = null;
        String portTooltip = null;
        String bindingName = null;
        String bindingTooltip = null;
        String portTypeName = null;
        String portTypeTooltip = null;
        String urlPattern = null;
        IFile stubJarFile = null;
        if (sunJaxWsBean != null) {
            QName portTypeQName;
            urlPattern = sunJaxWsBean.getUrlPattern();
            QName serviceQName = sunJaxWsBean.getServiceQNameSafe();
            if (serviceQName != null) {
                serviceName = serviceQName.getLocalPart();
                serviceTooltip = serviceQName.toString();
            }
            if ((portTypeQName = sunJaxWsBean.getPortQNameSafe()) != null) {
                portName = portTypeQName.getLocalPart();
                portTooltip = portTypeQName.toString();
            }
            if (wsdlDefinition != null) {
                Binding binding;
                portType = JaxWsSdkUtility.getPortType(wsdlDefinition, sunJaxWsBean.getServiceQNameSafe(), sunJaxWsBean.getPort());
                if (portType != null) {
                    portTypeName = portType.getQName().getLocalPart();
                    portTypeTooltip = portType.getQName().toString();
                }
                if ((binding = JaxWsSdkUtility.getBinding(wsdlDefinition, sunJaxWsBean.getServiceQNameSafe(), sunJaxWsBean.getPort())) != null) {
                    bindingName = binding.getQName().getLocalPart();
                    bindingTooltip = binding.getQName().toString();
                }
            }
        }
        if (buildJaxWsBean != null) {
            String wsdlFileName = null;
            if (sunJaxWsBean != null) {
                wsdlFileName = sunJaxWsBean.getWsdl();
            }
            stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, buildJaxWsBean, wsdlFileName);
        }
        this.m_targetNamespacePresenter.setInput(wsdlDefinition != null ? wsdlDefinition.getTargetNamespace() : null);
        this.m_targetNamespacePresenter.setTooltip((String)this.m_targetNamespacePresenter.getValue());
        this.m_servicePresenter.setInput(serviceName);
        this.m_servicePresenter.setTooltip(serviceTooltip);
        this.m_portPresenter.setInput(portName);
        this.m_portPresenter.setTooltip(portTooltip);
        this.m_bindingPresenter.setInput(bindingName);
        this.m_bindingPresenter.setTooltip(bindingTooltip);
        this.m_portTypePresenter.setInput(portTypeName);
        this.m_portTypePresenter.setTooltip(portTypeTooltip);
        this.m_urlPatternPresenter.setInput(urlPattern);
        this.m_urlPatternPresenter.setSunJaxWsBean(sunJaxWsBean);
        String servletRegistrationBundleName = ServletRegistrationUtility.getBuildJaxServletRegistrationBundleName(this.m_bundle);
        if (servletRegistrationBundleName != null) {
            this.m_urlPatternPresenter.setTooltip(Texts.get("JaxWsServletRegistrationInBundleX", servletRegistrationBundleName));
        } else {
            this.m_urlPatternPresenter.setTooltip(null);
        }
        IFile wsdlFile = this.getPage().getWsdlResource().getFile();
        if (wsdlFile != null) {
            IPath wsdlFolderPath = wsdlFile.getProjectRelativePath().removeLastSegments(1);
            IFolder folder = JaxWsSdkUtility.getFolder(this.m_bundle, wsdlFolderPath, false);
            if (folder == null) {
                folder = JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false);
            }
            this.m_wsdlFolderPresenter.setInput(folder);
            this.m_wsdlFilePresenter.setFileDirectory(folder);
        }
        this.m_wsdlFolderPresenter.setBuildJaxWsBean(buildJaxWsBean);
        this.m_wsdlFolderPresenter.setSunJaxWsBean(sunJaxWsBean);
        this.m_wsdlFilePresenter.setInput(wsdlFile);
        this.m_wsdlFilePresenter.setBuildJaxWsBean(buildJaxWsBean);
        this.m_wsdlFilePresenter.setSunJaxWsBean(sunJaxWsBean);
        this.m_stubJarFilePresenter.setInput(stubJarFile);
        this.m_stubFolderPresenter.setInput(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.STUB_FOLDER, false));
        portType = this.getPage().getPortType();
        if (portType != null) {
            IAnnotation scoutWebServiceAnnotation = JaxWsSdkUtility.getAnnotation((IType)portType, TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getFullyQualifiedName(), false);
            this.getSection(SECTION_ID_SCOUT_WEB_SERVICE_ANNOTATION).setVisible(TypeUtility.exists((IJavaElement)scoutWebServiceAnnotation));
            if (TypeUtility.exists((IJavaElement)scoutWebServiceAnnotation)) {
                AnnotationProperty propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue((IType)portType, scoutWebServiceAnnotation, "sessionFactory");
                this.m_sessionFactoryPresenter.setInput(propertyValue.getFullyQualifiedName());
                this.m_sessionFactoryPresenter.setDeclaringType((IType)portType);
                this.m_sessionFactoryPresenter.setResetLinkVisible(!propertyValue.isInherited());
                this.m_sessionFactoryPresenter.setBoldLabelText(!propertyValue.isInherited());
                propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue((IType)portType, scoutWebServiceAnnotation, "authenticationHandler");
                this.m_authenticationHandlerPresenter.setInput(propertyValue.getFullyQualifiedName());
                this.m_authenticationHandlerPresenter.setDeclaringType((IType)portType);
                this.m_authenticationHandlerPresenter.setResetLinkVisible(!propertyValue.isInherited());
                this.m_authenticationHandlerPresenter.setBoldLabelText(!propertyValue.isInherited());
                propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue((IType)portType, scoutWebServiceAnnotation, "credentialValidationStrategy");
                this.m_credentialValidationStrategyPresenter.setInput(propertyValue.getFullyQualifiedName());
                this.m_credentialValidationStrategyPresenter.setDeclaringType((IType)portType);
                this.m_credentialValidationStrategyPresenter.setResetLinkVisible(!propertyValue.isInherited());
                this.m_credentialValidationStrategyPresenter.setBoldLabelText(!propertyValue.isInherited());
            }
        }
        this.createBindingFilePresenters(buildJaxWsBean);
        this.validateRebuildStubPresenter();
        this.getSection(SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(this.getPage().getMarkerGroupUUID()));
        this.controlView();
    }

    private void createQuickLinkPresenters() {
        ActionPresenter actionPresenter;
        block4: {
            this.getForm().setRedraw(false);
            try {
                JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS).getSectionClient());
                this.createQuickLinkForTypesPresenters();
                SeparatorPresenter separatorPresenter = new SeparatorPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), this.getFormToolkit());
                this.applyLayoutData(separatorPresenter);
                FileOpenAction a = new FileOpenAction();
                a.setLinkText(ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile().getName());
                a.setImage(JaxWsSdk.getImageDescriptor("sunJaxWs.png"));
                a.setToolTip(Texts.get("JaxWsDeploymentDescriptor"));
                actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit(), ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile());
                this.applyLayoutData(actionPresenter);
                FileOpenAction b = new FileOpenAction();
                a.setLinkText(ResourceFactory.getBuildJaxWsResource(this.m_bundle).getFile().getName());
                a.setImage(JaxWsSdk.getImageDescriptor("build-jaxws.png"));
                actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), b, this.getFormToolkit(), ResourceFactory.getBuildJaxWsResource(this.m_bundle).getFile());
                b.setToolTip(Texts.get("JaxWsBuildDescriptor"));
                this.applyLayoutData(actionPresenter);
                if (this.getPage().getBuildJaxWsBean() != null) break block4;
            }
            catch (Throwable throwable) {
                this.getForm().setRedraw(true);
                this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
                throw throwable;
            }
            this.getForm().setRedraw(true);
            this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
            return;
        }
        IFile wsdlFile = this.getPage().getWsdlResource().getFile();
        if (wsdlFile != null) {
            FileOpenAction c = new FileOpenAction();
            c.setLinkText(wsdlFile.getName());
            c.setImage(JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"));
            c.setToolTip("Web Services Description Language");
            actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), c, this.getFormToolkit(), wsdlFile);
            actionPresenter.setEnabled(wsdlFile.exists());
            this.applyLayoutData(actionPresenter);
        }
        this.getForm().setRedraw(true);
        this.getSection(SECTION_ID_LINKS).setVisible(this.getSection(SECTION_ID_LINKS).getSectionClient().getChildren().length > 0);
        JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS));
    }

    private void createQuickLinkPresentersForReferencedFiles() {
        block5: {
            this.getForm().setRedraw(false);
            try {
                try {
                    JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient());
                    JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient());
                    JaxWsSdkUtility.disposeChildControls(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient());
                    WsdlResource wsdlResource = this.getPage().getWsdlResource();
                    SchemaUtility.visitArtifacts(wsdlResource.getFile(), (ISchemaArtifactVisitor<IFile>)new SchemaArtifactVisitor<IFile>(){

                        @Override
                        public void onReferencedWsdlArtifact(SchemaUtility.WsdlArtifact<IFile> wsdlArtifact) {
                            IFileHandle fileHandle = wsdlArtifact.getFileHandle();
                            FileOpenAction action = new FileOpenAction();
                            action.setLinkText(fileHandle.getName());
                            action.setImage(JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"));
                            ActionPresenter actionPresenter = new ActionPresenter(WebServiceProviderNodePagePropertyViewPart.this.getSection(WebServiceProviderNodePagePropertyViewPart.SECTION_ID_LINKS_REF_WSDLS).getSectionClient(), action, WebServiceProviderNodePagePropertyViewPart.this.getFormToolkit(), fileHandle.getFile());
                            actionPresenter.setEnabled(fileHandle.exists());
                            WebServiceProviderNodePagePropertyViewPart.this.applyLayoutData(actionPresenter);
                        }

                        @Override
                        public void onSchemaIncludeArtifact(SchemaUtility.SchemaIncludeArtifact<IFile> schemaIncludeArtifact) {
                            IFileHandle fileHandle = schemaIncludeArtifact.getFileHandle();
                            FileOpenAction b = new FileOpenAction();
                            b.setLinkText(fileHandle.getName());
                            b.setImage(JaxWsSdk.getImageDescriptor("xsdFile.gif"));
                            ActionPresenter actionPresenter = new ActionPresenter(WebServiceProviderNodePagePropertyViewPart.this.getSection(WebServiceProviderNodePagePropertyViewPart.SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient(), b, WebServiceProviderNodePagePropertyViewPart.this.getFormToolkit(), fileHandle.getFile());
                            actionPresenter.setEnabled(fileHandle.exists());
                            WebServiceProviderNodePagePropertyViewPart.this.applyLayoutData(actionPresenter);
                        }

                        @Override
                        public void onSchemaImportArtifact(SchemaUtility.SchemaImportArtifact<IFile> schemaImportArtifact) {
                            IFileHandle fileHandle = schemaImportArtifact.getFileHandle();
                            FileOpenAction b = new FileOpenAction();
                            b.setLinkText(fileHandle.getName());
                            b.setImage(JaxWsSdk.getImageDescriptor("xsdFile.gif"));
                            b.setToolTip("namespace: " + StringUtility.nvl((Object)schemaImportArtifact.getNamespaceUri(), (String)"?"));
                            ActionPresenter actionPresenter = new ActionPresenter(WebServiceProviderNodePagePropertyViewPart.this.getSection(WebServiceProviderNodePagePropertyViewPart.SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient(), b, WebServiceProviderNodePagePropertyViewPart.this.getFormToolkit(), fileHandle.getFile());
                            actionPresenter.setEnabled(fileHandle.exists());
                            WebServiceProviderNodePagePropertyViewPart.this.applyLayoutData(actionPresenter);
                        }
                    });
                }
                catch (Exception e) {
                    JaxWsSdk.logError(e);
                    this.getForm().setRedraw(true);
                    this.getSection(SECTION_ID_LINKS_REF_WSDLS).setVisible(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient().getChildren().length > 0);
                    JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_REF_WSDLS));
                    this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient().getChildren().length > 0);
                    JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS));
                    this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient().getChildren().length > 0);
                    JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS));
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.getForm().setRedraw(true);
                this.getSection(SECTION_ID_LINKS_REF_WSDLS).setVisible(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_REF_WSDLS));
                this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS));
                this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient().getChildren().length > 0);
                JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS));
                throw throwable;
            }
            this.getForm().setRedraw(true);
            this.getSection(SECTION_ID_LINKS_REF_WSDLS).setVisible(this.getSection(SECTION_ID_LINKS_REF_WSDLS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_REF_WSDLS));
            this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_IMPORTED_SCHEMAS));
            this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).setVisible(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS).getSectionClient().getChildren().length > 0);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_LINKS_INCLUDED_SCHEMAS));
        }
    }

    private void createQuickLinkForTypesPresenters() {
        SunJaxWsBean sunJaxWsBean = this.getPage().getSunJaxWsBean();
        if (sunJaxWsBean == null || sunJaxWsBean.getImplementation() == null) {
            return;
        }
        String fqn = sunJaxWsBean.getImplementation();
        if (!TypeUtility.existsType((String)fqn)) {
            return;
        }
        IType wsProviderImplType = TypeUtility.getType((String)fqn);
        TypeOpenAction a = new TypeOpenAction();
        a.setLinkText(wsProviderImplType.getElementName());
        ActionPresenter actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit(), wsProviderImplType);
        this.applyLayoutData(actionPresenter);
        this.createQuickLinkForPortTypeInterfaceType();
    }

    private void createQuickLinkForPortTypeInterfaceType() {
        BuildJaxWsBean buildJaxWsBean = this.getPage().getBuildJaxWsBean();
        SunJaxWsBean sunJaxWsBean = this.getPage().getSunJaxWsBean();
        if (sunJaxWsBean == null) {
            return;
        }
        PortType portType = JaxWsSdkUtility.getPortType(this.getPage().getWsdlDefinition(), sunJaxWsBean.getServiceQNameSafe(), sunJaxWsBean.getPort());
        if (portType == null || portType.getQName() == null) {
            return;
        }
        IFile stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, buildJaxWsBean, sunJaxWsBean.getWsdl());
        if (stubJarFile == null) {
            return;
        }
        IType portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(portType.getQName(), stubJarFile);
        if (!TypeUtility.exists((IJavaElement)portTypeInterfaceType)) {
            return;
        }
        TypeOpenAction action = new TypeOpenAction();
        action.setLinkText(portTypeInterfaceType.getElementName());
        action.setToolTip(Texts.get("JaxWsPortTypeInterface"));
        ActionPresenter presenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), action, this.getFormToolkit(), portTypeInterfaceType);
        this.applyLayoutData(presenter);
    }

    private void createBindingFilePresenters(BuildJaxWsBean buildJaxWsBean) {
        this.getForm().setRedraw(false);
        try {
            this.m_bindingFilePresenters.clear();
            JaxWsSdkUtility.disposeChildControls(this.m_bindingFilesComposite);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 5;
            this.m_bindingFilesComposite.setLayout((Layout)layout);
            if (buildJaxWsBean == null) {
                return;
            }
            IFile[] bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, buildJaxWsBean.getPropertiers());
            int index = 0;
            while (index < bindingFiles.length) {
                BindingFilePresenter filePresenter = new BindingFilePresenter(this.m_bundle, this.m_bindingFilesComposite, this.getFormToolkit());
                filePresenter.setMarkerGroupUUID(JaxWsSdkUtility.toMarkerGroupUUID(this.getPage().getMarkerGroupUUID(), index));
                filePresenter.setInput(bindingFiles[index]);
                filePresenter.setBuildJaxWsBean(buildJaxWsBean);
                this.applyLayoutData(filePresenter);
                this.m_bindingFilePresenters.add(filePresenter);
                ++index;
            }
        }
        finally {
            this.getForm().setRedraw(true);
            JaxWsSdkUtility.doLayout(this.m_bindingFilesComposite);
            JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_STUB_PROPERTIES));
        }
    }

    private void applyLayoutData(AbstractPresenter presenter) {
        GridData layoutData = new GridData(768);
        presenter.getContainer().setLayoutData((Object)layoutData);
    }

    private TypePresenter.ISearchJavaSearchScopeFactory createSubClassesSearchScopeFactory(final IType superType) {
        return new TypePresenter.ISearchJavaSearchScopeFactory(){

            @Override
            public IJavaSearchScope create() {
                IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(WebServiceProviderNodePagePropertyViewPart.this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
                return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
            }
        };
    }

    private void validateRebuildStubPresenter() {
        boolean valid = this.getPage().getBuildJaxWsBean() != null && this.getPage().getSunJaxWsBean() != null && !MarkerUtility.containsMarker(this.m_bundle, JaxWsConstants.MarkerType.Wsdl, this.getPage().getMarkerGroupUUID(), 2);
        this.m_rebuildStubPresenter.setEnabled(valid);
        if (valid) {
            StubRebuildAction action = new StubRebuildAction();
            this.m_rebuildStubPresenter.setAction(action);
            this.m_rebuildStubPresenter.setActionParams(this.getPage());
        }
    }

    private void controlView() {
        this.m_credentialValidationStrategyPresenter.setEnabled(JaxWsSdkUtility.isProviderAuthenticationSet((String)this.m_authenticationHandlerPresenter.getValue()));
    }

    private class P_PageLoadedListener
    implements IPageLoadedListener {
        private P_PageLoadedListener() {
        }

        @Override
        public void pageLoaded() {
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceProviderNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceProviderNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    if (MarkerUtility.containsMarker(WebServiceProviderNodePagePropertyViewPart.this.m_bundle, JaxWsConstants.MarkerType.MissingBuildJaxWsEntry, WebServiceProviderNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID(), 2)) {
                        return;
                    }
                    WebServiceProviderNodePagePropertyViewPart.this.updatePresenterValues();
                }
            });
        }
    }

    private final class P_PresenterListener
    implements IPresenterValueChangedListener {
        private P_PresenterListener() {
        }

        @Override
        public void propertyChanged(int presenterId, Object value) {
            switch (presenterId) {
                case 2: 
                case 4: 
                case 8: {
                    IType portType = WebServiceProviderNodePagePropertyViewPart.this.getPage().getPortType();
                    if (!TypeUtility.exists((IJavaElement)portType)) break;
                    String factoryFullyQualifiedName = (String)value;
                    if (!TypeUtility.existsType((String)factoryFullyQualifiedName)) {
                        return;
                    }
                    IType factoryType = TypeUtility.getType((String)factoryFullyQualifiedName);
                    AnnotationUpdateOperation op = new AnnotationUpdateOperation();
                    op.setDeclaringType(portType);
                    op.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
                    switch (presenterId) {
                        case 2: {
                            op.addTypeProperty("sessionFactory", factoryType);
                            break;
                        }
                        case 4: {
                            op.addTypeProperty("authenticationHandler", factoryType);
                            if (JaxWsSdkUtility.isProviderAuthenticationSet(factoryFullyQualifiedName)) break;
                            op.removeProperty("credentialValidationStrategy");
                            break;
                        }
                        case 8: {
                            op.addTypeProperty("credentialValidationStrategy", factoryType);
                        }
                    }
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        }
    }

    private class P_ScoutSeverityListener
    implements IScoutSeverityListener {
        private P_ScoutSeverityListener() {
        }

        public void severityChanged(IResource resource) {
            boolean accept = false;
            if (resource == ResourceFactory.getSunJaxWsResource(WebServiceProviderNodePagePropertyViewPart.this.m_bundle).getFile()) {
                accept = true;
            }
            if (!accept && resource == ResourceFactory.getBuildJaxWsResource(WebServiceProviderNodePagePropertyViewPart.this.m_bundle).getFile()) {
                accept = true;
            }
            if (!accept && resource == WebServiceProviderNodePagePropertyViewPart.this.getPage().getWsdlResource().getFile()) {
                accept = true;
            }
            if (!accept && WebServiceProviderNodePagePropertyViewPart.this.getPage().getPortType() != null && resource == WebServiceProviderNodePagePropertyViewPart.this.getPage().getPortType().getResource()) {
                accept = true;
            }
            if (!accept) {
                XmlResource[] xmlResourceArray = WebServiceProviderNodePagePropertyViewPart.this.getPage().getBindingFileResources();
                int n = xmlResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlResource bindingFileResource = xmlResourceArray[n2];
                    if (resource == bindingFileResource.getFile()) {
                        accept = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!accept) {
                return;
            }
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceProviderNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceProviderNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    WebServiceProviderNodePagePropertyViewPart.this.getSection(WebServiceProviderNodePagePropertyViewPart.SECTION_ID_REPAIR).setVisible(JaxWsSdk.getDefault().containsMarkerCommands(WebServiceProviderNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID()));
                    if (MarkerUtility.containsMarker(WebServiceProviderNodePagePropertyViewPart.this.m_bundle, JaxWsConstants.MarkerType.MissingBuildJaxWsEntry, WebServiceProviderNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID(), 2)) {
                        return;
                    }
                    WebServiceProviderNodePagePropertyViewPart.this.m_targetNamespacePresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_servicePresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_portPresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_bindingPresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_portTypePresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_urlPatternPresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_wsdlFilePresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_wsdlFolderPresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_sessionFactoryPresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_authenticationHandlerPresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_credentialValidationStrategyPresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_stubJarFilePresenter.updateInfo();
                    WebServiceProviderNodePagePropertyViewPart.this.m_stubFolderPresenter.updateInfo();
                    for (BindingFilePresenter presenter : WebServiceProviderNodePagePropertyViewPart.this.m_bindingFilePresenters) {
                        presenter.updateInfo();
                    }
                    WebServiceProviderNodePagePropertyViewPart.this.validateRebuildStubPresenter();
                    WebServiceProviderNodePagePropertyViewPart.this.controlView();
                }
            });
        }
    }
}

