/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.JaxWsServletRegistrationOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractStringActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.JaxWsServletRegistrationWizardPage;
import org.eclipse.swt.widgets.Composite;

public class UrlPatternPresenter
extends AbstractStringActionPresenter {
    private SunJaxWsBean m_sunJaxWsBean;

    public UrlPatternPresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit);
        this.setActionLinkTooltip(Texts.get("ChangeUrlOfWsdl"));
        this.setActionLinkEnabled(false);
    }

    @Override
    protected void execAction() throws CoreException {
        P_Wizard wizard = new P_Wizard(this.m_bundle);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setPageSize(650, 410);
        wizardDialog.open();
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.setActionLinkEnabled(this.m_sunJaxWsBean != null);
    }

    private class P_Wizard
    extends AbstractWorkspaceWizard {
        private IScoutBundle m_bundle;
        private JaxWsServletRegistrationWizardPage m_wizardPage;
        private JaxWsServletRegistrationOperation m_operation;

        public P_Wizard(IScoutBundle bundle) {
            this.m_bundle = bundle;
            this.m_operation = new JaxWsServletRegistrationOperation();
            this.setWindowTitle(Texts.get("EndpointPublishConfiguration"));
        }

        public void addPages() {
            this.m_wizardPage = new JaxWsServletRegistrationWizardPage(this.m_bundle, true);
            this.m_wizardPage.setTitle(Texts.get("SpecifyUrlOfWsdl"));
            this.m_wizardPage.setUrlPattern((String)UrlPatternPresenter.this.getValue());
            this.m_wizardPage.initializeDefaultValues(this.m_bundle);
            this.addPage((IWizardPage)this.m_wizardPage);
        }

        protected boolean beforeFinish() throws CoreException {
            this.m_operation.setBundle(this.m_bundle);
            this.m_operation.setRegistrationBundle(this.m_wizardPage.getRegistrationBundle());
            this.m_operation.setJaxWsAlias(this.m_wizardPage.getAlias());
            this.m_operation.setSunJaxWsBean(UrlPatternPresenter.this.m_sunJaxWsBean);
            this.m_operation.setUrlPattern(this.m_wizardPage.getUrlPattern());
            return true;
        }

        protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
            JaxWsSdk.getDefault().getMarkerQueueManager().suspend();
            try {
                this.m_operation.run(monitor, workingCopyManager);
            }
            finally {
                JaxWsSdk.getDefault().getMarkerQueueManager().resume();
            }
            return true;
        }
    }
}

