/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ErrorDialog;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ResourceSelectionWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class PhantomJarFilesDeleteWizard
extends AbstractWorkspaceWizard {
    private ResourceSelectionWizardPage m_wizardPage;
    private final IScoutBundle m_bundle;
    private final Set<IFile> m_phantomJarFiles;
    private IFile[] m_phantomJarFilesToBeDeleted;

    public PhantomJarFilesDeleteWizard(IScoutBundle bundle, Set<IFile> phantomJarFiles) {
        this.setWindowTitle(Texts.get("CleanupPhantomStubFiles"));
        this.m_bundle = bundle;
        this.m_phantomJarFiles = CollectionUtility.hashSet(phantomJarFiles);
    }

    public void addPages() {
        this.m_wizardPage = new ResourceSelectionWizardPage(Texts.get("CleanupPhantomStubFiles"), Texts.get("QuestionDeletion"));
        this.m_wizardPage.setElements(this.getPhantomElements());
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    private List<ElementBean> getPhantomElements() {
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        for (IFile file : this.m_phantomJarFiles) {
            elements.add(new ElementBean(0, file.getFullPath().toString(), JaxWsSdk.getImageDescriptor("jar_obj.gif"), (IResource)file, false));
        }
        return elements;
    }

    protected boolean beforeFinish() throws CoreException {
        LinkedList<IFile> filesToBeDeleted = new LinkedList<IFile>();
        for (ElementBean candidate : this.m_wizardPage.getElements()) {
            if (!candidate.isChecked() && !candidate.isMandatory()) continue;
            filesToBeDeleted.add((IFile)candidate.getResource());
        }
        this.m_phantomJarFilesToBeDeleted = filesToBeDeleted.toArray(new IFile[filesToBeDeleted.size()]);
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFile[] iFileArray = this.m_phantomJarFilesToBeDeleted;
        int n = this.m_phantomJarFilesToBeDeleted.length;
        int n2 = 0;
        while (n2 < n) {
            final IFile jarFile = iFileArray[n2];
            try {
                jarFile.delete(true, true, monitor);
                JaxWsSdkUtility.registerJarLib(this.m_bundle, jarFile, true, monitor);
            }
            catch (Exception e) {
                ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog dialog = new ErrorDialog(Texts.get("FailedToDeleteFile"));
                        dialog.setError(Texts.get("FailedToDeleteFileX", jarFile.getProjectRelativePath().toString()), e);
                        dialog.open();
                    }
                });
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }
}

