/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.wsdl.Definition;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.AdditionalResourcesWizard;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ResourceSelectionWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsdlFolderViewerFilter;
import org.eclipse.scout.sdk.ws.jaxws.util.ISchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.JavaFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WsdlLocationWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_FILE_SYSTEM = "fileSystem";
    public static final String PROP_PATH = "path";
    public static final String PROP_URL = "url";
    public static final String PROP_WSDL_FILE = "wsdlFile";
    public static final String PROP_WSDL_DEFINITION = "wsdlDefinition";
    public static final String PROP_REBUILD_STUB = "rebuilStub";
    public static final String PROP_ADDITIONAL_FILES = "additionalFiles";
    public static final String PROP_WSDL_FOLDER = "wsdlFolder";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private Button m_fileSystemRadioButton;
    private Composite m_fileSystemContainer;
    private TextField m_pathField;
    private Button m_browseButton;
    private Hyperlink m_addFilesLink;
    private Button m_urlRadioButton;
    private Composite m_urlContainer;
    private TextField m_urlField;
    private Button m_rebuidStubButton;
    private boolean m_rebuildStubOptionVisible;
    private boolean m_wsdlFolderVisible;
    private Label m_wsdlFolderDescriptionField;
    private TextField m_wsdlFolderField;
    private Button m_wsdlFolderBrowseButton;
    private IFolder m_rootWsdlFolder;

    public WsdlLocationWizardPage(IScoutBundle bundle) {
        super(WsdlLocationWizardPage.class.getName());
        this.setTitle(Texts.get("SpecifyWsdlLocation"));
        this.setDescription(Texts.get("SpecifyWsdlLocation"));
        this.m_bundle = bundle;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.applyDefaults();
    }

    private void applyDefaults() {
        this.setFileSystem(true);
        this.setAdditionalFiles(new File[0]);
        if (this.isRebuildStubOptionVisible()) {
            this.setRebuildStub(true);
        }
    }

    protected void createContent(Composite parent) {
        this.m_fileSystemRadioButton = new Button(parent, 16);
        this.m_fileSystemRadioButton.setText(Texts.get("ChooseWsdlFileFromFilesystem"));
        this.m_fileSystemRadioButton.setSelection(this.isFileSystem());
        this.m_fileSystemRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WsdlLocationWizardPage.this.setStateChanging(true);
                    WsdlLocationWizardPage.this.setFileSystem(WsdlLocationWizardPage.this.m_fileSystemRadioButton.getSelection());
                }
                finally {
                    WsdlLocationWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_fileSystemContainer = new Composite(parent, 0);
        this.m_pathField = new TextField(this.m_fileSystemContainer);
        this.m_pathField.setLabelText("Path");
        this.m_pathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsdlLocationWizardPage.this.setPathInternal(WsdlLocationWizardPage.this.m_pathField.getText());
                WsdlLocationWizardPage.this.pingStateChanging();
            }
        });
        this.m_browseButton = new Button(this.m_fileSystemContainer, 0x800008);
        this.m_browseButton.setText(Texts.get("Browse"));
        this.m_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WsdlLocationWizardPage.this.getShell(), 4096);
                String[] filterNames = new String[]{"wsdl"};
                String[] filterExtensions = new String[]{"*.wsdl"};
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                String path = dialog.open();
                if (path != null) {
                    WsdlLocationWizardPage.this.setPath(path);
                    final HashSet<SchemaUtility.WsdlArtifact<File>> referencedWsdlArtifacts = new HashSet<SchemaUtility.WsdlArtifact<File>>();
                    final HashSet<SchemaUtility.SchemaIncludeArtifact<File>> schemaIncludeArtifacts = new HashSet<SchemaUtility.SchemaIncludeArtifact<File>>();
                    final HashSet<SchemaUtility.SchemaImportArtifact<File>> schemaImportArtifacts = new HashSet<SchemaUtility.SchemaImportArtifact<File>>();
                    SchemaUtility.visitArtifacts(new Path(path).toFile(), (ISchemaArtifactVisitor<File>)new SchemaArtifactVisitor<File>(){

                        @Override
                        public void onReferencedWsdlArtifact(SchemaUtility.WsdlArtifact<File> wsdlArtifact) {
                            referencedWsdlArtifacts.add(wsdlArtifact);
                        }

                        @Override
                        public void onSchemaIncludeArtifact(SchemaUtility.SchemaIncludeArtifact<File> schemaIncludeArtifact) {
                            schemaIncludeArtifacts.add(schemaIncludeArtifact);
                        }

                        @Override
                        public void onSchemaImportArtifact(SchemaUtility.SchemaImportArtifact<File> schemaImportArtifact) {
                            schemaImportArtifacts.add(schemaImportArtifact);
                        }
                    });
                    if (!(referencedWsdlArtifacts.isEmpty() && schemaIncludeArtifacts.isEmpty() && schemaImportArtifacts.isEmpty())) {
                        P_ReferencedFilesFoundWizard wizard = new P_ReferencedFilesFoundWizard(referencedWsdlArtifacts, schemaIncludeArtifacts, schemaImportArtifacts);
                        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
                        wizardDialog.setPageSize(450, 350);
                        wizardDialog.open();
                    }
                }
            }
        });
        this.m_addFilesLink = new Hyperlink(this.m_fileSystemContainer, 0);
        this.m_addFilesLink.setText(Texts.get("AddRelatedFiles"));
        this.m_addFilesLink.setForeground(ScoutSdkUi.getDisplay().getSystemColor(9));
        this.m_addFilesLink.setToolTipText(Texts.get("ClickToAddAdditionalResources"));
        this.m_addFilesLink.setUnderlined(true);
        this.m_addFilesLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                AdditionalResourcesWizard wizard = new AdditionalResourcesWizard(WsdlLocationWizardPage.this.getAdditionalFiles());
                ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
                wizardDialog.setPageSize(650, 350);
                if (wizardDialog.open() == 0) {
                    WsdlLocationWizardPage.this.setAdditionalFiles(wizard.getFiles());
                }
            }
        });
        this.m_urlRadioButton = new Button(parent, 16);
        this.m_urlRadioButton.setText(Texts.get("ChooseWsdlFromUrl"));
        this.m_urlRadioButton.setSelection(!this.isFileSystem());
        this.m_urlContainer = new Composite(parent, 0);
        this.m_urlField = new TextField(this.m_urlContainer);
        this.m_urlField.setLabelText("Url");
        this.m_urlField.setEnabled(!this.isFileSystem());
        this.m_urlField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                WsdlLocationWizardPage.this.setUrlInternal(WsdlLocationWizardPage.this.m_urlField.getText());
                WsdlLocationWizardPage.this.pingStateChanging();
            }
        });
        if (this.isRebuildStubOptionVisible()) {
            this.m_rebuidStubButton = new Button(parent, 32);
            this.m_rebuidStubButton.setText(Texts.get("RebuildWebserviceStub"));
            this.m_rebuidStubButton.setSelection(this.isRebuildStub());
            this.m_rebuidStubButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WsdlLocationWizardPage.this.setRebuildStubInternal(WsdlLocationWizardPage.this.m_rebuidStubButton.getSelection());
                }
            });
        }
        if (this.isWsdlFolderVisible()) {
            this.m_wsdlFolderDescriptionField = new Label(parent, 64);
            this.m_wsdlFolderDescriptionField.setText(Texts.get("ChooseFolderForWsdlFileAndArtefacts"));
            this.m_wsdlFolderField = new TextField(parent);
            this.m_wsdlFolderField.setLabelText(Texts.get("WsdlFolder"));
            this.m_wsdlFolderField.getTextComponent().setBackground(JaxWsSdkUtility.getColorLightGray());
            this.m_wsdlFolderField.setEditable(false);
            this.m_wsdlFolderBrowseButton = new Button(parent, 0x800008);
            this.m_wsdlFolderBrowseButton.setText(Texts.get("Browse"));
            this.m_wsdlFolderBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFolder folder = JaxWsSdkUtility.openProjectFolderDialog(WsdlLocationWizardPage.this.m_bundle, new WsdlFolderViewerFilter(WsdlLocationWizardPage.this.getRootWsdlFolder()), Texts.get("WsdlFolder"), Texts.get("ChooseFolderForWsdlFileAndArtefacts"), WsdlLocationWizardPage.this.getRootWsdlFolder(), WsdlLocationWizardPage.this.getWsdlFolder());
                    if (folder != null) {
                        WsdlLocationWizardPage.this.setWsdlFolder(folder);
                    }
                }
            });
            IFolder folder = this.getWsdlFolder();
            if (folder != null) {
                this.m_wsdlFolderField.setText(folder.getProjectRelativePath().toString());
            }
        }
        parent.setLayout((Layout)new FormLayout());
        this.m_fileSystemContainer.setLayout((Layout)new FormLayout());
        this.m_urlContainer.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_fileSystemRadioButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_fileSystemRadioButton, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_fileSystemContainer.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, -75);
        this.m_pathField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_browseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_browseButton, 5, 1024);
        formData.left = new FormAttachment(19, 1);
        formData.right = new FormAttachment(100, 0);
        this.m_addFilesLink.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_fileSystemContainer, 10, 1024);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_urlRadioButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_urlRadioButton, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_urlContainer.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(-3, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_urlField.setLayoutData((Object)formData);
        Composite referenceControl = this.m_urlContainer;
        if (this.isWsdlFolderVisible()) {
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_urlContainer, 40, 1024);
            formData.left = new FormAttachment(0, 5);
            formData.right = new FormAttachment(100, 0);
            this.m_wsdlFolderDescriptionField.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_wsdlFolderDescriptionField, 5, 1024);
            formData.left = new FormAttachment(0, 50);
            formData.right = new FormAttachment(100, -75);
            this.m_wsdlFolderField.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_wsdlFolderField, 0, 128);
            formData.left = new FormAttachment(100, -70);
            formData.right = new FormAttachment(100, 0);
            this.m_wsdlFolderBrowseButton.setLayoutData((Object)formData);
            referenceControl = this.m_wsdlFolderField;
        }
        if (this.isRebuildStubOptionVisible()) {
            formData = new FormData();
            formData.top = new FormAttachment((Control)referenceControl, 20, 1024);
            formData.left = new FormAttachment(40, 5);
            formData.right = new FormAttachment(100, 0);
            this.m_rebuidStubButton.setLayoutData((Object)formData);
        }
        JaxWsSdkUtility.setView(this.m_fileSystemContainer, this.isFileSystem());
        JaxWsSdkUtility.setView(this.m_urlContainer, !this.isFileSystem());
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (this.isFileSystem()) {
            this.validatePath(multiStatus);
        } else {
            this.validateUrl(multiStatus);
        }
        IFolder wsdlFolder = this.getWsdlFolder();
        File wsdlFile = this.getWsdlFile();
        if (JaxWsSdkUtility.existsFileInProject(this.m_bundle, wsdlFolder, wsdlFile)) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("WSDLFileAlreadyExists", wsdlFile.getName(), wsdlFolder.getProjectRelativePath().toString())));
        }
        if (this.isWsdlFolderVisible() && this.getWsdlFolder() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_wsdlFolderField.getText())));
        }
    }

    public void setFileSystem(boolean fileSystem) {
        try {
            this.setStateChanging(true);
            this.setFileSystemInternal(fileSystem);
            if (this.isFileSystem()) {
                this.setUrl(null);
            } else {
                this.setPath(null);
            }
            if (this.isControlCreated()) {
                this.m_fileSystemRadioButton.setSelection(fileSystem);
                JaxWsSdkUtility.setView(this.m_fileSystemContainer, fileSystem);
                JaxWsSdkUtility.setView(this.m_urlContainer, !fileSystem);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFileSystemInternal(boolean fileSystem) {
        this.m_propertySupport.setProperty(PROP_FILE_SYSTEM, (Object)fileSystem);
    }

    public boolean isFileSystem() {
        return this.m_propertySupport.getPropertyBool(PROP_FILE_SYSTEM);
    }

    private void setWsdlDefinition(Definition wsdlDefinition) {
        this.m_propertySupport.setProperty(PROP_WSDL_DEFINITION, (Object)wsdlDefinition);
    }

    public Definition getWsdlDefinition() {
        return (Definition)this.m_propertySupport.getProperty(PROP_WSDL_DEFINITION);
    }

    public void setPath(String path) {
        try {
            this.setStateChanging(true);
            this.setPathInternal(path);
            if (this.isControlCreated()) {
                this.m_pathField.setText(path);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPathInternal(String path) {
        this.m_propertySupport.setPropertyString(PROP_PATH, path);
    }

    public String getPath() {
        return this.m_propertySupport.getPropertyString(PROP_PATH);
    }

    public void setAdditionalFiles(File[] files) {
        this.m_propertySupport.setProperty(PROP_ADDITIONAL_FILES, (Object)files);
    }

    public File[] getAdditionalFiles() {
        File[] files = (File[])this.m_propertySupport.getProperty(PROP_ADDITIONAL_FILES);
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    public void setUrl(String url) {
        try {
            this.setStateChanging(true);
            this.setPathInternal(url);
            if (this.isControlCreated()) {
                this.m_urlField.setText(url);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setUrlInternal(String url) {
        this.m_propertySupport.setPropertyString(PROP_URL, url);
    }

    public String getUrl() {
        return this.m_propertySupport.getPropertyString(PROP_URL);
    }

    private void setWsdlFile(File wsdlFile) {
        this.m_propertySupport.setProperty(PROP_WSDL_FILE, (Object)wsdlFile);
    }

    public File getWsdlFile() {
        return (File)this.m_propertySupport.getProperty(PROP_WSDL_FILE);
    }

    public void setRebuildStub(boolean rebuildStub) {
        try {
            this.setStateChanging(true);
            this.setRebuildStubInternal(rebuildStub);
            if (this.isControlCreated()) {
                this.m_rebuidStubButton.setSelection(rebuildStub);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setRebuildStubInternal(boolean rebuildStub) {
        this.m_propertySupport.setPropertyBool(PROP_REBUILD_STUB, rebuildStub);
    }

    public boolean isRebuildStub() {
        return BooleanUtility.nvl((Boolean)this.m_propertySupport.getPropertyBool(PROP_REBUILD_STUB), (boolean)false);
    }

    public void setWsdlFolder(IFolder wsdlFolder) {
        try {
            this.setStateChanging(true);
            this.setWsdlFolderInternal(wsdlFolder);
            if (this.isControlCreated() && this.m_wsdlFolderField != null) {
                if (wsdlFolder != null) {
                    this.m_wsdlFolderField.setText(wsdlFolder.getProjectRelativePath().toString());
                } else {
                    this.m_wsdlFolderField.setText("");
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setWsdlFolderInternal(IFolder wsdlFolder) {
        this.m_propertySupport.setProperty(PROP_WSDL_FOLDER, (Object)wsdlFolder);
    }

    public IFolder getWsdlFolder() {
        return (IFolder)this.m_propertySupport.getProperty(PROP_WSDL_FOLDER);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    private void validatePath(MultiStatus multiStatus) {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getPath())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("PleaseChooseFileFromFilesystem")));
            return;
        }
        File file = IOUtility.toFile((String)this.getPath());
        if (!file.exists()) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("FileDoesNotExistOrIsCorrupt")));
            return;
        }
        Definition wsdlDefinition = JaxWsSdkUtility.loadWsdlDefinition(new JavaFileHandle(file));
        this.setWsdlDefinition(wsdlDefinition);
        if (wsdlDefinition == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("WsdlCorrupt", this.getPath())));
        } else {
            this.setWsdlFile(file);
        }
    }

    private void validateUrl(MultiStatus multiStatus) {
        URL url;
        if (StringUtility.isNullOrEmpty((CharSequence)this.getUrl())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("PleaseEnterValidUrl")));
            return;
        }
        try {
            url = URIUtil.toURL((URI)URIUtil.fromString((String)this.getUrl()));
        }
        catch (Exception e) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("PleaseEnterValidUrl")));
            return;
        }
        InputStream is = null;
        SSLSocketFactory defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        try {
            try {
                try {
                    HttpsURLConnection.setDefaultHostnameVerifier(new P_DummyHostnameVerifier());
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, new TrustManager[]{new P_DummyTrustManager()}, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                    URLConnection connection = url.openConnection();
                    connection.setAllowUserInteraction(true);
                    connection.setDoOutput(true);
                    is = url.openStream();
                }
                catch (Exception e) {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("URLCouldNotBeAccessed"), (Throwable)e));
                    HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
                    HttpsURLConnection.setDefaultHostnameVerifier(defaultHostnameVerifier);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
            finally {
                HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isRebuildStubOptionVisible() {
        return this.m_rebuildStubOptionVisible;
    }

    public void setRebuildStubOptionVisible(boolean rebuildStubOptionVisible) {
        this.m_rebuildStubOptionVisible = rebuildStubOptionVisible;
    }

    public boolean isWsdlFolderVisible() {
        return this.m_wsdlFolderVisible;
    }

    public void setWsdlFolderVisible(boolean wsdlFolderVisible) {
        this.m_wsdlFolderVisible = wsdlFolderVisible;
    }

    public IFolder getRootWsdlFolder() {
        return this.m_rootWsdlFolder;
    }

    public void setRootWsdlFolder(IFolder rootWsdlFolder) {
        this.m_rootWsdlFolder = rootWsdlFolder;
    }

    private class P_DummyHostnameVerifier
    implements HostnameVerifier {
        private P_DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslsession) {
            return true;
        }
    }

    private class P_DummyTrustManager
    implements X509TrustManager {
        private P_DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private class P_ReferencedFilesFoundWizard
    extends AbstractWorkspaceWizard {
        private ResourceSelectionWizardPage m_wizardPage;
        private Set<SchemaUtility.WsdlArtifact<File>> m_referencedWsdlArtifacts;
        private Set<SchemaUtility.SchemaIncludeArtifact<File>> m_schemaIncludeArtifacts;
        private Set<SchemaUtility.SchemaImportArtifact<File>> m_schemaImportArtifacts;

        public P_ReferencedFilesFoundWizard(Set<SchemaUtility.WsdlArtifact<File>> referencedWsdlArtifacts, Set<SchemaUtility.SchemaIncludeArtifact<File>> schemaIncludeArtifacts, Set<SchemaUtility.SchemaImportArtifact<File>> schemaImportArtifacts) {
            this.setWindowTitle(Texts.get("ReferencedFilesFound"));
            this.m_referencedWsdlArtifacts = referencedWsdlArtifacts;
            this.m_schemaIncludeArtifacts = schemaIncludeArtifacts;
            this.m_schemaImportArtifacts = schemaImportArtifacts;
        }

        public void addPages() {
            this.m_wizardPage = new ResourceSelectionWizardPage(Texts.get("ReferencedFilesFound"), Texts.get("QuestionReferencedFilesFound"));
            ArrayList<ElementBean> elements = new ArrayList<ElementBean>();
            for (SchemaUtility.WsdlArtifact<File> wsdlArtifact : this.m_referencedWsdlArtifacts) {
                elements.add(this.toElement(wsdlArtifact, "referenced WSDL file", "wsdl_file_obj.gif"));
            }
            for (SchemaUtility.SchemaIncludeArtifact schemaIncludeArtifact : this.m_schemaIncludeArtifacts) {
                elements.add(this.toElement(schemaIncludeArtifact, "included XSD schema", "xsdFile.gif"));
            }
            for (SchemaUtility.SchemaImportArtifact schemaImportArtifact : this.m_schemaImportArtifacts) {
                elements.add(this.toElement(schemaImportArtifact, "imported XSD schema", "xsdFile.gif"));
            }
            this.m_wizardPage.setElements(elements);
            this.addPage((IWizardPage)this.m_wizardPage);
        }

        protected boolean beforeFinish() throws CoreException {
            LinkedList<File> files = new LinkedList<File>();
            for (ElementBean element : this.m_wizardPage.getElements()) {
                if (!element.isChecked() && !element.isMandatory()) continue;
                files.add((File)element.getData());
            }
            WsdlLocationWizardPage.this.setAdditionalFiles(files.toArray(new File[files.size()]));
            return true;
        }

        protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
            return true;
        }

        private ElementBean toElement(SchemaUtility.AbstractArtifact<File> artifact, String suffix, String image) {
            String label = String.format("%s (%s)", artifact.getFileHandle().getName(), suffix);
            ElementBean elementBean = new ElementBean(0, label, JaxWsSdk.getImageDescriptor(image), false);
            elementBean.setData(artifact.getFileHandle().getFile());
            return elementBean;
        }
    }
}

