/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import com.sun.xml.internal.bind.api.impl.NameConverter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.ImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.operation.OverrideUnimplementedMethodsOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JaxWsSdkUtility {
    private JaxWsSdkUtility() {
    }

    public static boolean existsFileInProject(IScoutBundle bundle, IFolder folder, File javaFile) {
        if (javaFile == null || folder == null) {
            return false;
        }
        IFile projectFile = bundle.getProject().getFile(folder.getProjectRelativePath().append(javaFile.getName()));
        if (projectFile.exists()) {
            IPath fullPathProjectFile = projectFile.getLocation();
            Path fullPathJavaFile = new Path(javaFile.getPath());
            return fullPathProjectFile.equals((Object)fullPathJavaFile);
        }
        return false;
    }

    public static Definition loadWsdlDefinition(IFileHandle fileHandle) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            return reader.readWSDL(fileHandle.getParent().getFullPath().toString(), new InputSource(fileHandle.getInputStream()));
        }
        catch (Exception e) {
            JaxWsSdk.logError(String.format("Could not load WSDL file '%s'", fileHandle.getName()), e);
            return null;
        }
    }

    public static Document createNewXmlDocument(InputStream is) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document document = docBuilder.parse(is);
            return document;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    public static Document createNewXmlDocument(String rootTagName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            document.appendChild(document.createElement(rootTagName));
            return document;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    public static List<Element> getChildElementsWithAttributes(Element parent, String tagName, String requiredAttributeName, String requiredAttributeValue) {
        NodeList endpoints = parent.getElementsByTagName(tagName);
        LinkedList<Element> result = new LinkedList<Element>();
        int i = 0;
        while (i < endpoints.getLength()) {
            String val;
            Element e;
            Node n = endpoints.item(i);
            if (n.getNodeType() == 1 && (e = (Element)n).hasAttribute(requiredAttributeName) && CompareUtility.equals((Object)requiredAttributeValue, (Object)(val = e.getAttribute(requiredAttributeName)))) {
                result.add(e);
            }
            ++i;
        }
        return result;
    }

    public static Element getParentElement(Node n) {
        Node node = n.getParentNode();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String getXmlPrefix(Element e) {
        if (e == null) {
            return null;
        }
        String n = e.getNodeName();
        int pos = n.indexOf(58);
        if (pos > 0) {
            return n.substring(0, pos);
        }
        return null;
    }

    public static String getXmlAttribute(Element e, String attributeName, String defaultValue) {
        if (e == null) {
            return defaultValue;
        }
        if (e.hasAttribute(attributeName)) {
            return e.getAttribute(attributeName);
        }
        return defaultValue;
    }

    public static Element getFirstChildElementByTagName(Element parent, String tagName) {
        NodeList children = parent.getElementsByTagName(tagName);
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public static String getXmlContent(Document xml) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 3);
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(xml), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (Exception e) {
            JaxWsSdk.logError("unable to get xml from DOM document", e);
            return "";
        }
    }

    public static List<Element> getChildElements(NodeList nodeList) {
        return JaxWsSdkUtility.getChildElements(nodeList, null);
    }

    public static void removeAllChildElements(Element e, String tagName) {
        for (Element c : JaxWsSdkUtility.getChildElements(e.getChildNodes(), tagName)) {
            e.removeChild(c);
        }
    }

    public static Element getChildElement(NodeList nodeList, String tagName) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            if (item instanceof Element) {
                Element e = (Element)item;
                if (tagName == null || tagName.equals(e.getTagName())) {
                    return e;
                }
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getChildElements(NodeList nodeList, String tagName) {
        ArrayList<Element> elements = new ArrayList<Element>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            if (item instanceof Element) {
                Element e = (Element)item;
                if (tagName == null || tagName.equals(e.getTagName())) {
                    elements.add(e);
                }
            }
            ++i;
        }
        return elements;
    }

    public static boolean exists(IResource resource) {
        JaxWsSdkUtility.refreshLocal(resource, 1);
        return resource != null && resource.exists() && resource.isSynchronized(1);
    }

    public static void refreshLocal(IResource resource, int depth) {
        try {
            if (resource != null && !resource.isSynchronized(depth)) {
                resource.refreshLocal(depth, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            JaxWsSdk.logWarning("The 'resource '" + resource.getFullPath().toString() + "' could not be synchronized with the filesystem.");
        }
    }

    public static IFile getFile(IScoutBundle scoutBundle, IPath projectRelativePath, boolean autoCreate) {
        if (projectRelativePath == null || projectRelativePath.isEmpty()) {
            return null;
        }
        IFile file = scoutBundle.getProject().getFile(projectRelativePath.makeRelative());
        JaxWsSdkUtility.ensureFileAccessibleAndRegistered(file, autoCreate);
        return file;
    }

    public static void ensureFileAccessibleAndRegistered(IFile file, boolean autoCreate) {
        JaxWsSdkUtility.refreshLocal((IResource)file, 0);
        try {
            IFolder folder;
            if (!JaxWsSdkUtility.exists((IResource)file) && autoCreate) {
                if (file.getParent() instanceof IFolder) {
                    ResourceUtility.mkdirs((IContainer)file.getParent(), (IProgressMonitor)new NullProgressMonitor());
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
                file.create((InputStream)inputStream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (autoCreate && file.getParent() instanceof IFolder && !(folder = (IFolder)file.getParent()).getProjectRelativePath().toString().contains("build")) {
                PluginModelHelper h = new PluginModelHelper(file.getProject());
                h.BuildProperties.addBinaryBuildEntry((IResource)folder);
                h.save();
            }
        }
        catch (CoreException e) {
            JaxWsSdk.logError("Unable to create file '" + file.getFullPath().toOSString() + "'.", e);
        }
    }

    public static IFolder getFolder(IScoutBundle scoutBundle, IPath projectRelativePath, boolean autoCreate) {
        if (projectRelativePath == null || projectRelativePath.isEmpty()) {
            return null;
        }
        IFolder folder = scoutBundle.getProject().getFolder(projectRelativePath.makeRelative());
        JaxWsSdkUtility.ensureFolderAccessibleAndRegistered(folder, autoCreate);
        return folder;
    }

    public static void ensureFolderAccessibleAndRegistered(IFolder folder, boolean autoCreate) {
        JaxWsSdkUtility.refreshLocal((IResource)folder, 2);
        try {
            if (!folder.exists() && autoCreate) {
                ResourceUtility.mkdirs((IContainer)folder, (IProgressMonitor)new NullProgressMonitor());
            }
            if (autoCreate && !folder.getProjectRelativePath().toString().contains("build")) {
                PluginModelHelper h = new PluginModelHelper(folder.getProject());
                h.BuildProperties.addBinaryBuildEntry((IResource)folder);
                h.save();
            }
        }
        catch (CoreException e) {
            JaxWsSdk.logError("Unable to create folder '" + folder.getFullPath().toOSString() + "'", e);
        }
    }

    public static void createImportDirective(IType declaringType, IType typeForImportDirective) {
        try {
            String resolveTypeName = JaxWsSdkUtility.resolveTypeName(declaringType, typeForImportDirective);
            if (resolveTypeName == null) {
                return;
            }
            if (typeForImportDirective.getFullyQualifiedName().equals(resolveTypeName)) {
                return;
            }
            declaringType.getCompilationUnit().createImport(typeForImportDirective.getFullyQualifiedName().replaceAll("\\$", "."), null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            JaxWsSdk.logError("Unable to create import directive", e);
        }
    }

    public static void organizeImports(IType type) {
        try {
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
            CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)type.getCompilationUnit(), (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            OrganizeImportsOperation.IChooseImportQuery chooseImportQuery = new OrganizeImportsOperation.IChooseImportQuery(){

                public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                    return new TypeNameMatch[0];
                }
            };
            OrganizeImportsOperation op = new OrganizeImportsOperation(type.getCompilationUnit(), astRoot, settings.importIgnoreLowercase, !type.getCompilationUnit().isWorkingCopy(), true, chooseImportQuery);
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            JaxWsSdk.logError(e);
        }
    }

    public static void doLayout(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            if (composite.getLayoutData() instanceof GridData) {
                ((GridData)composite.getLayoutData()).heightHint = composite.getChildren().length == 0 ? 0 : -1;
            }
            composite.layout(true, true);
        }
    }

    public static void doLayoutSection(ISection section) {
        if (section.isExpanded()) {
            section.setExpanded(false);
            section.setExpanded(true);
        }
    }

    public static void disposeChildControls(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    public static void setView(Composite composite, boolean enabled) {
        if (composite != null && !composite.isDisposed()) {
            composite.setEnabled(enabled);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    JaxWsSdkUtility.setView((Composite)child, enabled);
                } else {
                    child.setEnabled(enabled);
                }
                ++n2;
            }
        }
    }

    public static PortType getPortType(Definition wsdlDefinition, QName serviceQName, String portName) {
        if (wsdlDefinition == null || serviceQName == null || portName == null) {
            return null;
        }
        portName = QName.valueOf(portName).getLocalPart();
        javax.wsdl.Service service = wsdlDefinition.getService(serviceQName);
        if (service == null) {
            return null;
        }
        Port port = service.getPort(portName);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        return port.getBinding().getPortType();
    }

    public static IType resolvePortTypeInterfaceType(QName portTypeQName, IFile jarFile) {
        if (portTypeQName == null) {
            return null;
        }
        IType[] types = JaxWsSdkUtility.resolvePortTypeInterfaceTypes(portTypeQName, jarFile);
        if (types.length == 0) {
            return null;
        }
        if (types.length > 1) {
            JaxWsSdk.logWarning("Multiple PortType interface types found for port type '" + portTypeQName + "'");
        }
        return types[0];
    }

    public static IType[] resolvePortTypeInterfaceTypes(final QName portTypeQName, IFile jarFile) {
        if (jarFile == null) {
            return new IType[0];
        }
        final HashSet types = new HashSet();
        try {
            new SearchEngine().search(SearchPattern.createPattern((String)"*", (int)6, (int)0, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, (IJavaSearchScope)new JarFileSearchScope(jarFile), new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (!(match instanceof TypeDeclarationMatch)) {
                        return;
                    }
                    IType candidate = (IType)match.getElement();
                    if (!TypeUtility.exists((IJavaElement)candidate) || !candidate.isBinary()) {
                        return;
                    }
                    IAnnotation annotation = JaxWsSdkUtility.getAnnotation(candidate, WebService.class.getName(), false);
                    if (!TypeUtility.exists((IJavaElement)annotation)) {
                        return;
                    }
                    if (portTypeQName == null) {
                        types.add(candidate);
                        return;
                    }
                    String serviceName = JdtUtility.getAnnotationValueString((IAnnotation)annotation, (String)"name");
                    if (CompareUtility.equals((Object)serviceName, (Object)portTypeQName.getLocalPart())) {
                        types.add(candidate);
                    }
                }
            }, null);
        }
        catch (Exception e) {
            JaxWsSdk.logError("Failed to resolve portType interface type", e);
        }
        return types.toArray(new IType[types.size()]);
    }

    public static IType resolveServiceType(QName serviceQName, IFile jarFile) {
        if (serviceQName == null) {
            return null;
        }
        Set<IType> types = JaxWsSdkUtility.resolveServiceTypes(serviceQName, jarFile);
        if (types.size() == 0) {
            return null;
        }
        if (types.size() > 1) {
            JaxWsSdk.logWarning("Multiple service types found for service '" + serviceQName + "'");
        }
        return (IType)CollectionUtility.firstElement(types);
    }

    public static Set<IType> resolveServiceTypes(final QName serviceQName, IFile jarFile) {
        final HashSet<IType> types = new HashSet<IType>();
        try {
            new SearchEngine().search(SearchPattern.createPattern((String)"*", (int)0, (int)0, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, (IJavaSearchScope)new JarFileSearchScope(jarFile), new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (!(match instanceof TypeDeclarationMatch)) {
                        return;
                    }
                    IType candidate = (IType)match.getElement();
                    if (!TypeUtility.exists((IJavaElement)candidate) || !candidate.isBinary()) {
                        return;
                    }
                    if (!candidate.isClass() || Flags.isAbstract((int)candidate.getFlags())) {
                        return;
                    }
                    if (!JaxWsSdkUtility.isJdtSubType(Service.class.getName(), candidate)) {
                        return;
                    }
                    IAnnotation annotation = JaxWsSdkUtility.getAnnotation(candidate, WebServiceClient.class.getName(), false);
                    if (!TypeUtility.exists((IJavaElement)annotation)) {
                        return;
                    }
                    if (serviceQName == null) {
                        types.add(candidate);
                        return;
                    }
                    String serviceName = JdtUtility.getAnnotationValueString((IAnnotation)annotation, (String)"name");
                    if (CompareUtility.equals((Object)serviceName, (Object)serviceQName.getLocalPart())) {
                        types.add(candidate);
                    }
                }
            }, null);
        }
        catch (Exception e) {
            JaxWsSdk.logError("Failed to resolve portType interface type", e);
        }
        return types;
    }

    public static boolean isProviderAuthenticationSet(String fqn) {
        if (!StringUtility.hasText((CharSequence)fqn)) {
            return false;
        }
        fqn = fqn.replaceAll("\\$", "\\.");
        String noneAuthFqn = TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler$NONE").getFullyQualifiedName().replaceAll("\\$", "\\.");
        return TypeUtility.existsType((String)fqn) && !fqn.equals(noneAuthFqn);
    }

    public static IType extractGenericSuperType(IType type, int index) {
        String[] typeArguments;
        block8: {
            String superTypeSignature;
            block7: {
                block6: {
                    try {
                        if (TypeUtility.exists((IJavaElement)type)) break block6;
                        return null;
                    }
                    catch (JavaModelException e) {
                        JaxWsSdk.logError("could not extract generic super type", e);
                        return null;
                    }
                }
                superTypeSignature = type.getSuperclassTypeSignature();
                if (superTypeSignature != null) break block7;
                return null;
            }
            typeArguments = Signature.getTypeArguments((String)superTypeSignature);
            if (typeArguments.length != 0 && index < typeArguments.length) break block8;
            return null;
        }
        String signature = typeArguments[index];
        String fullyQualifiedName = JaxWsSdkUtility.getFullyQualifiedNameFromSignature(type, signature);
        if (TypeUtility.existsType((String)fullyQualifiedName)) {
            return TypeUtility.getType((String)fullyQualifiedName);
        }
        return null;
    }

    public static QName extractServiceQNameFromWsClient(IType webserviceClientType) {
        IType serviceType = JaxWsSdkUtility.extractGenericSuperType(webserviceClientType, 0);
        if (!TypeUtility.exists((IJavaElement)serviceType)) {
            return null;
        }
        if (!JaxWsSdkUtility.isJdtSubType(Service.class.getName(), serviceType)) {
            return null;
        }
        IAnnotation annotation = JaxWsSdkUtility.getAnnotation(serviceType, WebServiceClient.class.getName(), false);
        return JaxWsSdkUtility.extractQNameFromAnnotation(annotation);
    }

    public static QName extractPortTypeQNameFromWsClient(IType webserviceClientType) {
        IType portTypeInterfaceType = JaxWsSdkUtility.extractGenericSuperType(webserviceClientType, 1);
        if (!TypeUtility.exists((IJavaElement)portTypeInterfaceType)) {
            return null;
        }
        IAnnotation annotation = JaxWsSdkUtility.getAnnotation(portTypeInterfaceType, WebService.class.getName(), false);
        return JaxWsSdkUtility.extractQNameFromAnnotation(annotation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidSourceFolder(IScoutBundle bundle, String sourceFolder) {
        if (sourceFolder == null) {
            return false;
        }
        try {
            IClasspathEntry[] iClasspathEntryArray = bundle.getJavaProject().getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && sourceFolder.equals(classpathEntry.getPath().lastSegment())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("Failed to validate source folder.", e);
        }
        return false;
    }

    public static String getPlainPortTypeName(String portTypeName) {
        if (portTypeName == null) {
            return null;
        }
        while (true) {
            if (portTypeName.toLowerCase().endsWith("porttype")) {
                portTypeName = portTypeName.substring(0, portTypeName.length() - "porttype".length());
                continue;
            }
            if (portTypeName.toLowerCase().endsWith("webservice")) {
                portTypeName = portTypeName.substring(0, portTypeName.length() - "webservice".length());
                continue;
            }
            if (!portTypeName.toLowerCase().endsWith("service")) break;
            portTypeName = portTypeName.substring(0, portTypeName.length() - "service".length());
        }
        return portTypeName;
    }

    public static String getRecommendedProviderImplPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (Object[])new Object[]{bundle.getSymbolicName(), "services", "ws", "provider"});
    }

    public static String getRecommendedHandlerPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (Object[])new Object[]{bundle.getSymbolicName(), "services", "ws", "handler"});
    }

    public static String getRecommendedConsumerImplPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (Object[])new Object[]{bundle.getSymbolicName(), "services", "ws", "consumer"});
    }

    public static String getRecommendedProviderSecurityPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (Object[])new Object[]{bundle.getSymbolicName(), "services", "ws", "provider", "security"});
    }

    public static String getRecommendedConsumerSecurityPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (Object[])new Object[]{bundle.getSymbolicName(), "services", "ws", "consumer", "security"});
    }

    public static String getRecommendedSessionPackageName(IScoutBundle bundle) {
        return StringUtility.join((String)".", (Object[])new Object[]{bundle.getSymbolicName(), "services", "ws", "session"});
    }

    public static String getRecommendedTargetNamespace(IScoutBundle bundle, String serviceName) {
        String[] segments = bundle.getSymbolicName().split("\\.");
        String projectSuffex = null;
        int i = segments.length - 1;
        while (i >= 0) {
            String segment = segments[i];
            String segmentLow = segment.toLowerCase();
            if (!("server".equals(segmentLow) || "online".equals(segmentLow) || "offline".equals(segmentLow))) {
                projectSuffex = StringUtility.join((String)".", (Object[])new Object[]{projectSuffex, segments[i]});
            }
            --i;
        }
        return "http://ws.services." + projectSuffex + "/" + serviceName + "/";
    }

    public static String resolveStubPackageName(Map<String, List<String>> buildProperties, Definition wsdlDefinition) {
        String globalPackageName = JaxWsSdkUtility.getBuildProperty(buildProperties, "p");
        if (!StringUtility.isNullOrEmpty((CharSequence)globalPackageName)) {
            return globalPackageName;
        }
        if (wsdlDefinition == null) {
            return null;
        }
        globalPackageName = JaxWsSdkUtility.getWsdlBindingPackageName(wsdlDefinition);
        if (!StringUtility.isNullOrEmpty((CharSequence)globalPackageName)) {
            return globalPackageName;
        }
        String targetNamespace = wsdlDefinition.getTargetNamespace();
        return JaxWsSdkUtility.targetNamespaceToPackageName(targetNamespace);
    }

    public static String targetNamespaceToPackageName(String targetNamespace) {
        if (targetNamespace == null) {
            return null;
        }
        NameConverter nameConverter = NameConverter.standard;
        try {
            return nameConverter.toPackageName(targetNamespace);
        }
        catch (Exception e) {
            JaxWsSdk.logError("failed to convert targetNamespace into package name");
            return null;
        }
    }

    public static Binding getBinding(Definition wsdlDefinition, QName serviceQName, String portName) {
        if (wsdlDefinition == null || serviceQName == null || portName == null) {
            return null;
        }
        portName = QName.valueOf(portName).getLocalPart();
        javax.wsdl.Service service = wsdlDefinition.getService(serviceQName);
        if (service == null) {
            return null;
        }
        Port port = service.getPort(portName);
        if (port == null) {
            return null;
        }
        return port.getBinding();
    }

    public static IAnnotation getAnnotation(IType declaringType, String fqnAnnotationName, boolean recursively) {
        ITypeHierarchy superTypeHierarchy = null;
        if (recursively) {
            superTypeHierarchy = TypeUtility.getSupertypeHierarchy((IType)declaringType);
        }
        return JaxWsSdkUtility.getAnnotation(declaringType, fqnAnnotationName, recursively, superTypeHierarchy);
    }

    private static IAnnotation getAnnotation(IType declaringType, String fqnAnnotationName, boolean recursively, ITypeHierarchy superTypeHierarchy) {
        if (!TypeUtility.exists((IJavaElement)declaringType)) {
            return null;
        }
        IAnnotation annotation = JdtUtility.getAnnotation((IAnnotatable)declaringType, (String)fqnAnnotationName);
        if (TypeUtility.exists((IJavaElement)annotation)) {
            return annotation;
        }
        if (recursively) {
            IType superType = superTypeHierarchy.getSuperclass(declaringType);
            return JaxWsSdkUtility.getAnnotation(superType, fqnAnnotationName, recursively, superTypeHierarchy);
        }
        return null;
    }

    public static boolean isAnnotationOnDeclaringType(IType declaringType, IAnnotation annotation) {
        if (annotation == null || declaringType == null) {
            return false;
        }
        IJavaElement parent = annotation.getParent();
        if (parent.getElementType() != 7) {
            return false;
        }
        IType candidateType = (IType)parent;
        return candidateType.getFullyQualifiedName().equals(declaringType.getFullyQualifiedName());
    }

    public static Map<String, List<String>> getDefaultBuildProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("Xdebug", null);
        map.put("keep", null);
        map.put("verbose", null);
        LinkedList<String> values = new LinkedList<String>();
        values.add("2.1");
        map.put("target", values);
        return map;
    }

    public static IFile[] getBindingFiles(IScoutBundle bundle, Map<String, List<String>> buildProperties) {
        if (buildProperties == null || buildProperties.size() == 0) {
            return new IFile[0];
        }
        LinkedList<IFile> bindingFiles = new LinkedList<IFile>();
        for (Map.Entry<String, List<String>> property : buildProperties.entrySet()) {
            if (property.getKey() == null || !property.getKey().equals("b") || property.getValue() == null || property.getValue().size() == 0) continue;
            for (String bindingFileRaw : property.getValue()) {
                IFile bindingFile = JaxWsSdkUtility.getFile(bundle, (IPath)new Path(bindingFileRaw), false);
                bindingFiles.add(bindingFile);
            }
        }
        return bindingFiles.toArray(new IFile[bindingFiles.size()]);
    }

    public static void addBuildProperty(Map<String, List<String>> buildProperties, String propertyName, String propertyValue) {
        if (!buildProperties.containsKey(propertyName)) {
            buildProperties.put(propertyName, new LinkedList());
        }
        buildProperties.get(propertyName).add(propertyValue);
    }

    public static String getBuildProperty(Map<String, List<String>> buildProperties, String propertyName) {
        if (buildProperties == null || buildProperties.size() == 0) {
            return null;
        }
        for (Map.Entry<String, List<String>> property : buildProperties.entrySet()) {
            List<String> values;
            if (!CompareUtility.equals((Object)property.getKey(), (Object)propertyName) || (values = property.getValue()) == null || values.size() <= 0) continue;
            return values.get(0);
        }
        return null;
    }

    public static String toMarkerGroupUUID(String markerGroupUUID, int index) {
        return StringUtility.join((String)"_", (Object[])new Object[]{markerGroupUUID, String.valueOf(index)});
    }

    public static IPath toUniqueProjectRelativeBindingFilePath(IScoutBundle bundle, String alias, String schemaTargetNamespace) {
        String filename = StringUtility.join((String)"-", (Object[])new Object[]{alias, schemaTargetNamespace, "bindings"});
        filename = JaxWsSdkUtility.toValidFileName(filename);
        IPath folderBindingFile = JaxWsConstants.PATH_BUILD;
        IPath filePath = folderBindingFile.append(filename).addFileExtension("xml");
        IFile file = JaxWsSdkUtility.getFile(bundle, filePath, false);
        int i = 0;
        while (file.exists()) {
            String newFileName = String.format("%s (%s)", filename, ++i);
            IPath newFilePath = folderBindingFile.append(newFileName).addFileExtension("xml");
            file = JaxWsSdkUtility.getFile(bundle, newFilePath, false);
        }
        return file.getProjectRelativePath();
    }

    public static Color getColorLightGray() {
        Color color = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("lightGray");
        if (color == null) {
            PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().put("lightGray", new RGB(245, 245, 245));
            color = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("lightGray");
        }
        return color;
    }

    public static AnnotationProperty parseAnnotationTypeValue(IType declaringType, IAnnotation annotation, String property) {
        AnnotationProperty propertyValue = new AnnotationProperty();
        if (!TypeUtility.exists((IJavaElement)declaringType)) {
            return propertyValue;
        }
        if (!TypeUtility.exists((IJavaElement)annotation)) {
            return propertyValue;
        }
        try {
            String fqn;
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if (pair.getMemberName().equals(property)) {
                    String fqn2 = (String)pair.getValue();
                    if (StringUtility.hasText((CharSequence)fqn2)) {
                        String propertySignature = SignatureCache.createTypeSignature((String)((String)pair.getValue()));
                        String fullyQualifiedName = JaxWsSdkUtility.getFullyQualifiedNameFromSignature(declaringType, propertySignature);
                        propertyValue.setInherited(false);
                        propertyValue.setFullyQualifiedName(fullyQualifiedName);
                        propertyValue.setDefined(true);
                    }
                    return propertyValue;
                }
                ++n2;
            }
            propertyValue.setInherited(true);
            IType type = TypeUtility.getReferencedType((IType)declaringType, (String)annotation.getElementName(), (boolean)false);
            if (TypeUtility.exists((IJavaElement)type) && StringUtility.hasText((CharSequence)(fqn = (String)type.getMethod(property, new String[0]).getDefaultValue().getValue()))) {
                propertyValue.setFullyQualifiedName(fqn);
                propertyValue.setDefined(true);
            }
            return propertyValue;
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("failed to parse annotation property value", e);
            return propertyValue;
        }
    }

    public static IType[] getJdtSubTypes(IScoutBundle bundle, String fqnSuperType, boolean includeInterfaces, boolean includeAbstractTypes, boolean includeFinalTypes, boolean sameProject) {
        LinkedList<IType> types = new LinkedList<IType>();
        try {
            Set superTypes = TypeUtility.getTypes((String)fqnSuperType);
            for (IType superType : superTypes) {
                ITypeHierarchy hierarchy = TypeUtility.getSupertypeHierarchy((IType)superType);
                Set candidates = hierarchy.getAllSubtypes(superType);
                for (IType candidate : candidates) {
                    if (!TypeUtility.exists((IJavaElement)candidate) || !includeInterfaces && Flags.isInterface((int)candidate.getFlags()) || !includeAbstractTypes && Flags.isAbstract((int)candidate.getFlags()) || !includeFinalTypes && Flags.isFinal((int)candidate.getFlags()) || sameProject && !bundle.getJavaProject().equals(candidate.getJavaProject()) || !TypeUtility.isOnClasspath((IJavaElement)candidate, (IJavaProject)bundle.getJavaProject())) continue;
                    types.add(candidate);
                }
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("failed to get subclasses of '" + fqnSuperType + "'", e);
        }
        JaxWsSdkUtility.sortTypesByName(types, true);
        return types.toArray(new IType[types.size()]);
    }

    public static boolean isJdtSubType(String fqnSuperType, IType candidateToCheck) {
        if (!TypeUtility.exists((IJavaElement)candidateToCheck)) {
            return false;
        }
        IType superTypes = TypeUtility.getType((String)fqnSuperType);
        if (!TypeUtility.exists((IJavaElement)superTypes)) {
            return false;
        }
        return TypeUtility.getSupertypeHierarchy((IType)candidateToCheck).isSubtype(superTypes, candidateToCheck);
    }

    public static String resolveTypeName(IType declaringType, IType typeToBeResolved) throws CoreException {
        String typeSignature = SignatureCache.createTypeSignature((String)typeToBeResolved.getFullyQualifiedName());
        ImportValidator validator = new ImportValidator(declaringType.getCompilationUnit());
        return SignatureUtility.getTypeReference((String)typeSignature, (IImportValidator)validator);
    }

    public static boolean containsGlobalBindingSection(IScoutBundle bundle, Map<String, List<String>> propertiers, boolean checkForMultipleOccurences) {
        IFile[] bindingFiles = JaxWsSdkUtility.getBindingFiles(bundle, propertiers);
        LinkedList<XmlResource> bindingFileResources = new LinkedList<XmlResource>();
        IFile[] iFileArray = bindingFiles;
        int n = bindingFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile bindingFile = iFileArray[n2];
            XmlResource xmlResource = new XmlResource(bundle);
            xmlResource.setFile(bindingFile);
            bindingFileResources.add(xmlResource);
            ++n2;
        }
        return JaxWsSdkUtility.containsGlobalBindingSection(bindingFileResources.toArray(new XmlResource[bindingFileResources.size()]), checkForMultipleOccurences);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsGlobalBindingSection(XmlResource[] bindingFileResources, boolean checkForMultipleOccurences) {
        int count = 0;
        try {
            XmlResource[] xmlResourceArray = bindingFileResources;
            int n = bindingFileResources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                XmlResource bindingFileResource = xmlResourceArray[n2];
                Document xmlBindingFile = bindingFileResource.loadXml();
                for (Element e : JaxWsSdkUtility.getChildElements(xmlBindingFile.getDocumentElement().getChildNodes())) {
                    if (!e.getTagName().endsWith("globalBindings")) continue;
                    String prefix = JaxWsSdkUtility.getXmlPrefix(e);
                    String namespace = xmlBindingFile.getDocumentElement().getAttribute("xmlns:" + prefix);
                    if (!"http://java.sun.com/xml/ns/jaxb".equals(namespace)) continue;
                    if (!checkForMultipleOccurences) return true;
                    if (++count <= 1) break;
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static IFile getStubJarFile(IScoutBundle bundle, BuildJaxWsBean buildJaxWsBean, String wsdlFileName) {
        Map<String, List<String>> buildProperties = null;
        if (buildJaxWsBean != null) {
            buildProperties = buildJaxWsBean.getPropertiers();
        }
        return JaxWsSdkUtility.getStubJarFile(bundle, buildProperties, wsdlFileName);
    }

    public static IFile getStubJarFile(IScoutBundle bundle, Map<String, List<String>> buildProperties, String wsdlFileName) {
        String customJarFileName;
        String jarFileName = null;
        if (buildProperties != null && StringUtility.hasText((CharSequence)(customJarFileName = JaxWsSdkUtility.getBuildProperty(buildProperties, "jar")))) {
            jarFileName = new Path(customJarFileName).removeFileExtension().lastSegment();
        }
        if (jarFileName == null && wsdlFileName != null) {
            jarFileName = new Path(wsdlFileName).removeFileExtension().lastSegment();
        }
        if (jarFileName == null) {
            JaxWsSdk.logWarning("Failed to derive stub JAR file name. Ensure WSDL file to exist or specify the build property 'jar' with the JAR file name as its value");
            return null;
        }
        return JaxWsSdkUtility.toStubJarFile(bundle, jarFileName);
    }

    public static boolean registerJarLib(IScoutBundle bundle, IFile jarFile, boolean remove, IProgressMonitor monitor) {
        boolean success = true;
        JaxWsSdkUtility.refreshLocal((IResource)jarFile, 1);
        IPath jarFilePath = jarFile.getProjectRelativePath();
        IJavaProject javaProject = bundle.getJavaProject();
        IProject project = bundle.getProject();
        try {
            ArrayList<IClasspathEntry> cpeList = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 1) {
                    if (!cpe.getPath().equals((Object)project.getFullPath().append(jarFilePath))) {
                        cpeList.add(cpe);
                    }
                } else {
                    cpeList.add(cpe);
                }
                ++n2;
            }
            if (!remove) {
                cpeList.add(JavaCore.newLibraryEntry((IPath)project.getFullPath().append(jarFilePath), null, null, (boolean)true));
            }
            javaProject.setRawClasspath(cpeList.toArray(new IClasspathEntry[cpeList.size()]), monitor);
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not update Java class path in .classpath file", e);
        }
        PluginModelHelper h = new PluginModelHelper(project);
        try {
            if (remove) {
                h.Manifest.removeClasspathEntry((IResource)jarFile);
            } else {
                h.Manifest.addClasspathEntry((IResource)jarFile);
            }
            h.Manifest.addClasspathDefaultEntry();
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not update Bundle-ClassPath in MANIFEST.MF", e);
            success = false;
        }
        try {
            h.BuildProperties.removeBinaryBuildEntry((IResource)jarFile);
            if (!remove) {
                h.BuildProperties.addBinaryBuildEntry((IResource)JaxWsSdkUtility.getParentFolder(bundle, jarFile));
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not update bin.includes in build.properties", e);
            success = false;
        }
        h.save();
        return success;
    }

    public static void overrideUnimplementedMethodsAsync(IType type) {
        OverrideUnimplementedMethodsOperation op = new OverrideUnimplementedMethodsOperation();
        op.setType(type);
        new OperationJob(new IOperation[]{op}).schedule();
    }

    public static void sortTypesByName(List<IType> list, boolean removeDuplicates) {
        if (removeDuplicates) {
            JaxWsSdkUtility.removeDuplicateEntries(list);
        }
        Collections.sort(list, new Comparator<IType>(){

            @Override
            public int compare(IType type1, IType type2) {
                return CompareUtility.compareTo((Comparable)((Object)type1.getElementName()), (Comparable)((Object)type2.getElementName()));
            }
        });
    }

    public static IFolder getParentFolder(IScoutBundle bundle, IFile file) {
        if (file == null) {
            return null;
        }
        IPath parentFolderPath = file.getProjectRelativePath().removeLastSegments(1);
        if (parentFolderPath.segmentCount() == 0) {
            return null;
        }
        return JaxWsSdkUtility.getFolder(bundle, parentFolderPath, false);
    }

    public static IFolder openProjectFolderDialog(IScoutBundle bundle, ViewerFilter filter, String title, String description, IFolder rootFolder, IFolder initialFolder) {
        if (!JaxWsSdkUtility.exists((IResource)rootFolder)) {
            rootFolder = JaxWsSdkUtility.getFolder(bundle, rootFolder.getProjectRelativePath(), true);
        }
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        FolderSelectionDialog dialog = new FolderSelectionDialog(ScoutSdkUi.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.addFilter(filter);
        dialog.setHelpAvailable(false);
        dialog.setAllowMultiple(false);
        if (initialFolder != null) {
            dialog.setInitialSelection((Object)initialFolder);
        }
        IPath parentFolderPath = rootFolder.getProjectRelativePath().removeLastSegments(1);
        dialog.setInput((Object)JaxWsSdkUtility.getFolder(bundle, parentFolderPath, true));
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    public static void markStructureDirtyAndFixSelection(final IPage parentPage) {
        ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IScoutExplorerPart explorer = ScoutSdkUi.getExplorer((boolean)false);
                    if (explorer == null) {
                        return;
                    }
                    IStructuredSelection selection = explorer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    if (new ArrayList(parentPage.getChildren()).removeAll(selection.toList())) {
                        explorer.setSelection((IStructuredSelection)new StructuredSelection((Object)parentPage));
                    }
                }
                catch (Exception e) {
                    JaxWsSdk.logError(e);
                }
                parentPage.markStructureDirty();
            }
        });
    }

    private static String getFullyQualifiedNameFromSignature(IType declaringType, String signature) throws JavaModelException {
        return TypeUtility.getReferencedTypeFqn((IType)declaringType, (String)StringUtility.join((String)".", (Object[])new Object[]{Signature.getSignatureQualifier((String)signature), Signature.getSignatureSimpleName((String)signature)}), (boolean)false);
    }

    private static <T> void removeDuplicateEntries(List<T> list) {
        HashSet<T> elementsVisited = new HashSet<T>();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (elementsVisited.contains(element)) {
                iterator.remove();
            }
            elementsVisited.add(element);
        }
    }

    private static IFile toStubJarFile(IScoutBundle bundle, String jarFileName) {
        if (jarFileName == null) {
            return null;
        }
        jarFileName = new Path(jarFileName).removeFileExtension().lastSegment();
        jarFileName = JaxWsSdkUtility.toValidFileName(jarFileName);
        IPath path = JaxWsConstants.STUB_FOLDER.append(jarFileName).addFileExtension("jar");
        return JaxWsSdkUtility.getFile(bundle, path, false);
    }

    private static String toValidFileName(String name) {
        return name.replaceAll("[\\\\/\\:\\*\\?\\<\\>\"]", "");
    }

    private static String getWsdlBindingPackageName(Definition definition) {
        if (definition == null) {
            return null;
        }
        for (Object e : definition.getExtensibilityElements()) {
            Element globalPackageBindingElement;
            String name;
            Element element;
            NodeList nodes;
            UnknownExtensibilityElement uee;
            if (!(e instanceof UnknownExtensibilityElement) || !(uee = (UnknownExtensibilityElement)e).getElementType().equals(new QName("http://java.sun.com/xml/ns/jaxws", "bindings")) || (nodes = (element = uee.getElement()).getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxws", "package")).getLength() <= 0 || !StringUtility.hasText((CharSequence)(name = (globalPackageBindingElement = (Element)nodes.item(0)).getAttribute("name")))) continue;
            return name;
        }
        return null;
    }

    private static QName extractQNameFromAnnotation(IAnnotation annotation) {
        if (annotation == null || !annotation.exists()) {
            return null;
        }
        String localPart = null;
        String namespaceURI = null;
        try {
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("name".equals(pair.getMemberName())) {
                    localPart = (String)pair.getValue();
                } else if ("targetNamespace".equals(pair.getMemberName())) {
                    namespaceURI = (String)pair.getValue();
                }
                if (namespaceURI != null && localPart != null) break;
                ++n2;
            }
            QName qname = null;
            if (namespaceURI != null && localPart != null) {
                qname = new QName(namespaceURI, localPart);
            } else if (localPart != null) {
                qname = new QName(localPart);
            }
            if (qname != null) {
                return qname;
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not extract QName from annotation '" + annotation.getElementName() + "'", e);
        }
        return null;
    }

    private static class JarFileSearchScope
    implements IJavaSearchScope {
        private IFile m_jarFile;

        public JarFileSearchScope(IFile jarFile) {
            this.m_jarFile = jarFile;
        }

        public boolean encloses(String resourcePath) {
            return true;
        }

        public boolean encloses(IJavaElement element) {
            return element.getElementType() == 7;
        }

        public IPath[] enclosingProjectsAndJars() {
            return new IPath[]{this.m_jarFile.getFullPath()};
        }

        public boolean includesBinaries() {
            return true;
        }

        public boolean includesClasspaths() {
            return false;
        }

        public void setIncludesBinaries(boolean includesBinaries) {
        }

        public void setIncludesClasspaths(boolean includesClasspaths) {
        }
    }
}

