/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.worker;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;

public abstract class AbstractQueueManager<T> {
    private final Lock m_workerLock = new ReentrantLock();
    private final Lock m_suspendLock = new ReentrantLock();
    private final Lock m_refuseLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<T> m_requests = new ConcurrentLinkedQueue();
    private AtomicInteger m_suspendCounter = new AtomicInteger();
    private AtomicInteger m_refuseCounter = new AtomicInteger();

    public void queueRequest(T request) {
        if (!this.isRefuseRequests()) {
            if (!this.m_requests.contains(request)) {
                this.m_requests.offer(request);
            }
            this.startWorker();
        }
    }

    public void refuseRequests(boolean refuseRequests) {
        this.m_refuseLock.lock();
        try {
            if (refuseRequests) {
                this.m_refuseCounter.incrementAndGet();
            } else if (this.m_refuseCounter.decrementAndGet() < 0) {
                this.m_refuseCounter.set(0);
            }
        }
        finally {
            this.m_refuseLock.unlock();
        }
    }

    public void resume() {
        this.m_suspendLock.lock();
        try {
            if (this.m_suspendCounter.decrementAndGet() < 0) {
                this.m_suspendCounter.set(0);
            }
            if (this.m_suspendCounter.get() == 0) {
                this.startWorker();
            }
        }
        finally {
            this.m_suspendLock.unlock();
        }
    }

    public void suspend() {
        this.m_suspendLock.lock();
        try {
            this.m_suspendCounter.incrementAndGet();
            this.cancelWorker();
        }
        finally {
            this.m_suspendLock.unlock();
        }
    }

    private void startWorker() {
        if (this.m_workerLock.tryLock()) {
            try {
                if (!this.isWorkerActive() && !this.isSuspend()) {
                    P_Worker worker = new P_Worker();
                    worker.setSystem(true);
                    worker.setUser(false);
                    worker.setPriority(40);
                    worker.schedule(200L);
                }
            }
            finally {
                this.m_workerLock.unlock();
            }
        }
    }

    public void cancelWorker() {
        if (this.m_workerLock.tryLock()) {
            try {
                if (this.isWorkerActive()) {
                    Job[] jobArray = Job.getJobManager().find((Object)this);
                    int n = jobArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Job job = jobArray[n2];
                        job.cancel();
                        ++n2;
                    }
                }
            }
            finally {
                this.m_workerLock.unlock();
            }
        }
    }

    private boolean isRefuseRequests() {
        return this.m_refuseCounter.get() > 0;
    }

    private boolean isSuspend() {
        return this.m_suspendCounter.get() > 0;
    }

    private boolean isWorkerActive() {
        return Job.getJobManager().find((Object)this).length > 0;
    }

    protected abstract void handleRequest(T var1, IProgressMonitor var2);

    private final class P_Worker
    extends Job {
        public P_Worker() {
            super(AbstractQueueManager.this.getClass().getSimpleName());
        }

        public boolean belongsTo(Object family) {
            return CompareUtility.equals((Object)family, (Object)AbstractQueueManager.this);
        }

        protected IStatus run(IProgressMonitor monitor) {
            AbstractQueueManager.this.m_workerLock.lock();
            try {
                Object request;
                while ((request = AbstractQueueManager.this.m_requests.poll()) != null) {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        AbstractQueueManager.this.handleRequest(request, monitor);
                        continue;
                    }
                    catch (Exception e) {
                        JaxWsSdk.logError("Error occured while processing queued job", e);
                    }
                    break;
                }
            }
            finally {
                AbstractQueueManager.this.m_workerLock.unlock();
            }
            return Status.OK_STATUS;
        }
    }
}

