/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.ui.rap.calendarfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ICalendarContextMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.ext.MenuAdapterEx;
import org.eclipse.scout.rt.ui.svg.calendar.builder.AbstractCalendarDocumentBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.listener.ICalendarDocumentListener;
import org.eclipse.scout.svg.ui.rap.AbstractRwtScoutSvgComposite;
import org.eclipse.scout.svg.ui.rap.calendarfield.IRwtScoutCalendarField;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.w3c.dom.svg.SVGDocument;

public class RwtScoutCalendarField
extends AbstractRwtScoutSvgComposite<ICalendarField<?>>
implements IRwtScoutCalendarField {
    private static final int CALENDAR_DISPLAY_MODE_COUNT = 4;
    private static final int CONTEXT_MENU_POS_INSET = 10;
    private P_InnerCalendarPropertyChangeListener m_innerCalPropertyListener;
    private AbstractCalendarDocumentBuilder[] m_documentBuilders = new AbstractCalendarDocumentBuilder[4];

    @Override
    protected SVGDocument getSvgDocument() {
        return this.getDocBuilder().getSVGDocument();
    }

    @Override
    protected void updateSvgDocument() {
        Rectangle r = this.getAbsoluteCalendarBounds();
        this.getDocBuilder().setSize(r.width, r.height);
        super.updateSvgDocument();
    }

    protected void detachScout() {
        if (this.m_innerCalPropertyListener != null && this.getScoutObject() != null && ((ICalendarField)this.getScoutObject()).getCalendar() != null) {
            ((ICalendarField)this.getScoutObject()).getCalendar().removePropertyChangeListener((PropertyChangeListener)this.m_innerCalPropertyListener);
            this.m_innerCalPropertyListener = null;
        }
        int i = 0;
        while (i < this.m_documentBuilders.length) {
            if (this.m_documentBuilders[i] != null) {
                this.m_documentBuilders[i].dispose();
            }
            this.m_documentBuilders[i] = null;
            ++i;
        }
        super.detachScout();
    }

    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() != null && ((ICalendarField)this.getScoutObject()).getCalendar() != null) {
            if (this.m_innerCalPropertyListener == null) {
                this.m_innerCalPropertyListener = new P_InnerCalendarPropertyChangeListener();
                ((ICalendarField)this.getScoutObject()).getCalendar().addPropertyChangeListener((PropertyChangeListener)this.m_innerCalPropertyListener);
            }
            this.initDocBuilder(this.getDocBuilder());
            this.updateSvgDocument();
        }
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("viewRange".equals(name)) {
            this.updateSvgDocument();
        } else if ("selectedDate".equals(name)) {
            this.getDocBuilder().setNumContextMenus(this.getContextMenusFromScout().size());
            this.updateSvgDocument();
        } else if ("selectedComponent".equals(name)) {
            this.getDocBuilder().setNumContextMenus(this.getContextMenusFromScout().size());
            this.updateSvgDocument();
        } else if ("components".equals(name)) {
            this.getDocBuilder().setComponents(((ICalendarField)this.getScoutObject()).getCalendar().getComponents());
            this.updateSvgDocument();
        } else if ("displayMode".equals(name)) {
            this.initDocBuilder(this.getDocBuilder());
            this.updateSvgDocument();
        }
    }

    @Override
    protected void hyperlinkActivatedFromUi(String url) {
        if (url == null || url.length() < 1) {
            return;
        }
        this.getDocBuilder().hyperlinkActivated(url);
    }

    private AbstractCalendarDocumentBuilder getDocBuilder() {
        int mode = ((ICalendarField)this.getScoutObject()).getCalendar().getDisplayMode();
        int index = mode - 1;
        AbstractCalendarDocumentBuilder ret = this.m_documentBuilders[index];
        if (ret == null) {
            ret = AbstractCalendarDocumentBuilder.createInstance((int)mode);
            this.initDocBuilder(ret);
            ret.addCalendarDocumentListener((ICalendarDocumentListener)new P_CalendarDocumentListener());
            this.m_documentBuilders[index] = ret;
        }
        return ret;
    }

    private void initDocBuilder(AbstractCalendarDocumentBuilder builder) {
        Date selDate = ((ICalendarField)this.getScoutObject()).getCalendar().getSelectedDate();
        CalendarComponent selComp = ((ICalendarField)this.getScoutObject()).getCalendar().getSelectedComponent();
        builder.setWorkHours(((ICalendarField)this.getScoutObject()).getCalendar().getStartHour(), ((ICalendarField)this.getScoutObject()).getCalendar().getEndHour(), ((ICalendarField)this.getScoutObject()).getCalendar().getUseOverflowCells());
        builder.setShowDisplayModeSelectionPanel(((ICalendarField)this.getScoutObject()).getCalendar().getShowDisplayModeSelection());
        builder.setMarkNoonHour(((ICalendarField)this.getScoutObject()).getCalendar().getMarkNoonHour());
        builder.setMarkOutOfMonthDays(((ICalendarField)this.getScoutObject()).getCalendar().getMarkOutOfMonthDays());
        builder.reconfigureLayout();
        builder.setShownDate(selDate);
        builder.setSelection(selDate, selComp);
        builder.setNumContextMenus(this.getContextMenusFromScout().size());
        builder.setComponents(((ICalendarField)this.getScoutObject()).getCalendar().getComponents());
        this.setViewRangeFromUi(builder.getStartDate(), builder.getEndDate());
    }

    private void showPopupMenu() {
        Rectangle calBounds = this.getAbsoluteCalendarBounds();
        Point contextMenuPos = new Point(calBounds.x + calBounds.width - 10, calBounds.y + calBounds.height - 10);
        this.createAndShowMenu(contextMenuPos);
    }

    private Menu createMenu() {
        if (this.getUiField().getMenu() != null) {
            this.getUiField().getMenu().dispose();
            this.getUiField().setMenu(null);
        }
        Menu contextMenu = new Menu((Decorations)this.getUiField().getShell(), 8);
        contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        this.getUiField().setMenu(contextMenu);
        return contextMenu;
    }

    private void createAndShowMenu(Point location) {
        Menu menu = this.createMenu();
        this.showMenu(menu, location);
    }

    private void showMenu(Menu menu, Point location) {
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private Rectangle getAbsoluteCalendarBounds() {
        Rectangle ret = new Rectangle(0, 0, 0, 0);
        Rectangle browserBounds = this.getAbsoluteBrowserBounds();
        float calRatio = 1.1987079f;
        if ((double)calRatio < (double)browserBounds.width / (double)browserBounds.height) {
            ret.width = Math.round((float)browserBounds.height * calRatio);
            ret.height = browserBounds.height;
        } else {
            ret.width = browserBounds.width;
            ret.height = Math.round((float)browserBounds.width / calRatio);
        }
        ret.x = browserBounds.x + (int)Math.round((double)(browserBounds.width - ret.width) / 2.0);
        ret.y = browserBounds.y + (int)Math.round((double)(browserBounds.height - ret.height) / 2.0);
        return ret;
    }

    private void setViewRangeFromUi(final Date start, final Date end) {
        if (this.getScoutObject() != null && ((ICalendarField)this.getScoutObject()).getCalendar() != null) {
            this.getUiEnvironment().invokeScoutLater(new Runnable(){

                @Override
                public void run() {
                    ((ICalendarField)RwtScoutCalendarField.this.getScoutObject()).getCalendar().getUIFacade().setVisibleRangeFromUI(start, end);
                }
            }, 0L);
        }
    }

    private void setDisplayModeFromUi(final int mode) {
        this.getUiEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                ((ICalendarField)RwtScoutCalendarField.this.getScoutObject()).getCalendar().setDisplayMode(mode);
            }
        }, 0L);
    }

    private void setSelectionFromUi(final Date d, final CalendarComponent c) {
        if (this.getScoutObject() != null && ((ICalendarField)this.getScoutObject()).getCalendar() != null) {
            this.getUiEnvironment().invokeScoutLater(new Runnable(){

                @Override
                public void run() {
                    ((ICalendarField)RwtScoutCalendarField.this.getScoutObject()).getCalendar().getUIFacade().setSelectionFromUI(d, c);
                }
            }, 0L);
        }
    }

    private List<IMenu> getContextMenusFromScout() {
        ICalendarContextMenu contextMenu = ((ICalendarField)this.getScoutObject()).getCalendar().getContextMenu();
        IActionFilter actionFilter = ActionUtility.createMenuFilterMenuTypes((Set)contextMenu.getCurrentMenuTypes(), (boolean)true);
        List normalizedActions = ActionUtility.normalizedActions((List)contextMenu.getChildActions(), (IActionFilter)actionFilter);
        return normalizedActions;
    }

    private final class P_CalendarDocumentListener
    implements ICalendarDocumentListener {
        private P_CalendarDocumentListener() {
        }

        public void visibleRangeChanged(Date start, Date end) {
            RwtScoutCalendarField.this.setViewRangeFromUi(start, end);
        }

        public void displayModeMenuActivated(int displayMode) {
            RwtScoutCalendarField.this.setDisplayModeFromUi(displayMode);
        }

        public void popupMenuActivated() {
            RwtScoutCalendarField.this.showPopupMenu();
        }

        public void selectionChanged(Date selectedDate, CalendarComponent selectedComponent) {
            RwtScoutCalendarField.this.setSelectionFromUi(selectedDate, selectedComponent);
        }
    }

    private final class P_ContextMenuListener
    extends MenuAdapterEx {
        private static final long serialVersionUID = 1L;

        public P_ContextMenuListener() {
            super((Control)RwtScoutCalendarField.this.getUiField(), (Control)RwtScoutCalendarField.this.getUiContainer());
        }

        public void menuShown(MenuEvent e) {
            super.menuShown(e);
            Menu menu = (Menu)e.getSource();
            final ICalendarContextMenu contextMenu = ((ICalendarField)RwtScoutCalendarField.this.getScoutObject()).getCalendar().getContextMenu();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    contextMenu.callAboutToShow(ActionUtility.createMenuFilterMenuTypes((Set)contextMenu.getCurrentMenuTypes(), (boolean)false));
                }
            };
            JobEx job = RwtScoutCalendarField.this.getUiEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IActionFilter displayFilter = ActionUtility.createMenuFilterMenuTypes((Set)contextMenu.getCurrentMenuTypes(), (boolean)true);
            RwtMenuUtility.fillMenu((Menu)menu, (List)contextMenu.getChildActions(), (IActionFilter)displayFilter, (IRwtEnvironment)RwtScoutCalendarField.this.getUiEnvironment());
        }
    }

    private final class P_InnerCalendarPropertyChangeListener
    implements PropertyChangeListener {
        private P_InnerCalendarPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            RwtScoutCalendarField.this.debugHandlePropertyChanged(e);
            if (RwtScoutCalendarField.this.isIgnoredScoutEvent(PropertyChangeEvent.class, e.getPropertyName())) {
                return;
            }
            if (RwtScoutCalendarField.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue()) && RwtScoutCalendarField.this.getUiEnvironment().getDisplay() != null && !RwtScoutCalendarField.this.getUiEnvironment().getDisplay().isDisposed()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (!RwtScoutCalendarField.this.isUiDisposed()) {
                            try {
                                RwtScoutCalendarField.this.getUpdateUiFromScoutLock().acquire();
                                RwtScoutCalendarField.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                            }
                            finally {
                                RwtScoutCalendarField.this.getUpdateUiFromScoutLock().release();
                            }
                        }
                    }
                };
                RwtScoutCalendarField.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }
}

