/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.common.ui.tools.api.dialog.FolderSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewFileDialog
extends FolderSelectionDialog {
    private Text newFileNameText;
    private String newFileName;

    public NewFileDialog(String defaultName) {
        super("Select the folder");
        this.setTitle("File Name");
        this.newFileName = defaultName != null ? defaultName : "";
    }

    public String getNewFileName() {
        return this.newFileName;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control result = super.createDialogArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("File");
        this.newFileNameText = new Text(composite, 2048);
        GridData data = new GridData(1536);
        data.heightHint = this.newFileNameText.getLineHeight();
        data.widthHint = this.newFileNameText.getLineHeight() * 30;
        this.newFileNameText.setLayoutData((Object)data);
        this.newFileNameText.setText(this.newFileName);
        this.newFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFileDialog.this.updateOKStatus();
            }
        });
        return result;
    }

    protected void updateOKStatus() {
        if (this.newFileNameText == null || this.newFileNameText.getText() == null || this.newFileNameText.getText().trim().length() == 0) {
            this.newFileName = "";
            this.updateStatus((IStatus)new Status(4, "org.eclipse.sirius.common.ui", 4, "Select a file", null));
        } else {
            this.newFileName = this.newFileNameText.getText();
            super.updateOKStatus();
        }
    }
}

