/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.selection.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectModelElementWizardPage
extends WizardPage {
    protected TreeViewer myTreeViewer;
    protected ModelFilesFilter filter;
    protected ResourceSet resourceSet = new ResourceSetImpl();
    private Composite topLevel;
    private EObject mySelectedModelElement;
    private String modelElementType;
    private Collection<String> fileExtensions;
    private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;
    private AdapterFactoryContentProvider myAdapterFactoryContentProvider;
    private IFile selectedFile;

    public SelectModelElementWizardPage(String pageName, AdapterFactory factory, Collection<String> fileExtensions, String typeName) {
        this(pageName, factory, fileExtensions, typeName, null);
    }

    public SelectModelElementWizardPage(String pageName, AdapterFactory factory, Collection<String> fileExtensions, String typeName, IFile selectedFile) {
        super(pageName);
        this.fileExtensions = fileExtensions;
        this.modelElementType = typeName;
        this.myAdapterFactoryContentProvider = new AdapterFactoryContentProvider(factory);
        this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(factory);
        this.selectedFile = selectedFile;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.topLevel = new Composite(parent, 0);
        this.topLevel.setLayout((Layout)new GridLayout());
        this.topLevel.setLayoutData((Object)new GridData(272));
        this.topLevel.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.topLevel, "org.eclipse.ui.ide.new_file_wizard_page_context");
        this.createModelBrowser(this.topLevel);
        this.setErrorMessage(null);
        this.setControl((Control)this.topLevel);
    }

    public void dispose() {
        this.topLevel.dispose();
    }

    private void createModelBrowser(Composite composite) {
        this.myTreeViewer = new TreeViewer(composite, 2820){

            public void setSelection(ISelection selection, boolean reveal) {
                Object element = ((StructuredSelection)selection).getFirstElement();
                Widget item = this.findItem(element);
                if (item == null) {
                    Object[] expandedElements = this.getExpandedElements();
                    this.expandAll();
                    item = this.findItem(element);
                    this.setExpandedElements(expandedElements);
                }
                if (item != null && item.getData() != null) {
                    super.setSelection((ISelection)new StructuredSelection(item.getData()), reveal);
                }
            }
        };
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.myTreeViewer.getTree().setLayoutData((Object)layoutData);
        this.myTreeViewer.setContentProvider((IContentProvider)new ModelElementsTreeContentProvider());
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementsTreeLabelProvider());
        this.setInput();
        this.filter = new ModelFilesFilter();
        this.myTreeViewer.addFilter((ViewerFilter)this.filter);
        this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler());
    }

    protected void setInput() {
        this.myTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected boolean isValidModelFile(IFile file) {
        if (this.fileExtensions == null || this.fileExtensions.size() == 0) {
            return true;
        }
        boolean isValid = false;
        String fileExtension = file.getFullPath().getFileExtension();
        for (String extension : this.fileExtensions) {
            if (fileExtension == null || !fileExtension.equals(extension)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    private boolean containsAValidFile(IContainer container) {
        final ArrayList result = new ArrayList();
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && SelectModelElementWizardPage.this.isValidModelFile((IFile)resource)) {
                    result.add(Boolean.TRUE);
                }
                return result.size() == 0;
            }
        };
        try {
            container.accept(visitor);
        }
        catch (CoreException coreException) {}
        return result.size() != 0;
    }

    public EObject getSelectedModelElement() {
        return this.mySelectedModelElement;
    }

    public IFile getSelectedFile() {
        return this.selectedFile;
    }

    private static boolean eInternalInstanceOf(EObject eObject, String type) {
        if (eObject == null) {
            return false;
        }
        LinkedList<String> allTypes = new LinkedList<String>();
        allTypes.add(eObject.eClass().getName());
        Iterator iterSuperTypes = eObject.eClass().getEAllSuperTypes().iterator();
        while (iterSuperTypes.hasNext()) {
            allTypes.add(eObject.eClass().getName());
        }
        return allTypes.contains(type);
    }

    private class ModelElementsTreeContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider myWorkbenchContentProvider = new WorkbenchContentProvider();

        private ModelElementsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = this.myWorkbenchContentProvider.getChildren(parentElement);
            if (children != null && children.length > 0) {
                return children;
            }
            if (parentElement instanceof IFile) {
                IFile modelFile = (IFile)parentElement;
                IPath resourcePath = modelFile.getFullPath();
                Resource modelResource = null;
                try {
                    modelResource = SelectModelElementWizardPage.this.resourceSet.getResource(URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true), true);
                }
                catch (WrappedException exception) {
                    SiriusTransPlugin.getPlugin().error("following file is not valid" + resourcePath.toString(), exception);
                }
                children = modelResource == null ? Collections.EMPTY_LIST.toArray() : SelectModelElementWizardPage.this.myAdapterFactoryContentProvider.getChildren((Object)modelResource);
            } else {
                children = SelectModelElementWizardPage.this.myAdapterFactoryContentProvider.getChildren(parentElement);
            }
            return children;
        }

        public Object getParent(Object element) {
            Object parent = this.myWorkbenchContentProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (element instanceof EObject) {
                URI eObjectResourceURI;
                EObject eObject = (EObject)element;
                if (eObject.eContainer() == null && (eObjectResourceURI = eObject.eResource().getURI()).isFile()) {
                    String path = eObjectResourceURI.path();
                    parent = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
                }
                if (parent == null) {
                    parent = SelectModelElementWizardPage.this.myAdapterFactoryContentProvider.getParent((Object)eObject);
                }
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return SelectModelElementWizardPage.this.isValidModelFile((IFile)element);
            }
            boolean hasChildren = false;
            hasChildren = this.myWorkbenchContentProvider.hasChildren(element) || SelectModelElementWizardPage.this.myAdapterFactoryContentProvider.hasChildren(element);
            return hasChildren;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.myWorkbenchContentProvider.getElements(inputElement);
            return elements;
        }

        public void dispose() {
            this.myWorkbenchContentProvider.dispose();
            SelectModelElementWizardPage.this.myAdapterFactoryContentProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myWorkbenchContentProvider.inputChanged(viewer, oldInput, newInput);
            SelectModelElementWizardPage.this.myAdapterFactoryContentProvider.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ModelElementsTreeLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();

        private ModelElementsTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Image result = this.myWorkbenchLabelProvider.getImage(element);
            return result != null ? result : SelectModelElementWizardPage.this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            String result = this.myWorkbenchLabelProvider.getText(element);
            return result != null && result.length() > 0 ? result : SelectModelElementWizardPage.this.myAdapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            SelectModelElementWizardPage.this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            SelectModelElementWizardPage.this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || SelectModelElementWizardPage.this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            SelectModelElementWizardPage.this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class ModelFilesFilter
    extends ViewerFilter {
        private ModelFilesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean isSelected = true;
            if (element instanceof IProject) {
                isSelected = ((IProject)element).isOpen() ? SelectModelElementWizardPage.this.containsAValidFile((IContainer)element) : false;
            } else if (element instanceof IContainer) {
                isSelected = SelectModelElementWizardPage.this.containsAValidFile((IContainer)element);
            } else if (element instanceof IFile) {
                IFile file = (IFile)element;
                isSelected = SelectModelElementWizardPage.this.isValidModelFile(file);
            }
            return isSelected;
        }
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        private OkButtonEnabler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IWrapperItemProvider) {
                    selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
                }
                if (selectedElement instanceof FeatureMap.Entry) {
                    selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
                }
                if (selectedElement instanceof EObject) {
                    SelectModelElementWizardPage.this.mySelectedModelElement = (EObject)selectedElement;
                    SelectModelElementWizardPage.this.setPageComplete(SelectModelElementWizardPage.eInternalInstanceOf(SelectModelElementWizardPage.this.mySelectedModelElement, SelectModelElementWizardPage.this.modelElementType));
                    return;
                }
            }
            SelectModelElementWizardPage.this.mySelectedModelElement = null;
            SelectModelElementWizardPage.this.setPageComplete(false);
        }
    }
}

