/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoading;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.ClasspathChangeCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.internal.interpreter.BundleClassLoading;
import org.eclipse.sirius.common.tools.internal.interpreter.ClassLoadingService;

public final class JavaExtensionsManager {
    private static final String WORKSPACE_SEPARATOR = "/";
    private Set<String> viewpointPlugins = Sets.newLinkedHashSet();
    private Set<String> viewpointProjects = Sets.newLinkedHashSet();
    private final Set<String> imports = new LinkedHashSet<String>();
    private final Set<String> couldNotBeLoaded = new LinkedHashSet<String>();
    private final Map<String, Class<?>> loadedClasses = Maps.newLinkedHashMap();
    private ClassLoading classLoading;
    private List<ClassLoadingCallback> callbacks = Lists.newArrayList();
    private List<EPackageLoadingCallback> ePackageCallbacks = Lists.newArrayList();
    private boolean shouldLoadServices = true;
    private boolean shouldLoadEPackages = true;
    private ClasspathChangeCallback onWorkspaceChange = new ClasspathChangeCallback(){

        @Override
        public void classpathChanged(Set<String> updatedProjects) {
            if (JavaExtensionsManager.this.viewpointPlugins.size() > 0 || JavaExtensionsManager.this.viewpointProjects.size() > 0) {
                JavaExtensionsManager.this.reload();
            }
        }
    };
    private Multimap<String, EPackage> lastDeclarerIDsToEPackages = HashMultimap.create();
    private Set<String> lastDeclarerIDsInBundles;

    public JavaExtensionsManager() {
        this.classLoading = new BundleClassLoading();
    }

    public void setClassLoadingOverride(ClassLoading override) {
        if (this.classLoading != null) {
            this.classLoading.dispose();
        }
        override.setClasspathChangeCallback(this.onWorkspaceChange);
        this.classLoading = override;
    }

    public void addClassLoadingCallBack(ClassLoadingCallback callback) {
        this.callbacks.add(callback);
    }

    public void removeClassLoadingCallBack(ClassLoadingCallback callback) {
        this.callbacks.remove(callback);
    }

    public void addEPackageCallBack(EPackageLoadingCallback callback) {
        this.ePackageCallbacks.add(callback);
    }

    public void removeEPackageCallBack(EPackageLoadingCallback callback) {
        this.ePackageCallbacks.remove(callback);
    }

    public void dispose() {
        this.classLoading.dispose();
        this.clearImports();
        this.viewpointPlugins.clear();
        this.viewpointProjects.clear();
    }

    public void updateScope(Set<String> plugins, Set<String> project) {
        boolean removedAddedAtLeastOnePlugin = this.viewpointPlugins.retainAll(plugins) || this.viewpointPlugins.addAll(plugins);
        boolean removedAddedAtLeastOnProject = this.viewpointProjects.retainAll(project) || this.viewpointProjects.addAll(project);
        this.viewpointPlugins = plugins;
        this.viewpointProjects = project;
        if ((this.couldNotBeLoaded.size() > 0 || removedAddedAtLeastOnePlugin || removedAddedAtLeastOnProject) && (this.viewpointPlugins.size() > 0 || this.viewpointProjects.size() > 0)) {
            this.reload();
        }
    }

    private synchronized void reload() {
        this.shouldLoadEPackages = true;
        this.shouldLoadServices = true;
    }

    public synchronized void reloadIfNeeded() {
        if (this.shouldLoadEPackages) {
            this.reloadEPackages();
            this.shouldLoadEPackages = false;
        }
        if (this.shouldLoadServices) {
            this.loadJavaExtensions(this.imports);
            this.shouldLoadServices = false;
        }
    }

    private void reloadEPackages() {
        boolean firstRun;
        HashMultimap newDeclarations = HashMultimap.create();
        LinkedHashSet newDeclarersAsBundles = Sets.newLinkedHashSet();
        Collection<EPackageLoadingCallback.EPackageDeclarationSource> ecoreDeclarationSources = this.classLoading.findEcoreDeclarations(this.viewpointProjects, this.viewpointPlugins);
        ArrayList workspaceDeclarations = Lists.newArrayList();
        for (EPackageLoadingCallback.EPackageDeclarationSource declarer : ecoreDeclarationSources) {
            if (declarer.isBundle()) {
                newDeclarersAsBundles.add(declarer.getSymbolicName());
                for (EPackageLoadingCallback.EPackageDeclaration ePackageDeclaration : declarer.getEPackageDeclarations()) {
                    EPackage pak = EPackage.Registry.INSTANCE.getEPackage(ePackageDeclaration.getNsURI());
                    if (pak == null) continue;
                    newDeclarations.put((Object)declarer.getSymbolicName(), (Object)pak);
                }
                continue;
            }
            workspaceDeclarations.add(declarer);
        }
        if (workspaceDeclarations.size() > 0) {
            ResourceSetImpl set = new ResourceSetImpl();
            this.computePlatformURIMap(set);
            for (EPackageLoadingCallback.EPackageDeclarationSource workspaceSource : workspaceDeclarations) {
                LinkedHashMap ecorePackages = Maps.newLinkedHashMap();
                this.loadAndFindEPackages(set, workspaceSource, ecorePackages);
                for (EPackageLoadingCallback.EPackageDeclaration declaration : workspaceSource.getEPackageDeclarations()) {
                    EPackage loaded;
                    String nsURI = declaration.getNsURI();
                    if (StringUtil.isEmpty(nsURI) || (loaded = (EPackage)ecorePackages.get(nsURI)) == null) continue;
                    newDeclarations.put((Object)nsURI, (Object)loaded);
                }
            }
        }
        boolean bl = firstRun = this.lastDeclarerIDsInBundles == null;
        if (!firstRun) {
            for (Map.Entry entry : this.lastDeclarerIDsToEPackages.entries()) {
                boolean changedType = this.lastDeclarerIDsInBundles.contains(entry.getKey()) ^ newDeclarersAsBundles.contains(entry.getKey());
                if (!changedType) continue;
                this.unloadedEPackage((EPackage)entry.getValue());
            }
        }
        for (Map.Entry entry : newDeclarations.entries()) {
            boolean changedType;
            boolean bl2 = changedType = firstRun || this.lastDeclarerIDsInBundles.contains(entry.getKey()) != newDeclarersAsBundles.contains(entry.getKey());
            if (!changedType) continue;
            this.loadedEPackage((EPackage)entry.getValue());
        }
        this.lastDeclarerIDsToEPackages = newDeclarations;
        this.lastDeclarerIDsInBundles = newDeclarersAsBundles;
    }

    private void computePlatformURIMap(ResourceSetImpl set) {
        Map result = null;
        try {
            Method computePlatformURIMap = EcorePlugin.class.getMethod("computePlatformURIMap", Boolean.TYPE);
            result = (Map)computePlatformURIMap.invoke(null, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (result == null) {
            result = EcorePlugin.computePlatformURIMap();
        }
        if (result != null) {
            set.getURIConverter().getURIMap().putAll(result);
        }
    }

    private void loadAndFindEPackages(ResourceSetImpl set, EPackageLoadingCallback.EPackageDeclarationSource workspaceSource, Map<String, EPackage> ecorePackages) {
        for (EPackageLoadingCallback.EPackageDeclaration declaration : workspaceSource.getEPackageDeclarations()) {
            EObject genModel;
            String genmodelPath = declaration.getGenModelPath();
            if (StringUtil.isEmpty(genmodelPath)) continue;
            URI genModelURI = URI.createPlatformResourceURI((String)(WORKSPACE_SEPARATOR + workspaceSource.getSymbolicName() + WORKSPACE_SEPARATOR + genmodelPath), (boolean)true);
            if (!genModelURI.hasFragment()) {
                genModelURI = genModelURI.appendFragment(WORKSPACE_SEPARATOR);
            }
            if ((genModel = set.getEObject(genModelURI, true)) == null || genModel.eClass().getEPackage() == null || !"GenModel".equals(genModel.eClass().getName()) || !"genmodel".equals(genModel.eClass().getEPackage().getName())) continue;
            Collection genPackages = (Collection)genModel.eGet(genModel.eClass().getEStructuralFeature("genPackages"));
            this.collectEPackages(ecorePackages, genPackages);
        }
    }

    private void collectEPackages(Map<String, EPackage> ecorePackages, Collection<EObject> genPackages) {
        for (EObject genPackage : genPackages) {
            Object ePak = genPackage.eGet(genPackage.eClass().getEStructuralFeature("ecorePackage"));
            if (ePak instanceof EPackage && !StringUtil.isEmpty(((EPackage)ePak).getNsURI())) {
                ecorePackages.put(((EPackage)ePak).getNsURI(), (EPackage)ePak);
            }
            Collection subGenPackages = (Collection)genPackage.eGet(genPackage.eClass().getEStructuralFeature("nestedGenPackages"));
            this.collectEPackages(ecorePackages, subGenPackages);
        }
    }

    private void unloadedEPackage(EPackage removed) {
        for (EPackageLoadingCallback ePackageCallBack : this.ePackageCallbacks) {
            try {
                ePackageCallBack.unloaded(removed.getNsURI(), removed);
            }
            catch (Throwable throwable) {}
        }
    }

    private void loadedEPackage(EPackage ePackage) {
        for (EPackageLoadingCallback ePackageCallBack : this.ePackageCallbacks) {
            try {
                ePackageCallBack.loaded(ePackage.getNsURI(), ePackage);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addImport(String classQualifiedName) {
        if (classQualifiedName != null && classQualifiedName.contains(".")) {
            this.imports.add(classQualifiedName);
            this.shouldLoadServices = true;
        }
    }

    public void removeImport(String classQualifiedName) {
        if (this.imports.contains(classQualifiedName)) {
            this.couldNotBeLoaded.remove(classQualifiedName);
            LinkedHashSet removedImport = Sets.newLinkedHashSet();
            removedImport.add(classQualifiedName);
            this.imports.remove(classQualifiedName);
            this.unloadJavaExtensions(removedImport);
        }
    }

    public Collection<String> getImports() {
        return ImmutableList.copyOf(this.imports);
    }

    public void clearImports() {
        this.unloadJavaExtensions(this.imports);
        this.imports.clear();
        this.couldNotBeLoaded.clear();
    }

    private void loadJavaExtensions(Set<String> addedImports) {
        LinkedHashMap toUnload = Maps.newLinkedHashMap();
        LinkedHashMap toLoad = Maps.newLinkedHashMap();
        LinkedHashSet notFound = Sets.newLinkedHashSet();
        for (String string : addedImports) {
            Class<?> found = this.classLoading.findClass(this.viewpointProjects, this.viewpointPlugins, string);
            if (found != null) {
                this.couldNotBeLoaded.remove(string);
                Class<?> alreadyHere = this.loadedClasses.get(string);
                if (alreadyHere != null) {
                    toUnload.put(string, alreadyHere);
                }
                this.loadedClasses.put(string, found);
                toLoad.put(string, found);
                continue;
            }
            notFound.add(string);
            this.couldNotBeLoaded.add(string);
        }
        for (Map.Entry entry : toUnload.entrySet()) {
            this.unloaded((String)entry.getKey(), (Class)entry.getValue());
        }
        for (Map.Entry entry : toLoad.entrySet()) {
            this.loaded((String)entry.getKey(), (Class)entry.getValue());
        }
        for (String string : notFound) {
            this.notFound(string);
        }
    }

    private void notFound(String qualifiedName) {
        for (ClassLoadingCallback callback : this.callbacks) {
            try {
                callback.notFound(qualifiedName);
            }
            catch (Throwable throwable) {}
        }
    }

    private void loaded(String qualifiedName, Class<?> clazz) {
        for (ClassLoadingCallback callback : this.callbacks) {
            try {
                callback.loaded(qualifiedName, clazz);
            }
            catch (Throwable throwable) {}
        }
    }

    private void unloaded(String qualifiedName, Class<?> clazz) {
        for (ClassLoadingCallback callback : this.callbacks) {
            try {
                callback.unloaded(qualifiedName, clazz);
            }
            catch (Throwable throwable) {}
        }
    }

    private void unloadJavaExtensions(Set<String> removedImports) {
        for (String qualifiedName : removedImports) {
            Class<?> alreadyHere = this.loadedClasses.get(qualifiedName);
            if (alreadyHere == null) continue;
            this.unloaded(qualifiedName, alreadyHere);
        }
    }

    public void updateScope(Collection<String> value) {
        LinkedHashSet prjs = Sets.newLinkedHashSet();
        LinkedHashSet plugins = Sets.newLinkedHashSet();
        if (value != null) {
            for (String odesignPath : value) {
                URI workspaceCandidate = URI.createPlatformResourceURI((String)odesignPath, (boolean)true);
                URI pluginCandidate = URI.createPlatformPluginURI((String)odesignPath, (boolean)true);
                if (JavaExtensionsManager.existsInWorkspace(workspaceCandidate.toPlatformString(true))) {
                    prjs.add(workspaceCandidate.segment(1));
                    continue;
                }
                if (!JavaExtensionsManager.existsInPlugins(URI.decode((String)pluginCandidate.toString()))) continue;
                plugins.add(pluginCandidate.segment(1));
            }
        }
        this.updateScope(plugins, prjs);
    }

    private static boolean existsInPlugins(String path) {
        try {
            URL url = new URL(path);
            return FileLocator.find((URL)url) != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private static boolean existsInWorkspace(String path) {
        if (path == null || path.length() == 0 || EcorePlugin.getWorkspaceRoot() == null) {
            return false;
        }
        return ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(path));
    }

    public static JavaExtensionsManager createManagerWithOverride() {
        JavaExtensionsManager result = new JavaExtensionsManager();
        result.setClassLoadingOverride(ClassLoadingService.getClassLoading());
        return result;
    }
}

