/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;

public class EObjectCouple {
    private EObject obj1;
    private EObject obj2;
    private Integer int1;
    private Integer int2;

    public EObjectCouple(EObject obj1, EObject obj2, RefreshIdsHolder ids) {
        if (obj1 == null) {
            throw new IllegalArgumentException("the first eObject is null");
        }
        if (obj2 == null) {
            throw new IllegalArgumentException("the second eObject is null");
        }
        this.obj1 = obj1;
        this.obj2 = obj2;
        this.int1 = ids.getOrCreateID(obj1);
        this.int2 = ids.getOrCreateID(obj2);
    }

    public int hashCode() {
        return this.int1 + this.int2;
    }

    public boolean equals(Object obj) {
        boolean areEquals = false;
        if (this == obj) {
            areEquals = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            EObjectCouple other = (EObjectCouple)obj;
            areEquals = this.int1.equals(other.int1) && this.int2.equals(other.int2);
        }
        return areEquals;
    }

    public EObject getObj1() {
        return this.obj1;
    }

    public EObject getObj2() {
        return this.obj2;
    }
}

