/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;
import org.eclipse.sirius.diagram.ui.business.internal.edit.helpers.EdgeReconnectionHelper;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;

public class SetReconnectingConnectionBendpointsCommand
extends SetConnectionBendpointsCommand {
    private EdgeReconnectionHelper reconnectingEdgeHelper;

    public SetReconnectingConnectionBendpointsCommand(TransactionalEditingDomain editingDomain, View reconnectionTarget, List<Edge> reconnectionTargetEdges, ReconnectionKind reconnectionKind) {
        super(editingDomain);
        this.reconnectingEdgeHelper = new EdgeReconnectionHelper(reconnectionTarget, reconnectionTargetEdges, reconnectionKind);
    }

    public Point getSourceRefPoint() {
        Edge edge = this.reconnectingEdgeHelper.getReconnectedEdge();
        if (edge != null) {
            Connection connection = (Connection)((GraphicalEditPart)GMFHelper.getGraphicalEditPart((View)edge).get()).getFigure();
            Point sourceRefPoint = connection.getSourceAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)sourceRefPoint);
            return sourceRefPoint;
        }
        return super.getSourceRefPoint();
    }

    public Point getTargetRefPoint() {
        Edge edge = this.reconnectingEdgeHelper.getReconnectedEdge();
        if (edge != null) {
            Connection connection = (Connection)((GraphicalEditPart)GMFHelper.getGraphicalEditPart((View)edge).get()).getFigure();
            Point targetRefPoint = connection.getTargetAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)targetRefPoint);
            return targetRefPoint;
        }
        return super.getTargetRefPoint();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)this.getNewPointList());
        Assert.isNotNull((Object)this.getSourceRefPoint());
        Assert.isNotNull((Object)this.getTargetRefPoint());
        Edge edge = this.reconnectingEdgeHelper.getReconnectedEdge();
        if (edge != null) {
            ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
            int numOfPoints = this.getNewPointList().size();
            int i = 0;
            while (i < numOfPoints) {
                Dimension s = this.getNewPointList().getPoint(i).getDifference(this.getSourceRefPoint());
                Dimension t = this.getNewPointList().getPoint(i).getDifference(this.getTargetRefPoint());
                newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
                i = (short)(i + 1);
            }
            RelativeBendpoints points = (RelativeBendpoints)edge.getBendpoints();
            points.setPoints(newBendpoints);
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation(edge, false);
            centerEdgeEndModelChangeOperation.execute();
        }
        return CommandResult.newOKCommandResult();
    }
}

