/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.BracketEdgeStyle;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class CustomizableQuery {
    private Customizable customizable;

    public CustomizableQuery(Customizable customizable) {
        this.customizable = customizable;
    }

    public List<String> getCustomizableFeatureNames() {
        ArrayList<String> customizableFeatureNames = new ArrayList<String>();
        for (EStructuralFeature feature : this.customizable.eClass().getEAllStructuralFeatures()) {
            if (ViewpointPackage.Literals.STYLE__DESCRIPTION.equals(feature) || ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES.equals(feature) || this.isUselessFeature(feature) || this.isGaugeCompositeSectionsFeature(feature) || this.isEdgeStyleBeginCenterEndFeature(feature)) continue;
            customizableFeatureNames.add(feature.getName());
        }
        return customizableFeatureNames;
    }

    private boolean isGaugeCompositeSectionsFeature(EStructuralFeature feature) {
        boolean isGaugeCompositeSectionsFeature = DiagramPackage.Literals.GAUGE_COMPOSITE_STYLE__SECTIONS.equals(feature);
        return isGaugeCompositeSectionsFeature;
    }

    private boolean isEdgeStyleBeginCenterEndFeature(EStructuralFeature feature) {
        boolean isEdgeStyleBeginCenterEndFeature = DiagramPackage.Literals.EDGE_STYLE__BEGIN_LABEL_STYLE.equals(feature) || DiagramPackage.Literals.EDGE_STYLE__CENTER_LABEL_STYLE.equals(feature) || DiagramPackage.Literals.EDGE_STYLE__END_LABEL_STYLE.equals(feature);
        return isEdgeStyleBeginCenterEndFeature;
    }

    private boolean isUselessFeature(EStructuralFeature feature) {
        return DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE.equals(feature) || DiagramPackage.Literals.HIDE_LABEL_CAPABILITY_STYLE__HIDE_LABEL_BY_DEFAULT.equals(feature) || DiagramPackage.Literals.SQUARE__WIDTH.equals(feature) || DiagramPackage.Literals.SQUARE__HEIGHT.equals(feature) || DiagramPackage.Literals.LOZENGE__WIDTH.equals(feature) || DiagramPackage.Literals.LOZENGE__HEIGHT.equals(feature) || DiagramPackage.Literals.DOT__STROKE_SIZE_COMPUTATION_EXPRESSION.equals(feature) || DiagramPackage.Literals.SHAPE_CONTAINER_STYLE__SHAPE.equals(feature) || this.customizable instanceof WorkspaceImage && this.customizable.eContainer() instanceof DDiagramElementContainer && DiagramPackage.Literals.NODE_STYLE__LABEL_POSITION.equals(feature) || this.customizable instanceof BracketEdgeStyle && DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.equals(feature);
    }
}

