/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusComponentEditPolicy;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies.DeleteHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;

public class NodeDeletionEditPolicy
extends SiriusComponentEditPolicy {
    TransactionalEditingDomain editingDomain;

    public NodeDeletionEditPolicy(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    protected org.eclipse.gef.commands.Command createDeleteSemanticCommand(GroupRequest deleteRequest) {
        CompoundCommand cc = new CompoundCommand();
        View view = (View)this.getHost().getModel();
        if (this.getHost().isActive() && view.getElement() instanceof DDiagramElement) {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)view);
            IAdaptable editor = (IAdaptable)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
            IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
            IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
            DDiagramElement viewPointElement = (DDiagramElement)view.getElement();
            IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(viewPointElement.getTarget());
            EObject target = viewPointElement.getTarget();
            if (target == null || target.eResource() == null || authority != null && !authority.canDeleteInstance(target)) {
                return UnexecutableCommand.INSTANCE;
            }
            cc.add(this.buildGlobalDeleteCommand(diagramCommandFactory, view, viewPointElement));
        }
        return cc;
    }

    private org.eclipse.gef.commands.Command buildGlobalDeleteCommand(IDiagramCommandFactory commandFactory, View view, DDiagramElement diagramElement) {
        CompositeCommand compositeCommand = new CompositeCommand("Delete element");
        Command buildedCommand = commandFactory.buildDeleteDiagramElement(diagramElement);
        boolean removeHideNote = DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiInternalPreferencesKeys.PREF_REMOVE_HIDE_NOTE_WHEN_ANNOTED_ELEMENT_HIDDEN_OR_REMOVE.name());
        if (removeHideNote) {
            DeleteHelper.addDeleteLinkedNotesTask(buildedCommand, view);
        } else {
            DeleteHelper.addDeleteLinkedNoteAttachmentsTask(buildedCommand, view);
        }
        compositeCommand.add((IUndoableOperation)new GMFCommandWrapper(this.editingDomain, buildedCommand));
        return new ICommandProxy(compositeCommand.reduce());
    }

    protected boolean shouldDeleteSemantic() {
        CanonicalEditPolicy cep;
        EditPart content;
        if (this.getHost() instanceof ConnectionNodeEditPart && this.getHost().getParent() instanceof DiagramRootEditPart && (content = ((DiagramRootEditPart)this.getHost().getParent()).getContents()) instanceof IGraphicalEditPart && (cep = (CanonicalEditPolicy)content.getEditPolicy((Object)"Canonical")) != null) {
            return cep.isEnabled();
        }
        return super.shouldDeleteSemantic();
    }
}

