/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.diagram;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.diagramtype.ICollapseUpdater;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionQuery;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CollapseUpdater;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.SetBestHeightHeaderCommand;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.AbstractCanonicalSynchronizer;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ConnectionsFactory;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramUpdater;
import org.eclipse.sirius.diagram.ui.part.SiriusLinkDescriptor;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;

public class DDiagramCanonicalSynchronizer
extends AbstractCanonicalSynchronizer {
    private Diagram gmfDiagram;
    private ConnectionsFactory connectionsFactory;

    public DDiagramCanonicalSynchronizer(Diagram gmfDiagram) {
        this.gmfDiagram = gmfDiagram;
        this.connectionsFactory = new ConnectionsFactory(gmfDiagram, this.viewpointViewProvider);
    }

    public void synchronize() {
        this.refreshSemantic();
    }

    private void refreshSemantic() {
        if (this.gmfDiagram != null && this.gmfDiagram.getElement() != null) {
            LinkedHashSet createdNodeViews = Sets.newLinkedHashSet();
            createdNodeViews.addAll(this.refreshSemanticChildren((View)this.gmfDiagram, this.gmfDiagram.getElement()));
            for (Object object : this.gmfDiagram.getChildren()) {
                createdNodeViews.addAll(this.refreshSemantic((View)object));
            }
            LinkedHashSet createdConnectionViews = Sets.newLinkedHashSet();
            createdConnectionViews.addAll(this.refreshConnections(this.gmfDiagram));
            Sets.SetView createdViews = Sets.union((Set)createdNodeViews, (Set)createdConnectionViews);
            this.manageCreatedViewsLayout((Set<View>)createdViews);
            this.manageCollapse(createdNodeViews);
            this.manageRegions();
        }
    }

    private void manageRegions() {
        for (EObject regionContainer : this.regionsToLayout) {
            if (!(regionContainer instanceof Node)) continue;
            new RegionContainerUpdateLayoutOperation((Node)regionContainer).execute();
        }
        this.regionsToLayout.clear();
    }

    private void manageCreatedViewsLayout(Set<View> createdViews) {
        Set filteredCreatedViewsToLayout = Sets.filter(createdViews, (Predicate)new Predicate<View>(){

            public boolean apply(View input) {
                return input.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getAdapterMarker());
            }
        });
        Set filteredCreatedViewsWithCenterLayout = Sets.filter(createdViews, (Predicate)new Predicate<View>(){

            public boolean apply(View input) {
                return input.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker());
            }
        });
        LinkedHashSet createdViewsWithCenterLayout = Sets.newLinkedHashSet((Iterable)filteredCreatedViewsWithCenterLayout);
        LinkedHashSet createdViewsToLayout = Sets.newLinkedHashSet((Iterable)filteredCreatedViewsToLayout);
        this.calculateCenterLayout(createdViewsWithCenterLayout, createdViewsToLayout);
        if (!createdViewsWithCenterLayout.isEmpty() && this.storeViews2Arrange) {
            SiriusLayoutDataManager.INSTANCE.addCreatedViewWithCenterLayout(this.gmfDiagram, Sets.newLinkedHashSet((Iterable)createdViewsWithCenterLayout));
            this.removeAlreadyArrangeMarker(filteredCreatedViewsWithCenterLayout);
        }
        if (!createdViewsToLayout.isEmpty() && this.storeViews2Arrange) {
            SiriusLayoutDataManager.INSTANCE.addCreatedViewsToLayout(this.gmfDiagram, Sets.newLinkedHashSet((Iterable)createdViewsToLayout));
            this.removeAlreadyArrangeMarker(filteredCreatedViewsToLayout);
        }
    }

    private void calculateCenterLayout(Set<View> createdViewsWithSpecialLayout, Set<View> createdViewsToLayout) {
        HashSet<View> toRemove = new HashSet<View>();
        for (View view : createdViewsWithSpecialLayout) {
            if (!this.hasContainer(view, createdViewsWithSpecialLayout)) continue;
            toRemove.add(view);
        }
        createdViewsToLayout.addAll(toRemove);
        createdViewsWithSpecialLayout.removeAll(toRemove);
    }

    private boolean hasContainer(View view, Set<View> createdViewsToLayout) {
        for (View aView : createdViewsToLayout) {
            if (view.equals(aView) || !this.hasContainer(view, aView)) continue;
            return true;
        }
        return false;
    }

    private boolean hasContainer(View view, View aView) {
        View eContainer = view;
        while (eContainer != null && !(eContainer instanceof AnnotationEntry) && !eContainer.equals(aView)) {
            eContainer = eContainer.eContainer();
        }
        return !(eContainer instanceof AnnotationEntry);
    }

    private void removeAlreadyArrangeMarker(Collection<View> createdViews) {
        block0: for (View view : createdViews) {
            Iterator iterator = view.eAdapters().iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private Collection<Edge> refreshConnections(Diagram diagram) {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<SiriusLinkDescriptor> linkDescriptors = this.collectAllLinks((View)diagram, domain2NotationMap);
        LinkedList<Edge> existingLinks = new LinkedList<Edge>((Collection<Edge>)diagram.getEdges());
        existingLinks.addAll(this.collectAllDanglingEdges(diagram));
        Collection<Edge> noteAttachments = this.collectAllNoteAttachments(diagram);
        existingLinks.removeAll(noteAttachments);
        Collection<Edge> lines = this.collectAllLines(diagram);
        existingLinks.removeAll(lines);
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject nextDiagramLinkEContainer = nextDiagramLink.eContainer();
            if (diagramLinkObject == null) continue;
            EObject diagramLinkEContainer = diagramLinkObject.eContainer();
            if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null || nextDiagramLink.getSource().eContainer() == null || nextDiagramLink.getTarget().eContainer() == null) continue;
            final EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            final EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            int diagramLinkVisualID = SiriusVisualIDRegistry.getVisualID((View)nextDiagramLink);
            Iterator<SiriusLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                SiriusLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                boolean exist = nextDiagramLinkEContainer != null && diagramLinkEContainer != null && diagramLinkObject == nextLinkDescriptor.getModelElement();
                boolean bl = exist = exist && diagramLinkSrc == nextLinkDescriptor.getSource() && diagramLinkDst == nextLinkDescriptor.getDestination() && diagramLinkVisualID == nextLinkDescriptor.getVisualID();
                if (exist && diagramLinkSrc instanceof DEdge) {
                    Predicate<SiriusLinkDescriptor> existingEdgeSource = new Predicate<SiriusLinkDescriptor>(){

                        public boolean apply(SiriusLinkDescriptor input) {
                            return input.getModelElement().equals(diagramLinkSrc);
                        }
                    };
                    boolean bl2 = exist = exist && Iterables.isEmpty((Iterable)Iterables.filter(linkDescriptors, (Predicate)existingEdgeSource));
                }
                if (exist && diagramLinkDst instanceof DEdge) {
                    Predicate<SiriusLinkDescriptor> existingEdgeTarget = new Predicate<SiriusLinkDescriptor>(){

                        public boolean apply(SiriusLinkDescriptor input) {
                            return input.getModelElement().equals(diagramLinkDst);
                        }
                    };
                    boolean bl3 = exist = exist && Iterables.isEmpty((Iterable)Iterables.filter(linkDescriptors, (Predicate)existingEdgeTarget));
                }
                if (!exist) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
            }
        }
        this.deleteViews(existingLinks);
        return this.createConnections(linkDescriptors, domain2NotationMap, diagram);
    }

    private Collection<Edge> createConnections(Collection<SiriusLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap, Diagram diagram) {
        ArrayList<Edge> createdEdges = new ArrayList<Edge>();
        for (SiriusLinkDescriptor viewDescriptor : linkDescriptors) {
            Edge createdEdge = this.connectionsFactory.createEdge(viewDescriptor, domain2NotationMap);
            if (createdEdge != null) {
                createdEdges.add(createdEdge);
            }
            this.collectAllLinks((View)this.gmfDiagram, domain2NotationMap);
        }
        return createdEdges;
    }

    private Collection<SiriusLinkDescriptor> collectAllLinks(View view, Map<EObject, View> domain2NotationMap) {
        if (!"Sirius".equals(SiriusVisualIDRegistry.getModelID(view))) {
            return Collections.emptyList();
        }
        LinkedList<SiriusLinkDescriptor> result = new LinkedList<SiriusLinkDescriptor>();
        result.addAll(SiriusDiagramUpdater.getDDiagram_1000ContainedLinks(view));
        AbstractTreeIterator<View> it = new AbstractTreeIterator<View>(view){

            protected Iterator<? extends View> getChildren(Object object) {
                if (object instanceof View) {
                    View view = (View)object;
                    EList children = view.getChildren();
                    return children.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (it.hasNext()) {
            View child = (View)it.next();
            if (domain2NotationMap.containsKey(child.getElement())) continue;
            domain2NotationMap.put(child.getElement(), child);
        }
        for (Edge edge : Iterables.filter((Iterable)((Diagram)view).getEdges(), Edge.class)) {
            if (domain2NotationMap.containsKey(edge.getElement())) continue;
            domain2NotationMap.put(edge.getElement(), (View)edge);
        }
        return result;
    }

    private Collection<Edge> collectAllDanglingEdges(Diagram diagram) {
        LinkedList<Edge> result = new LinkedList<Edge>();
        TreeIterator iterContents = diagram.eAllContents();
        while (iterContents.hasNext()) {
            EObject next = (EObject)iterContents.next();
            for (EReference eReference : next.eClass().getEAllReferences()) {
                if (!eReference.getEType().equals(NotationPackage.eINSTANCE.getEdge()) || eReference.isContainment() || !eReference.isMany()) continue;
                Collection values = (Collection)next.eGet((EStructuralFeature)eReference);
                for (Edge edge : values) {
                    if (edge.eContainer() != null) continue;
                    result.add(edge);
                }
            }
        }
        return result;
    }

    private Collection<Edge> collectAllNoteAttachments(Diagram diagram) {
        LinkedList<Edge> result = new LinkedList<Edge>();
        for (Edge currentEdge : diagram.getEdges()) {
            if (!"NoteAttachment".equals(currentEdge.getType())) continue;
            result.add(currentEdge);
        }
        return result;
    }

    private Collection<Edge> collectAllLines(Diagram diagram) {
        LinkedList<Edge> result = new LinkedList<Edge>();
        for (Edge currentEdge : diagram.getEdges()) {
            if (!"line".equals(currentEdge.getType())) continue;
            result.add(currentEdge);
        }
        return result;
    }

    private void manageCollapse(Set<View> createdNodeViews) {
        if (createdNodeViews.isEmpty() && !(this.gmfDiagram.getElement() instanceof DDiagram)) {
            return;
        }
        DDiagram dDiagram = (DDiagram)this.gmfDiagram.getElement();
        ICollapseUpdater cu = CollapseUpdater.getICollapseUpdater(dDiagram);
        for (Node node : Iterables.filter(createdNodeViews, Node.class)) {
            CollapseFilter filter;
            DDiagramElement dde;
            EObject element = node.getElement();
            if (!(element instanceof DDiagramElement) || !(cu instanceof CollapseUpdater) || !new DDiagramElementQuery(dde = (DDiagramElement)element).isIndirectlyCollapsed() || (filter = (CollapseFilter)Iterables.getFirst((Iterable)Iterables.filter((Iterable)dde.getGraphicalFilters(), (Predicate)Predicates.instanceOf(CollapseFilter.class)), null)) == null || filter.getWidth() != 0 || filter.getHeight() != 0) continue;
            ((CollapseUpdater)cu).storeInFilterAndCollapseBounds(dde, (Option<Node>)Options.newSome((Object)node), false);
        }
    }

    public void postCreation() {
        TransactionalEditingDomain domain;
        if (this.gmfDiagram != null && this.gmfDiagram.getElement() instanceof DDiagram && ((DDiagram)this.gmfDiagram.getElement()).getDescription() != null && new DiagramDescriptionQuery(((DDiagram)this.gmfDiagram.getElement()).getDescription()).isHeaderSectionEnabled() && (domain = TransactionUtil.getEditingDomain((EObject)this.gmfDiagram.getElement())) != null) {
            SetBestHeightHeaderCommand setBestHeightHeaderCommand = new SetBestHeightHeaderCommand(domain, this.gmfDiagram);
            setBestHeightHeaderCommand.execute();
        }
    }
}

