/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.diagram;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.color.RGBValuesProvider;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.BeginLabelStyle;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.CenterLabelStyle;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.Dot;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.EndLabelStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Lozenge;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.Note;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.swt.graphics.RGB;

public class ViewPropertiesSynchronizer {
    public static final Map<EStructuralFeature, EStructuralFeature> GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING = new HashMap<EStructuralFeature, EStructuralFeature>();
    private static final String DEFAULT_FONT_STYLE = "Arial";

    static {
        GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.put((EStructuralFeature)NotationPackage.Literals.FONT_STYLE__FONT_HEIGHT, (EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE);
        GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.put((EStructuralFeature)NotationPackage.Literals.FONT_STYLE__ITALIC, (EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT);
        GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.put((EStructuralFeature)NotationPackage.Literals.FONT_STYLE__BOLD, (EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT);
        GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.put((EStructuralFeature)NotationPackage.Literals.FONT_STYLE__UNDERLINE, (EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT);
        GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.put((EStructuralFeature)NotationPackage.Literals.FONT_STYLE__STRIKE_THROUGH, (EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT);
        GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.put((EStructuralFeature)NotationPackage.Literals.FONT_STYLE__FONT_COLOR, (EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_COLOR);
        GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.put((EStructuralFeature)NotationPackage.Literals.FONT_STYLE__FONT_HEIGHT, (EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE);
    }

    public void synchronizeViewProperties(View view) {
        EObject element = view.getElement();
        if (element instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)element;
            if (new ViewQuery(view).isForNameEditPart()) {
                view.setVisible(!new DDiagramElementQuery(dDiagramElement).isLabelHidden());
            } else {
                view.setVisible(dDiagramElement.isVisible());
            }
            if (dDiagramElement.getStyle() instanceof BasicLabelStyle) {
                BasicLabelStyle basicLabelStyle = (BasicLabelStyle)dDiagramElement.getStyle();
                this.updateGMFFontStyle(view, basicLabelStyle);
            } else if (dDiagramElement.getStyle() instanceof EdgeStyle) {
                EndLabelStyle endLabelStyle;
                CenterLabelStyle centerLabelStyle;
                EdgeStyle edgeStyle = (EdgeStyle)dDiagramElement.getStyle();
                BeginLabelStyle beginLabelStyle = edgeStyle.getBeginLabelStyle();
                if (beginLabelStyle != null) {
                    this.updateGMFFontStyle(view, (BasicLabelStyle)beginLabelStyle);
                }
                if ((centerLabelStyle = edgeStyle.getCenterLabelStyle()) != null) {
                    this.updateGMFFontStyle(view, (BasicLabelStyle)centerLabelStyle);
                }
                if ((endLabelStyle = edgeStyle.getEndLabelStyle()) != null) {
                    this.updateGMFFontStyle(view, (BasicLabelStyle)endLabelStyle);
                }
            }
        }
    }

    private void updateGMFFontStyle(View view, BasicLabelStyle basicLabelStyle) {
        RGBValues labelColor;
        FontStyle fontStyle = (FontStyle)this.createOrFindStyle(view, NotationPackage.eINSTANCE.getFontStyle());
        EList labelFormat = basicLabelStyle.getLabelFormat();
        if (fontStyle.isBold() != labelFormat.contains(FontFormat.BOLD_LITERAL)) {
            fontStyle.setBold(labelFormat.contains(FontFormat.BOLD_LITERAL));
        }
        if (fontStyle.isItalic() != labelFormat.contains(FontFormat.ITALIC_LITERAL)) {
            fontStyle.setItalic(labelFormat.contains(FontFormat.ITALIC_LITERAL));
        }
        if (fontStyle.isUnderline() != labelFormat.contains(FontFormat.UNDERLINE_LITERAL)) {
            fontStyle.setUnderline(labelFormat.contains(FontFormat.UNDERLINE_LITERAL));
        }
        if (fontStyle.isStrikeThrough() != labelFormat.contains(FontFormat.STRIKE_THROUGH_LITERAL)) {
            fontStyle.setStrikeThrough(labelFormat.contains(FontFormat.STRIKE_THROUGH_LITERAL));
        }
        fontStyle.setFontHeight(basicLabelStyle.getLabelSize());
        if (fontStyle.getFontName() == null) {
            fontStyle.setFontName(DEFAULT_FONT_STYLE);
        }
        if ((labelColor = basicLabelStyle.getLabelColor()) != null) {
            fontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)new RGB(labelColor.getRed(), labelColor.getGreen(), labelColor.getBlue())).intValue());
        }
    }

    public void synchronizeDDiagramElementStyleProperties(View view) {
        EObject element = view.getElement();
        if (element instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)element;
            LabelStyle labelStyle = null;
            if (dDiagramElement.getStyle() instanceof LabelStyle) {
                labelStyle = (LabelStyle)dDiagramElement.getStyle();
            } else if (dDiagramElement.getStyle() instanceof EdgeStyle) {
                EdgeStyle edgeStyle = (EdgeStyle)dDiagramElement.getStyle();
                labelStyle = edgeStyle.getCenterLabelStyle();
                BeginLabelStyle beginLabelStyle = edgeStyle.getBeginLabelStyle();
                EndLabelStyle endLabelStyle = edgeStyle.getEndLabelStyle();
                this.updateLabelStyle(view, (BasicLabelStyle)beginLabelStyle);
                this.updateLabelStyle(view, (BasicLabelStyle)endLabelStyle);
            }
            this.updateLabelStyle(view, (BasicLabelStyle)labelStyle);
        }
    }

    public void synchronizeDDiagramElementStyleColorProperties(View view, FixedColor newColor, String propertyId, IInterpreter interpreter) {
        NodeStyle nodeStyle;
        EObject element;
        if (view.getElement() instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)view.getElement();
            Style style = dDiagramElement.getStyle();
            List<EStructuralFeature> features = this.getFeatures(propertyId, style);
            if (Properties.ID_FONTCOLOR.equals(propertyId) && style instanceof EdgeStyle) {
                EdgeStyle edgeStyle = (EdgeStyle)style;
                if (edgeStyle.getBeginLabelStyle() != null) {
                    for (EStructuralFeature feature : features) {
                        if (edgeStyle.getBeginLabelStyle().getCustomFeatures().contains((Object)feature.getName())) continue;
                        edgeStyle.getBeginLabelStyle().getCustomFeatures().add((Object)feature.getName());
                    }
                }
                if (edgeStyle.getCenterLabelStyle() != null) {
                    for (EStructuralFeature feature : features) {
                        if (edgeStyle.getCenterLabelStyle().getCustomFeatures().contains((Object)feature.getName())) continue;
                        edgeStyle.getCenterLabelStyle().getCustomFeatures().add((Object)feature.getName());
                    }
                }
                if (edgeStyle.getEndLabelStyle() != null) {
                    for (EStructuralFeature feature : features) {
                        if (edgeStyle.getEndLabelStyle().getCustomFeatures().contains((Object)feature.getName())) continue;
                        edgeStyle.getEndLabelStyle().getCustomFeatures().add((Object)feature.getName());
                    }
                }
            } else {
                for (EStructuralFeature feature : features) {
                    if (style.getCustomFeatures().contains((Object)feature.getName())) continue;
                    style.getCustomFeatures().add((Object)feature.getName());
                }
            }
        }
        if ((element = view.getElement()) instanceof DNode) {
            DNode dNode = (DNode)element;
            nodeStyle = dNode.getOwnedStyle();
            if (Properties.ID_FILLCOLOR.equals(propertyId)) {
                this.setColor(nodeStyle, newColor);
            } else if (Properties.ID_LINECOLOR.equals(propertyId)) {
                this.setBorderColor((BorderedStyle)nodeStyle, newColor);
            } else if (Properties.ID_FONTCOLOR.equals(propertyId)) {
                this.setFontColor((LabelStyle)nodeStyle, newColor);
            }
        } else if (element instanceof DNodeListElement) {
            DNodeListElement dNodeListElement = (DNodeListElement)element;
            nodeStyle = dNodeListElement.getOwnedStyle();
            if (Properties.ID_FONTCOLOR.equals(propertyId)) {
                this.setFontColor((LabelStyle)nodeStyle, newColor);
            }
        } else if (element instanceof DDiagramElementContainer) {
            DDiagramElementContainer diagramElementContainer = (DDiagramElementContainer)element;
            ContainerStyle containerStyle = diagramElementContainer.getOwnedStyle();
            if (Properties.ID_FILLCOLOR.equals(propertyId)) {
                this.setColor(containerStyle, newColor);
            } else if (Properties.ID_LINECOLOR.equals(propertyId)) {
                this.setBorderColor((BorderedStyle)containerStyle, newColor);
            } else if (Properties.ID_FONTCOLOR.equals(propertyId)) {
                this.setFontColor((LabelStyle)containerStyle, newColor);
            }
        } else if (element instanceof DEdge) {
            DEdge dEdge = (DEdge)element;
            EdgeStyle edgeStyle = dEdge.getOwnedStyle();
            if (Properties.ID_LINECOLOR.equals(propertyId)) {
                edgeStyle.setStrokeColor(new RGBValuesProvider().getRGBValues(newColor));
            } else if (Properties.ID_FONTCOLOR.equals(propertyId)) {
                if (edgeStyle.getBeginLabelStyle() != null) {
                    edgeStyle.getBeginLabelStyle().setLabelColor(new RGBValuesProvider().getRGBValues(newColor));
                }
                if (edgeStyle.getCenterLabelStyle() != null) {
                    edgeStyle.getCenterLabelStyle().setLabelColor(new RGBValuesProvider().getRGBValues(newColor));
                }
                if (edgeStyle.getEndLabelStyle() != null) {
                    edgeStyle.getEndLabelStyle().setLabelColor(new RGBValuesProvider().getRGBValues(newColor));
                }
            }
        }
    }

    private List<EStructuralFeature> getFeatures(String gmfPropertyID, Style style) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        if (Properties.ID_FILLCOLOR.equals(gmfPropertyID)) {
            if (style instanceof Square) {
                features.add((EStructuralFeature)DiagramPackage.Literals.SQUARE__COLOR);
            } else if (style instanceof Lozenge) {
                features.add((EStructuralFeature)DiagramPackage.Literals.LOZENGE__COLOR);
            } else if (style instanceof Ellipse) {
                features.add((EStructuralFeature)DiagramPackage.Literals.ELLIPSE__COLOR);
            } else if (style instanceof Dot) {
                features.add((EStructuralFeature)DiagramPackage.Literals.DOT__BACKGROUND_COLOR);
            } else if (style instanceof Note) {
                features.add((EStructuralFeature)DiagramPackage.Literals.NOTE__COLOR);
            } else if (style instanceof BundledImage) {
                features.add((EStructuralFeature)DiagramPackage.Literals.BUNDLED_IMAGE__COLOR);
            } else if (style instanceof FlatContainerStyle) {
                features.add((EStructuralFeature)DiagramPackage.Literals.FLAT_CONTAINER_STYLE__BACKGROUND_COLOR);
                features.add((EStructuralFeature)DiagramPackage.Literals.FLAT_CONTAINER_STYLE__FOREGROUND_COLOR);
            } else if (style instanceof ShapeContainerStyle) {
                features.add((EStructuralFeature)DiagramPackage.Literals.SHAPE_CONTAINER_STYLE__BACKGROUND_COLOR);
            }
        } else if (Properties.ID_LINECOLOR.equals(gmfPropertyID)) {
            if (style instanceof EdgeStyle) {
                features.add((EStructuralFeature)DiagramPackage.Literals.EDGE_STYLE__STROKE_COLOR);
            } else {
                features.add((EStructuralFeature)DiagramPackage.Literals.BORDERED_STYLE__BORDER_COLOR);
            }
        } else if (Properties.ID_FONTCOLOR.equals(gmfPropertyID)) {
            features.add((EStructuralFeature)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_COLOR);
        }
        return features;
    }

    private void updateLabelStyle(View notationView, BasicLabelStyle labelStyle) {
        if (labelStyle != null) {
            ArrayList newFontFormats = Lists.newArrayList();
            FontStyle fontStyle = (FontStyle)this.createOrFindStyle(notationView, NotationPackage.eINSTANCE.getFontStyle());
            if (fontStyle.isBold()) {
                newFontFormats.add(FontFormat.BOLD_LITERAL);
            }
            if (fontStyle.isItalic()) {
                newFontFormats.add(FontFormat.ITALIC_LITERAL);
            }
            if (fontStyle.isUnderline()) {
                newFontFormats.add(FontFormat.UNDERLINE_LITERAL);
            }
            if (fontStyle.isStrikeThrough()) {
                newFontFormats.add(FontFormat.STRIKE_THROUGH_LITERAL);
            }
            FontFormatHelper.setFontFormat((List)labelStyle.getLabelFormat(), (Collection)newFontFormats);
            labelStyle.setLabelSize(fontStyle.getFontHeight());
        }
    }

    private org.eclipse.gmf.runtime.notation.Style createOrFindStyle(View view, EClass styleClass) {
        org.eclipse.gmf.runtime.notation.Style style = view.getStyle(styleClass);
        if (style == null) {
            style = (org.eclipse.gmf.runtime.notation.Style)styleClass.getEPackage().getEFactoryInstance().create(styleClass);
            view.getStyles().add((Object)style);
        }
        return style;
    }

    public void setColor(NodeStyle style, SystemColors color) {
        if (style instanceof Note) {
            ((Note)style).setColor(VisualBindingManager.getDefault().getRGBValuesFor(color));
        }
    }

    public void setBorderColor(BorderedStyle style, FixedColor color) {
        style.setBorderColor(new RGBValuesProvider().getRGBValues(color));
    }

    public void setFontColor(LabelStyle style, FixedColor color) {
        style.setLabelColor(new RGBValuesProvider().getRGBValues(color));
    }

    public void setColor(ContainerStyle style, SystemColors color) {
        if (style instanceof FlatContainerStyle) {
            ((FlatContainerStyle)style).setBackgroundColor(VisualBindingManager.getDefault().getRGBValuesFor(color));
            ((FlatContainerStyle)style).setForegroundColor(VisualBindingManager.getDefault().getRGBValuesFor(color));
        } else if (style instanceof ShapeContainerStyle) {
            ((ShapeContainerStyle)style).setBackgroundColor(VisualBindingManager.getDefault().getRGBValuesFor(color));
        }
    }

    public void setColor(ContainerStyle style, FixedColor color) {
        RGBValues rgb = new RGBValuesProvider().getRGBValues(color);
        if (style instanceof FlatContainerStyle) {
            ((FlatContainerStyle)style).setBackgroundColor(rgb);
            ((FlatContainerStyle)style).setForegroundColor(rgb);
        } else if (style instanceof ShapeContainerStyle) {
            ((ShapeContainerStyle)style).setBackgroundColor(rgb);
        }
    }

    public void setColor(NodeStyle style, FixedColor color) {
        RGBValues rgb = new RGBValuesProvider().getRGBValues(color);
        if (style instanceof Square) {
            ((Square)style).setColor(rgb);
        } else if (style instanceof Lozenge) {
            ((Lozenge)style).setColor(rgb);
        } else if (style instanceof Ellipse) {
            ((Ellipse)style).setColor(rgb);
        } else if (style instanceof Dot) {
            ((Dot)style).setBackgroundColor(rgb);
        } else if (style instanceof Note) {
            ((Note)style).setColor(rgb);
        } else if (style instanceof BundledImage) {
            ((BundledImage)style).setColor(rgb);
        }
    }
}

