/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.business.api.dialect.DRepresentationNotificationFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RefreshEdgeLayoutNotificationFilter
extends DRepresentationNotificationFilter {
    private static final Set<EStructuralFeature> INTERESTING_FEATURES = new HashSet<EStructuralFeature>();
    private static final Set<EStructuralFeature> INDIRECT_INTERESTING_FEATURES;

    static {
        INTERESTING_FEATURES.add((EStructuralFeature)DiagramPackage.Literals.DEDGE__OWNED_STYLE);
        INTERESTING_FEATURES.add((EStructuralFeature)DiagramPackage.Literals.EDGE_STYLE__CENTERED);
        INTERESTING_FEATURES.add((EStructuralFeature)NotationPackage.Literals.ROUTING_STYLE__ROUTING);
        INTERESTING_FEATURES.add((EStructuralFeature)NotationPackage.Literals.DIAGRAM__PERSISTED_EDGES);
        INDIRECT_INTERESTING_FEATURES = new HashSet<EStructuralFeature>();
        INDIRECT_INTERESTING_FEATURES.add((EStructuralFeature)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES);
        INDIRECT_INTERESTING_FEATURES.add((EStructuralFeature)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE);
    }

    public RefreshEdgeLayoutNotificationFilter(DDiagram dDiagram) {
        super((DRepresentation)dDiagram);
    }

    public boolean matches(Notification notification) {
        boolean matches = super.matches(notification) && notification.getNewValue() != null && INTERESTING_FEATURES.contains(notification.getFeature());
        return matches;
    }

    public boolean otherNotificationsAreIndirectlyConcerned(Notification notification, Collection<Notification> notifications) {
        boolean otherNotificationsAreIndirectlyConcerned = false;
        if (NotationPackage.Literals.ROUTING_STYLE__ROUTING == notification.getFeature() || DiagramPackage.Literals.EDGE_STYLE__CENTERED == notification.getFeature()) {
            for (Notification currentNotification : notifications) {
                if (currentNotification == notification || INDIRECT_INTERESTING_FEATURES.contains(currentNotification.getFeature())) continue;
                otherNotificationsAreIndirectlyConcerned = true;
                break;
            }
        }
        return otherNotificationsAreIndirectlyConcerned;
    }
}

