/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.distribute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.requests.DistributeRequest;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.ui.IWorkbenchPage;

public class DistributeAction
extends DiagramAction {
    public static final int GAPS_HORIZONTALLY = 0;
    public static final int CENTERS_HORIZONTALLY = 1;
    public static final int GAPS_VERTICALLY = 2;
    public static final int CENTERS_VERTICALLY = 3;
    private static final String DISTRIBUTE_PREFIX = "Distribute ";
    private static final String GAPS_HORIZONTALLY_LABEL = "Gaps Horizontally";
    private static final String CENTERS_HORIZONTALLY_LABEL = "Centers Horizontally";
    private static final String GAPS_VERTICALLY_LABEL = "Gaps Vertically";
    private static final String CENTERS_VERTICALLY_LABEL = "Centers Vertically";
    private static final String GAPS_HORIZONTALLY_TOOLTIP = "Distribute With Uniform Gaps Horizontally";
    private static final String CENTERS_HORIZONTALLY_TOOLTIP = "Distribute Centers Evenly Horizontally";
    private static final String GAPS_VERTICALLY_TOOLTIP = "Distribute With Uniform Gaps Vertically";
    private static final String CENTERS_VERTICALLY_TOOLTIP = "Distribute Centers Evenly Vertically";
    private int distributeType;

    protected DistributeAction(IWorkbenchPage workbenchPage, int distributeType, boolean isToolbarItem) {
        super(workbenchPage);
        this.distributeType = distributeType;
        this.setText(DistributeAction.getLabel(distributeType, isToolbarItem));
        this.setToolTipText(DistributeAction.getTooltip(distributeType));
    }

    public static String getLabel(int distributeType, boolean isToolbarItem) {
        String label = "";
        switch (distributeType) {
            case 0: {
                label = GAPS_HORIZONTALLY_LABEL;
                break;
            }
            case 1: {
                label = CENTERS_HORIZONTALLY_LABEL;
                break;
            }
            case 2: {
                label = GAPS_VERTICALLY_LABEL;
                break;
            }
            case 3: {
                label = CENTERS_VERTICALLY_LABEL;
                break;
            }
        }
        if (isToolbarItem && !"".equals(label)) {
            label = DISTRIBUTE_PREFIX + label;
        }
        return label;
    }

    public static String getTooltip(int distributeType) {
        String tooltip = "";
        switch (distributeType) {
            case 0: {
                tooltip = GAPS_HORIZONTALLY_TOOLTIP;
                break;
            }
            case 1: {
                tooltip = CENTERS_HORIZONTALLY_TOOLTIP;
                break;
            }
            case 2: {
                tooltip = GAPS_VERTICALLY_TOOLTIP;
                break;
            }
            case 3: {
                tooltip = CENTERS_VERTICALLY_TOOLTIP;
                break;
            }
        }
        return tooltip;
    }

    public static DistributeAction createDistributeHorizontallyWithUniformGapsAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 0, isToolbarItem);
        action.setId("distributeGapsHorizontally");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeWithUniformGapHorizontal.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static DistributeAction createDistributeCentersHorizontallyAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 1, isToolbarItem);
        action.setId("distributeCentersHorizontally");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeCentersHorizontal.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static DistributeAction createDistributeVerticallyWithUniformGapsAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 2, isToolbarItem);
        action.setId("distributeGapsVertically");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeWithUniformGapVertical.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static DistributeAction createDistributeCentersVerticallyAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 3, isToolbarItem);
        action.setId("distributeCentersVertically");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeCentersVertical.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    protected Request createTargetRequest() {
        DistributeRequest distributionRequest = new DistributeRequest();
        distributionRequest.setDistributeType(this.distributeType);
        return distributionRequest;
    }

    protected void updateTargetRequest() {
        DistributeRequest distributionRequest = (DistributeRequest)this.getTargetRequest();
        distributionRequest.setDistributeType(this.distributeType);
        distributionRequest.setEditParts(this.getOperationSet());
    }

    protected Command getCommand() {
        EditPart targetEP;
        Command cmd = null;
        List operationSet = this.getOperationSet();
        if (!operationSet.isEmpty() && (targetEP = this.getTargetEditPartForDistributeSelection(operationSet)) != null) {
            cmd = targetEP.getCommand(this.getTargetRequest());
        }
        return cmd;
    }

    protected List<?> createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            selection = Collections.EMPTY_LIST;
        } else {
            selection = ToolUtilities.getSelectionWithoutDependants((List)selection);
            if ((selection = Lists.newArrayList((Iterable)Iterables.filter((Iterable)selection, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ConnectionEditPart.class))))).size() < 3) {
                selection = Collections.EMPTY_LIST;
            } else {
                EditPart parent = ((EditPart)selection.get(0)).getParent();
                int sideOfFirstSelection = 0;
                if (selection.get(0) instanceof IBorderItemEditPart && !this.isHorizontalAxisAuthorizedForBorderNode(sideOfFirstSelection = ((IBorderItemEditPart)selection.get(0)).getBorderItemLocator().getCurrentSideOfParent()) && !this.isVerticalAxisAuthorizedForBorderNode(sideOfFirstSelection)) {
                    selection = Collections.EMPTY_LIST;
                }
                int i = 1;
                while (i < selection.size()) {
                    EditPartQuery containerLayoutQuery;
                    EditPart part = (EditPart)selection.get(i);
                    if (part.getParent() != parent) {
                        selection = Collections.EMPTY_LIST;
                        break;
                    }
                    if (sideOfFirstSelection != 0 && !this.isABorderNodeOnSameAxis(part, sideOfFirstSelection)) {
                        selection = Collections.EMPTY_LIST;
                        break;
                    }
                    if (part instanceof IGraphicalEditPart && !(containerLayoutQuery = new EditPartQuery((IGraphicalEditPart)part)).isFreeFormContainerChildrenPresentation()) {
                        selection = Collections.EMPTY_LIST;
                        break;
                    }
                    ++i;
                }
            }
        }
        return selection;
    }

    private boolean isHorizontalAxisAuthorizedForBorderNode(int side) {
        return this.isOnHorizontalAxis(side) && (this.distributeType == 0 || this.distributeType == 1);
    }

    private boolean isVerticalAxisAuthorizedForBorderNode(int side) {
        return this.isOnVerticalAxis(side) && (this.distributeType == 2 || this.distributeType == 3);
    }

    private boolean isABorderNodeOnSameAxis(EditPart part, int expectedSide) {
        boolean result = false;
        if (part instanceof IBorderItemEditPart) {
            int currentSide = ((IBorderItemEditPart)part).getBorderItemLocator().getCurrentSideOfParent();
            if (this.isOnHorizontalAxis(expectedSide) && this.isOnHorizontalAxis(currentSide) || this.isOnVerticalAxis(expectedSide) && this.isOnVerticalAxis(currentSide)) {
                result = true;
            }
        }
        return result;
    }

    private boolean isOnHorizontalAxis(int side) {
        return side == 1 || side == 4;
    }

    private boolean isOnVerticalAxis(int side) {
        return side == 16 || side == 8;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }

    private EditPart getTargetEditPartForDistributeSelection(List<?> editparts) {
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        if (parent != null) {
            int i = 1;
            while (i < editparts.size()) {
                EditPart part = (EditPart)editparts.get(i);
                if (part.getParent() != parent) {
                    return null;
                }
                ++i;
            }
        }
        return parent;
    }
}

