/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.internal.operation.RemoveBendpointsOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveBendpointsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ArrayList<RecordingCommand> commands = new ArrayList<RecordingCommand>();
            TransactionalEditingDomain ted = this.computeCommandsToExecute(selection, commands);
            if (commands.size() > 0 && ted != null) {
                CompoundCommand cc = new CompoundCommand("Remove Bend-points");
                for (RecordingCommand command : commands) {
                    cc.append((Command)command);
                }
                ted.getCommandStack().execute((Command)cc);
            }
        }
        return null;
    }

    private TransactionalEditingDomain computeCommandsToExecute(ISelection selection, List<RecordingCommand> commands) {
        TransactionalEditingDomain ted = null;
        for (Object currentSelectedObject : (IStructuredSelection)selection) {
            if (!(currentSelectedObject instanceof ConnectionNodeEditPart)) continue;
            if (ted == null) {
                ted = ((ConnectionNodeEditPart)currentSelectedObject).getEditingDomain();
            }
            RecordingCommand command = CommandFactory.createRecordingCommand(ted, new RemoveBendpointsOperation((ConnectionNodeEditPart)currentSelectedObject));
            commands.add(command);
        }
        return ted;
    }
}

