/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect.description;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.DefaultInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramStyleInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramToolInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.internal.dialect.description.FilterInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.concern.ConcernPackage;
import org.eclipse.sirius.diagram.description.filter.FilterPackage;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DiagramInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    private static final String DIAGRAM_D_SEMANTIC_DIAGRAM = "diagram.DSemanticDiagram";
    private static final String DIAGRAM_D_NODE = "diagram.DNode";
    private static final String DIAGRAM_D_NODE_LIST = "diagram.DNodeList";
    private static final String DIAGRAM_D_NODE_CONTAINER = "diagram.DNodeContainer";
    private static final String DIAGRAM_D_EDGE_TYPE = "diagram.DEdge";
    private static final String DIAGRAM_EDGE_TARGET_TYPE = "diagram.EdgeTarget";

    public DiagramInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        super(target, feature);
    }

    public Collection<EPackage> getPackagesToImport() {
        Collection superResult = super.getPackagesToImport();
        superResult.add(DiagramPackage.eINSTANCE);
        superResult.add(DescriptionPackage.eINSTANCE);
        superResult.add(StylePackage.eINSTANCE);
        superResult.add(ToolPackage.eINSTANCE);
        superResult.add(FilterPackage.eINSTANCE);
        superResult.add(ConcernPackage.eINSTANCE);
        return superResult;
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new DiagramGlobalInterpretedTargetSwitch();
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<VariableType>> definitions, EObject context) {
        super.appendAllLocalVariableDefinitions(definitions, context);
        if (context instanceof DirectEditLabel && ((DirectEditLabel)context).getMask() != null) {
            EditMaskVariables emv = ((DirectEditLabel)context).getMask();
            this.appendEditMaskVariables(emv, definitions);
        }
        if (context instanceof CreateView) {
            this.availableVariables.put(((CreateView)context).getVariableName(), VariableType.ANY_EOBJECT);
        }
    }

    protected void collectContextualVariableForOperation(EObject current, Map<String, Collection<VariableType>> definitions, EObject leaf) {
        super.collectContextualVariableForOperation(current, definitions, leaf);
        if (current instanceof CreateView) {
            CreateView op = (CreateView)current;
            DiagramElementMapping mapping = op.getMapping();
            if (mapping instanceof NodeMapping) {
                this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_NODE));
            } else if (mapping instanceof ContainerMapping) {
                if (((ContainerMapping)mapping).getChildrenPresentation() == ContainerLayout.LIST) {
                    this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_NODE_LIST));
                } else {
                    this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_NODE_CONTAINER));
                }
            } else if (mapping instanceof EdgeMapping) {
                this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_EDGE_TYPE));
            }
        }
    }

    public Map<String, VariableType> getAvailableVariables() {
        Map availableVariables = super.getAvailableVariables();
        if (this.getToolContext().some()) {
            LinkedHashSet possibleViewTypes;
            String domainClass;
            LinkedHashSet possibleSemanticTypes;
            Object tool;
            EObject operationContext = (EObject)this.getToolContext().get();
            if (operationContext instanceof EdgeCreationDescription) {
                tool = (EdgeCreationDescription)operationContext;
                this.declareEdgeSourceTargets(availableVariables, (Collection<EdgeMapping>)tool.getEdgeMappings(), (Collection<DiagramElementMapping>)tool.getExtraSourceMappings(), (Collection<DiagramElementMapping>)tool.getExtraTargetMappings());
            }
            if (operationContext instanceof ReconnectEdgeDescription) {
                tool = (ReconnectEdgeDescription)operationContext;
                this.declareEdgeSourceTargets(availableVariables, (Collection<EdgeMapping>)tool.getMappings(), (Collection<DiagramElementMapping>)Collections.<DiagramElementMapping>emptyList(), (Collection<DiagramElementMapping>)Collections.<DiagramElementMapping>emptyList());
                availableVariables.put("otherEnd", VariableType.fromString((String)DIAGRAM_EDGE_TARGET_TYPE));
                availableVariables.put("edgeView", VariableType.fromString((String)DIAGRAM_D_EDGE_TYPE));
                ArrayList possibleSources = Lists.newArrayList();
                for (EdgeMapping eMapping : tool.getMappings()) {
                    this.collectSemanticElementType(possibleSources, eMapping);
                }
                this.refineVariableType(availableVariables, "element", possibleSources);
            }
            if (operationContext instanceof NodeCreationDescription) {
                tool = (NodeCreationDescription)operationContext;
                possibleSemanticTypes = Sets.newLinkedHashSet();
                for (AbstractNodeMapping np : tool.getExtraMappings()) {
                    domainClass = np.getDomainClass();
                    if (StringUtil.isEmpty((String)domainClass)) continue;
                    possibleSemanticTypes.add(domainClass);
                }
                possibleViewTypes = Sets.newLinkedHashSet();
                this.collectPotentialContainerTypes((Collection<String>)possibleSemanticTypes, (Collection<String>)possibleViewTypes, (Collection<? extends AbstractNodeMapping>)tool.getNodeMappings());
                this.refineVariableType(availableVariables, "container", possibleSemanticTypes);
                this.refineVariableType(availableVariables, "containerView", possibleViewTypes);
            }
            if (operationContext instanceof ContainerCreationDescription) {
                tool = (ContainerCreationDescription)operationContext;
                LinkedHashSet possibleTypes = Sets.newLinkedHashSet();
                for (AbstractNodeMapping np : tool.getExtraMappings()) {
                    domainClass = np.getDomainClass();
                    if (StringUtil.isEmpty((String)domainClass)) continue;
                    possibleTypes.add(domainClass);
                }
                this.collectPotentialContainerTypes((Collection<String>)possibleTypes, (Collection<String>)Sets.newLinkedHashSet(), (Collection<? extends AbstractNodeMapping>)tool.getContainerMappings());
                this.refineVariableType(availableVariables, "container", possibleTypes);
            }
            if (operationContext instanceof DeleteElementDescription) {
                tool = (DeleteElementDescription)operationContext;
                possibleSemanticTypes = Sets.newLinkedHashSet();
                possibleViewTypes = Sets.newLinkedHashSet();
                LinkedHashSet possibleContainerViewTypes = Sets.newLinkedHashSet();
                for (DiagramElementMapping mapping : tool.getMappings()) {
                    this.collectTypes(possibleSemanticTypes, possibleViewTypes, mapping);
                    this.collectPotentialContainerTypes((Collection<String>)Sets.newLinkedHashSet(), (Collection<String>)possibleContainerViewTypes, mapping);
                }
                this.refineVariableType(availableVariables, "element", possibleSemanticTypes);
                this.refineVariableType(availableVariables, "elementView", possibleViewTypes);
                this.refineVariableType(availableVariables, "containerView", possibleContainerViewTypes);
            }
            if (operationContext instanceof OperationAction && new EObjectQuery((EObject)(tool = (OperationAction)operationContext)).getFirstAncestorOfType(DescriptionPackage.Literals.DIAGRAM_DESCRIPTION).some()) {
                availableVariables.put("diagram", VariableType.fromString((String)DIAGRAM_D_SEMANTIC_DIAGRAM));
            }
        }
        if (this.target instanceof EdgeCreationDescription && ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION.equals(this.feature)) {
            availableVariables.put("diagram", VariableType.fromString((String)"diagram.DDiagram"));
            availableVariables.put("preSource", VariableType.fromString((String)"ecore.EObject"));
            availableVariables.put("preSourceView", VariableType.fromString((String)DIAGRAM_EDGE_TARGET_TYPE));
            availableVariables.put("preTarget", VariableType.fromString((String)"ecore.EObject"));
            availableVariables.put("preTargetView", VariableType.fromString((String)DIAGRAM_EDGE_TARGET_TYPE));
        }
        return availableVariables;
    }

    private void refineVariableType(Map<String, VariableType> availableVariables, String variableName, Collection<String> foundTypes) {
        if (foundTypes.size() > 0) {
            availableVariables.put(variableName, VariableType.fromStrings(foundTypes));
        }
    }

    private void collectPotentialContainerTypes(Collection<String> possibleSemanticTypes, Collection<String> possibleViewTypes, Collection<? extends AbstractNodeMapping> toolMappings) {
        for (AbstractNodeMapping abstractNodeMapping : toolMappings) {
            this.collectPotentialContainerTypes(possibleSemanticTypes, possibleViewTypes, abstractNodeMapping);
        }
    }

    private void collectPotentialContainerTypes(Collection<String> possibleSemanticTypes, Collection<String> possibleViewTypes, DiagramElementMapping mapping) {
        String domainClass;
        EObject container = mapping.eContainer();
        if (container instanceof Layer) {
            container = container.eContainer();
        }
        if (container instanceof AbstractNodeMapping) {
            domainClass = ((AbstractNodeMapping)container).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSemanticTypes.add(domainClass);
            }
            this.collectViewTypes(possibleViewTypes, (AbstractNodeMapping)container);
        } else if (container instanceof DiagramDescription) {
            domainClass = ((DiagramDescription)container).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSemanticTypes.add(domainClass);
            }
            possibleViewTypes.add(DIAGRAM_D_SEMANTIC_DIAGRAM);
        }
        ECrossReferenceAdapter crossReferencer = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)mapping);
        if (crossReferencer != null) {
            for (EStructuralFeature.Setting xRef : crossReferencer.getInverseReferences((EObject)mapping)) {
                String domainClass2;
                EStructuralFeature eStructuralFeature = xRef.getEStructuralFeature();
                EObject referencingObject = xRef.getEObject();
                if (eStructuralFeature == DescriptionPackage.Literals.DIAGRAM_DESCRIPTION__REUSED_MAPPINGS && referencingObject instanceof DiagramDescription) {
                    domainClass2 = ((DiagramDescription)referencingObject).getDomainClass();
                    if (StringUtil.isEmpty((String)domainClass2)) continue;
                    possibleSemanticTypes.add(domainClass2);
                    continue;
                }
                if (eStructuralFeature == DescriptionPackage.Literals.ABSTRACT_NODE_MAPPING__REUSED_BORDERED_NODE_MAPPINGS && referencingObject instanceof AbstractNodeMapping) {
                    domainClass2 = ((AbstractNodeMapping)referencingObject).getDomainClass();
                    if (StringUtil.isEmpty((String)domainClass2)) continue;
                    possibleSemanticTypes.add(domainClass2);
                    continue;
                }
                if (eStructuralFeature != DescriptionPackage.Literals.CONTAINER_MAPPING__REUSED_CONTAINER_MAPPINGS && eStructuralFeature != DescriptionPackage.Literals.CONTAINER_MAPPING__REUSED_NODE_MAPPINGS || !(referencingObject instanceof ContainerMapping) || StringUtil.isEmpty((String)(domainClass2 = ((ContainerMapping)referencingObject).getDomainClass()))) continue;
                possibleSemanticTypes.add(domainClass2);
            }
        }
    }

    private void declareEdgeSourceTargets(Map<String, VariableType> availableVariables, Collection<EdgeMapping> eMappings, Collection<DiagramElementMapping> extraSourceMappings, Collection<DiagramElementMapping> extraTargetMappings) {
        LinkedHashSet possibleSemanticSources = Sets.newLinkedHashSet();
        LinkedHashSet possibleViewSources = Sets.newLinkedHashSet();
        LinkedHashSet possibleSemanticTargets = Sets.newLinkedHashSet();
        LinkedHashSet possibleViewTargets = Sets.newLinkedHashSet();
        for (EdgeMapping eMapping : eMappings) {
            for (DiagramElementMapping endMapping : eMapping.getSourceMapping()) {
                this.collectTypes(possibleSemanticSources, possibleViewSources, endMapping);
            }
            for (DiagramElementMapping endMapping : eMapping.getTargetMapping()) {
                this.collectTypes(possibleSemanticTargets, possibleViewTargets, endMapping);
            }
        }
        for (DiagramElementMapping extraSource : extraSourceMappings) {
            this.collectTypes(possibleSemanticSources, possibleViewSources, extraSource);
        }
        for (DiagramElementMapping extraTarget : extraTargetMappings) {
            this.collectTypes(possibleSemanticTargets, possibleViewTargets, extraTarget);
        }
        this.refineVariableType(availableVariables, "sourceView", possibleViewSources);
        this.refineVariableType(availableVariables, "targetView", possibleViewTargets);
        this.refineVariableType(availableVariables, "preSource", possibleSemanticSources);
        this.refineVariableType(availableVariables, "source", possibleSemanticSources);
        if (this.feature != ToolPackage.Literals.EDGE_CREATION_DESCRIPTION__CONNECTION_START_PRECONDITION) {
            this.refineVariableType(availableVariables, "preTarget", possibleSemanticTargets);
            this.refineVariableType(availableVariables, "target", possibleSemanticTargets);
        }
    }

    private void collectTypes(Collection<String> possibleSemanticTypes, Collection<String> possibleViewTypes, DiagramElementMapping endMapping) {
        this.collectViewTypes(possibleViewTypes, endMapping);
        if (endMapping instanceof AbstractNodeMapping) {
            String domainClass = ((AbstractNodeMapping)endMapping).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSemanticTypes.add(domainClass);
            }
        } else if (endMapping instanceof EdgeMapping) {
            EdgeMapping edgeMapping = (EdgeMapping)endMapping;
            this.collectSemanticElementType(possibleSemanticTypes, edgeMapping);
        }
    }

    private void collectViewTypes(Collection<String> possibleViewTypes, DiagramElementMapping endMapping) {
        if (endMapping instanceof ContainerMapping) {
            if (((ContainerMapping)endMapping).getChildrenPresentation() == ContainerLayout.LIST) {
                possibleViewTypes.add(DIAGRAM_D_NODE_LIST);
            } else {
                possibleViewTypes.add(DIAGRAM_D_NODE_CONTAINER);
            }
        } else if (endMapping instanceof NodeMapping) {
            possibleViewTypes.add(DIAGRAM_D_NODE);
        } else if (endMapping instanceof EdgeMapping) {
            possibleViewTypes.add(DIAGRAM_D_EDGE_TYPE);
        }
    }

    private void collectSemanticElementType(Collection<String> possibleSources, EdgeMapping edgeMapping) {
        if (edgeMapping.isUseDomainElement()) {
            String domainClass = edgeMapping.getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSources.add(domainClass);
            }
        } else {
            for (AbstractNodeMapping nMapping : Iterables.filter(edgeMapping.getSourceMapping(), AbstractNodeMapping.class)) {
                String domainClass = nMapping.getDomainClass();
                if (StringUtil.isEmpty((String)domainClass)) continue;
                possibleSources.add(domainClass);
            }
        }
    }

    private class DiagramGlobalInterpretedTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private DefaultInterpretedExpressionTargetSwitch defaultSwitch;
        private DiagramInterpretedExpressionTargetSwitch diagramDescriptionSwitch;
        private DiagramStyleInterpretedExpressionTargetSwitch diagramStyleSwitch;
        private DiagramToolInterpretedExpressionTargetSwitch diagramToolSwitch;
        private FilterInterpretedExpressionTargetSwitch diagramFilterSwitch;

        private DiagramGlobalInterpretedTargetSwitch() {
            this.defaultSwitch = new DefaultInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this){

                public EObject getFirstRelevantContainer(EObject obj) {
                    return DiagramGlobalInterpretedTargetSwitch.this.getFirstRelevantContainer(obj);
                }
            };
            this.diagramDescriptionSwitch = new DiagramInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
            this.diagramStyleSwitch = new DiagramStyleInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
            this.diagramToolSwitch = new DiagramToolInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
            this.diagramFilterSwitch = new FilterInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = Sets.newLinkedHashSet();
            Option expressionTarget = Options.newSome((Object)targetTypes);
            if (target != null) {
                for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                    IInterpretedExpressionTargetSwitch contributedSwitch;
                    if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(target.eClass().getEPackage()) || (contributedSwitch = diagramTypeDescriptor.getDiagramDescriptionProvider().createInterpretedExpressionSwitch(DiagramInterpretedExpressionQuery.this.feature, this)) == null) continue;
                    expressionTarget = contributedSwitch.doSwitch(target, considerFeature);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramDescriptionSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramDescriptionSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramStyleSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramStyleSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramToolSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramToolSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramFilterSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramFilterSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    expressionTarget = this.defaultSwitch.doSwitch(target, considerFeature);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            if (obj != null) {
                EObject container = obj.eContainer();
                while (container != null && !this.isRelevant(container)) {
                    container = container.eContainer();
                }
                return container;
            }
            return null;
        }

        private boolean isRelevant(EObject container) {
            return container instanceof RepresentationDescription || container instanceof RepresentationElementMapping || container instanceof EdgeMappingImport || container instanceof DiagramExtensionDescription;
        }
    }
}

