/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.tool.BehaviorTool;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.DoubleClickDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.view.CreateDiagramWithInitialOperation;
import org.eclipse.sirius.diagram.tools.api.command.view.HideDDiagramElement;
import org.eclipse.sirius.diagram.tools.api.command.view.HideDDiagramElementLabel;
import org.eclipse.sirius.diagram.tools.api.command.view.RefreshSiriusElement;
import org.eclipse.sirius.diagram.tools.api.command.view.RevealAllElementsCommand;
import org.eclipse.sirius.diagram.tools.api.command.view.RevealDDiagramElements;
import org.eclipse.sirius.diagram.tools.api.command.view.RevealDDiagramElementsLabel;
import org.eclipse.sirius.diagram.tools.internal.command.builders.ContainerCreationCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.DeletionCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.DirectEditCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.DoubleClickCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.DragAndDropCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.EdgeCreationCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.GenericToolCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.NodeCreationCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.PaneBasedSelectionWizardCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.PasteCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.ReconnectionCommandBuilder;
import org.eclipse.sirius.diagram.tools.internal.command.builders.SelectionWizardCommandBuilder;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.AbstractCommandFactory;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.command.view.JavaActionFromToolCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ContainerViewVariable;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.NameVariable;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;

public class UndoRedoCapableEMFCommandFactory
extends AbstractCommandFactory
implements IDiagramCommandFactory {
    private TaskHelper commandTaskHelper;

    public UndoRedoCapableEMFCommandFactory(TransactionalEditingDomain domain) {
        super(domain);
        this.commandTaskHelper = new TaskHelper(this.modelAccessor, this.uiCallBack);
    }

    private IPermissionAuthority getPermissionAuthority() {
        return this.modelAccessor.getPermissionAuthority();
    }

    @Override
    public Command buildLaunchRuleCommandFromTool(DSemanticDecorator rootObject, BehaviorTool tool, boolean executeFromRootContainer, boolean deepProcess) {
        EObject root = rootObject.getTarget();
        if (root != null) {
            if (executeFromRootContainer) {
                root = EcoreUtil.getRootContainer((EObject)root);
            }
            Option representation = new EObjectQuery((EObject)rootObject).getRepresentation();
            SiriusCommand result = new SiriusCommand(this.domain, tool.getName());
            if ((representation.some() && tool.getDomainClass() == null || StringUtil.isEmpty((String)tool.getDomainClass().trim()) || this.modelAccessor.eInstanceOf(root, tool.getDomainClass())) && this.commandTaskHelper.checkPrecondition(root, (AbstractToolDescription)tool) && tool.getInitialOperation() != null && tool.getInitialOperation().getFirstModelOperations() != null) {
                result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)representation.get(), root, tool.getInitialOperation().getFirstModelOperations()));
            }
            if (representation.some() && deepProcess) {
                TreeIterator iterContents = root.eAllContents();
                while (iterContents.hasNext()) {
                    EObject current = (EObject)iterContents.next();
                    if (tool.getDomainClass() != null && !StringUtil.isEmpty((String)tool.getDomainClass().trim()) && !this.modelAccessor.eInstanceOf(current, tool.getDomainClass()) || !this.commandTaskHelper.checkPrecondition(current, (AbstractToolDescription)tool)) continue;
                    result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)representation.get(), current, tool.getInitialOperation().getFirstModelOperations()));
                }
            }
            this.addRefreshTask(rootObject, (DCommand)result, tool);
            return result;
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildCreateNodeCommandFromTool(DDiagramElementContainer container, NodeCreationDescription tool) {
        NodeCreationCommandBuilder builder = new NodeCreationCommandBuilder(tool, container);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildCreateNodeCommandFromTool(DNode node, NodeCreationDescription tool) {
        NodeCreationCommandBuilder builder = new NodeCreationCommandBuilder(tool, node);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildCreateNodeCommandFromTool(DDiagram diagram, NodeCreationDescription tool) {
        NodeCreationCommandBuilder builder = new NodeCreationCommandBuilder(tool, diagram);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildCreateContainerCommandFromTool(DDiagram diagram, ContainerCreationDescription tool) {
        ContainerCreationCommandBuilder builder = new ContainerCreationCommandBuilder(tool, diagram);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildCreateContainerCommandFromTool(DDiagramElementContainer nodeContainer, ContainerCreationDescription tool) {
        ContainerCreationCommandBuilder builder = new ContainerCreationCommandBuilder(tool, nodeContainer);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildSelectionWizardCommandFromTool(SelectionWizardDescription tool, DSemanticDecorator containerView, Collection<EObject> selectedElement) {
        SelectionWizardCommandBuilder builder = new SelectionWizardCommandBuilder(tool, containerView, selectedElement);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildPaneBasedSelectionWizardCommandFromTool(PaneBasedSelectionWizardDescription tool, DSemanticDecorator containerView, Collection<EObject> selectedElement) {
        PaneBasedSelectionWizardCommandBuilder builder = new PaneBasedSelectionWizardCommandBuilder(tool, containerView, selectedElement);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildJavaActionFromTool(ExternalJavaAction tool, Collection<DSemanticDecorator> containerViews, IExternalJavaAction javaAction) {
        EObject anySemantic = containerViews.iterator().next().getTarget();
        CompoundCommand compoundCommand = new CompoundCommand();
        SiriusCommand dCommand = new SiriusCommand(this.domain, tool.getName());
        Command command = this.buildJavaActionFromTool(tool, anySemantic, containerViews, javaAction);
        compoundCommand.append(command);
        compoundCommand.append((Command)dCommand);
        for (DSemanticDecorator containerView : containerViews) {
            this.addRefreshTask(containerView, (DCommand)dCommand, (AbstractToolDescription)tool);
        }
        return compoundCommand;
    }

    private Command buildJavaActionFromTool(ExternalJavaAction tool, EObject container, Collection<DSemanticDecorator> containerViews, IExternalJavaAction javaAction) {
        return new JavaActionFromToolCommand(this.domain, javaAction, tool, containerViews);
    }

    @Override
    public Command buildOperationActionFromTool(OperationAction tool, Collection<DSemanticDecorator> containerViews) {
        EObject anySemantic = containerViews.iterator().next().getTarget();
        DCommand command = this.buildOperationActionFromTool(tool, anySemantic, containerViews);
        for (DSemanticDecorator containerView : containerViews) {
            this.addRefreshTask(containerView, command, (AbstractToolDescription)tool);
        }
        return command;
    }

    private DCommand buildOperationActionFromTool(OperationAction tool, EObject container, Collection<DSemanticDecorator> containerViews) {
        Option representation;
        SiriusCommand result = new SiriusCommand(this.domain, tool.getName());
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)container);
        HashMap<ContainerViewVariable, Collection<DSemanticDecorator>> variables = new HashMap<ContainerViewVariable, Collection<DSemanticDecorator>>();
        variables.put(tool.getView(), containerViews);
        result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallBack));
        DSemanticDecorator firstContainerView = null;
        if (containerViews != null && containerViews.size() > 0) {
            firstContainerView = containerViews.iterator().next();
            this.addDiagramVariable((DCommand)result, (EObject)firstContainerView, interpreter);
        }
        if ((representation = new EObjectQuery((EObject)firstContainerView).getRepresentation()).some() && tool.getInitialOperation() != null && tool.getInitialOperation().getFirstModelOperations() != null) {
            result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)representation.get(), container, tool.getInitialOperation().getFirstModelOperations()));
        }
        return result;
    }

    private void addDiagramVariable(DCommand command, EObject containerView, final IInterpreter interpreter) {
        final Option<DDiagram> diag = new EObjectQuery(containerView).getParentDiagram();
        if (diag.some()) {
            command.getTasks().add(new AbstractCommandTask(){

                public String getLabel() {
                    return "Add diagram variable";
                }

                public void execute() {
                    interpreter.setVariable("diagram", diag.get());
                }
            });
        }
    }

    @Override
    public Command buildCreateEdgeCommandFromTool(EdgeTarget source, EdgeTarget target, EdgeCreationDescription tool) {
        EdgeCreationCommandBuilder builder = new EdgeCreationCommandBuilder(tool, source, target);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildReconnectEdgeCommandFromTool(ReconnectEdgeDescription tool, DEdge edge, EdgeTarget source, EdgeTarget target) {
        ReconnectionCommandBuilder builder = new ReconnectionCommandBuilder(tool, edge, source, target);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildDropInContainerCommandFromTool(DragAndDropTarget container, DDiagramElement element, ContainerDropDescription tool) {
        DragAndDropCommandBuilder builder = new DragAndDropCommandBuilder(tool, container, element);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildDropInContainerCommandFromTool(DragAndDropTarget container, EObject droppedElement, ContainerDropDescription tool) {
        DragAndDropCommandBuilder builder = new DragAndDropCommandBuilder(tool, container, droppedElement);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildDoubleClickOnElementCommandFromTool(DDiagramElement dDiagramElement, DoubleClickDescription tool) {
        DoubleClickCommandBuilder builder = new DoubleClickCommandBuilder(tool, dDiagramElement);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    public Command buildDoExecuteDetailsOperation(DSemanticDecorator target, RepresentationCreationDescription desc, String newRepresentationName) {
        SiriusCommand cmd = new SiriusCommand(this.domain, "Create new representation");
        HashMap<ContainerViewVariable, DSemanticDecorator> variables = new HashMap<ContainerViewVariable, DSemanticDecorator>();
        variables.put(desc.getContainerViewVariable(), target);
        HashMap<NameVariable, String> stringVariables = new HashMap<NameVariable, String>();
        stringVariables.put(desc.getRepresentationNameVariable(), newRepresentationName);
        InitInterpreterVariablesTask initInterpreterVariables = new InitInterpreterVariablesTask(variables, stringVariables, InterpreterUtil.getInterpreter((EObject)target), this.uiCallBack);
        cmd.getTasks().add(initInterpreterVariables);
        Option representation = new EObjectQuery((EObject)target).getRepresentation();
        if (representation.some() && desc.getInitialOperation() != null && desc.getInitialOperation().getFirstModelOperations() != null) {
            cmd.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)representation.get(), target.getTarget(), desc.getInitialOperation().getFirstModelOperations()));
        }
        return cmd;
    }

    @Override
    public Command buildDeleteDiagram(DDiagram dDiagram) {
        DeletionCommandBuilder builder = new DeletionCommandBuilder(dDiagram);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildDeleteFromDiagramCommand(DDiagramElement element) {
        DeletionCommandBuilder builder = new DeletionCommandBuilder(element, true);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildDeleteDiagramElement(DDiagramElement element) {
        DeletionCommandBuilder builder = new DeletionCommandBuilder(element, false);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildDirectEditLabelFromTool(DRepresentationElement repElement, DirectEditLabel directEditTool, String newValue) {
        DirectEditCommandBuilder builder = new DirectEditCommandBuilder(repElement, directEditTool, newValue);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildRefreshCommand(DRefreshable vpElem) {
        if (this.getPermissionAuthority().canEditInstance((EObject)vpElem)) {
            return new RefreshSiriusElement(this.domain, vpElem);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildHideCommand(Set<EObject> elementsToHide) {
        HashSet<EObject> filteredSet = new HashSet<EObject>();
        for (EObject eObj : elementsToHide) {
            if (!this.getPermissionAuthority().canEditInstance(eObj)) continue;
            filteredSet.add(eObj);
        }
        if (filteredSet.size() > 0) {
            return new HideDDiagramElement(this.domain, filteredSet);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildHideLabelCommand(Set<EObject> elementsToHide) {
        HashSet<EObject> filteredSet = new HashSet<EObject>();
        for (EObject eObj : elementsToHide) {
            if (!this.getPermissionAuthority().canEditInstance(eObj)) continue;
            filteredSet.add(eObj);
        }
        boolean canHideLabel = true;
        for (Object e : filteredSet) {
            if (!(e instanceof DDiagramElement)) continue;
            canHideLabel &= new DDiagramElementQuery((DDiagramElement)e).canHideLabel();
        }
        if (canHideLabel) {
            return new HideDDiagramElementLabel(this.domain, filteredSet);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildRevealCommand(DDiagramElement vpe) {
        if (this.getPermissionAuthority().canEditInstance((EObject)vpe)) {
            return new RevealDDiagramElements(this.domain, Collections.singleton(vpe));
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildRevealLabelCommand(DDiagramElement diagramElement) {
        if (this.getPermissionAuthority().canEditInstance((EObject)diagramElement)) {
            return new RevealDDiagramElementsLabel(this.domain, Collections.singleton(diagramElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildRevealElementsCommand(DDiagram viewpoint) {
        if (this.getPermissionAuthority().canEditInstance((EObject)viewpoint)) {
            return new RevealAllElementsCommand(this.domain, viewpoint);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildRevealElementsCommand(Set<DDiagramElement> elementsToReveal) {
        HashSet<DDiagramElement> filteredSet = new HashSet<DDiagramElement>();
        if (elementsToReveal != null) {
            for (DDiagramElement diagramElement : elementsToReveal) {
                if (!this.getPermissionAuthority().canEditInstance((EObject)diagramElement)) continue;
                filteredSet.add(diagramElement);
            }
            if (filteredSet.size() > 0) {
                return new RevealDDiagramElements(this.domain, filteredSet);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public DCommand buildCreateDiagramFromDescription(DiagramDescription description, EObject semanticElement, IProgressMonitor monitor) {
        SiriusCommand command = new SiriusCommand(this.domain, "Create new diagram"){

            public boolean canUndo() {
                return false;
            }
        };
        command.getTasks().add(new CreateDiagramWithInitialOperation(description, semanticElement, this.uiCallBack, monitor));
        return command;
    }

    public void setUserInterfaceCallBack(UICallBack newCB) {
        this.uiCallBack = newCB;
        this.commandTaskHelper = new TaskHelper(this.modelAccessor, this.uiCallBack);
    }

    @Override
    public Command buildQuickFixOperation(ValidationFix fix, EObject fixTarget, DDiagram diagram) {
        if (fix.getInitialOperation() != null && fix.getInitialOperation().getFirstModelOperations() != null) {
            SiriusCommand result = new SiriusCommand(this.domain, "Quick fix");
            result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)diagram, fixTarget, fix.getInitialOperation().getFirstModelOperations()));
            return result;
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command buildGenericToolCommandFromTool(EObject containerView, ToolDescription tool) {
        GenericToolCommandBuilder builder = new GenericToolCommandBuilder(tool, containerView);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildPasteCommandFromTool(DSemanticDecorator dContainer, DSemanticDecorator element, PasteDescription tool) {
        PasteCommandBuilder builder = new PasteCommandBuilder(tool, dContainer, element);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }

    @Override
    public Command buildPasteCommandFromTool(DSemanticDecorator dContainer, EObject droppedElement, PasteDescription tool) {
        PasteCommandBuilder builder = new PasteCommandBuilder(tool, dContainer, droppedElement);
        builder.init(this.modelAccessor, this.domain, this.uiCallBack);
        return builder.buildCommand();
    }
}

