/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.api.assist;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.properties.sections.common.ModelViewBinding;
import org.eclipse.sirius.editor.tools.internal.assist.TypeAssistant;
import org.eclipse.sirius.editor.tools.internal.assist.TypeContentProposal;
import org.eclipse.sirius.ui.tools.api.assist.IAssistContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class TypeContentProposalProvider
implements IContentProposalProvider {
    private final TypeAssistant assistant;

    public TypeContentProposalProvider(TypeAssistant assistant) {
        this.assistant = assistant;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String incompleteText = contents.substring(0, position);
        List<EClassifier> proposals = this.assistant.proposal(incompleteText);
        IContentProposal[] result = new IContentProposal[proposals.size()];
        int i = 0;
        while (i < proposals.size()) {
            TypeContentProposal newProposal = new TypeContentProposal(proposals.get(i), incompleteText);
            result[i] = newProposal;
            ++i;
        }
        return result;
    }

    public static void bindCompletionProcessor(final AbstractPropertySection section, Text text) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] contentAssistBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (contentAssistBindings != null && contentAssistBindings.length > 0) {
            KeyStroke keyStroke = TypeContentProposalProvider.getKeyStroke(contentAssistBindings[0]);
            TypeAssistant typeAssistant = new TypeAssistant(SiriusEditorPlugin.getPlugin().getWorkspaceEPackageRegistry(), section);
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TypeContentProposalProvider(typeAssistant), keyStroke, null);
            adapter.addContentProposalListener(new IContentProposalListener2(){

                public void proposalPopupClosed(ContentProposalAdapter arg0) {
                    if (section instanceof ModelViewBinding) {
                        ((ModelViewBinding)section).enableModelUpdating();
                    }
                }

                public void proposalPopupOpened(ContentProposalAdapter arg0) {
                    if (section instanceof ModelViewBinding) {
                        ((ModelViewBinding)section).disableModelUpdating();
                    }
                }
            });
        }
    }

    public static void bindPluginsCompletionProcessors(AbstractPropertySection section, Text text) {
        List extension = EclipseUtil.getExtensionPlugins(IAssistContentProvider.class, (String)"org.eclipse.sirius.ui.assistContentProvider", (String)"class");
        if (extension.size() != 0) {
            IAssistContentProvider contentProposalAdapter = (IAssistContentProvider)extension.get(0);
            contentProposalAdapter.setView(section);
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            TriggerSequence[] activeBindinds = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
            if (activeBindinds != null && activeBindinds.length > 0) {
                TriggerSequence sequence = activeBindinds[0];
                KeyStroke keyStroke = TypeContentProposalProvider.getKeyStroke(sequence);
                TextContentAdapter textContentAdapter = new TextContentAdapter();
                ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)contentProposalAdapter, keyStroke, IAssistContentProvider.AUTO_ACTIVATION_CHARACTERS);
                adapter.setPopupSize(new Point(300, 100));
                adapter.addContentProposalListener((IContentProposalListener2)contentProposalAdapter);
            }
        }
    }

    private static KeyStroke getKeyStroke(TriggerSequence sequence) {
        Trigger[] triggerArray = sequence.getTriggers();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                return (KeyStroke)trigger;
            }
            ++n2;
        }
        return null;
    }
}

