/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.business.internal.dialect;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableNavigationDescription;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;
import org.eclipse.swt.graphics.Image;

public class HierarchyLabelTableProvider
extends LabelProvider {
    private static final String DELIMITER = " > ";
    private ILabelProvider wrappedProvider;

    public HierarchyLabelTableProvider(ILabelProvider wrappedLabelProvider) {
        this.wrappedProvider = wrappedLabelProvider;
    }

    public Image getImage(Object element) {
        return this.wrappedProvider != null ? this.wrappedProvider.getImage(element) : super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof TableMapping || element instanceof TableDescription || element instanceof TableNavigationDescription || element instanceof ToolEntry) {
            IdentifiedElement mapping = (IdentifiedElement)element;
            String text = mapping.getName();
            EObject container = mapping.eContainer();
            while (container != null && !(container instanceof Group)) {
                text = String.valueOf(this.getLabel(container)) + DELIMITER + text;
                container = container.eContainer();
            }
            return text;
        }
        return this.wrappedProvider != null ? this.wrappedProvider.getText(element) : super.getText(element);
    }

    private String getLabel(EObject eObject) {
        String label = null;
        if (eObject instanceof IdentifiedElement) {
            label = new IdentifiedElementQuery((IdentifiedElement)eObject).getLabel();
        } else if (eObject instanceof RepresentationExtensionDescription) {
            label = ((RepresentationExtensionDescription)eObject).getName();
        }
        return label != null ? label : "Element whithout name";
    }
}

