/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import org.eclipse.jface.action.Action;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PaperClipsPrintHelper;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PrintHelper;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class PrintAction
extends Action {
    private IEditorPart editorPart;
    private Control controlToPrint;

    public void setEditor(IEditorPart editor) {
        this.editorPart = editor;
    }

    public void run() {
        if (this.editorPart instanceof AbstractDTableEditor) {
            this.controlToPrint = ((AbstractDTableEditor)this.editorPart).getTableViewer().getControl();
            if (this.controlToPrint != null) {
                Display display = this.controlToPrint.getDisplay();
                Shell shell = display.getActiveShell();
                String tableName = this.editorPart.getTitle() != null ? this.editorPart.getTitle() : "table without name";
                try {
                    PrinterData data = this.openPrintDialog(shell);
                    if (data == null) {
                        return;
                    }
                    this.launchPrintWithPaperclip(data, tableName);
                }
                catch (SWTError e) {
                    MessageBox box = new MessageBox(shell, 1);
                    box.setMessage("An error occurs during printing : " + e.getMessage());
                    box.open();
                }
            }
        }
    }

    private PrinterData openPrintDialog(Shell shell) {
        PrintDialog dialog = new PrintDialog(shell, 0);
        PrinterData printerData = dialog.open();
        return printerData;
    }

    private void launchPrintWithPaperclip(PrinterData data, String tableName) {
        PaperClipsPrintHelper helper = new PaperClipsPrintHelper(data, this.controlToPrint);
        this.launch(helper, tableName);
    }

    private void launch(PrintHelper helper, String tableName) {
        helper.launchPrintJob(tableName);
        helper.dispose();
    }
}

