/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.quickoutline;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineCallback;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlineDescriptor;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlinePageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.SiriusInformationPresenter;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.SiriusInformationPresenterFactory;
import org.eclipse.sirius.table.ui.tools.api.editor.DTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.quickoutline.DColumnOutlineContentProvider;
import org.eclipse.sirius.table.ui.tools.internal.quickoutline.DLineQuickOutlineContentProvider;
import org.eclipse.sirius.table.ui.tools.internal.quickoutline.DTableQuickOutlineLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.quickoutline.TableOutlineCallback;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TableQuickOutlineHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DTableEditor editor = this.getCurrentEditor();
        if (editor != null) {
            QuickOutlineDescriptor descriptor = this.createDescriptor(editor);
            SiriusInformationPresenter presenter = SiriusInformationPresenterFactory.createInformationPresenter((Control)editor.getControl(), (QuickOutlineDescriptor)descriptor, (Object)editor.getRepresentation());
            presenter.showInformation();
        }
        return null;
    }

    private QuickOutlineDescriptor createDescriptor(DTableEditor editor) {
        ComposedAdapterFactory caf = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        DTableQuickOutlineLabelProvider labelProvider = new DTableQuickOutlineLabelProvider((AdapterFactory)caf);
        TableOutlineCallback callBack = new TableOutlineCallback(editor);
        QuickOutlinePageDescriptor page = new QuickOutlinePageDescriptor((IQuickOutlineCallback)callBack, (IQuickOutlineLabelProvider)labelProvider, (IContentProvider)new DLineQuickOutlineContentProvider(), "select line");
        QuickOutlinePageDescriptor columnsPage = new QuickOutlinePageDescriptor((IQuickOutlineCallback)callBack, (IQuickOutlineLabelProvider)labelProvider, (IContentProvider)new DColumnOutlineContentProvider(), "select column");
        QuickOutlineDescriptor descriptor = new QuickOutlineDescriptor();
        descriptor.addPage(page);
        descriptor.addPage(columnsPage);
        return descriptor;
    }

    private DTableEditor getCurrentEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof DTableEditor) {
            return (DTableEditor)window.getActivePage().getActiveEditor();
        }
        return null;
    }
}

