/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.tools.internal.command;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.helper.task.label.InitInterpreterFromParsedVariableTask2;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationElementsTask;
import org.eclipse.sirius.business.internal.helper.task.DeleteWithoutToolTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.internal.helper.task.CreateTableTask;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.LabelEditTool;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.table.metamodel.table.description.TableVariable;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.tools.api.command.AbstractCommandFactory;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.InvalidPermissionCommand;
import org.eclipse.sirius.tools.api.command.NoNullResourceCommand;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ContainerViewVariable;
import org.eclipse.sirius.viewpoint.description.tool.NameVariable;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class TableCommandFactory
extends AbstractCommandFactory
implements ITableCommandFactory {
    private TaskHelper commandTaskHelper;

    public TableCommandFactory(TransactionalEditingDomain domain) {
        super(domain);
    }

    public TableCommandFactory(TransactionalEditingDomain domain, ModelAccessor modelAccessor) {
        super(domain);
    }

    private IPermissionAuthority getPermissionAuthority() {
        return this.modelAccessor.getPermissionAuthority();
    }

    @Override
    public Command buildDeleteTableElement(DTableElement element) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (element instanceof DLine || element instanceof DTargetColumn) {
            if (!this.getPermissionAuthority().canEditInstance((EObject)element)) {
                cmd = new InvalidPermissionCommand(this.domain, new EObject[]{element});
            } else if (!this.getPermissionAuthority().canEditInstance(element.eContainer())) {
                cmd = new InvalidPermissionCommand(this.domain, new EObject[]{element.eContainer()});
            } else {
                SiriusCommand result = new SiriusCommand(this.domain);
                DeleteTool deleteTool = this.getDeleteTool(element);
                DTable parentTable = TableHelper.getTable((EObject)element);
                if (deleteTool != null) {
                    this.addDeleteTableElementFromTool(result, element, deleteTool);
                    this.addRefreshTask(parentTable, (DCommand)result, deleteTool);
                    cmd = new NoNullResourceCommand((Command)result, (EObject)element);
                } else {
                    result.getTasks().add(new DeleteWithoutToolTask((DRepresentationElement)element, this.modelAccessor, this.commandTaskHelper));
                    this.addRefreshTask(parentTable, (DCommand)result, deleteTool);
                    cmd = new NoNullResourceCommand((Command)result, (EObject)element);
                }
            }
        }
        return cmd;
    }

    @Override
    public Command buildCreateLineCommandFromTool(LineContainer lineContainer, EObject semanticCurrentElement, CreateTool tool) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (!this.getPermissionAuthority().canEditInstance((EObject)lineContainer)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{lineContainer});
        } else if (this.commandTaskHelper.checkPrecondition(semanticCurrentElement, (AbstractToolDescription)tool)) {
            SiriusCommand createLineCommand = this.buildCommandFromModelOfTool(semanticCurrentElement, tool, (EObject)lineContainer);
            this.addRefreshTask(lineContainer, (DCommand)createLineCommand, tool);
            result = createLineCommand;
        }
        return result;
    }

    @Override
    public Command buildCreateColumnCommandFromTool(DTable containerView, EObject semanticCurrentElement, CreateTool tool) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (!this.getPermissionAuthority().canEditInstance((EObject)containerView)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{containerView});
        } else if (this.commandTaskHelper.checkPrecondition(semanticCurrentElement, (AbstractToolDescription)tool)) {
            SiriusCommand createColumnCommand = this.buildCommandFromModelOfTool(semanticCurrentElement, tool, (EObject)containerView);
            this.addRefreshTask(containerView, (DCommand)createColumnCommand, tool);
            result = createColumnCommand;
        }
        return result;
    }

    private DeleteTool getDeleteTool(DTableElement element) {
        ColumnMapping columnMapping;
        DeleteTool result = null;
        if (element instanceof DLine) {
            result = ((DLine)element).getOriginMapping().getDelete();
        } else if (element instanceof DTargetColumn && (columnMapping = ((DTargetColumn)element).getOriginMapping()) instanceof ElementColumnMapping) {
            result = ((ElementColumnMapping)columnMapping).getDelete();
        }
        return result;
    }

    private void addDeleteTableElementFromTool(SiriusCommand cmd, DTableElement element, DeleteTool deleteTool) {
        EObject semanticElement = element.getTarget();
        EObject rootContainer = TableHelper.getTable((EObject)element).getTarget();
        boolean delete = true;
        if (deleteTool.getPrecondition() != null && !StringUtil.isEmpty((String)deleteTool.getPrecondition().trim())) {
            delete = false;
            IInterpreter acceleoInterpreter = InterpreterUtil.getInterpreter((EObject)semanticElement);
            acceleoInterpreter.setVariable("root", (Object)rootContainer);
            acceleoInterpreter.setVariable("element", (Object)semanticElement);
            try {
                delete = acceleoInterpreter.evaluateBoolean(semanticElement, deleteTool.getPrecondition());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)deleteTool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
            }
            acceleoInterpreter.unSetVariable("root");
            acceleoInterpreter.unSetVariable("element");
        }
        if (delete) {
            cmd.getTasks().addAll(this.buildCommandFromModelOfTool(semanticElement, deleteTool, element.eContainer()).getTasks());
            cmd.getTasks().add(new DeleteDRepresentationElementsTask(this.modelAccessor, (DCommand)cmd, this.commandTaskHelper, (DRepresentationElement)element));
        } else {
            cmd.getTasks().add(UnexecutableTask.INSTANCE);
        }
    }

    protected SiriusCommand buildCommandFromModelOfTool(EObject semanticCurrentElement, AbstractToolDescription tool, EObject containerView) {
        SiriusCommand result = new SiriusCommand(this.domain);
        if (!this.getPermissionAuthority().canEditInstance(containerView)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{containerView});
        } else {
            HashMap<TableVariable, EObject> variables = new HashMap<TableVariable, EObject>();
            if (tool instanceof DeleteTool) {
                DeleteTool deleteTool = (DeleteTool)tool;
                if (containerView instanceof DTableElement) {
                    variables.put(TableHelper.getVariable(deleteTool, "root"), TableHelper.getTable(containerView).getTarget());
                } else if (containerView instanceof DTable) {
                    variables.put(TableHelper.getVariable(deleteTool, "root"), ((DTable)containerView).getTarget());
                }
                variables.put(TableHelper.getVariable(deleteTool, "element"), semanticCurrentElement);
                result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)semanticCurrentElement), this.uiCallBack));
                result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TableHelper.getTable(containerView), semanticCurrentElement, deleteTool.getFirstModelOperation()));
            } else if (tool instanceof CreateTool) {
                TableVariable elementVariable;
                CreateTool creationTool = (CreateTool)tool;
                if (containerView instanceof DTableElement) {
                    variables.put(TableHelper.getVariable(creationTool, "root"), TableHelper.getTable(containerView).getTarget());
                    if (containerView instanceof DLine) {
                        variables.put(TableHelper.getVariable(creationTool, "container"), ((DLine)containerView).getTarget());
                    }
                } else if (containerView instanceof DTable) {
                    TableVariable containerVariable;
                    TableVariable rootVariable = TableHelper.getVariable(creationTool, "root");
                    if (rootVariable != null) {
                        variables.put(rootVariable, ((DTable)containerView).getTarget());
                    }
                    if ((containerVariable = TableHelper.getVariable(creationTool, "container")) != null) {
                        variables.put(containerVariable, ((DTable)containerView).getTarget());
                    }
                }
                if ((elementVariable = TableHelper.getVariable(creationTool, "element")) != null) {
                    variables.put(elementVariable, semanticCurrentElement);
                }
                result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)semanticCurrentElement), this.uiCallBack));
                result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TableHelper.getTable(containerView), semanticCurrentElement, creationTool.getFirstModelOperation()));
            }
        }
        return result;
    }

    private SiriusCommand buildCommandFromCell(DCell currentCell, TableTool tool, Object newValue) {
        SiriusCommand result = new SiriusCommand(this.domain, "Set cell content");
        if (!this.getPermissionAuthority().canEditInstance((EObject)currentCell)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{currentCell});
        } else {
            CreateCellTool createCellTool;
            String messageFormat;
            LabelEditTool labelEditTool;
            EObject interpreterContext = currentCell.getTarget();
            if (interpreterContext == null) {
                interpreterContext = currentCell.getLine().getTarget();
            }
            HashMap<TableVariable, EObject> variables = new HashMap<TableVariable, EObject>();
            variables.put(TableHelper.getVariable(tool, "root"), TableHelper.getTable((EObject)currentCell).getTarget());
            variables.put(TableHelper.getVariable(tool, "lineSemantic"), currentCell.getLine().getTarget());
            if (currentCell.getColumn() instanceof DTargetColumn) {
                variables.put(TableHelper.getVariable(tool, "columnSemantic"), ((DTargetColumn)currentCell.getColumn()).getTarget());
            }
            if (tool instanceof LabelEditTool) {
                variables.put(TableHelper.getVariable(tool, "element"), currentCell.getTarget());
            }
            result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)interpreterContext), this.uiCallBack));
            if (tool instanceof LabelEditTool && (labelEditTool = (LabelEditTool)tool).getMask() != null) {
                messageFormat = labelEditTool.getMask().getMask();
                result.getTasks().add(new InitInterpreterFromParsedVariableTask2(InterpreterUtil.getInterpreter((EObject)interpreterContext), messageFormat, newValue));
            }
            if (tool instanceof CreateCellTool && (createCellTool = (CreateCellTool)tool).getMask() != null) {
                messageFormat = createCellTool.getMask().getMask();
                result.getTasks().add(new InitInterpreterFromParsedVariableTask2(InterpreterUtil.getInterpreter((EObject)interpreterContext), messageFormat, newValue));
            }
            result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TableHelper.getTable((EObject)currentCell), interpreterContext, tool.getFirstModelOperation()));
        }
        return result;
    }

    private SiriusCommand buildCommandFromIntersection(DLine currentLine, DTargetColumn currentColumn, CreateCellTool tool, Object newValue) {
        SiriusCommand result = new SiriusCommand(this.domain, "Set cell content");
        if (!this.getPermissionAuthority().canEditInstance((EObject)currentLine)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{currentLine});
        } else if (!this.getPermissionAuthority().canEditInstance((EObject)currentColumn)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{currentColumn});
        } else {
            EObject interpreterContext = currentLine.getTarget();
            HashMap<TableVariable, EObject> variables = new HashMap<TableVariable, EObject>();
            variables.put(TableHelper.getVariable(tool, "root"), TableHelper.getTable((EObject)currentLine).getTarget());
            variables.put(TableHelper.getVariable(tool, "lineSemantic"), currentLine.getTarget());
            variables.put(TableHelper.getVariable(tool, "columnSemantic"), currentColumn.getTarget());
            result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)interpreterContext), this.uiCallBack));
            if (tool.getMask() != null) {
                String messageFormat = tool.getMask().getMask();
                result.getTasks().add(new InitInterpreterFromParsedVariableTask2(InterpreterUtil.getInterpreter((EObject)interpreterContext), messageFormat, newValue));
            }
            result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TableHelper.getTable((EObject)currentLine), interpreterContext, tool.getFirstModelOperation()));
        }
        return result;
    }

    public TaskHelper getCommandTaskHelper() {
        return this.commandTaskHelper;
    }

    private ModelAccessor getModelAccessor() {
        return this.modelAccessor;
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
        this.modelAccessor = modelAccessor;
        this.commandTaskHelper = new TaskHelper(modelAccessor, this.uiCallBack);
    }

    @Override
    public Command buildSetCellValueFromTool(DCell editedCell, Object newValue) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (!this.getPermissionAuthority().canEditInstance((EObject)editedCell)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{editedCell});
        } else if (editedCell.getUpdater() != null && editedCell.getUpdater().getDirectEdit() != null) {
            result = this.buildCommandFromCell(editedCell, editedCell.getUpdater().getDirectEdit(), newValue);
            this.addRefreshTask(TableHelper.getTable((EObject)editedCell), (DCommand)((SiriusCommand)result), null);
        }
        return result;
    }

    @Override
    public Command buildCreateCellFromTool(DLine line, DTargetColumn column, Object newValue) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (!this.getPermissionAuthority().canEditInstance((EObject)line)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{line});
        } else if (!this.getPermissionAuthority().canEditInstance((EObject)column)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{column});
        } else {
            Option<CreateCellTool> optionalCreateCellTool = TableHelper.getCreateCellTool(line, column);
            if (optionalCreateCellTool.some()) {
                result = this.buildCommandFromIntersection(line, column, (CreateCellTool)optionalCreateCellTool.get(), newValue);
                this.addRefreshTask(TableHelper.getTable((EObject)line), (DCommand)((SiriusCommand)result), (AbstractToolDescription)optionalCreateCellTool.get());
            }
        }
        return result;
    }

    public DCommand buildCreateTableFromDescription(TableDescription description, EObject semanticElement, IProgressMonitor monitor) {
        SiriusCommand command = new SiriusCommand(this.domain){

            public boolean canUndo() {
                return false;
            }
        };
        command.getTasks().add(new CreateTableTask(description, semanticElement, monitor));
        return command;
    }

    @Override
    public Command buildSetValue(final EObject instance, final String name, Object value) {
        if (this.getPermissionAuthority().canEditInstance(instance)) {
            SiriusCommand result = new SiriusCommand(this.domain);
            try {
                result.getTasks().add(new AbstractCommandTask(value){
                    private final Object oldValue;
                    private final Object newValue;
                    {
                        this.oldValue = TableCommandFactory.this.getModelAccessor().eGet(eObject, string);
                        this.newValue = object;
                    }

                    public void undo() {
                        try {
                            if (!TableCommandFactory.this.getModelAccessor().eGet(instance, name).equals(this.oldValue)) {
                                TableCommandFactory.this.getModelAccessor().eSet(instance, name, this.oldValue);
                            }
                        }
                        catch (LockedInstanceException e) {
                            SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                        }
                        catch (FeatureNotFoundException e) {
                            SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                        }
                    }

                    public void redo() {
                        try {
                            if (!TableCommandFactory.this.getModelAccessor().eGet(instance, name).equals(this.newValue)) {
                                TableCommandFactory.this.getModelAccessor().eSet(instance, name, this.newValue);
                            }
                        }
                        catch (LockedInstanceException e) {
                            SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                        }
                        catch (FeatureNotFoundException e) {
                            SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                        }
                    }

                    public String getLabel() {
                        return "Set " + name + " value";
                    }

                    public void execute() {
                        this.redo();
                    }
                });
            }
            catch (FeatureNotFoundException e1) {
                SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e1);
            }
            return result;
        }
        return new InvalidPermissionCommand(this.domain, new EObject[]{instance});
    }

    @Override
    public Command buildAddValue(final EObject instance, final String name, Object value) {
        if (this.getPermissionAuthority().canEditInstance(instance)) {
            SiriusCommand result = new SiriusCommand(this.domain);
            result.getTasks().add(new AbstractCommandTask(value){
                private final Object addedValue;
                {
                    this.addedValue = object;
                }

                public void undo() {
                    try {
                        TableCommandFactory.this.getModelAccessor().eRemove(instance, name, this.addedValue);
                    }
                    catch (LockedInstanceException e) {
                        SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                    }
                }

                public void redo() {
                    try {
                        TableCommandFactory.this.getModelAccessor().eAdd(instance, name, this.addedValue);
                    }
                    catch (LockedInstanceException e) {
                        SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                    }
                    catch (FeatureNotFoundException e) {
                        SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                    }
                }

                public String getLabel() {
                    return "Add " + name + " value";
                }

                public void execute() {
                    this.redo();
                }
            });
            return result;
        }
        return new InvalidPermissionCommand(this.domain, new EObject[]{instance});
    }

    @Override
    public Command buildClearValue(final EObject instance, final String name) {
        if (this.getPermissionAuthority().canEditInstance(instance)) {
            SiriusCommand result = new SiriusCommand(this.domain);
            try {
                result.getTasks().add(new AbstractCommandTask(){
                    private final Object oldValues;
                    {
                        this.oldValues = TableCommandFactory.this.getModelAccessor().eGet(eObject, string);
                    }

                    public void undo() {
                        try {
                            TableCommandFactory.this.getModelAccessor().eSet(instance, name, this.oldValues);
                        }
                        catch (LockedInstanceException e) {
                            SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                        }
                        catch (FeatureNotFoundException e) {
                            SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                        }
                    }

                    public void redo() {
                        try {
                            TableCommandFactory.this.getModelAccessor().eClear(instance, name);
                        }
                        catch (LockedInstanceException e) {
                            SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
                        }
                    }

                    public String getLabel() {
                        return "Clear " + name;
                    }

                    public void execute() {
                        this.redo();
                    }
                });
            }
            catch (FeatureNotFoundException e1) {
                SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e1);
            }
            return result;
        }
        return new InvalidPermissionCommand(this.domain, new EObject[]{instance});
    }

    public AbstractCommand buildDoExecuteDetailsOperation(DSemanticDecorator target, RepresentationCreationDescription desc, String newRepresentationName) {
        SiriusCommand cmd = new SiriusCommand(this.domain);
        HashMap<ContainerViewVariable, DSemanticDecorator> variables = new HashMap<ContainerViewVariable, DSemanticDecorator>();
        variables.put(desc.getContainerViewVariable(), target);
        HashMap<NameVariable, String> stringVariables = new HashMap<NameVariable, String>();
        stringVariables.put(desc.getRepresentationNameVariable(), newRepresentationName);
        InitInterpreterVariablesTask initInterpreterVariables = new InitInterpreterVariablesTask(variables, stringVariables, InterpreterUtil.getInterpreter((EObject)target), this.uiCallBack);
        cmd.getTasks().add(initInterpreterVariables);
        cmd.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TableHelper.getTable((EObject)target), target.getTarget(), desc.getInitialOperation().getFirstModelOperations()));
        return cmd;
    }
}

