/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.description.TreeItemEditionTool;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.DTreeItemEditorFocusListener;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class DTreeItemEditingSupport
extends EditingSupport {
    private final TransactionalEditingDomain editingDomain;
    private final ModelAccessor accessor;
    private final ITreeCommandFactory treeCommandFactory;
    private final AbstractDTreeEditor treeEditor;

    public DTreeItemEditingSupport(TreeViewer viewer, TransactionalEditingDomain editingDomain, ModelAccessor accessor, ITreeCommandFactory treeCommandFactory, AbstractDTreeEditor abstractDTreeEditor) {
        super((ColumnViewer)viewer);
        this.editingDomain = editingDomain;
        this.accessor = accessor;
        this.treeCommandFactory = treeCommandFactory;
        this.treeEditor = abstractDTreeEditor;
    }

    protected boolean canEdit(Object element) {
        if (element instanceof DTreeItem) {
            DTreeItem item = (DTreeItem)element;
            boolean canEdit = false;
            IInterpreter interpreter = null;
            if (item.getUpdater() != null && item.getUpdater().getDirectEdit() != null) {
                canEdit = true;
                if (!StringUtil.isEmpty((String)item.getUpdater().getDirectEdit().getPrecondition())) {
                    if (interpreter == null) {
                        interpreter = InterpreterUtil.getInterpreter((EObject)item.getTarget());
                    }
                    String precondition = item.getUpdater().getDirectEdit().getPrecondition();
                    try {
                        canEdit = interpreter.evaluateBoolean(item.getTarget(), precondition);
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)item.getUpdater().getDirectEdit(), (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    }
                }
            }
            return canEdit && this.getAuthority().canEditInstance((EObject)item);
        }
        return false;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof DTreeItem) {
            DTreeItem editedItem = (DTreeItem)element;
            boolean directEdit = editedItem.getUpdater() != null && editedItem.getUpdater().getDirectEdit() != null;
            return this.getBestCellEditor(editedItem.getTarget(), directEdit);
        }
        return null;
    }

    protected Object getValue(Object element) {
        String result = null;
        if (element instanceof DTreeItem) {
            result = ((DTreeItem)element).getName();
        }
        return result;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof DTreeItem) {
            DTreeItem treeItem = (DTreeItem)element;
            if (value != null) {
                Object finalValue = value;
                if (treeItem.getUpdater() != null && treeItem.getUpdater().getDirectEdit() != null) {
                    this.specificSetValue(treeItem, finalValue);
                } else {
                    this.standardSetValue(treeItem, finalValue);
                }
            }
        }
    }

    private void standardSetValue(DTreeItem itemToSet, Object value) {
        DTreeItem treeItem = itemToSet;
        if (value instanceof String) {
            this.getEditingDomain().getCommandStack().execute((Command)new StandardSetValueRecordingCommand(this.getEditingDomain(), "Direct Edit on " + itemToSet.getName(), treeItem, value));
        }
    }

    private void specificSetValue(DTreeItem editedTreeItem, Object value) {
        this.treeEditor.enablePropertiesUpdate(false);
        TreeItemEditionTool editTool = editedTreeItem.getUpdater().getDirectEdit();
        if (editTool.getFirstModelOperation() != null) {
            this.getEditingDomain().getCommandStack().execute(this.treeCommandFactory.buildDirectEditLabelFromTool(editedTreeItem, editTool, (String)value));
        }
        this.treeEditor.enablePropertiesUpdate(true);
        this.treeEditor.forceRefreshProperties();
    }

    private CellEditor getBestCellEditor(EObject element, boolean directEdit) {
        Tree tree = ((TreeViewer)this.getViewer()).getTree();
        TextCellEditor textEditor = new TextCellEditor((Composite)tree){

            protected void doSetFocus() {
                super.doSetFocus();
                if (this.text != null) {
                    this.text.clearSelection();
                }
            }
        };
        textEditor.getControl().addFocusListener((FocusListener)new DTreeItemEditorFocusListener(this.treeEditor, textEditor));
        return textEditor;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    private IPermissionAuthority getAuthority() {
        return this.getAccessor().getPermissionAuthority();
    }

    private ModelAccessor getAccessor() {
        return this.accessor;
    }

    private class StandardSetValueRecordingCommand
    extends RecordingCommand {
        private DTreeItem treeItem;
        private Object value;

        public StandardSetValueRecordingCommand(TransactionalEditingDomain domain, String label, DTreeItem treeItem, Object value) {
            super(domain, label);
            this.treeItem = treeItem;
            this.value = value;
        }

        protected void doExecute() {
            this.treeItem.setName((String)this.value);
        }
    }
}

