/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.internal.session.danalysis.SaveSessionJob;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.business.api.session.EditingSessionEvent;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public class SaveSessionWhenNoDialectEditorsListener
implements ResourceSyncClient {
    private final Session session;
    private Job saveSessionJob;
    private boolean activation = true;

    public SaveSessionWhenNoDialectEditorsListener(Session session) {
        this.session = session;
    }

    public void register() {
        ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.session.getTransactionalEditingDomain()).registerClient((ResourceSyncClient)this);
    }

    public void unregister() {
        Option resourceSetSync = ResourceSetSync.getResourceSetSync((TransactionalEditingDomain)this.session.getTransactionalEditingDomain());
        if (resourceSetSync.some()) {
            ((ResourceSetSync)resourceSetSync.get()).unregisterClient((ResourceSyncClient)this);
        }
        this.saveSessionJob = null;
    }

    public void notify(EditingSessionEvent event) {
        switch (event) {
            case REPRESENTATION_ABOUT_TO_BE_CREATED_BEFORE_OPENING: {
                this.activation = false;
                break;
            }
            case REPRESENTATION_CREATED_BEFORE_OPENING: {
                this.activation = true;
                break;
            }
        }
    }

    private boolean newMode() {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        return preferenceStore != null && preferenceStore.getBoolean(SiriusUIPreferencesKeys.PREF_SAVE_WHEN_NO_EDITOR.name());
    }

    public void statusChanged(Resource resource, ResourceSetSync.ResourceStatus oldStatus, ResourceSetSync.ResourceStatus newStatus) {
    }

    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.activation && this.newMode()) {
            this.statusChangedInternal(changes);
        }
    }

    private void statusChangedInternal(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(this.session);
        if (this.session.isOpen() && editingSession != null && editingSession.getEditors().isEmpty() && this.resourceNoMoreInSync(changes)) {
            if (this.wasProjectDeletedOrRenamed(changes)) {
                return;
            }
            if (SessionStatus.DIRTY.equals((Object)this.session.getStatus()) && (this.saveSessionJob == null || this.saveSessionJob != null && this.saveSessionJob.getState() == 0)) {
                this.saveSessionJob = new SaveSessionJob(this.session);
                this.saveSessionJob.schedule();
            }
        }
    }

    private boolean wasProjectDeletedOrRenamed(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        HashSet projects = Sets.newHashSet();
        for (ResourceSyncClient.ResourceStatusChange change : changes) {
            IProject project;
            IFile file = WorkspaceSynchronizer.getFile((Resource)change.getResource());
            if (file == null || (project = file.getProject()) == null) continue;
            projects.add(project);
        }
        for (IProject project : projects) {
            if (project.exists()) continue;
            return true;
        }
        return false;
    }

    private boolean resourceNoMoreInSync(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        boolean resourcesNoMoreInSync = false;
        for (ResourceSyncClient.ResourceStatusChange change : changes) {
            ResourceSetSync.ResourceStatus newStatus = change.getNewStatus();
            boolean bl = resourcesNoMoreInSync = resourcesNoMoreInSync || !newStatus.equals((Object)ResourceSetSync.ResourceStatus.SYNC);
        }
        return resourcesNoMoreInSync;
    }
}

