/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractExportRepresentationsAsImagesDialog
extends Dialog {
    public static final String FILE_SEPARATOR_ALTERNATIVE = "_";
    protected static final ImageFileFormat DEFAULT_VALUE = ImageFileFormat.JPG;
    protected static final String CHARACTER_EXTENSION_FILE = ".";
    protected static final ImageFileFormat[] SAFE_VALUES = new ImageFileFormat[]{DEFAULT_VALUE, ImageFileFormat.PNG, ImageFileFormat.SVG, ImageFileFormat.BMP, ImageFileFormat.GIF};
    protected static final String EMPTY_STRING = "";
    protected static final String IMAGE_FORMAT_LABEL = "&Image Format:";
    protected static final String BROWSE_LABEL = "&Browse...";
    protected static final String DIALOG_SETTINGS_IMAGE_FORMAT = "ExportRepresentationsAsImagesDialog.imageFormat";
    protected static final String ACCES_ERROR_MESSAGE = "Access to path is impossible";
    protected static final String FOLDER_NOT_EXIST_MESSAGE = "Folder does not exist";
    private static final String EXPORT_TO_HTML_LABEL = "Export to HTML";
    private static final String FOLDER_BLANK_MESSAGE = "Folder cannot be blank";
    private static final String FOLDER_INVALID_MESSAGE = "Folder is not a valid path";
    private static final String DIALOG_SETTINGS_ID = "ExportRepresentationsAsImagesDialog";
    private static final int COMBO_HISTORY_LENGTH = 5;
    protected Combo folderText;
    protected Combo imageFormatCombo;
    protected ImageFileFormat imageFormat;
    protected String folder;
    private Label messageImageLabel;
    private Label messageLabel;
    private Button exportToHTMLCheckbox;
    private boolean exportToHTML;

    public AbstractExportRepresentationsAsImagesDialog(Shell shell, IPath path) {
        super(shell);
        this.initDialogSettings(path);
    }

    public static ImageFileFormat resolveImageFormat(int ordinal) {
        return SAFE_VALUES[ordinal];
    }

    public static ImageFileFormat resolveImageFormat(String imageFormat) {
        ImageFileFormat[] imageFileFormatArray = SAFE_VALUES;
        int n = SAFE_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat element = imageFileFormatArray[n2];
            if (element.getName().toLowerCase().equals(imageFormat.toLowerCase())) {
                return element;
            }
            ++n2;
        }
        return AbstractExportRepresentationsAsImagesDialog.getDefaultImageFormat();
    }

    public static ImageFileFormat getDefaultImageFormat() {
        return ImageFileFormat.JPG;
    }

    public boolean isExportToHtml() {
        return this.exportToHTML;
    }

    public static GridData makeButtonData(Button button) {
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        GridData data = new GridData();
        data.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)14);
        data.widthHint = Math.max(Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gc.dispose();
        return data;
    }

    public IPath getOutputPath() {
        return new Path(this.folder);
    }

    public ImageFileFormat getImageFormat() {
        return this.imageFormat;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = SiriusEditPlugin.getPlugin().getDialogSettings();
        if ((settings = settings.getSection(DIALOG_SETTINGS_ID)) == null) {
            settings = SiriusEditPlugin.getPlugin().getDialogSettings().addNewSection(DIALOG_SETTINGS_ID);
        }
        return settings;
    }

    protected abstract void initDialogSettings(IPath var1);

    protected abstract void saveDialogSettings();

    protected void okPressed() {
        super.okPressed();
        this.saveDialogSettings();
    }

    protected abstract void handleBrowseButtonPressed();

    protected void validateFolderText() {
        if (this.folderText.getText().equals(EMPTY_STRING)) {
            this.setDialogErrorState(FOLDER_BLANK_MESSAGE);
        } else {
            Path path = new Path(EMPTY_STRING);
            if (!path.isValidPath(this.folderText.getText())) {
                this.setDialogErrorState(FOLDER_INVALID_MESSAGE);
                return;
            }
            File file = new File(this.folderText.getText());
            File directory = file.getParentFile();
            if (file.exists()) {
                if (!file.canWrite()) {
                    this.setDialogErrorState(ACCES_ERROR_MESSAGE);
                    return;
                }
            } else if (directory != null && !directory.canWrite()) {
                this.setDialogErrorState(ACCES_ERROR_MESSAGE);
                return;
            }
            this.folder = this.folderText.getText();
            this.setDialogOKState();
        }
    }

    protected void setDialogErrorState(String message) {
        this.messageLabel.setText(message);
        this.messageImageLabel.setVisible(true);
        this.messageLabel.setVisible(true);
        this.getButton(0).setEnabled(false);
        this.getButton(1).getShell().setDefaultButton(this.getButton(1));
    }

    protected String[] getImageSafeFormatItems() {
        String[] items = new String[SAFE_VALUES.length];
        int i = 0;
        while (i < SAFE_VALUES.length) {
            items[i] = SAFE_VALUES[i].getName();
            ++i;
        }
        return items;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateFolderText();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFolderGroup(composite);
        this.createImageFormatGroup(composite);
        if (DialectUIManager.INSTANCE.canExport(new ExportFormat(ExportFormat.ExportDocumentFormat.HTML, null))) {
            this.createGenerateHTMLGroup(composite);
        }
        this.createMessageGroup(composite);
        this.initListeners();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected abstract void createFolderGroup(Composite var1);

    protected abstract void initListeners();

    protected abstract void restoreWidgetValues();

    protected abstract void createImageFormatGroup(Composite var1);

    private void createGenerateHTMLGroup(Composite parent) {
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)1, (boolean)false);
        this.exportToHTMLCheckbox = new Button(composite, 16416);
        this.exportToHTMLCheckbox.setText(EXPORT_TO_HTML_LABEL);
        GridData data = new GridData(768);
        this.exportToHTMLCheckbox.setLayoutData((Object)data);
        this.exportToHTMLCheckbox.setSelection(this.exportToHTML);
        this.exportToHTMLCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractExportRepresentationsAsImagesDialog.this.exportToHTML = AbstractExportRepresentationsAsImagesDialog.this.exportToHTMLCheckbox.getSelection();
            }
        });
    }

    private void createMessageGroup(Composite parent) {
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)2, (boolean)false);
        this.messageImageLabel = new Label(composite, 0);
        this.messageImageLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.messageImageLabel.setVisible(false);
        this.messageLabel = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        this.messageLabel.setLayoutData((Object)gridData);
        this.messageLabel.setVisible(false);
    }

    private void setDialogOKState() {
        this.messageImageLabel.setVisible(false);
        this.messageLabel.setVisible(false);
        this.getButton(0).setEnabled(true);
        this.getButton(0).getShell().setDefaultButton(this.getButton(0));
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }
}

