/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.export;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.actions.export.ExportAction;
import org.eclipse.sirius.ui.tools.api.dialogs.AbstractExportRepresentationsAsImagesDialog;
import org.eclipse.sirius.ui.tools.api.dialogs.ExportOneRepresentationAsImageDialog;
import org.eclipse.sirius.ui.tools.api.dialogs.ExportSeveralRepresentationsAsImagesDialog;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractExportRepresentationsAction
extends Action {
    protected AbstractExportRepresentationsAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public void run() {
        IPath exportPath;
        DRepresentation firstDRepresentationToExport;
        Session session;
        Collection<DRepresentation> collectedRepresentations = this.getDRepresentationToExport();
        Iterable dRepresentationsToExport = Iterables.filter(collectedRepresentations, (Predicate)Predicates.notNull());
        if (!Iterables.isEmpty((Iterable)dRepresentationsToExport) && (session = this.getSession(firstDRepresentationToExport = (DRepresentation)dRepresentationsToExport.iterator().next())) != null && (exportPath = this.getExportPath(firstDRepresentationToExport, session)) != null) {
            this.exportRepresentation(exportPath, dRepresentationsToExport, session);
        }
    }

    protected abstract Collection<DRepresentation> getDRepresentationToExport();

    protected abstract Session getSession(DRepresentation var1);

    protected void exportRepresentation(IPath exportPath, Iterable<DRepresentation> dRepresentationToExport, Session session) {
        Shell shell = Display.getCurrent().getActiveShell();
        AbstractExportRepresentationsAsImagesDialog dialog = Iterables.size(dRepresentationToExport) > 1 ? new ExportSeveralRepresentationsAsImagesDialog(shell, exportPath) : new ExportOneRepresentationAsImageDialog(shell, exportPath, dRepresentationToExport.iterator().next().getName());
        if (dialog.open() == 0) {
            ArrayList toExport = Lists.newArrayList(dRepresentationToExport);
            ExportAction exportAction = new ExportAction(session, toExport, dialog.getOutputPath(), dialog.getImageFormat(), dialog.isExportToHtml());
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            try {
                try {
                    pmd.run(false, false, (IRunnableWithProgress)exportAction);
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getTargetException().getMessage());
                    pmd.close();
                }
                catch (InterruptedException e) {
                    MessageDialog.openInformation((Shell)shell, (String)"Cancelled", (String)e.getMessage());
                    pmd.close();
                }
            }
            finally {
                pmd.close();
            }
        } else {
            dialog.close();
        }
    }

    protected IPath getExportPath(DRepresentation representation, Session session) {
        String[] segments;
        String opaquePart;
        URI representationResourceURI = representation.eResource().getURI();
        URIQuery uriQuery = new URIQuery(representationResourceURI);
        Option iResourceOption = uriQuery.getCorrespondingResource();
        if (iResourceOption.some()) {
            return ((IResource)iResourceOption.get()).getParent().getLocation();
        }
        IPath exportPath = Platform.getLocation();
        URI mainSessionResourceURI = session.getSessionResource().getURI();
        uriQuery = new URIQuery(mainSessionResourceURI);
        iResourceOption = uriQuery.getCorrespondingResource();
        if (iResourceOption.some()) {
            exportPath = ((IResource)iResourceOption.get()).getParent().getLocation();
        } else if (uriQuery.isInMemoryURI() && !StringUtil.isEmpty((String)(opaquePart = mainSessionResourceURI.opaquePart())) && (segments = opaquePart.split(Pattern.quote("/"))) != null && segments.length > 0) {
            String projectName = segments[0];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                exportPath = project.getLocation();
            }
        }
        return exportPath;
    }
}

