/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.session;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenCloseSessionAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenCloseSessionActionProvider
extends CommonActionProvider {
    private ICommonViewerWorkbenchSite viewSite;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.viewSite = (ICommonViewerWorkbenchSite)aSite.getViewSite();
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        OpenCloseSessionAction openCloseAnalysisAction = this.createOpenCloseAnalysisAction(selection);
        openCloseAnalysisAction.selectionChanged(selection);
        if (openCloseAnalysisAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)openCloseAnalysisAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        OpenCloseSessionAction openCloseAnalysisAction = this.createOpenCloseAnalysisAction(selection);
        if (openCloseAnalysisAction.isEnabled() && openCloseAnalysisAction.isOpenMode()) {
            menu.insertAfter("group.open", (IAction)openCloseAnalysisAction);
        }
        if (selection.getFirstElement() instanceof IFile) {
            IFile file = (IFile)selection.getFirstElement();
            MenuManager submenu = new MenuManager("Open With", "group.openWith");
            submenu.add((IContributionItem)new OpenWithMenu(this.viewSite.getPage(), (IAdaptable)file));
            if (submenu.getItems().length > 0 && submenu.isEnabled()) {
                menu.appendToGroup("group.openWith", (IContributionItem)submenu);
            }
        }
    }

    private OpenCloseSessionAction createOpenCloseAnalysisAction(IStructuredSelection selection) {
        OpenCloseSessionAction openCloseSessionAction = new OpenCloseSessionAction("Open", "Close");
        openCloseSessionAction.selectionChanged(selection);
        return openCloseSessionAction;
    }
}

