/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.api.views.common.item.AnalysisResourceItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ProjectDependenciesItem;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.AddModelDependencyAction;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.AddSemanticResourceAction;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.RemoveRepresentationResourceAction;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.RemoveSemanticResourceAction;
import org.eclipse.sirius.ui.tools.internal.actions.control.DesignerControlAction;
import org.eclipse.sirius.ui.tools.internal.actions.copy.CopyRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.actions.creation.CreateRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.actions.creation.CreateRepresentationFromSessionAction;
import org.eclipse.sirius.ui.tools.internal.actions.export.ExportRepresentationsAction;
import org.eclipse.sirius.ui.tools.internal.actions.session.CloseSessionsAction;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenRepresentationsAction;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenViewpointSelectionAction;
import org.eclipse.sirius.ui.tools.internal.views.ViewHelperImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.FileSessionFinder;
import org.eclipse.sirius.ui.tools.internal.views.common.action.DeleteRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.action.ExtractRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.action.MoveRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.action.RenameRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ControlledRoot;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonLabelProvider;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.IContextMenuActionProvider;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ContextMenuFiller
implements IMenuListener,
IMenuListener2 {
    private static final String NEW_REPRESENTATION_MENU = "New Representation";
    private static final String NEW_REPRESENTATION_MENU_ID = "menu.viewpoint.new.representation";
    private static final String SESSION_MANAGEMENT_SEPARATOR = "group.viewpoint.session";
    private static final String REPRESENTATION_MANAGEMENT_SEPARATOR = "group.viewpoint.representation";
    private static final String SEMANTIC_MANAGEMENT_SEPARATOR = "group.viewpoint.semantic";
    private static final String SESSION_SEPARATOR = "group.viewpoint";
    private static final String GROUP_NEW = "group.new";
    private static final String GROUP_PORT = "group.port";
    private static final String GROUP_OPEN = "group.open";
    private static final String GROUP_REORGANIZE = "group.reorganize";
    private static final String GROUP_EDIT = "group.edit";
    private ILabelProvider labelProvider;
    private DesignerControlAction controlAction;
    private StructuredViewer modelViewer;
    private WeakHashMap<IContributionItem, Object> addedIContributionItemCache = new WeakHashMap();

    public ContextMenuFiller(StructuredViewer modelViewer, ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.controlAction = new DesignerControlAction();
        this.modelViewer = modelViewer;
        modelViewer.addSelectionChangedListener((ISelectionChangedListener)this.controlAction);
    }

    public void fillContextMenu(IMenuManager menu, ISelection selection) {
        List selectedObjects;
        menu.addMenuListener((IMenuListener)this);
        this.safeAddGroups(menu);
        if (selection instanceof IStructuredSelection && !(selectedObjects = ((IStructuredSelection)selection).toList()).isEmpty()) {
            this.computeSessionContextMenu(menu, selectedObjects);
            this.computeModelDependenciesContextMenu(menu, selectedObjects);
            this.computeControlledRootContextMenu(menu, selectedObjects);
            Collection<EObject> selectedEObjects = this.getEObjects(selectedObjects);
            this.computeSemanticContextMenu(menu, selectedEObjects);
            this.computeRepresentationContextMenu(menu, this.getRepresentations(selectedObjects), selectedEObjects);
            this.computeRepresentationsResourcesContextMenu(menu, this.getRepresentationResources(selectedObjects));
            this.computeSemanticResourcesContextMenu(menu, this.getSemanticResources(selectedObjects));
            this.computeContextMenuContribution(menu, selection);
        }
    }

    private void safeAddGroups(IMenuManager menu) {
        if (menu != null) {
            if (menu.find(GROUP_NEW) == null) {
                menu.add((IContributionItem)new GroupMarker(GROUP_NEW));
            }
            if (menu.find(SESSION_MANAGEMENT_SEPARATOR) == null) {
                menu.insertBefore(GROUP_NEW, (IContributionItem)new Separator(SESSION_MANAGEMENT_SEPARATOR));
            }
            if (menu.find(REPRESENTATION_MANAGEMENT_SEPARATOR) == null) {
                menu.insertAfter(SESSION_MANAGEMENT_SEPARATOR, (IContributionItem)new Separator(REPRESENTATION_MANAGEMENT_SEPARATOR));
            }
            if (menu.find(SEMANTIC_MANAGEMENT_SEPARATOR) == null) {
                menu.insertAfter(REPRESENTATION_MANAGEMENT_SEPARATOR, (IContributionItem)new Separator(SEMANTIC_MANAGEMENT_SEPARATOR));
            }
            if (menu.find(SESSION_SEPARATOR) == null) {
                menu.insertAfter(SEMANTIC_MANAGEMENT_SEPARATOR, (IContributionItem)new Separator(SESSION_SEPARATOR));
            }
            if (menu.find(GROUP_OPEN) == null) {
                menu.insertAfter(GROUP_NEW, (IContributionItem)new GroupMarker(GROUP_OPEN));
            }
            if (menu.find(GROUP_EDIT) == null) {
                menu.insertAfter(GROUP_OPEN, (IContributionItem)new GroupMarker(GROUP_EDIT));
            }
            if (menu.find(GROUP_REORGANIZE) == null) {
                menu.insertAfter(GROUP_EDIT, (IContributionItem)new GroupMarker(GROUP_REORGANIZE));
            }
            if (menu.find(GROUP_PORT) == null) {
                menu.insertAfter(GROUP_REORGANIZE, (IContributionItem)new GroupMarker(GROUP_PORT));
            }
        }
    }

    private void computeControlledRootContextMenu(IMenuManager menu, Collection<?> selectedObjects) {
        Object selected;
        Iterable roots = Iterables.filter(selectedObjects, ControlledRoot.class);
        if (Iterables.size((Iterable)roots) == 1 && (selected = ((ControlledRoot)roots.iterator().next()).getWrappedObject()) instanceof EObject) {
            EObject selectedEObject = (EObject)selected;
            Session session = SessionManager.INSTANCE.getSession((EObject)selected);
            if (session != null) {
                final StructuredSelection newSelection = new StructuredSelection(selected);
                if (!this.hasSharedObjectInSelection(this.getEObjects(Collections.singletonList(selectedEObject)))) {
                    this.controlAction.selectionChanged((IStructuredSelection)newSelection);
                    this.addActionToMenu(menu, GROUP_REORGANIZE, (IAction)this.controlAction);
                }
                this.addActionToMenu(menu, SEMANTIC_MANAGEMENT_SEPARATOR, (IAction)new Action("Show in hierarchy"){

                    public void run() {
                        ContextMenuFiller.this.modelViewer.setSelection((ISelection)newSelection, true);
                    }
                });
            }
        }
    }

    private void addActionToMenu(IMenuManager menu, String group, IAction action) {
        this.addContributionToMenu(menu, group, (IContributionItem)new ActionContributionItem(action));
    }

    private void addContributionToMenu(IMenuManager menu, String group, IContributionItem item) {
        menu.appendToGroup(group, item);
        this.addedIContributionItemCache.put(item, null);
    }

    private void computeModelDependenciesContextMenu(IMenuManager menu, Collection<?> selection) {
        Option<Session> session;
        Collection<ProjectDependenciesItem> items = this.getModelDependencies(selection);
        if (items.size() == 1 && selection.size() == 1 && (session = items.iterator().next().getSession()).some()) {
            this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, this.buildAddModelAction((Session)session.get()));
        }
    }

    private void computeRepresentationContextMenu(IMenuManager menu, Collection<DRepresentation> selectedRepresentations, Collection<EObject> selectedEObjects) {
        if (selectedRepresentations == null || selectedEObjects == null) {
            return;
        }
        Session session = null;
        EObject firstEObject = null;
        for (DSemanticDecorator dsem : Iterables.filter((Iterable)Iterables.concat(selectedRepresentations, selectedEObjects), DSemanticDecorator.class)) {
            firstEObject = dsem.getTarget();
            if (firstEObject != null) break;
        }
        if (firstEObject == null && !selectedEObjects.isEmpty()) {
            firstEObject = selectedEObjects.iterator().next();
        }
        Session session2 = session = firstEObject == null ? null : SessionManager.INSTANCE.getSession(firstEObject);
        if (session != null) {
            if (!selectedRepresentations.isEmpty()) {
                this.addActionToMenu(menu, GROUP_OPEN, this.buildOpenRepresentationAction(selectedRepresentations));
                this.addActionToMenu(menu, GROUP_REORGANIZE, (IAction)this.buildRenameRepresentationAction(selectedRepresentations));
                this.addActionToMenu(menu, GROUP_REORGANIZE, (IAction)this.buildCopyRepresentationsAction(selectedRepresentations, session));
            }
            if (!selectedRepresentations.isEmpty() && session.getAllSessionResources().size() >= 1) {
                LinkedHashSet<Resource> targetResources = new LinkedHashSet<Resource>(session.getAllSessionResources());
                Collection<Resource> originResources = this.collectOriginResources(selectedRepresentations);
                if (originResources.size() == 1) {
                    targetResources.removeAll(originResources);
                }
                if (targetResources.size() > 0) {
                    this.computeMoveMenu(menu, session, selectedRepresentations, targetResources);
                }
                this.addActionToMenu(menu, GROUP_REORGANIZE, this.buildExtractRepresentationsAction(session, selectedRepresentations));
            }
            ExportRepresentationsAction actionExportImage = new ExportRepresentationsAction(session, selectedEObjects, selectedRepresentations);
            this.addActionToMenu(menu, GROUP_PORT, (IAction)actionExportImage);
        }
        if (!selectedRepresentations.isEmpty()) {
            this.addActionToMenu(menu, GROUP_EDIT, (IAction)this.buildDeleteRepresentationAction(selectedRepresentations));
        }
    }

    private void computeRepresentationsResourcesContextMenu(IMenuManager menu, Collection<AnalysisResourceItem> diagramResources) {
        Session session = null;
        if (!diagramResources.isEmpty()) {
            for (AnalysisResourceItem diagramResource : diagramResources) {
                Option<Session> s = diagramResource.getSession();
                if (!s.some()) continue;
                session = (Session)s.get();
                break;
            }
        }
        if (!diagramResources.isEmpty() && session != null) {
            this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, this.buildRemoveRepresentationsResourceAction(diagramResources, session));
        }
    }

    private void computeSemanticContextMenu(IMenuManager menu, Collection<EObject> selection) {
        EObject firstSelected;
        Session session;
        if (selection != null && !selection.isEmpty() && (session = SessionManager.INSTANCE.getSession(firstSelected = (EObject)selection.toArray()[0])) != null) {
            Collection descriptions;
            if (!this.hasSharedObjectInSelection(selection)) {
                this.addActionToMenu(menu, GROUP_REORGANIZE, (IAction)this.controlAction);
            }
            if ((descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(session.getSelectedViewpoints(false), firstSelected)).size() > 0) {
                MenuManager addNewRepresentation = new MenuManager(NEW_REPRESENTATION_MENU, NEW_REPRESENTATION_MENU_ID);
                for (RepresentationDescription representationDescription : descriptions) {
                    if (!DialectManager.INSTANCE.canCreate(firstSelected, representationDescription)) continue;
                    addNewRepresentation.add((IAction)this.buildCreateRepresentationAction(firstSelected, representationDescription, session));
                }
                this.addContributionToMenu(menu, GROUP_NEW, (IContributionItem)addNewRepresentation);
            }
        }
    }

    private boolean hasSharedObjectInSelection(Collection<EObject> selection) {
        boolean hasSharedObjectInSelection = false;
        for (EObject selectedEObject : selection) {
            Resource selectedEObjectResource = selectedEObject.eResource();
            if (selectedEObjectResource == null || !"cdo".equals(selectedEObjectResource.getURI().scheme())) continue;
            hasSharedObjectInSelection = true;
            break;
        }
        return hasSharedObjectInSelection;
    }

    private void computeSemanticResourcesContextMenu(IMenuManager menu, Collection<Resource> resources) {
        Session session = null;
        if (!resources.isEmpty()) {
            for (Resource resource : resources) {
                EObject object;
                if (!resource.getContents().isEmpty() && (session = SessionManager.INSTANCE.getSession(object = (EObject)resource.getContents().iterator().next())) != null) break;
            }
        }
        if (!resources.isEmpty() && session != null) {
            this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, this.buildRemoveSemanticResourceAction(resources, session));
        }
    }

    private void computeSessionContextMenu(IMenuManager menu, Collection<?> selection) {
        Collection<IProject> modelingProjects = this.getModelingProjects(selection);
        if (modelingProjects.size() == 1) {
            this.computeModelingProjectMenu(menu, modelingProjects.iterator().next());
        } else {
            HashSet impactedProjects = Sets.newHashSet();
            for (IResource res : Iterables.filter(selection, IResource.class)) {
                impactedProjects.add(res.getProject());
            }
            for (IProject p : impactedProjects) {
                if (!ModelingProject.hasModelingProjectNature((IProject)p)) continue;
                return;
            }
            this.computeSessionLegacyContextMenu(menu, selection);
        }
    }

    private void computeSessionLegacyContextMenu(IMenuManager menu, Collection<?> selection) {
        List<Session> selectedSessions = FileSessionFinder.getSelectedSessions(selection);
        if (!selectedSessions.isEmpty()) {
            if (selectedSessions.size() == 1) {
                Session session = selectedSessions.get(0);
                this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, (IAction)this.buildViewpointsSelectionDialogAction(session));
                this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, (IAction)this.buildCreateRepresentationAction(session));
            }
            this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, (IAction)this.buildCloseSessionAction(selectedSessions));
            boolean needSave = false;
            for (Session s : selectedSessions) {
                if (s.getStatus() != SessionStatus.DIRTY) continue;
                needSave = true;
                break;
            }
            if (needSave) {
                this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, (IAction)this.buildSaveSessionAction(selectedSessions));
            }
            this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, this.buildAddSemanticResourceAction(selectedSessions));
        }
    }

    private void computeModelingProjectMenu(IMenuManager menu, IProject project) {
        Session session = null;
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        if (modelingProject.some()) {
            session = ((ModelingProject)modelingProject.get()).getSession();
        }
        if (session != null) {
            this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, (IAction)this.buildViewpointsSelectionDialogAction(session));
            this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, (IAction)this.buildCreateRepresentationAction(session));
            if (session.getStatus() == SessionStatus.DIRTY && SiriusCommonLabelProvider.shoudlShowSessionDirtyStatus(session)) {
                this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, (IAction)this.buildSaveSessionAction(Collections.singletonList(session)));
            }
        }
    }

    private void computeMoveMenu(IMenuManager menu, Session session, Collection<DRepresentation> movableRepresentations, Collection<Resource> targetResources) {
        MenuManager moveMenu = new MenuManager("Move", "1");
        for (Resource target : targetResources) {
            if (target.getContents().isEmpty() || !(target.getContents().get(0) instanceof DAnalysis)) continue;
            moveMenu.add((IAction)this.buildMoveRepresentationsActions(session, movableRepresentations, (DAnalysis)target.getContents().get(0)));
        }
        this.addContributionToMenu(menu, GROUP_REORGANIZE, (IContributionItem)moveMenu);
    }

    private void computeContextMenuContribution(IMenuManager menu, ISelection selection) {
        if (ViewHelper.INSTANCE instanceof ViewHelperImpl) {
            Collection<IContextMenuActionProvider> providers = ((ViewHelperImpl)ViewHelper.INSTANCE).getContextMenuActionsProviders();
            for (IContextMenuActionProvider provider : providers) {
                for (IAction action : provider.getContextMenuActions(selection)) {
                    this.addActionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, action);
                }
            }
            for (IContextMenuActionProvider provider : providers) {
                for (IContributionItem contributionItem : provider.getContextualMenuContributionItems(selection)) {
                    this.addContributionToMenu(menu, SESSION_MANAGEMENT_SEPARATOR, contributionItem);
                }
            }
        }
    }

    private IAction buildOpenRepresentationAction(Collection<DRepresentation> selection) {
        return new OpenRepresentationsAction(selection);
    }

    private IAction buildRemoveSemanticResourceAction(Collection<Resource> selection, Session session) {
        return new RemoveSemanticResourceAction(selection, session);
    }

    private IAction buildRemoveRepresentationsResourceAction(Collection<AnalysisResourceItem> diagramResourceItems, Session session) {
        HashSet<Resource> diagramResources = new HashSet<Resource>();
        for (AnalysisResourceItem diagramResourceItem : diagramResourceItems) {
            diagramResources.add((Resource)diagramResourceItem.getWrappedObject());
        }
        return new RemoveRepresentationResourceAction(diagramResources, session);
    }

    private IAction buildExtractRepresentationsAction(Session session, Collection<DRepresentation> movableRepresentations) {
        return new ExtractRepresentationAction(session, movableRepresentations);
    }

    private Action buildMoveRepresentationsActions(Session session, Collection<DRepresentation> movableRepresentations, DAnalysis targetAnalysis) {
        return new MoveRepresentationAction(session, targetAnalysis, movableRepresentations);
    }

    private Action buildViewpointsSelectionDialogAction(Session session) {
        return new OpenViewpointSelectionAction(session.getSessionResource().getURI());
    }

    private Action buildCopyRepresentationsAction(Collection<DRepresentation> selection, Session session) {
        return new CopyRepresentationAction(session, selection);
    }

    private Action buildRenameRepresentationAction(Collection<DRepresentation> selection) {
        RenameRepresentationAction renameAction = new RenameRepresentationAction(selection);
        renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        return renameAction;
    }

    private IAction buildAddSemanticResourceAction(List<Session> selection) {
        return new AddSemanticResourceAction(selection);
    }

    private IAction buildAddModelAction(Session selectedSession) {
        return new AddModelDependencyAction(selectedSession);
    }

    private Action buildDeleteRepresentationAction(Collection<DRepresentation> representations) {
        DeleteRepresentationAction deleteAction = new DeleteRepresentationAction(representations);
        deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        return deleteAction;
    }

    private Action buildCreateRepresentationAction(EObject selection, RepresentationDescription representationDescription, Session session) {
        return new CreateRepresentationAction(session, selection, representationDescription, this.labelProvider);
    }

    private Action buildCreateRepresentationAction(Session session) {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/addRepresentation.gif");
        return new CreateRepresentationFromSessionAction(session, descriptor);
    }

    private Action buildCloseSessionAction(List<Session> selection) {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/close.gif");
        CloseSessionsAction closeSessionsAction = new CloseSessionsAction("Close");
        closeSessionsAction.setImageDescriptor(descriptor);
        closeSessionsAction.selectionChanged((IStructuredSelection)new StructuredSelection(selection));
        return closeSessionsAction;
    }

    private Action buildSaveSessionAction(final List<Session> selection) {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/save.gif");
        return new Action("Save", descriptor){

            public void run() {
                super.run();
                for (final Session session : selection) {
                    Status status;
                    final IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
                    try {
                        new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(true, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                if (uiSession instanceof ISaveablesSource) {
                                    ISaveablesSource saveablesSource = (ISaveablesSource)uiSession;
                                    Saveable[] saveableArray = saveablesSource.getActiveSaveables();
                                    int n = saveableArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Saveable saveable = saveableArray[n2];
                                        try {
                                            saveable.doSave(monitor);
                                        }
                                        catch (CoreException e) {
                                            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", "Error at session saving", (Throwable)e));
                                        }
                                        ++n2;
                                    }
                                } else {
                                    session.save(monitor);
                                }
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        status = new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e);
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                    catch (InvocationTargetException e) {
                        status = new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), e.getTargetException());
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                }
            }
        };
    }

    public void dispose() {
        this.modelViewer.removeSelectionChangedListener((ISelectionChangedListener)this.controlAction);
        this.modelViewer = null;
        this.controlAction = null;
        this.labelProvider = null;
    }

    private Collection<Resource> collectOriginResources(Collection<DRepresentation> movableRepresentations) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        for (DRepresentation representation : movableRepresentations) {
            result.add(representation.eResource());
        }
        return result;
    }

    private Collection<EObject> getEObjects(Collection<?> selection) {
        SequencedCollection<Object> eObjects = Collections.emptyList();
        if (selection != null) {
            eObjects = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)Iterables.filter(selection, EObject.class), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Resource.class))));
        }
        return eObjects;
    }

    private Collection<ProjectDependenciesItem> getModelDependencies(Collection<?> selection) {
        SequencedCollection<ProjectDependenciesItem> deps = Collections.emptyList();
        if (selection != null) {
            deps = Sets.newLinkedHashSet((Iterable)Iterables.filter(selection, ProjectDependenciesItem.class));
        }
        return deps;
    }

    private Collection<IProject> getModelingProjects(Collection<?> selection) {
        SequencedCollection<Object> projects = Collections.emptyList();
        if (selection != null) {
            projects = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)Iterables.filter(selection, IProject.class), (Predicate)new Predicate<IProject>(){

                public boolean apply(IProject input) {
                    return ModelingProject.hasModelingProjectNature((IProject)input);
                }
            }));
        }
        return projects;
    }

    private Collection<DRepresentation> getRepresentations(Collection<?> selection) {
        SequencedCollection<Object> selectedReps = Collections.emptyList();
        if (selection != null) {
            selectedReps = Sets.newLinkedHashSet();
            Iterables.addAll(selectedReps, (Iterable)Iterables.filter(selection, DRepresentation.class));
            Iterables.addAll(selectedReps, (Iterable)Iterables.transform((Iterable)Iterables.filter(selection, RepresentationItemImpl.class), RepresentationItemImpl.REPRESENTATION_ITEM_TO_REPRESENTATION));
        }
        return selectedReps;
    }

    private Collection<AnalysisResourceItem> getRepresentationResources(Collection<?> selection) {
        SequencedCollection<AnalysisResourceItem> airdResItems = Collections.emptyList();
        if (selection != null) {
            airdResItems = Sets.newLinkedHashSet((Iterable)Iterables.filter(selection, AnalysisResourceItem.class));
        }
        return airdResItems;
    }

    private Collection<Resource> getSemanticResources(Collection<?> selection) {
        SequencedCollection<Object> semRes = Collections.emptyList();
        if (selection != null) {
            semRes = Sets.newLinkedHashSet((Iterable)Iterables.filter(selection, Resource.class));
        }
        return semRes;
    }

    public void menuAboutToShow(IMenuManager manager) {
    }

    public void menuAboutToHide(IMenuManager manager) {
        LinkedHashSet toRemove = Sets.newLinkedHashSet();
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (this.addedIContributionItemCache.keySet().contains(item)) {
                toRemove.add(item);
            }
            ++n2;
        }
        for (IContributionItem item : toRemove) {
            manager.remove(item);
        }
        manager.removeMenuListener((IMenuListener)this);
        this.addedIContributionItemCache.clear();
    }
}

