/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.control;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.DAnalysisQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.internal.command.control.UncontrolCommand;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class SiriusUncontrolCommand
extends UncontrolCommand {
    private final Session session;
    private final boolean uncontrolRepresentations;
    private final boolean shouldEndBySaving;
    private IProgressMonitor monitor;

    @Deprecated
    public SiriusUncontrolCommand(EObject semanticRoot, boolean uncontrolRepresentations, IProgressMonitor monitor) {
        this(semanticRoot, uncontrolRepresentations, true, monitor);
    }

    public SiriusUncontrolCommand(EObject semanticRoot, boolean uncontrolRepresentations, boolean shouldEndBySaving, IProgressMonitor monitor) {
        super(semanticRoot);
        this.uncontrolRepresentations = uncontrolRepresentations;
        this.session = SessionManager.INSTANCE.getSession(semanticRoot);
        this.shouldEndBySaving = shouldEndBySaving;
        this.monitor = monitor;
    }

    protected EObject getRootContainer(EObject eObject) {
        return new EObjectQuery(eObject).getResourceContainer();
    }

    @Override
    protected void doExecute() {
        try {
            this.monitor.beginTask("Uncontrol resource", 4);
            Resource childSemanticResource = this.semanticElementToUncontrol.eResource();
            Resource childAirdResource = this.getChildAirdResource();
            Resource parentAirdResource = this.getParentAirdResource();
            super.doExecute();
            this.monitor.worked(1);
            this.markContainerResourceAsModified(this.semanticElementToUncontrol.eContainer());
            if (this.uncontrolRepresentations && childAirdResource != null) {
                this.moveRepresentations(childAirdResource, parentAirdResource, this.semanticElementToUncontrol.eResource());
            }
            this.monitor.worked(1);
            this.cleanupChildrenResources(childSemanticResource, childAirdResource);
            this.monitor.worked(1);
            if (this.shouldEndBySaving) {
                this.session.save((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
        }
        finally {
            this.monitor.done();
        }
    }

    private void cleanupChildrenResources(Resource childSemanticResource, Resource childAirdResource) {
        this.notifySessionAboutUncontrolledResource(childSemanticResource);
        this.deleteResource(childSemanticResource);
        if (childAirdResource != null && this.uncontrolRepresentations && this.airdResourceHasNoRepresentations(childAirdResource)) {
            this.removeObsoleteAnalyis(childAirdResource);
            this.notifySessionAboutUncontrolledResource(childAirdResource);
            this.deleteResource(childAirdResource);
        }
    }

    private void removeObsoleteAnalyis(Resource childAirdResource) {
        if (this.session instanceof DAnalysisSession) {
            ((DAnalysisSession)this.session).removeReferencedAnalysis(this.getDAnalysis(childAirdResource));
        }
    }

    private boolean airdResourceHasNoRepresentations(Resource childAirdResource) {
        return Iterators.size((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)childAirdResource, (boolean)true), DRepresentation.class)) == 0;
    }

    private Resource getChildAirdResource() {
        return this.getAirdResourceWithAnalysisOn(this.semanticElementToUncontrol);
    }

    private Resource getParentAirdResource() {
        return this.getAirdResourceWithAnalysisOn(this.getRootContainer(this.semanticElementToUncontrol.eContainer()));
    }

    protected Resource getAirdResourceWithAnalysisOn(EObject object) {
        for (Resource anResource : this.session.getAllSessionResources()) {
            for (DAnalysis analysis : this.getAnalyses(anResource)) {
                Set<EObject> releventModels = new DAnalysisQuery(analysis).getMainModels();
                if (!Iterables.contains(releventModels, (Object)object)) continue;
                return anResource;
            }
        }
        return null;
    }

    protected Collection<DAnalysis> getAnalyses(Resource aird) {
        ArrayList analyses = Lists.newArrayList();
        for (EObject root : aird.getContents()) {
            if (!(root instanceof DAnalysis)) continue;
            analyses.add((DAnalysis)root);
        }
        return analyses;
    }

    private void moveRepresentations(Resource childResource, Resource parentResource, Resource parentSemanticResource) {
        Collection<DRepresentation> representations = this.collectExistingRepresentations(childResource);
        DAnalysis parentAnalysis = this.getDAnalysis(parentResource);
        DAnalysis childAnalysis = this.getDAnalysis(childResource);
        DAnalysisSession aSession = (DAnalysisSession)this.session;
        for (DRepresentation representation : representations) {
            aSession.moveRepresentation(parentAnalysis, representation);
        }
        if (childAnalysis != null) {
            parentAnalysis.getReferencedAnalysis().addAll(childAnalysis.getReferencedAnalysis());
        }
    }

    private DAnalysis getDAnalysis(Resource parentResource) {
        for (EObject root : parentResource.getContents()) {
            if (!(root instanceof DAnalysis)) continue;
            return (DAnalysis)root;
        }
        return null;
    }

    private Collection<DRepresentation> collectExistingRepresentations(Resource resource) {
        return Sets.newHashSet((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)resource, (boolean)true), DRepresentation.class));
    }

    private void markContainerResourceAsModified(EObject obj) {
        Resource containerResource;
        EObject resourceContainer = this.getRootContainer(obj);
        if (obj != null && resourceContainer != null && (containerResource = resourceContainer.eResource()) != null) {
            containerResource.setModified(true);
        }
    }

    protected void deleteResource(Resource res) {
        if (res != null) {
            try {
                res.save(Collections.emptyMap());
                res.delete(Collections.emptyMap());
            }
            catch (IOException e) {
                SiriusPlugin.getDefault().error("Resource deletion failed", e);
            }
        }
    }

    private void notifySessionAboutUncontrolledResource(Resource controlledSemanticResource) {
        if (this.session instanceof DAnalysisSession) {
            ((DAnalysisSession)this.session).notifyUnControlledModel(this.semanticElementToUncontrol, controlledSemanticResource);
        }
    }
}

